/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import sun.security.util.Debug;
import sun.security.util.ManifestDigester;
import sun.security.util.ManifestEntryVerifier;
import sun.security.util.SignatureFileVerifier;

class JarVerifier {
    static final Debug debug = Debug.getInstance("jar");
    private Hashtable verifiedSigners;
    private Hashtable sigFileSigners;
    private Hashtable sigFileData;
    private ArrayList pendingBlocks;
    private ArrayList signerCache;
    private boolean parsingBlockOrSF = false;
    private boolean parsingMeta = true;
    private boolean anyToVerify = true;
    private ByteArrayOutputStream baos;
    private volatile ManifestDigester manDig;
    byte[] manifestRawBytes = null;
    boolean eagerValidation;
    private Object csdomain = new Object();
    private List manifestDigests;
    private Map urlToCodeSourceMap = new HashMap();
    private Map signerToCodeSource = new HashMap();
    private URL lastURL;
    private Map lastURLMap;
    private CodeSigner[] emptySigner = new CodeSigner[0];
    private Map signerMap;
    private Enumeration emptyEnumeration = new Enumeration<String>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public String nextElement() {
            throw new NoSuchElementException();
        }
    };
    private List jarCodeSigners;

    public JarVerifier(byte[] rawBytes) {
        this.manifestRawBytes = rawBytes;
        this.sigFileSigners = new Hashtable();
        this.verifiedSigners = new Hashtable();
        this.sigFileData = new Hashtable(11);
        this.pendingBlocks = new ArrayList();
        this.baos = new ByteArrayOutputStream();
        this.manifestDigests = new ArrayList();
    }

    public void beginEntry(JarEntry je, ManifestEntryVerifier mev) throws IOException {
        String uname;
        if (je == null) {
            return;
        }
        if (debug != null) {
            debug.println("beginEntry " + je.getName());
        }
        String name = je.getName();
        if (this.parsingMeta && ((uname = name.toUpperCase(Locale.ENGLISH)).startsWith("META-INF/") || uname.startsWith("/META-INF/"))) {
            if (je.isDirectory()) {
                mev.setEntry(null, je);
                return;
            }
            if (SignatureFileVerifier.isBlockOrSF(uname)) {
                this.parsingBlockOrSF = true;
                this.baos.reset();
                mev.setEntry(null, je);
            }
            return;
        }
        if (this.parsingMeta) {
            this.doneWithMeta();
        }
        if (je.isDirectory()) {
            mev.setEntry(null, je);
            return;
        }
        if (name.startsWith("./")) {
            name = name.substring(2);
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (this.sigFileSigners.get(name) != null || this.verifiedSigners.get(name) != null) {
            mev.setEntry(name, je);
            return;
        }
        mev.setEntry(null, je);
    }

    public void update(int b, ManifestEntryVerifier mev) throws IOException {
        if (b != -1) {
            if (this.parsingBlockOrSF) {
                this.baos.write(b);
            } else {
                mev.update((byte)b);
            }
        } else {
            this.processEntry(mev);
        }
    }

    public void update(int n, byte[] b, int off, int len, ManifestEntryVerifier mev) throws IOException {
        if (n != -1) {
            if (this.parsingBlockOrSF) {
                this.baos.write(b, off, n);
            } else {
                mev.update(b, off, n);
            }
        } else {
            this.processEntry(mev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void processEntry(ManifestEntryVerifier mev) throws IOException {
        if (!this.parsingBlockOrSF) {
            JarEntry je = mev.getEntry();
            if (je == null) return;
            if (je.signers != null) return;
            je.signers = mev.verify(this.verifiedSigners, this.sigFileSigners);
            je.certs = JarVerifier.mapSignersToCertArray(je.signers);
            return;
        }
        try {
            SignatureFileVerifier sfv;
            String uname;
            this.parsingBlockOrSF = false;
            if (debug != null) {
                debug.println("processEntry: processing block");
            }
            if ((uname = mev.getEntry().getName().toUpperCase(Locale.ENGLISH)).endsWith(".SF")) {
                String key = uname.substring(0, uname.length() - 3);
                byte[] bytes = this.baos.toByteArray();
                this.sigFileData.put(key, bytes);
                Iterator it = this.pendingBlocks.iterator();
                while (it.hasNext()) {
                    SignatureFileVerifier sfv2 = (SignatureFileVerifier)it.next();
                    if (!sfv2.needSignatureFile(key)) continue;
                    if (debug != null) {
                        debug.println("processEntry: processing pending block");
                    }
                    sfv2.setSignatureFile(bytes);
                    sfv2.process(this.sigFileSigners, this.manifestDigests);
                }
                return;
            }
            String key = uname.substring(0, uname.lastIndexOf("."));
            if (this.signerCache == null) {
                this.signerCache = new ArrayList();
            }
            if (this.manDig == null) {
                byte[] bytes = this.manifestRawBytes;
                // MONITORENTER : this.manifestRawBytes
                if (this.manDig == null) {
                    this.manDig = new ManifestDigester(this.manifestRawBytes);
                    this.manifestRawBytes = null;
                }
                // MONITOREXIT : bytes
            }
            if ((sfv = new SignatureFileVerifier(this.signerCache, this.manDig, uname, this.baos.toByteArray())).needSignatureFileBytes()) {
                byte[] bytes = (byte[])this.sigFileData.get(key);
                if (bytes == null) {
                    if (debug != null) {
                        debug.println("adding pending block");
                    }
                    this.pendingBlocks.add(sfv);
                    return;
                }
                sfv.setSignatureFile(bytes);
            }
            sfv.process(this.sigFileSigners, this.manifestDigests);
            return;
        }
        catch (IOException ioe) {
            if (debug == null) return;
            debug.println("processEntry caught: " + ioe);
            return;
        }
        catch (SignatureException se) {
            if (debug == null) return;
            debug.println("processEntry caught: " + se);
            return;
        }
        catch (NoSuchAlgorithmException nsae) {
            if (debug == null) return;
            debug.println("processEntry caught: " + nsae);
            return;
        }
        catch (CertificateException ce) {
            if (debug == null) return;
            debug.println("processEntry caught: " + ce);
        }
    }

    public Certificate[] getCerts(String name) {
        return JarVerifier.mapSignersToCertArray(this.getCodeSigners(name));
    }

    public Certificate[] getCerts(JarFile jar2, JarEntry entry) {
        return JarVerifier.mapSignersToCertArray(this.getCodeSigners(jar2, entry));
    }

    public CodeSigner[] getCodeSigners(String name) {
        return (CodeSigner[])this.verifiedSigners.get(name);
    }

    public CodeSigner[] getCodeSigners(JarFile jar2, JarEntry entry) {
        String name = entry.getName();
        if (this.eagerValidation && this.sigFileSigners.get(name) != null) {
            try {
                InputStream s = jar2.getInputStream(entry);
                byte[] buffer = new byte[1024];
                int n = buffer.length;
                while (n != -1) {
                    n = s.read(buffer, 0, buffer.length);
                }
                s.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return this.getCodeSigners(name);
    }

    private static Certificate[] mapSignersToCertArray(CodeSigner[] signers) {
        if (signers != null) {
            ArrayList<? extends Certificate> certChains = new ArrayList<Certificate>();
            for (int i = 0; i < signers.length; ++i) {
                certChains.addAll(signers[i].getSignerCertPath().getCertificates());
            }
            return certChains.toArray(new Certificate[certChains.size()]);
        }
        return null;
    }

    boolean nothingToVerify() {
        return !this.anyToVerify;
    }

    void doneWithMeta() {
        this.parsingMeta = false;
        this.anyToVerify = !this.sigFileSigners.isEmpty();
        this.baos = null;
        this.sigFileData = null;
        this.pendingBlocks = null;
        this.signerCache = null;
        this.manDig = null;
        if (this.sigFileSigners.containsKey("META-INF/MANIFEST.MF")) {
            this.verifiedSigners.put("META-INF/MANIFEST.MF", this.sigFileSigners.remove("META-INF/MANIFEST.MF"));
        }
    }

    private synchronized CodeSource mapSignersToCodeSource(URL url, CodeSigner[] signers) {
        Map map;
        if (url == this.lastURL) {
            map = this.lastURLMap;
        } else {
            map = (Map)this.urlToCodeSourceMap.get(url);
            if (map == null) {
                map = new HashMap();
                this.urlToCodeSourceMap.put(url, map);
            }
            this.lastURLMap = map;
            this.lastURL = url;
        }
        CodeSource cs = (CodeSource)map.get(signers);
        if (cs == null) {
            cs = new VerifierCodeSource(this.csdomain, url, signers);
            this.signerToCodeSource.put(signers, cs);
        }
        return cs;
    }

    private CodeSource[] mapSignersToCodeSources(URL url, List signers, boolean unsigned) {
        ArrayList<CodeSource> sources = new ArrayList<CodeSource>();
        for (int i = 0; i < signers.size(); ++i) {
            sources.add(this.mapSignersToCodeSource(url, (CodeSigner[])signers.get(i)));
        }
        if (unsigned) {
            sources.add(this.mapSignersToCodeSource(url, null));
        }
        return sources.toArray(new CodeSource[sources.size()]);
    }

    private CodeSigner[] findMatchingSigners(CodeSource cs) {
        VerifierCodeSource vcs;
        if (cs instanceof VerifierCodeSource && (vcs = (VerifierCodeSource)cs).isSameDomain(this.csdomain)) {
            return ((VerifierCodeSource)cs).getPrivateSigners();
        }
        CodeSource[] sources = this.mapSignersToCodeSources(cs.getLocation(), this.getJarCodeSigners(), true);
        ArrayList<CodeSource> sourceList = new ArrayList<CodeSource>();
        for (int i = 0; i < sources.length; ++i) {
            sourceList.add(sources[i]);
        }
        int j = sourceList.indexOf(cs);
        if (j != -1) {
            CodeSigner[] match = ((VerifierCodeSource)sourceList.get(j)).getPrivateSigners();
            if (match == null) {
                match = this.emptySigner;
            }
            return match;
        }
        return null;
    }

    private synchronized Map signerMap() {
        if (this.signerMap == null) {
            this.signerMap = new HashMap(this.verifiedSigners.size() + this.sigFileSigners.size());
            this.signerMap.putAll(this.verifiedSigners);
            this.signerMap.putAll(this.sigFileSigners);
        }
        return this.signerMap;
    }

    public synchronized Enumeration<String> entryNames(JarFile jar2, CodeSource[] cs) {
        Map map = this.signerMap();
        final Iterator itor = map.entrySet().iterator();
        boolean matchUnsigned = false;
        ArrayList<CodeSigner[]> req = new ArrayList<CodeSigner[]>(cs.length);
        for (int i = 0; i < cs.length; ++i) {
            CodeSigner[] match = this.findMatchingSigners(cs[i]);
            if (match == null) continue;
            if (match.length > 0) {
                req.add(match);
                continue;
            }
            matchUnsigned = true;
        }
        final ArrayList<CodeSigner[]> signersReq = req;
        final Enumeration<String> enum2 = matchUnsigned ? this.unsignedEntryNames(jar2) : this.emptyEnumeration;
        return new Enumeration<String>(){
            String name;

            @Override
            public boolean hasMoreElements() {
                if (this.name != null) {
                    return true;
                }
                while (itor.hasNext()) {
                    Map.Entry e = (Map.Entry)itor.next();
                    if (!signersReq.contains((CodeSigner[])e.getValue())) continue;
                    this.name = (String)e.getKey();
                    return true;
                }
                if (enum2.hasMoreElements()) {
                    this.name = (String)enum2.nextElement();
                    return true;
                }
                return false;
            }

            @Override
            public String nextElement() {
                if (this.hasMoreElements()) {
                    String value = this.name;
                    this.name = null;
                    return value;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Enumeration<JarEntry> entries2(final JarFile jar2, Enumeration e) {
        final HashMap map = new HashMap();
        map.putAll(this.signerMap());
        final Enumeration enum_ = e;
        return new Enumeration<JarEntry>(){
            Enumeration signers = null;
            JarEntry entry;

            @Override
            public boolean hasMoreElements() {
                if (this.entry != null) {
                    return true;
                }
                while (enum_.hasMoreElements()) {
                    ZipEntry ze = (ZipEntry)enum_.nextElement();
                    if (JarVerifier.isSigningRelated(ze.getName())) continue;
                    this.entry = jar2.newEntry(ze);
                    return true;
                }
                if (this.signers == null) {
                    this.signers = Collections.enumeration(map.keySet());
                }
                if (this.signers.hasMoreElements()) {
                    String name = (String)this.signers.nextElement();
                    this.entry = jar2.newEntry(new ZipEntry(name));
                    return true;
                }
                return false;
            }

            @Override
            public JarEntry nextElement() {
                if (this.hasMoreElements()) {
                    JarEntry je = this.entry;
                    map.remove(je.getName());
                    this.entry = null;
                    return je;
                }
                throw new NoSuchElementException();
            }
        };
    }

    static boolean isSigningRelated(String name) {
        if (!(name = name.toUpperCase(Locale.ENGLISH)).startsWith("META-INF/")) {
            return false;
        }
        if ((name = name.substring(9)).indexOf(47) != -1) {
            return false;
        }
        return name.endsWith(".DSA") || name.endsWith(".RSA") || name.endsWith(".SF") || name.endsWith(".EC") || name.startsWith("SIG-") || name.equals("MANIFEST.MF");
    }

    private Enumeration<String> unsignedEntryNames(JarFile jar2) {
        final Map map = this.signerMap();
        final Enumeration<JarEntry> entries = jar2.entries();
        return new Enumeration<String>(){
            String name;

            @Override
            public boolean hasMoreElements() {
                if (this.name != null) {
                    return true;
                }
                while (entries.hasMoreElements()) {
                    ZipEntry e = (ZipEntry)entries.nextElement();
                    String value = e.getName();
                    if (e.isDirectory() || JarVerifier.isSigningRelated(value) || map.get(value) != null) continue;
                    this.name = value;
                    return true;
                }
                return false;
            }

            @Override
            public String nextElement() {
                if (this.hasMoreElements()) {
                    String value = this.name;
                    this.name = null;
                    return value;
                }
                throw new NoSuchElementException();
            }
        };
    }

    private synchronized List getJarCodeSigners() {
        if (this.jarCodeSigners == null) {
            HashSet set = new HashSet();
            set.addAll(this.signerMap().values());
            this.jarCodeSigners = new ArrayList();
            this.jarCodeSigners.addAll(set);
        }
        return this.jarCodeSigners;
    }

    public synchronized CodeSource[] getCodeSources(JarFile jar2, URL url) {
        boolean hasUnsigned = this.unsignedEntryNames(jar2).hasMoreElements();
        return this.mapSignersToCodeSources(url, this.getJarCodeSigners(), hasUnsigned);
    }

    public CodeSource getCodeSource(URL url, String name) {
        CodeSigner[] signers = (CodeSigner[])this.signerMap().get(name);
        return this.mapSignersToCodeSource(url, signers);
    }

    public CodeSource getCodeSource(URL url, JarFile jar2, JarEntry je) {
        return this.mapSignersToCodeSource(url, this.getCodeSigners(jar2, je));
    }

    public void setEagerValidation(boolean eager) {
        this.eagerValidation = eager;
    }

    public synchronized List getManifestDigests() {
        return Collections.unmodifiableList(this.manifestDigests);
    }

    static CodeSource getUnsignedCS(URL url) {
        return new VerifierCodeSource(null, url, (Certificate[])null);
    }

    private static class VerifierCodeSource
    extends CodeSource {
        URL vlocation;
        CodeSigner[] vsigners;
        Certificate[] vcerts;
        Object csdomain;

        VerifierCodeSource(Object csdomain, URL location, CodeSigner[] signers) {
            super(location, signers);
            this.csdomain = csdomain;
            this.vlocation = location;
            this.vsigners = signers;
        }

        VerifierCodeSource(Object csdomain, URL location, Certificate[] certs) {
            super(location, certs);
            this.csdomain = csdomain;
            this.vlocation = location;
            this.vcerts = certs;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof VerifierCodeSource) {
                VerifierCodeSource that = (VerifierCodeSource)obj;
                if (this.isSameDomain(that.csdomain)) {
                    if (that.vsigners != this.vsigners || that.vcerts != this.vcerts) {
                        return false;
                    }
                    if (that.vlocation != null) {
                        return that.vlocation.equals(this.vlocation);
                    }
                    if (this.vlocation != null) {
                        return this.vlocation.equals(that.vlocation);
                    }
                    return true;
                }
            }
            return super.equals(obj);
        }

        boolean isSameDomain(Object csdomain) {
            return this.csdomain == csdomain;
        }

        private CodeSigner[] getPrivateSigners() {
            return this.vsigners;
        }

        private Certificate[] getPrivateCertificates() {
            return this.vcerts;
        }
    }

    static class VerifierStream
    extends InputStream {
        private InputStream is;
        private JarVerifier jv;
        private ManifestEntryVerifier mev;
        private long numLeft;

        VerifierStream(Manifest man, JarEntry je, InputStream is, JarVerifier jv) throws IOException {
            this.is = is;
            this.jv = jv;
            this.mev = new ManifestEntryVerifier(man);
            this.jv.beginEntry(je, this.mev);
            this.numLeft = je.getSize();
            if (this.numLeft == 0L) {
                this.jv.update(-1, this.mev);
            }
        }

        @Override
        public int read() throws IOException {
            if (this.numLeft > 0L) {
                int b = this.is.read();
                this.jv.update(b, this.mev);
                --this.numLeft;
                if (this.numLeft == 0L) {
                    this.jv.update(-1, this.mev);
                }
                return b;
            }
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.numLeft > 0L && this.numLeft < (long)len) {
                len = (int)this.numLeft;
            }
            if (this.numLeft > 0L) {
                int n = this.is.read(b, off, len);
                this.jv.update(n, b, off, len, this.mev);
                this.numLeft -= (long)n;
                if (this.numLeft == 0L) {
                    this.jv.update(-1, b, off, len, this.mev);
                }
                return n;
            }
            return -1;
        }

        @Override
        public void close() throws IOException {
            if (this.is != null) {
                this.is.close();
            }
            this.is = null;
            this.mev = null;
            this.jv = null;
        }

        @Override
        public int available() throws IOException {
            return this.is.available();
        }
    }
}

