/*
 * Decompiled with CFR 0.152.
 */
package com.sun.naming.internal;

import com.sun.naming.internal.VersionHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import sun.reflect.misc.ReflectUtil;

final class VersionHelper12
extends VersionHelper {
    private static final boolean noPackageAccessWithTCCL = "true".equals(AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("com.sun.naming.untieAccessContextWithTCCL");
        }
    }));

    VersionHelper12() {
    }

    @Override
    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, this.getContextClassLoader());
    }

    @Override
    Class loadClass(String className, ClassLoader cl) throws ClassNotFoundException {
        Class<?> cls = Class.forName(className, true, cl);
        VersionHelper12.checkPackageAccess(cls);
        return cls;
    }

    @Override
    public Class loadClass(String className, String codebase) throws ClassNotFoundException, MalformedURLException {
        ClassLoader parent = this.getContextClassLoader();
        URLClassLoader cl = URLClassLoader.newInstance(VersionHelper12.getUrlArray(codebase), parent);
        return this.loadClass(className, cl);
    }

    static void checkPackageAccess(Class<?> cls) {
        if (noPackageAccessWithTCCL) {
            return;
        }
        final SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (ReflectUtil.isNonPublicProxyClass(cls)) {
                for (Class<?> intf : cls.getInterfaces()) {
                    VersionHelper12.checkPackageAccess(intf);
                }
                return;
            }
            final String name = cls.getName();
            final int i = name.lastIndexOf(46);
            if (i != -1) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        sm.checkPackageAccess(name.substring(0, i));
                        return null;
                    }
                }, AccessController.getContext());
            }
        }
    }

    @Override
    String getJndiProperty(final int i) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty(VersionHelper.PROPS[i]);
                }
                catch (SecurityException e) {
                    return null;
                }
            }
        });
    }

    @Override
    String[] getJndiProperties() {
        Properties sysProps = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperties();
                }
                catch (SecurityException e) {
                    return null;
                }
            }
        });
        if (sysProps == null) {
            return null;
        }
        String[] jProps = new String[PROPS.length];
        for (int i = 0; i < PROPS.length; ++i) {
            jProps[i] = sysProps.getProperty(PROPS[i]);
        }
        return jProps;
    }

    @Override
    InputStream getResourceAsStream(final Class c, final String name) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return c.getResourceAsStream(name);
            }
        });
    }

    @Override
    InputStream getJavaHomeLibStream(final String filename) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    String javahome = System.getProperty("java.home");
                    if (javahome == null) {
                        return null;
                    }
                    String pathname = javahome + File.separator + "lib" + File.separator + filename;
                    return new FileInputStream(pathname);
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    @Override
    NamingEnumeration getResources(final ClassLoader cl, final String name) throws IOException {
        Enumeration urls;
        try {
            urls = (Enumeration)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return cl == null ? ClassLoader.getSystemResources(name) : cl.getResources(name);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        return new InputStreamEnumeration(urls);
    }

    @Override
    ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    class InputStreamEnumeration
    implements NamingEnumeration {
        private final Enumeration urls;
        private Object nextElement = null;

        InputStreamEnumeration(Enumeration urls) {
            this.urls = urls;
        }

        private Object getNextElement() {
            return AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    while (InputStreamEnumeration.this.urls.hasMoreElements()) {
                        try {
                            return ((URL)InputStreamEnumeration.this.urls.nextElement()).openStream();
                        }
                        catch (IOException iOException) {
                        }
                    }
                    return null;
                }
            });
        }

        @Override
        public boolean hasMore() {
            if (this.nextElement != null) {
                return true;
            }
            this.nextElement = this.getNextElement();
            return this.nextElement != null;
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasMore();
        }

        public Object next() {
            if (this.hasMore()) {
                Object res = this.nextElement;
                this.nextElement = null;
                return res;
            }
            throw new NoSuchElementException();
        }

        @Override
        public Object nextElement() {
            return this.next();
        }

        @Override
        public void close() {
        }
    }
}

