/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.ProviderException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import sun.security.action.GetPropertyAction;
import sun.security.pkcs11.ConfigurationException;
import sun.security.pkcs11.Secmod;
import sun.security.pkcs11.SunPKCS11;
import sun.security.pkcs11.TemplateManager;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.Functions;
import sun.security.util.PropertyExpander;

final class Config {
    static final int ERR_HALT = 1;
    static final int ERR_IGNORE_ALL = 2;
    static final int ERR_IGNORE_LIB = 3;
    static final int ERR_IGNORE_MULTI_INIT = 4;
    private static final boolean staticAllowSingleThreadedModules;
    private static final Map<String, Config> configMap;
    private static final boolean DEBUG = false;
    private Reader reader;
    private StreamTokenizer st;
    private Set<String> parsedKeywords;
    private String name;
    private String library;
    private String description;
    private int slotID = -1;
    private int slotListIndex = -1;
    private Set<Long> enabledMechanisms;
    private Set<Long> disabledMechanisms;
    private boolean showInfo = false;
    private TemplateManager templateManager;
    private int handleStartupErrors = 1;
    private boolean keyStoreCompatibilityMode = true;
    private boolean explicitCancel = true;
    private int insertionCheckInterval = 2000;
    private boolean omitInitialize = false;
    private boolean allowSingleThreadedModules = true;
    private String functionList = "C_GetFunctionList";
    private boolean nssUseSecmod;
    private String nssLibraryDirectory;
    private String nssSecmodDirectory;
    private String nssModule;
    private Secmod.DbMode nssDbMode = Secmod.DbMode.READ_WRITE;
    private boolean nssNetscapeDbWorkaround = true;
    private String nssArgs;
    private boolean nssUseSecmodTrust = false;
    private boolean useEcX963Encoding = false;
    private boolean nssOptimizeSpace = false;
    private static final CK_ATTRIBUTE[] CK_A0;

    static Config getConfig(String name, InputStream stream) {
        Config config = configMap.get(name);
        if (config != null) {
            return config;
        }
        try {
            config = new Config(name, stream);
            configMap.put(name, config);
            return config;
        }
        catch (Exception e) {
            throw new ProviderException("Error parsing configuration", e);
        }
    }

    static Config removeConfig(String name) {
        return configMap.remove(name);
    }

    private static void debug(Object o) {
    }

    private Config(String filename, InputStream in) throws IOException {
        if (in == null) {
            if (filename.startsWith("--")) {
                String config = filename.substring(2).replace("\\n", "\n");
                this.reader = new StringReader(config);
            } else {
                in = new FileInputStream(Config.expand(filename));
            }
        }
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader(in));
        }
        this.parsedKeywords = new HashSet<String>();
        this.st = new StreamTokenizer(this.reader);
        this.setupTokenizer();
        this.parse();
    }

    String getName() {
        return this.name;
    }

    String getLibrary() {
        return this.library;
    }

    String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return "SunPKCS11-" + this.name + " using library " + this.library;
    }

    int getSlotID() {
        return this.slotID;
    }

    int getSlotListIndex() {
        if (this.slotID == -1 && this.slotListIndex == -1) {
            return 0;
        }
        return this.slotListIndex;
    }

    boolean getShowInfo() {
        return SunPKCS11.debug != null || this.showInfo;
    }

    TemplateManager getTemplateManager() {
        if (this.templateManager == null) {
            this.templateManager = new TemplateManager();
        }
        return this.templateManager;
    }

    boolean isEnabled(long m) {
        if (this.enabledMechanisms != null) {
            return this.enabledMechanisms.contains(m);
        }
        if (this.disabledMechanisms != null) {
            return !this.disabledMechanisms.contains(m);
        }
        return true;
    }

    int getHandleStartupErrors() {
        return this.handleStartupErrors;
    }

    boolean getKeyStoreCompatibilityMode() {
        return this.keyStoreCompatibilityMode;
    }

    boolean getExplicitCancel() {
        return this.explicitCancel;
    }

    int getInsertionCheckInterval() {
        return this.insertionCheckInterval;
    }

    boolean getOmitInitialize() {
        return this.omitInitialize;
    }

    boolean getAllowSingleThreadedModules() {
        return staticAllowSingleThreadedModules && this.allowSingleThreadedModules;
    }

    String getFunctionList() {
        return this.functionList;
    }

    boolean getNssUseSecmod() {
        return this.nssUseSecmod;
    }

    String getNssLibraryDirectory() {
        return this.nssLibraryDirectory;
    }

    String getNssSecmodDirectory() {
        return this.nssSecmodDirectory;
    }

    String getNssModule() {
        return this.nssModule;
    }

    Secmod.DbMode getNssDbMode() {
        return this.nssDbMode;
    }

    public boolean getNssNetscapeDbWorkaround() {
        return this.nssUseSecmod && this.nssNetscapeDbWorkaround;
    }

    String getNssArgs() {
        return this.nssArgs;
    }

    boolean getNssUseSecmodTrust() {
        return this.nssUseSecmodTrust;
    }

    boolean getUseEcX963Encoding() {
        return this.useEcX963Encoding;
    }

    boolean getNssOptimizeSpace() {
        return this.nssOptimizeSpace;
    }

    private static String expand(String s) throws IOException {
        try {
            return PropertyExpander.expand(s);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private void setupTokenizer() {
        this.st.resetSyntax();
        this.st.wordChars(97, 122);
        this.st.wordChars(65, 90);
        this.st.wordChars(48, 57);
        this.st.wordChars(58, 58);
        this.st.wordChars(46, 46);
        this.st.wordChars(95, 95);
        this.st.wordChars(45, 45);
        this.st.wordChars(47, 47);
        this.st.wordChars(92, 92);
        this.st.wordChars(36, 36);
        this.st.wordChars(123, 123);
        this.st.wordChars(125, 125);
        this.st.wordChars(42, 42);
        this.st.wordChars(43, 43);
        this.st.wordChars(126, 126);
        this.st.whitespaceChars(0, 32);
        this.st.commentChar(35);
        this.st.eolIsSignificant(true);
        this.st.quoteChar(34);
    }

    private ConfigurationException excToken(String msg) {
        return new ConfigurationException(msg + " " + this.st);
    }

    private ConfigurationException excLine(String msg) {
        return new ConfigurationException(msg + ", line " + this.st.lineno());
    }

    private void parse() throws IOException {
        int token;
        while ((token = this.nextToken()) != -1) {
            if (token == 10) continue;
            if (token != -3) {
                throw this.excToken("Unexpected token:");
            }
            String word = this.st.sval;
            if (word.equals("name")) {
                this.name = this.parseStringEntry(word);
            } else if (word.equals("library")) {
                this.library = this.parseLibrary(word);
            } else if (word.equals("description")) {
                this.parseDescription(word);
            } else if (word.equals("slot")) {
                this.parseSlotID(word);
            } else if (word.equals("slotListIndex")) {
                this.parseSlotListIndex(word);
            } else if (word.equals("enabledMechanisms")) {
                this.parseEnabledMechanisms(word);
            } else if (word.equals("disabledMechanisms")) {
                this.parseDisabledMechanisms(word);
            } else if (word.equals("attributes")) {
                this.parseAttributes(word);
            } else if (word.equals("handleStartupErrors")) {
                this.parseHandleStartupErrors(word);
            } else if (word.endsWith("insertionCheckInterval")) {
                this.insertionCheckInterval = this.parseIntegerEntry(word);
                if (this.insertionCheckInterval < 100) {
                    throw this.excLine(word + " must be at least 100 ms");
                }
            } else if (word.equals("showInfo")) {
                this.showInfo = this.parseBooleanEntry(word);
            } else if (word.equals("keyStoreCompatibilityMode")) {
                this.keyStoreCompatibilityMode = this.parseBooleanEntry(word);
            } else if (word.equals("explicitCancel")) {
                this.explicitCancel = this.parseBooleanEntry(word);
            } else if (word.equals("omitInitialize")) {
                this.omitInitialize = this.parseBooleanEntry(word);
            } else if (word.equals("allowSingleThreadedModules")) {
                this.allowSingleThreadedModules = this.parseBooleanEntry(word);
            } else if (word.equals("functionList")) {
                this.functionList = this.parseStringEntry(word);
            } else if (word.equals("nssUseSecmod")) {
                this.nssUseSecmod = this.parseBooleanEntry(word);
            } else if (word.equals("nssLibraryDirectory")) {
                this.nssLibraryDirectory = this.parseLibrary(word);
                this.nssUseSecmod = true;
            } else if (word.equals("nssSecmodDirectory")) {
                this.nssSecmodDirectory = Config.expand(this.parseStringEntry(word));
                this.nssUseSecmod = true;
            } else if (word.equals("nssModule")) {
                this.nssModule = this.parseStringEntry(word);
                this.nssUseSecmod = true;
            } else if (word.equals("nssDbMode")) {
                String mode = this.parseStringEntry(word);
                if (mode.equals("readWrite")) {
                    this.nssDbMode = Secmod.DbMode.READ_WRITE;
                } else if (mode.equals("readOnly")) {
                    this.nssDbMode = Secmod.DbMode.READ_ONLY;
                } else if (mode.equals("noDb")) {
                    this.nssDbMode = Secmod.DbMode.NO_DB;
                } else {
                    throw this.excToken("nssDbMode must be one of readWrite, readOnly, and noDb:");
                }
                this.nssUseSecmod = true;
            } else if (word.equals("nssNetscapeDbWorkaround")) {
                this.nssNetscapeDbWorkaround = this.parseBooleanEntry(word);
                this.nssUseSecmod = true;
            } else if (word.equals("nssArgs")) {
                this.parseNSSArgs(word);
            } else if (word.equals("nssUseSecmodTrust")) {
                this.nssUseSecmodTrust = this.parseBooleanEntry(word);
            } else if (word.equals("useEcX963Encoding")) {
                this.useEcX963Encoding = this.parseBooleanEntry(word);
            } else if (word.equals("nssOptimizeSpace")) {
                this.nssOptimizeSpace = this.parseBooleanEntry(word);
            } else {
                throw new ConfigurationException("Unknown keyword '" + word + "', line " + this.st.lineno());
            }
            this.parsedKeywords.add(word);
        }
        this.reader.close();
        this.reader = null;
        this.st = null;
        this.parsedKeywords = null;
        if (this.name == null) {
            throw new ConfigurationException("name must be specified");
        }
        if (!this.nssUseSecmod) {
            if (this.library == null) {
                throw new ConfigurationException("library must be specified");
            }
        } else {
            if (this.library != null) {
                throw new ConfigurationException("library must not be specified in NSS mode");
            }
            if (this.slotID != -1 || this.slotListIndex != -1) {
                throw new ConfigurationException("slot and slotListIndex must not be specified in NSS mode");
            }
            if (this.nssArgs != null) {
                throw new ConfigurationException("nssArgs must not be specified in NSS mode");
            }
            if (this.nssUseSecmodTrust) {
                throw new ConfigurationException("nssUseSecmodTrust is an internal option and must not be specified in NSS mode");
            }
        }
    }

    private int nextToken() throws IOException {
        int token = this.st.nextToken();
        Config.debug(this.st);
        return token;
    }

    private void parseEquals() throws IOException {
        int token = this.nextToken();
        if (token != 61) {
            throw this.excToken("Expected '=', read");
        }
    }

    private void parseOpenBraces() throws IOException {
        int token;
        while ((token = this.nextToken()) == 10) {
        }
        if (token == -3 && this.st.sval.equals("{")) {
            return;
        }
        throw this.excToken("Expected '{', read");
    }

    private boolean isCloseBraces(int token) {
        return token == -3 && this.st.sval.equals("}");
    }

    private String parseWord() throws IOException {
        int token = this.nextToken();
        if (token != -3) {
            throw this.excToken("Unexpected value:");
        }
        return this.st.sval;
    }

    private String parseStringEntry(String keyword) throws IOException {
        this.checkDup(keyword);
        this.parseEquals();
        int token = this.nextToken();
        if (token != -3 && token != 34) {
            throw this.excToken("Unexpected value:");
        }
        String value = this.st.sval;
        Config.debug(keyword + ": " + value);
        return value;
    }

    private boolean parseBooleanEntry(String keyword) throws IOException {
        this.checkDup(keyword);
        this.parseEquals();
        boolean value = this.parseBoolean();
        Config.debug(keyword + ": " + value);
        return value;
    }

    private int parseIntegerEntry(String keyword) throws IOException {
        this.checkDup(keyword);
        this.parseEquals();
        int value = this.decodeNumber(this.parseWord());
        Config.debug(keyword + ": " + value);
        return value;
    }

    private boolean parseBoolean() throws IOException {
        String val = this.parseWord();
        if (val.equals("true")) {
            return true;
        }
        if (val.equals("false")) {
            return false;
        }
        throw this.excToken("Expected boolean value, read:");
    }

    private String parseLine() throws IOException {
        int token;
        String s = this.parseWord();
        while ((token = this.nextToken()) != 10 && token != -1) {
            if (token != -3) {
                throw this.excToken("Unexpected value");
            }
            s = s + " " + this.st.sval;
        }
        return s;
    }

    private int decodeNumber(String str) throws IOException {
        try {
            if (str.startsWith("0x") || str.startsWith("0X")) {
                return Integer.parseInt(str.substring(2), 16);
            }
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw this.excToken("Expected number, read");
        }
    }

    private static boolean isNumber(String s) {
        if (s.length() == 0) {
            return false;
        }
        char ch = s.charAt(0);
        return ch >= '0' && ch <= '9';
    }

    private void parseComma() throws IOException {
        int token = this.nextToken();
        if (token != 44) {
            throw this.excToken("Expected ',', read");
        }
    }

    private static boolean isByteArray(String val) {
        return val.startsWith("0h");
    }

    private byte[] decodeByteArray(String str) throws IOException {
        if (!str.startsWith("0h")) {
            throw this.excToken("Expected byte array value, read");
        }
        str = str.substring(2);
        try {
            return new BigInteger(str, 16).toByteArray();
        }
        catch (NumberFormatException e) {
            throw this.excToken("Expected byte array value, read");
        }
    }

    private void checkDup(String keyword) throws IOException {
        if (this.parsedKeywords.contains(keyword)) {
            throw this.excLine(keyword + " must only be specified once");
        }
    }

    private String parseLibrary(String keyword) throws IOException {
        this.checkDup(keyword);
        this.parseEquals();
        String lib = this.parseLine();
        lib = Config.expand(lib);
        int i = lib.indexOf("/$ISA/");
        if (i != -1) {
            String osName = System.getProperty("os.name", "");
            String osArch = System.getProperty("os.arch", "");
            String prefix = lib.substring(0, i);
            String suffix = lib.substring(i + 5);
            lib = osName.equals("SunOS") && osArch.equals("sparcv9") ? prefix + "/sparcv9" + suffix : (osName.equals("SunOS") && osArch.equals("amd64") ? prefix + "/amd64" + suffix : prefix + suffix);
        }
        Config.debug(keyword + ": " + lib);
        if (!new File(lib).isAbsolute()) {
            throw new ConfigurationException("Absolute path required for library value: " + lib);
        }
        return lib;
    }

    private void parseDescription(String keyword) throws IOException {
        this.checkDup(keyword);
        this.parseEquals();
        this.description = this.parseLine();
        Config.debug("description: " + this.description);
    }

    private void parseSlotID(String keyword) throws IOException {
        if (this.slotID >= 0) {
            throw this.excLine("Duplicate slot definition");
        }
        if (this.slotListIndex >= 0) {
            throw this.excLine("Only one of slot and slotListIndex must be specified");
        }
        this.parseEquals();
        String slotString = this.parseWord();
        this.slotID = this.decodeNumber(slotString);
        Config.debug("slot: " + this.slotID);
    }

    private void parseSlotListIndex(String keyword) throws IOException {
        if (this.slotListIndex >= 0) {
            throw this.excLine("Duplicate slotListIndex definition");
        }
        if (this.slotID >= 0) {
            throw this.excLine("Only one of slot and slotListIndex must be specified");
        }
        this.parseEquals();
        String slotString = this.parseWord();
        this.slotListIndex = this.decodeNumber(slotString);
        Config.debug("slotListIndex: " + this.slotListIndex);
    }

    private void parseEnabledMechanisms(String keyword) throws IOException {
        this.enabledMechanisms = this.parseMechanisms(keyword);
    }

    private void parseDisabledMechanisms(String keyword) throws IOException {
        this.disabledMechanisms = this.parseMechanisms(keyword);
    }

    private Set<Long> parseMechanisms(String keyword) throws IOException {
        int token;
        this.checkDup(keyword);
        HashSet<Long> mechs = new HashSet<Long>();
        this.parseEquals();
        this.parseOpenBraces();
        while (!this.isCloseBraces(token = this.nextToken())) {
            if (token == 10) continue;
            if (token != -3) {
                throw this.excToken("Expected mechanism, read");
            }
            long mech = this.parseMechanism(this.st.sval);
            mechs.add(mech);
        }
        return mechs;
    }

    private long parseMechanism(String mech) throws IOException {
        if (Config.isNumber(mech)) {
            return this.decodeNumber(mech);
        }
        try {
            return Functions.getMechanismId(mech);
        }
        catch (IllegalArgumentException e) {
            throw this.excLine("Unknown mechanism: " + mech);
        }
    }

    private void parseAttributes(String keyword) throws IOException {
        int token;
        if (this.templateManager == null) {
            this.templateManager = new TemplateManager();
        }
        if ((token = this.nextToken()) == 61) {
            String s = this.parseWord();
            if (!s.equals("compatibility")) {
                throw this.excLine("Expected 'compatibility', read " + s);
            }
            this.setCompatibilityAttributes();
            return;
        }
        if (token != 40) {
            throw this.excToken("Expected '(' or '=', read");
        }
        String op = this.parseOperation();
        this.parseComma();
        long objectClass = this.parseObjectClass();
        this.parseComma();
        long keyAlg = this.parseKeyAlgorithm();
        token = this.nextToken();
        if (token != 41) {
            throw this.excToken("Expected ')', read");
        }
        this.parseEquals();
        this.parseOpenBraces();
        ArrayList<CK_ATTRIBUTE> attributes = new ArrayList<CK_ATTRIBUTE>();
        while (!this.isCloseBraces(token = this.nextToken())) {
            if (token == 10) continue;
            if (token != -3) {
                throw this.excToken("Expected mechanism, read");
            }
            String attributeName = this.st.sval;
            long attributeId = this.decodeAttributeName(attributeName);
            this.parseEquals();
            String attributeValue = this.parseWord();
            attributes.add(this.decodeAttributeValue(attributeId, attributeValue));
        }
        this.templateManager.addTemplate(op, objectClass, keyAlg, attributes.toArray(CK_A0));
    }

    private void setCompatibilityAttributes() {
        this.templateManager.addTemplate("*", 4L, 0x7FFFFF22L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.TOKEN_FALSE, CK_ATTRIBUTE.SENSITIVE_FALSE, CK_ATTRIBUTE.EXTRACTABLE_TRUE, CK_ATTRIBUTE.ENCRYPT_TRUE, CK_ATTRIBUTE.DECRYPT_TRUE, CK_ATTRIBUTE.WRAP_TRUE, CK_ATTRIBUTE.UNWRAP_TRUE});
        this.templateManager.addTemplate("*", 4L, 16L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.SIGN_TRUE, CK_ATTRIBUTE.VERIFY_TRUE, CK_ATTRIBUTE.ENCRYPT_NULL, CK_ATTRIBUTE.DECRYPT_NULL, CK_ATTRIBUTE.WRAP_NULL, CK_ATTRIBUTE.UNWRAP_NULL, CK_ATTRIBUTE.DERIVE_TRUE});
        this.templateManager.addTemplate("*", 3L, 0x7FFFFF22L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.TOKEN_FALSE, CK_ATTRIBUTE.SENSITIVE_FALSE, CK_ATTRIBUTE.EXTRACTABLE_TRUE});
        this.templateManager.addTemplate("*", 2L, 0x7FFFFF22L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.TOKEN_FALSE});
        this.templateManager.addTemplate("*", 3L, 0L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.DECRYPT_TRUE, CK_ATTRIBUTE.SIGN_TRUE, CK_ATTRIBUTE.SIGN_RECOVER_TRUE, CK_ATTRIBUTE.UNWRAP_TRUE});
        this.templateManager.addTemplate("*", 2L, 0L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.ENCRYPT_TRUE, CK_ATTRIBUTE.VERIFY_TRUE, CK_ATTRIBUTE.VERIFY_RECOVER_TRUE, CK_ATTRIBUTE.WRAP_TRUE});
        this.templateManager.addTemplate("*", 3L, 1L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.SIGN_TRUE});
        this.templateManager.addTemplate("*", 2L, 1L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.VERIFY_TRUE});
        this.templateManager.addTemplate("*", 3L, 2L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.DERIVE_TRUE});
        this.templateManager.addTemplate("*", 3L, 3L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.SIGN_TRUE, CK_ATTRIBUTE.DERIVE_TRUE});
        this.templateManager.addTemplate("*", 2L, 3L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.VERIFY_TRUE});
    }

    private String parseOperation() throws IOException {
        String op = this.parseWord();
        if (op.equals("*")) {
            return "*";
        }
        if (op.equals("generate")) {
            return "generate";
        }
        if (op.equals("import")) {
            return "import";
        }
        throw this.excLine("Unknown operation " + op);
    }

    private long parseObjectClass() throws IOException {
        String name = this.parseWord();
        try {
            return Functions.getObjectClassId(name);
        }
        catch (IllegalArgumentException e) {
            throw this.excLine("Unknown object class " + name);
        }
    }

    private long parseKeyAlgorithm() throws IOException {
        String name = this.parseWord();
        if (Config.isNumber(name)) {
            return this.decodeNumber(name);
        }
        try {
            return Functions.getKeyId(name);
        }
        catch (IllegalArgumentException e) {
            throw this.excLine("Unknown key algorithm " + name);
        }
    }

    private long decodeAttributeName(String name) throws IOException {
        if (Config.isNumber(name)) {
            return this.decodeNumber(name);
        }
        try {
            return Functions.getAttributeId(name);
        }
        catch (IllegalArgumentException e) {
            throw this.excLine("Unknown attribute name " + name);
        }
    }

    private CK_ATTRIBUTE decodeAttributeValue(long id, String value) throws IOException {
        if (value.equals("null")) {
            return new CK_ATTRIBUTE(id);
        }
        if (value.equals("true")) {
            return new CK_ATTRIBUTE(id, true);
        }
        if (value.equals("false")) {
            return new CK_ATTRIBUTE(id, false);
        }
        if (Config.isByteArray(value)) {
            return new CK_ATTRIBUTE(id, this.decodeByteArray(value));
        }
        if (Config.isNumber(value)) {
            return new CK_ATTRIBUTE(id, (Object)this.decodeNumber(value));
        }
        throw this.excLine("Unknown attribute value " + value);
    }

    private void parseNSSArgs(String keyword) throws IOException {
        this.checkDup(keyword);
        this.parseEquals();
        int token = this.nextToken();
        if (token != 34) {
            throw this.excToken("Expected quoted string");
        }
        this.nssArgs = Config.expand(this.st.sval);
        Config.debug("nssArgs: " + this.nssArgs);
    }

    private void parseHandleStartupErrors(String keyword) throws IOException {
        this.checkDup(keyword);
        this.parseEquals();
        String val = this.parseWord();
        if (val.equals("ignoreAll")) {
            this.handleStartupErrors = 2;
        } else if (val.equals("ignoreMissingLibrary")) {
            this.handleStartupErrors = 3;
        } else if (val.equals("halt")) {
            this.handleStartupErrors = 1;
        } else if (val.equals("ignoreMultipleInitialisation")) {
            this.handleStartupErrors = 4;
        } else {
            throw this.excToken("Invalid value for handleStartupErrors:");
        }
        Config.debug("handleStartupErrors: " + this.handleStartupErrors);
    }

    static {
        String p = "sun.security.pkcs11.allowSingleThreadedModules";
        String s = AccessController.doPrivileged(new GetPropertyAction(p));
        staticAllowSingleThreadedModules = !"false".equalsIgnoreCase(s);
        configMap = new HashMap<String, Config>();
        CK_A0 = new CK_ATTRIBUTE[0];
    }
}

