/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.tools.jconsole.JConsoleContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteObjectInvocationHandler;
import java.rmi.server.RemoteRef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.swing.event.SwingPropertyChangeSupport;
import sun.rmi.server.UnicastRef2;
import sun.rmi.transport.LiveRef;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.LocalVirtualMachine;
import sun.tools.jconsole.MemoryPoolProxy;
import sun.tools.jconsole.Resources;

public class ProxyClient
implements JConsoleContext {
    private JConsoleContext.ConnectionState connectionState = JConsoleContext.ConnectionState.DISCONNECTED;
    private SwingPropertyChangeSupport propertyChangeSupport = new SwingPropertyChangeSupport(this, true);
    private static Map<String, ProxyClient> cache = Collections.synchronizedMap(new HashMap());
    private volatile boolean isDead = true;
    private String hostName = null;
    private int port = 0;
    private String userName = null;
    private String password = null;
    private boolean hasPlatformMXBeans = false;
    private boolean hasHotSpotDiagnosticMXBean = false;
    private boolean hasCompilationMXBean = false;
    private boolean supportsLockUsage = false;
    private LocalVirtualMachine lvm;
    private String advancedUrl = null;
    private JMXServiceURL jmxUrl = null;
    private MBeanServerConnection mbsc = null;
    private SnapshotMBeanServerConnection server = null;
    private JMXConnector jmxc = null;
    private RMIServer stub = null;
    private static final SslRMIClientSocketFactory sslRMIClientSocketFactory = new SslRMIClientSocketFactory();
    private String registryHostName = null;
    private int registryPort = 0;
    private boolean vmConnector = false;
    private boolean sslRegistry = false;
    private boolean sslStub = false;
    private final String connectionName;
    private final String displayName;
    private ClassLoadingMXBean classLoadingMBean = null;
    private CompilationMXBean compilationMBean = null;
    private MemoryMXBean memoryMBean = null;
    private OperatingSystemMXBean operatingSystemMBean = null;
    private RuntimeMXBean runtimeMBean = null;
    private ThreadMXBean threadMBean = null;
    private com.sun.management.OperatingSystemMXBean sunOperatingSystemMXBean = null;
    private HotSpotDiagnosticMXBean hotspotDiagnosticMXBean = null;
    private List<MemoryPoolProxy> memoryPoolProxies = null;
    private List<GarbageCollectorMXBean> garbageCollectorMBeans = null;
    private static final String HOTSPOT_DIAGNOSTIC_MXBEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static final String rmiServerImplStubClassName = "javax.management.remote.rmi.RMIServerImpl_Stub";
    private static final Class<? extends Remote> rmiServerImplStubClass;

    private ProxyClient(String hostName, int port, String userName, String password) throws IOException {
        this.displayName = this.connectionName = ProxyClient.getConnectionName(hostName, port, userName);
        if (hostName.equals("localhost") && port == 0) {
            this.hostName = hostName;
            this.port = port;
        } else {
            String urlPath = "/jndi/rmi://" + hostName + ":" + port + "/jmxrmi";
            JMXServiceURL url = new JMXServiceURL("rmi", "", 0, urlPath);
            this.setParameters(url, userName, password);
            this.vmConnector = true;
            this.registryHostName = hostName;
            this.registryPort = port;
            this.checkSslConfig();
        }
    }

    private ProxyClient(String url, String userName, String password) throws IOException {
        this.advancedUrl = url;
        this.displayName = this.connectionName = ProxyClient.getConnectionName(url, userName);
        this.setParameters(new JMXServiceURL(url), userName, password);
    }

    private ProxyClient(LocalVirtualMachine lvm) throws IOException {
        this.lvm = lvm;
        this.connectionName = ProxyClient.getConnectionName(lvm);
        this.displayName = "pid: " + lvm.vmid() + " " + lvm.displayName();
    }

    private void setParameters(JMXServiceURL url, String userName, String password) {
        this.jmxUrl = url;
        this.hostName = this.jmxUrl.getHost();
        this.port = this.jmxUrl.getPort();
        this.userName = userName;
        this.password = password;
    }

    private static void checkStub(Remote stub, Class<? extends Remote> stubClass) {
        RemoteRef ref;
        if (stub.getClass() != stubClass) {
            if (!Proxy.isProxyClass(stub.getClass())) {
                throw new SecurityException("Expecting a " + stubClass.getName() + " stub!");
            }
            InvocationHandler handler = Proxy.getInvocationHandler(stub);
            if (handler.getClass() != RemoteObjectInvocationHandler.class) {
                throw new SecurityException("Expecting a dynamic proxy instance with a " + RemoteObjectInvocationHandler.class.getName() + " invocation handler!");
            }
            stub = (Remote)((Object)handler);
        }
        if ((ref = ((RemoteObject)stub).getRef()).getClass() != UnicastRef2.class) {
            throw new SecurityException("Expecting a " + UnicastRef2.class.getName() + " remote reference in stub!");
        }
        LiveRef liveRef = ((UnicastRef2)ref).getLiveRef();
        RMIClientSocketFactory csf = liveRef.getClientSocketFactory();
        if (csf == null || csf.getClass() != SslRMIClientSocketFactory.class) {
            throw new SecurityException("Expecting a " + SslRMIClientSocketFactory.class.getName() + " RMI client socket factory in stub!");
        }
    }

    private void checkSslConfig() throws IOException {
        try {
            Registry registry = LocateRegistry.getRegistry(this.registryHostName, this.registryPort, sslRMIClientSocketFactory);
            try {
                this.stub = (RMIServer)registry.lookup("jmxrmi");
            }
            catch (NotBoundException nbe) {
                throw (IOException)new IOException(nbe.getMessage()).initCause(nbe);
            }
            this.sslRegistry = true;
        }
        catch (IOException e) {
            Registry registry = LocateRegistry.getRegistry(this.registryHostName, this.registryPort);
            try {
                this.stub = (RMIServer)registry.lookup("jmxrmi");
            }
            catch (NotBoundException nbe) {
                throw (IOException)new IOException(nbe.getMessage()).initCause(nbe);
            }
            this.sslRegistry = false;
        }
        try {
            ProxyClient.checkStub(this.stub, rmiServerImplStubClass);
            this.sslStub = true;
        }
        catch (SecurityException e) {
            this.sslStub = false;
        }
    }

    public boolean isSslRmiRegistry() {
        if (!this.isVmConnector()) {
            throw new UnsupportedOperationException("ProxyClient.isSslRmiRegistry() is only supported if this ProxyClient is a JMX connector for a JMX VM agent");
        }
        return this.sslRegistry;
    }

    public boolean isSslRmiStub() {
        if (!this.isVmConnector()) {
            throw new UnsupportedOperationException("ProxyClient.isSslRmiStub() is only supported if this ProxyClient is a JMX connector for a JMX VM agent");
        }
        return this.sslStub;
    }

    public boolean isVmConnector() {
        return this.vmConnector;
    }

    private void setConnectionState(JConsoleContext.ConnectionState state) {
        JConsoleContext.ConnectionState oldState = this.connectionState;
        this.connectionState = state;
        this.propertyChangeSupport.firePropertyChange("connectionState", (Object)oldState, (Object)state);
    }

    @Override
    public JConsoleContext.ConnectionState getConnectionState() {
        return this.connectionState;
    }

    void flush() {
        if (this.server != null) {
            this.server.flush();
        }
    }

    void connect() {
        this.setConnectionState(JConsoleContext.ConnectionState.CONNECTING);
        try {
            this.tryConnect();
            this.setConnectionState(JConsoleContext.ConnectionState.CONNECTED);
        }
        catch (Exception e) {
            if (JConsole.isDebug()) {
                e.printStackTrace();
            }
            this.setConnectionState(JConsoleContext.ConnectionState.DISCONNECTED);
        }
    }

    private void tryConnect() throws IOException {
        if (this.jmxUrl == null && "localhost".equals(this.hostName) && this.port == 0) {
            this.jmxc = null;
            this.mbsc = ManagementFactory.getPlatformMBeanServer();
            this.server = Snapshot.newSnapshot(this.mbsc);
        } else {
            if (this.lvm != null) {
                if (!this.lvm.isManageable()) {
                    this.lvm.startManagementAgent();
                    if (!this.lvm.isManageable()) {
                        throw new IOException(this.lvm + "not manageable");
                    }
                }
                if (this.jmxUrl == null) {
                    this.jmxUrl = new JMXServiceURL(this.lvm.connectorAddress());
                }
            }
            if (this.userName == null && this.password == null) {
                if (this.isVmConnector()) {
                    if (this.stub == null) {
                        this.checkSslConfig();
                    }
                    this.jmxc = new RMIConnector(this.stub, null);
                    this.jmxc.connect();
                } else {
                    this.jmxc = JMXConnectorFactory.connect(this.jmxUrl);
                }
            } else {
                HashMap<String, String[]> env = new HashMap<String, String[]>();
                env.put("jmx.remote.credentials", new String[]{this.userName, this.password});
                if (this.isVmConnector()) {
                    if (this.stub == null) {
                        this.checkSslConfig();
                    }
                    this.jmxc = new RMIConnector(this.stub, null);
                    this.jmxc.connect(env);
                } else {
                    this.jmxc = JMXConnectorFactory.connect(this.jmxUrl, env);
                }
            }
            this.mbsc = this.jmxc.getMBeanServerConnection();
            this.server = Snapshot.newSnapshot(this.mbsc);
        }
        this.isDead = false;
        try {
            ObjectName on = new ObjectName("java.lang:type=Threading");
            this.hasPlatformMXBeans = this.server.isRegistered(on);
            this.hasHotSpotDiagnosticMXBean = this.server.isRegistered(new ObjectName(HOTSPOT_DIAGNOSTIC_MXBEAN_NAME));
            if (this.hasPlatformMXBeans) {
                MBeanOperationInfo[] mopis;
                for (MBeanOperationInfo op : mopis = this.server.getMBeanInfo(on).getOperations()) {
                    if (!op.getName().equals("findDeadlockedThreads")) continue;
                    this.supportsLockUsage = true;
                    break;
                }
                on = new ObjectName("java.lang:type=Compilation");
                this.hasCompilationMXBean = this.server.isRegistered(on);
            }
        }
        catch (MalformedObjectNameException e) {
            throw new InternalError(e.getMessage());
        }
        catch (IntrospectionException e) {
            InternalError ie = new InternalError(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        catch (InstanceNotFoundException e) {
            InternalError ie = new InternalError(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        catch (ReflectionException e) {
            InternalError ie = new InternalError(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        if (this.hasPlatformMXBeans) {
            this.getRuntimeMXBean();
        }
    }

    public static ProxyClient getProxyClient(LocalVirtualMachine lvm) throws IOException {
        String key = ProxyClient.getCacheKey(lvm);
        ProxyClient proxyClient = cache.get(key);
        if (proxyClient == null) {
            proxyClient = new ProxyClient(lvm);
            cache.put(key, proxyClient);
        }
        return proxyClient;
    }

    public static String getConnectionName(LocalVirtualMachine lvm) {
        return Integer.toString(lvm.vmid());
    }

    private static String getCacheKey(LocalVirtualMachine lvm) {
        return Integer.toString(lvm.vmid());
    }

    public static ProxyClient getProxyClient(String url, String userName, String password) throws IOException {
        String key = ProxyClient.getCacheKey(url, userName, password);
        ProxyClient proxyClient = cache.get(key);
        if (proxyClient == null) {
            proxyClient = new ProxyClient(url, userName, password);
            cache.put(key, proxyClient);
        }
        return proxyClient;
    }

    public static String getConnectionName(String url, String userName) {
        if (userName != null && userName.length() > 0) {
            return userName + "@" + url;
        }
        return url;
    }

    private static String getCacheKey(String url, String userName, String password) {
        return (url == null ? "" : url) + ":" + (userName == null ? "" : userName) + ":" + (password == null ? "" : password);
    }

    public static ProxyClient getProxyClient(String hostName, int port, String userName, String password) throws IOException {
        String key = ProxyClient.getCacheKey(hostName, port, userName, password);
        ProxyClient proxyClient = cache.get(key);
        if (proxyClient == null) {
            proxyClient = new ProxyClient(hostName, port, userName, password);
            cache.put(key, proxyClient);
        }
        return proxyClient;
    }

    public static String getConnectionName(String hostName, int port, String userName) {
        String name = hostName + ":" + port;
        if (userName != null && userName.length() > 0) {
            return userName + "@" + name;
        }
        return name;
    }

    private static String getCacheKey(String hostName, int port, String userName, String password) {
        return (hostName == null ? "" : hostName) + ":" + port + ":" + (userName == null ? "" : userName) + ":" + (password == null ? "" : password);
    }

    public String connectionName() {
        return this.connectionName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        if (!this.isConnected()) {
            return Resources.getText("ConnectionName (disconnected)", this.displayName);
        }
        return this.displayName;
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection() {
        return this.mbsc;
    }

    public SnapshotMBeanServerConnection getSnapshotMBeanServerConnection() {
        return this.server;
    }

    public String getUrl() {
        return this.advancedUrl;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public int getVmid() {
        return this.lvm != null ? this.lvm.vmid() : 0;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void disconnect() {
        this.stub = null;
        if (this.jmxc != null) {
            try {
                this.jmxc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.classLoadingMBean = null;
        this.compilationMBean = null;
        this.memoryMBean = null;
        this.operatingSystemMBean = null;
        this.runtimeMBean = null;
        this.threadMBean = null;
        this.sunOperatingSystemMXBean = null;
        this.garbageCollectorMBeans = null;
        if (!this.isDead) {
            this.isDead = true;
            this.setConnectionState(JConsoleContext.ConnectionState.DISCONNECTED);
        }
    }

    public String[] getDomains() throws IOException {
        return this.server.getDomains();
    }

    public Map<ObjectName, MBeanInfo> getMBeans(String domain) throws IOException {
        ObjectName name;
        block8: {
            name = null;
            if (domain != null) {
                try {
                    name = new ObjectName(domain + ":*");
                }
                catch (MalformedObjectNameException e) {
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError();
                }
            }
        }
        Set<ObjectName> mbeans = this.server.queryNames(name, null);
        HashMap<ObjectName, MBeanInfo> result = new HashMap<ObjectName, MBeanInfo>(mbeans.size());
        for (ObjectName object : mbeans) {
            if (!(object instanceof ObjectName)) continue;
            ObjectName o = object;
            try {
                MBeanInfo info = this.server.getMBeanInfo(o);
                result.put(o, info);
            }
            catch (IntrospectionException e) {
            }
            catch (InstanceNotFoundException e) {
            }
            catch (ReflectionException e) {}
        }
        return result;
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws IOException {
        AttributeList list = null;
        try {
            list = this.server.getAttributes(name, attributes);
        }
        catch (InstanceNotFoundException e) {
        }
        catch (ReflectionException e) {
            // empty catch block
        }
        return list;
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InvalidAttributeValueException, MBeanException, IOException {
        try {
            this.server.setAttribute(name, attribute);
        }
        catch (InstanceNotFoundException e) {
        }
        catch (AttributeNotFoundException e) {
            assert (false);
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws IOException, MBeanException {
        Object result = null;
        try {
            result = this.server.invoke(name, operationName, params, signature);
        }
        catch (InstanceNotFoundException e) {
        }
        catch (ReflectionException e) {
            // empty catch block
        }
        return result;
    }

    public synchronized ClassLoadingMXBean getClassLoadingMXBean() throws IOException {
        if (this.hasPlatformMXBeans && this.classLoadingMBean == null) {
            this.classLoadingMBean = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=ClassLoading", ClassLoadingMXBean.class);
        }
        return this.classLoadingMBean;
    }

    public synchronized CompilationMXBean getCompilationMXBean() throws IOException {
        if (this.hasCompilationMXBean && this.compilationMBean == null) {
            this.compilationMBean = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=Compilation", CompilationMXBean.class);
        }
        return this.compilationMBean;
    }

    public Collection<MemoryPoolProxy> getMemoryPoolProxies() throws IOException {
        if (this.memoryPoolProxies == null) {
            ObjectName poolName;
            block5: {
                poolName = null;
                try {
                    poolName = new ObjectName("java.lang:type=MemoryPool,*");
                }
                catch (MalformedObjectNameException e) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
            Set<ObjectName> mbeans = this.server.queryNames(poolName, null);
            if (mbeans != null) {
                this.memoryPoolProxies = new ArrayList<MemoryPoolProxy>();
                for (ObjectName objName : mbeans) {
                    MemoryPoolProxy p = new MemoryPoolProxy(this, objName);
                    this.memoryPoolProxies.add(p);
                }
            }
        }
        return this.memoryPoolProxies;
    }

    public synchronized Collection<GarbageCollectorMXBean> getGarbageCollectorMXBeans() throws IOException {
        if (this.garbageCollectorMBeans == null) {
            ObjectName gcName;
            block5: {
                gcName = null;
                try {
                    gcName = new ObjectName("java.lang:type=GarbageCollector,*");
                }
                catch (MalformedObjectNameException e) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
            Set<ObjectName> mbeans = this.server.queryNames(gcName, null);
            if (mbeans != null) {
                this.garbageCollectorMBeans = new ArrayList<GarbageCollectorMXBean>();
                for (ObjectName on : mbeans) {
                    String name = "java.lang:type=GarbageCollector,name=" + on.getKeyProperty("name");
                    GarbageCollectorMXBean mBean = ManagementFactory.newPlatformMXBeanProxy(this.server, name, GarbageCollectorMXBean.class);
                    this.garbageCollectorMBeans.add(mBean);
                }
            }
        }
        return this.garbageCollectorMBeans;
    }

    public synchronized MemoryMXBean getMemoryMXBean() throws IOException {
        if (this.hasPlatformMXBeans && this.memoryMBean == null) {
            this.memoryMBean = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=Memory", MemoryMXBean.class);
        }
        return this.memoryMBean;
    }

    public synchronized RuntimeMXBean getRuntimeMXBean() throws IOException {
        if (this.hasPlatformMXBeans && this.runtimeMBean == null) {
            this.runtimeMBean = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=Runtime", RuntimeMXBean.class);
        }
        return this.runtimeMBean;
    }

    public synchronized ThreadMXBean getThreadMXBean() throws IOException {
        if (this.hasPlatformMXBeans && this.threadMBean == null) {
            this.threadMBean = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=Threading", ThreadMXBean.class);
        }
        return this.threadMBean;
    }

    public synchronized OperatingSystemMXBean getOperatingSystemMXBean() throws IOException {
        if (this.hasPlatformMXBeans && this.operatingSystemMBean == null) {
            this.operatingSystemMBean = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=OperatingSystem", OperatingSystemMXBean.class);
        }
        return this.operatingSystemMBean;
    }

    public synchronized com.sun.management.OperatingSystemMXBean getSunOperatingSystemMXBean() throws IOException {
        try {
            ObjectName on = new ObjectName("java.lang:type=OperatingSystem");
            if (this.sunOperatingSystemMXBean == null && this.server.isInstanceOf(on, "com.sun.management.OperatingSystemMXBean")) {
                this.sunOperatingSystemMXBean = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=OperatingSystem", com.sun.management.OperatingSystemMXBean.class);
            }
        }
        catch (InstanceNotFoundException e) {
            return null;
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
        return this.sunOperatingSystemMXBean;
    }

    public synchronized HotSpotDiagnosticMXBean getHotSpotDiagnosticMXBean() throws IOException {
        if (this.hasHotSpotDiagnosticMXBean && this.hotspotDiagnosticMXBean == null) {
            this.hotspotDiagnosticMXBean = ManagementFactory.newPlatformMXBeanProxy(this.server, HOTSPOT_DIAGNOSTIC_MXBEAN_NAME, HotSpotDiagnosticMXBean.class);
        }
        return this.hotspotDiagnosticMXBean;
    }

    public <T> T getMXBean(ObjectName objName, Class<T> interfaceClass) throws IOException {
        return ManagementFactory.newPlatformMXBeanProxy(this.server, objName.toString(), interfaceClass);
    }

    public long[] findDeadlockedThreads() throws IOException {
        ThreadMXBean tm = this.getThreadMXBean();
        if (this.supportsLockUsage && tm.isSynchronizerUsageSupported()) {
            return tm.findDeadlockedThreads();
        }
        return tm.findMonitorDeadlockedThreads();
    }

    public synchronized void markAsDead() {
        this.disconnect();
    }

    public boolean isDead() {
        return this.isDead;
    }

    boolean isConnected() {
        return !this.isDead();
    }

    boolean hasPlatformMXBeans() {
        return this.hasPlatformMXBeans;
    }

    boolean hasHotSpotDiagnosticMXBean() {
        return this.hasHotSpotDiagnosticMXBean;
    }

    boolean isLockUsageSupported() {
        return this.supportsLockUsage;
    }

    public boolean isRegistered(ObjectName name) throws IOException {
        return this.server.isRegistered(name);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addWeakPropertyChangeListener(PropertyChangeListener listener) {
        if (!(listener instanceof WeakPCL)) {
            listener = new WeakPCL(listener);
        }
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (!(listener instanceof WeakPCL)) {
            for (PropertyChangeListener pcl : this.propertyChangeSupport.getPropertyChangeListeners()) {
                if (!(pcl instanceof WeakPCL) || ((WeakPCL)pcl).get() != listener) continue;
                listener = pcl;
                break;
            }
        }
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    static {
        Class<Remote> serverStubClass = null;
        try {
            serverStubClass = Class.forName(rmiServerImplStubClassName).asSubclass(Remote.class);
        }
        catch (ClassNotFoundException e) {
            throw (InternalError)new InternalError(e.getMessage()).initCause(e);
        }
        rmiServerImplStubClass = serverStubClass;
    }

    static class SnapshotInvocationHandler
    implements InvocationHandler {
        private final MBeanServerConnection conn;
        private Map<ObjectName, NameValueMap> cachedValues = SnapshotInvocationHandler.newMap();
        private Map<ObjectName, Set<String>> cachedNames = SnapshotInvocationHandler.newMap();

        SnapshotInvocationHandler(MBeanServerConnection conn) {
            this.conn = conn;
        }

        synchronized void flush() {
            this.cachedValues = SnapshotInvocationHandler.newMap();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("getAttribute")) {
                return this.getAttribute((ObjectName)args[0], (String)args[1]);
            }
            if (methodName.equals("getAttributes")) {
                return this.getAttributes((ObjectName)args[0], (String[])args[1]);
            }
            if (methodName.equals("flush")) {
                this.flush();
                return null;
            }
            try {
                return method.invoke((Object)this.conn, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        private Object getAttribute(ObjectName objName, String attrName) throws MBeanException, InstanceNotFoundException, AttributeNotFoundException, ReflectionException, IOException {
            NameValueMap values = this.getCachedAttributes(objName, Collections.singleton(attrName));
            Object value = values.get(attrName);
            if (value != null || values.containsKey(attrName)) {
                return value;
            }
            return this.conn.getAttribute(objName, attrName);
        }

        private AttributeList getAttributes(ObjectName objName, String[] attrNames) throws InstanceNotFoundException, ReflectionException, IOException {
            NameValueMap values = this.getCachedAttributes(objName, new TreeSet<String>(Arrays.asList(attrNames)));
            AttributeList list = new AttributeList();
            for (String attrName : attrNames) {
                Object value = values.get(attrName);
                if (value == null && !values.containsKey(attrName)) continue;
                list.add(new Attribute(attrName, value));
            }
            return list;
        }

        private synchronized NameValueMap getCachedAttributes(ObjectName objName, Set<String> attrNames) throws InstanceNotFoundException, ReflectionException, IOException {
            NameValueMap values = this.cachedValues.get(objName);
            if (values != null && values.keySet().containsAll(attrNames)) {
                return values;
            }
            attrNames = new TreeSet<String>(attrNames);
            Set<String> oldNames = this.cachedNames.get(objName);
            if (oldNames != null) {
                attrNames.addAll(oldNames);
            }
            values = new NameValueMap();
            AttributeList attrs = this.conn.getAttributes(objName, attrNames.toArray(new String[attrNames.size()]));
            for (Attribute attr : attrs.asList()) {
                values.put(attr.getName(), attr.getValue());
            }
            this.cachedValues.put(objName, values);
            this.cachedNames.put(objName, attrNames);
            return values;
        }

        private static <K, V> Map<K, V> newMap() {
            return new HashMap();
        }

        private static final class NameValueMap
        extends HashMap<String, Object> {
            private NameValueMap() {
            }
        }
    }

    public static class Snapshot {
        private Snapshot() {
        }

        public static SnapshotMBeanServerConnection newSnapshot(MBeanServerConnection mbsc) {
            SnapshotInvocationHandler ih = new SnapshotInvocationHandler(mbsc);
            return (SnapshotMBeanServerConnection)Proxy.newProxyInstance(Snapshot.class.getClassLoader(), new Class[]{SnapshotMBeanServerConnection.class}, (InvocationHandler)ih);
        }
    }

    public static interface SnapshotMBeanServerConnection
    extends MBeanServerConnection {
        public void flush();
    }

    private class WeakPCL
    extends WeakReference<PropertyChangeListener>
    implements PropertyChangeListener {
        WeakPCL(PropertyChangeListener referent) {
            super(referent);
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            PropertyChangeListener pcl = (PropertyChangeListener)this.get();
            if (pcl == null) {
                this.dispose();
            } else {
                pcl.propertyChange(pce);
            }
        }

        private void dispose() {
            ProxyClient.this.removePropertyChangeListener(this);
        }
    }
}

