/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingWorker;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Tab;
import sun.tools.jconsole.VMPanel;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XDataViewer;
import sun.tools.jconsole.inspector.XSheet;
import sun.tools.jconsole.inspector.XTree;
import sun.tools.jconsole.inspector.XTreeRenderer;

public class MBeansTab
extends Tab
implements NotificationListener,
PropertyChangeListener,
TreeSelectionListener,
TreeWillExpandListener {
    private XTree tree;
    private XSheet sheet;
    private XDataViewer viewer;
    private MouseListener ml = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            int selRow;
            if (e.getClickCount() == 1 && (selRow = MBeansTab.this.tree.getRowForLocation(e.getX(), e.getY())) != -1) {
                TreePath selPath = MBeansTab.this.tree.getPathForLocation(e.getX(), e.getY());
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                if (MBeansTab.this.sheet.isMBeanNode(node)) {
                    MBeansTab.this.tree.expandPath(selPath);
                }
            }
        }
    };

    public static String getTabName() {
        return Resources.getText("MBeans", new Object[0]);
    }

    public MBeansTab(VMPanel vmPanel) {
        super(vmPanel, MBeansTab.getTabName());
        this.addPropertyChangeListener(this);
        this.setupTab();
    }

    public XDataViewer getDataViewer() {
        return this.viewer;
    }

    public XTree getTree() {
        return this.tree;
    }

    public XSheet getSheet() {
        return this.sheet;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.sheet.dispose();
    }

    public int getUpdateInterval() {
        return this.vmPanel.getUpdateInterval();
    }

    private void buildMBeanServerView() {
        new SwingWorker<Set<ObjectName>, Void>(){

            @Override
            public Set<ObjectName> doInBackground() {
                try {
                    MBeansTab.this.getMBeanServerConnection().addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, MBeansTab.this, null, null);
                }
                catch (InstanceNotFoundException e) {
                    if (JConsole.isDebug()) {
                        e.printStackTrace();
                    }
                }
                catch (IOException e) {
                    if (JConsole.isDebug()) {
                        e.printStackTrace();
                    }
                    MBeansTab.this.vmPanel.getProxyClient().markAsDead();
                    return null;
                }
                Set<ObjectName> mbeans = null;
                try {
                    mbeans = MBeansTab.this.getMBeanServerConnection().queryNames(null, null);
                }
                catch (IOException e) {
                    if (JConsole.isDebug()) {
                        e.printStackTrace();
                    }
                    MBeansTab.this.vmPanel.getProxyClient().markAsDead();
                    return null;
                }
                return mbeans;
            }

            @Override
            protected void done() {
                block2: {
                    try {
                        Set mbeans = (Set)this.get();
                        MBeansTab.this.tree.setVisible(false);
                        MBeansTab.this.tree.removeAll();
                        MBeansTab.this.tree.addMBeansToView(mbeans);
                        MBeansTab.this.tree.setVisible(true);
                    }
                    catch (Exception e) {
                        Throwable t = Utils.getActualException(e);
                        if (!JConsole.isDebug()) break block2;
                        System.err.println("Problem at MBean tree construction");
                        t.printStackTrace();
                    }
                }
            }
        }.execute();
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.vmPanel.getProxyClient().getMBeanServerConnection();
    }

    public ProxyClient.SnapshotMBeanServerConnection getSnapshotMBeanServerConnection() {
        return this.vmPanel.getProxyClient().getSnapshotMBeanServerConnection();
    }

    @Override
    public void update() {
        try {
            this.getMBeanServerConnection().getDefaultDomain();
        }
        catch (IOException ex) {
            this.vmPanel.getProxyClient().markAsDead();
        }
    }

    private void setupTab() {
        this.setLayout(new BorderLayout());
        JSplitPane mainSplit = new JSplitPane(1);
        mainSplit.setDividerLocation(160);
        mainSplit.setBorder(BorderFactory.createEmptyBorder());
        this.tree = new XTree(this);
        this.tree.setCellRenderer(new XTreeRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.tree.addTreeWillExpandListener(this);
        this.tree.addMouseListener(this.ml);
        JScrollPane theScrollPane = new JScrollPane(this.tree, 20, 30);
        JPanel treePanel = new JPanel(new BorderLayout());
        treePanel.add((Component)theScrollPane, "Center");
        mainSplit.add(treePanel, "left", 0);
        this.viewer = new XDataViewer(this);
        this.sheet = new XSheet(this);
        mainSplit.add(this.sheet, "right", 0);
        this.add(mainSplit);
    }

    @Override
    public void handleNotification(final Notification notification, Object handback) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (notification instanceof MBeanServerNotification) {
                    ObjectName mbean = ((MBeanServerNotification)notification).getMBeanName();
                    if (notification.getType().equals("JMX.mbean.registered")) {
                        MBeansTab.this.tree.addMBeanToView(mbean);
                    } else if (notification.getType().equals("JMX.mbean.unregistered")) {
                        MBeansTab.this.tree.removeMBeanFromView(mbean);
                    }
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("connectionState".equals(evt.getPropertyName())) {
            boolean connected = (Boolean)evt.getNewValue();
            if (connected) {
                this.buildMBeanServerView();
            } else {
                this.sheet.dispose();
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        this.sheet.displayNode(node);
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
        DefaultMutableTreeNode node;
        TreePath path = e.getPath();
        if (!this.tree.hasBeenExpanded(path) && this.sheet.isMBeanNode(node = (DefaultMutableTreeNode)path.getLastPathComponent()) && !this.tree.hasMetadataNodes(node)) {
            this.tree.addMetadataNodes(node);
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
    }
}

