/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.util.Locale;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.GeneralNameInterface;

public class DNSName
implements GeneralNameInterface {
    private String name;
    private static final String alpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String digitsAndHyphen = "0123456789-";
    private static final String alphaDigitsAndHyphen = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-";

    public DNSName(DerValue derValue) throws IOException {
        this.name = derValue.getIA5String();
    }

    public DNSName(String name) throws IOException {
        if (name == null || name.length() == 0) {
            throw new IOException("DNS name must not be null");
        }
        if (name.indexOf(32) != -1) {
            throw new IOException("DNS names or NameConstraints with blank components are not permitted");
        }
        if (name.charAt(0) == '.' || name.charAt(name.length() - 1) == '.') {
            throw new IOException("DNS names or NameConstraints may not begin or end with a .");
        }
        int startIndex = 0;
        while (startIndex < name.length()) {
            int endIndex = name.indexOf(46, startIndex);
            if (endIndex < 0) {
                endIndex = name.length();
            }
            if (endIndex - startIndex < 1) {
                throw new IOException("DNSName SubjectAltNames with empty components are not permitted");
            }
            if (alpha.indexOf(name.charAt(startIndex)) < 0) {
                throw new IOException("DNSName components must begin with a letter");
            }
            for (int nonStartIndex = startIndex + 1; nonStartIndex < endIndex; ++nonStartIndex) {
                char x = name.charAt(nonStartIndex);
                if (alphaDigitsAndHyphen.indexOf(x) >= 0) continue;
                throw new IOException("DNSName components must consist of letters, digits, and hyphens");
            }
            startIndex = endIndex + 1;
        }
        this.name = name;
    }

    @Override
    public int getType() {
        return 2;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void encode(DerOutputStream out) throws IOException {
        out.putIA5String(this.name);
    }

    public String toString() {
        return "DNSName: " + this.name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DNSName)) {
            return false;
        }
        DNSName other = (DNSName)obj;
        return this.name.equalsIgnoreCase(other.name);
    }

    public int hashCode() {
        return this.name.toUpperCase().hashCode();
    }

    @Override
    public int constrains(GeneralNameInterface inputName) throws UnsupportedOperationException {
        int ndx;
        int inNdx;
        String thisName;
        String inName;
        int constraintType = inputName == null ? -1 : (inputName.getType() != 2 ? -1 : ((inName = ((DNSName)inputName).getName().toLowerCase(Locale.ENGLISH)).equals(thisName = this.name.toLowerCase(Locale.ENGLISH)) ? 0 : (thisName.endsWith(inName) ? (thisName.charAt((inNdx = thisName.lastIndexOf(inName)) - 1) == '.' ? 2 : 3) : (inName.endsWith(thisName) ? (inName.charAt((ndx = inName.lastIndexOf(thisName)) - 1) == '.' ? 1 : 3) : 3))));
        return constraintType;
    }

    @Override
    public int subtreeDepth() throws UnsupportedOperationException {
        String subtree = this.name;
        int i = 1;
        while (subtree.lastIndexOf(46) >= 0) {
            subtree = subtree.substring(0, subtree.lastIndexOf(46));
            ++i;
        }
        return i;
    }
}

