/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.concurrent.RejectedExecutionException;
import sun.misc.Unsafe;
import sun.nio.ch.Invoker;
import sun.nio.ch.Port;
import sun.nio.ch.ThreadPool;
import sun.nio.ch.Util;

class SolarisEventPort
extends Port {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int addressSize = unsafe.addressSize();
    private static final int SIZEOF_PORT_EVENT = SolarisEventPort.dependsArch(16, 24);
    private static final int OFFSETOF_EVENTS = 0;
    private static final int OFFSETOF_SOURCE = 4;
    private static final int OFFSETOF_OBJECT = 8;
    private static final short PORT_SOURCE_USER = 3;
    private static final short PORT_SOURCE_FD = 4;
    private final int port = SolarisEventPort.portCreate();
    private boolean closed;

    private static int dependsArch(int value32, int value64) {
        return addressSize == 4 ? value32 : value64;
    }

    SolarisEventPort(AsynchronousChannelProvider provider, ThreadPool pool) throws IOException {
        super(provider, pool);
    }

    SolarisEventPort start() {
        this.startThreads(new EventHandlerTask());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void implClose() {
        SolarisEventPort solarisEventPort = this;
        synchronized (solarisEventPort) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        SolarisEventPort.portClose(this.port);
    }

    private void wakeup() {
        try {
            SolarisEventPort.portSend(this.port, 0);
        }
        catch (IOException x) {
            throw new AssertionError((Object)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeOnHandlerTask(Runnable task) {
        SolarisEventPort solarisEventPort = this;
        synchronized (solarisEventPort) {
            if (this.closed) {
                throw new RejectedExecutionException();
            }
            this.offerTask(task);
            this.wakeup();
        }
    }

    @Override
    void shutdownHandlerTasks() {
        int nThreads = this.threadCount();
        if (nThreads == 0) {
            this.implClose();
        } else {
            while (nThreads-- > 0) {
                try {
                    SolarisEventPort.portSend(this.port, 0);
                }
                catch (IOException x) {
                    throw new AssertionError((Object)x);
                }
            }
        }
    }

    @Override
    void startPoll(int fd, int events) {
        try {
            SolarisEventPort.portAssociate(this.port, 4, fd, events);
        }
        catch (IOException x) {
            throw new AssertionError();
        }
    }

    private static native void init();

    private static native int portCreate() throws IOException;

    private static native void portAssociate(int var0, int var1, long var2, int var4) throws IOException;

    private static native void portGet(int var0, long var1) throws IOException;

    private static native int portGetn(int var0, long var1, int var3) throws IOException;

    private static native void portSend(int var0, int var1) throws IOException;

    private static native void portClose(int var0);

    static {
        Util.load();
        SolarisEventPort.init();
    }

    private class EventHandlerTask
    implements Runnable {
        private EventHandlerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Invoker.GroupAndInvokeCount myGroupAndInvokeCount = Invoker.getGroupAndInvokeCount();
            boolean isPooledThread = myGroupAndInvokeCount != null;
            boolean replaceMe = false;
            long address = unsafe.allocateMemory(SIZEOF_PORT_EVENT);
            try {
                while (true) {
                    Port.PollableChannel ch;
                    if (isPooledThread) {
                        myGroupAndInvokeCount.resetInvokeCount();
                    }
                    replaceMe = false;
                    try {
                        SolarisEventPort.portGet(SolarisEventPort.this.port, address);
                    }
                    catch (IOException x) {
                        x.printStackTrace();
                        unsafe.freeMemory(address);
                        int remaining = SolarisEventPort.this.threadExit(this, replaceMe);
                        if (remaining == 0 && SolarisEventPort.this.isShutdown()) {
                            SolarisEventPort.this.implClose();
                        }
                        return;
                    }
                    short source = unsafe.getShort(address + 4L);
                    if (source != 4) {
                        if (source != 3) continue;
                        Runnable task = SolarisEventPort.this.pollTask();
                        if (task == null) {
                            return;
                        }
                        replaceMe = true;
                        task.run();
                        continue;
                    }
                    int fd = (int)unsafe.getAddress(address + 8L);
                    int events = unsafe.getInt(address + 0L);
                    SolarisEventPort.this.fdToChannelLock.readLock().lock();
                    try {
                        ch = (Port.PollableChannel)SolarisEventPort.this.fdToChannel.get(fd);
                    }
                    finally {
                        SolarisEventPort.this.fdToChannelLock.readLock().unlock();
                    }
                    if (ch == null) continue;
                    replaceMe = true;
                    ch.onEvent(events, isPooledThread);
                }
            }
            finally {
                unsafe.freeMemory(address);
                int remaining = SolarisEventPort.this.threadExit(this, replaceMe);
                if (remaining == 0 && SolarisEventPort.this.isShutdown()) {
                    SolarisEventPort.this.implClose();
                }
            }
        }
    }
}

