/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import sun.font.AttributeValues;
import sun.font.CoreMetrics;
import sun.font.Decoration;
import sun.font.ExtendedTextLabel;
import sun.font.GlyphLayout;
import sun.font.StandardGlyphVector;
import sun.font.TextLineComponent;
import sun.font.TextSource;

class ExtendedTextSourceLabel
extends ExtendedTextLabel
implements Decoration.Label {
    TextSource source;
    private Decoration decorator;
    private Font font;
    private AffineTransform baseTX;
    private CoreMetrics cm;
    Rectangle2D lb;
    Rectangle2D ab;
    Rectangle2D vb;
    Rectangle2D ib;
    StandardGlyphVector gv;
    float[] charinfo;
    private static final int posx = 0;
    private static final int posy = 1;
    private static final int advx = 2;
    private static final int advy = 3;
    private static final int visx = 4;
    private static final int visy = 5;
    private static final int visw = 6;
    private static final int vish = 7;
    private static final int numvals = 8;

    public ExtendedTextSourceLabel(TextSource source, Decoration decorator) {
        this.source = source;
        this.decorator = decorator;
        this.finishInit();
    }

    public ExtendedTextSourceLabel(TextSource source, ExtendedTextSourceLabel oldLabel, int offset) {
        this.source = source;
        this.decorator = oldLabel.decorator;
        this.finishInit();
    }

    private void finishInit() {
        this.font = this.source.getFont();
        Map<TextAttribute, ?> atts = this.font.getAttributes();
        this.baseTX = AttributeValues.getBaselineTransform(atts);
        if (this.baseTX == null) {
            this.cm = this.source.getCoreMetrics();
        } else {
            AffineTransform charTX = AttributeValues.getCharTransform(atts);
            if (charTX == null) {
                charTX = new AffineTransform();
            }
            this.font = this.font.deriveFont(charTX);
            LineMetrics lm = this.font.getLineMetrics(this.source.getChars(), this.source.getStart(), this.source.getStart() + this.source.getLength(), this.source.getFRC());
            this.cm = CoreMetrics.get(lm);
        }
    }

    @Override
    public Rectangle2D getLogicalBounds() {
        return this.getLogicalBounds(0.0f, 0.0f);
    }

    @Override
    public Rectangle2D getLogicalBounds(float x, float y) {
        if (this.lb == null) {
            this.lb = this.createLogicalBounds();
        }
        return new Rectangle2D.Float((float)(this.lb.getX() + (double)x), (float)(this.lb.getY() + (double)y), (float)this.lb.getWidth(), (float)this.lb.getHeight());
    }

    @Override
    public float getAdvance() {
        if (this.lb == null) {
            this.lb = this.createLogicalBounds();
        }
        return (float)this.lb.getWidth();
    }

    @Override
    public Rectangle2D getVisualBounds(float x, float y) {
        if (this.vb == null) {
            this.vb = this.decorator.getVisualBounds(this);
        }
        return new Rectangle2D.Float((float)(this.vb.getX() + (double)x), (float)(this.vb.getY() + (double)y), (float)this.vb.getWidth(), (float)this.vb.getHeight());
    }

    @Override
    public Rectangle2D getAlignBounds(float x, float y) {
        if (this.ab == null) {
            this.ab = this.createAlignBounds();
        }
        return new Rectangle2D.Float((float)(this.ab.getX() + (double)x), (float)(this.ab.getY() + (double)y), (float)this.ab.getWidth(), (float)this.ab.getHeight());
    }

    @Override
    public Rectangle2D getItalicBounds(float x, float y) {
        if (this.ib == null) {
            this.ib = this.createItalicBounds();
        }
        return new Rectangle2D.Float((float)(this.ib.getX() + (double)x), (float)(this.ib.getY() + (double)y), (float)this.ib.getWidth(), (float)this.ib.getHeight());
    }

    @Override
    public Rectangle getPixelBounds(FontRenderContext frc, float x, float y) {
        return this.getGV().getPixelBounds(frc, x, y);
    }

    @Override
    public boolean isSimple() {
        return this.decorator == Decoration.getPlainDecoration() && this.baseTX == null;
    }

    @Override
    public AffineTransform getBaselineTransform() {
        return this.baseTX;
    }

    @Override
    public Shape handleGetOutline(float x, float y) {
        return this.getGV().getOutline(x, y);
    }

    @Override
    public Shape getOutline(float x, float y) {
        return this.decorator.getOutline(this, x, y);
    }

    @Override
    public void handleDraw(Graphics2D g, float x, float y) {
        g.drawGlyphVector(this.getGV(), x, y);
    }

    @Override
    public void draw(Graphics2D g, float x, float y) {
        this.decorator.drawTextAndDecorations(this, g, x, y);
    }

    protected Rectangle2D createLogicalBounds() {
        return this.getGV().getLogicalBounds();
    }

    @Override
    public Rectangle2D handleGetVisualBounds() {
        return this.getGV().getVisualBounds();
    }

    protected Rectangle2D createAlignBounds() {
        int rn;
        float[] info = this.getCharinfo();
        float al = 0.0f;
        float at = -this.cm.ascent;
        float aw = 0.0f;
        float ah = this.cm.ascent + this.cm.descent;
        boolean lineIsLTR = (this.source.getLayoutFlags() & 8) == 0;
        if (lineIsLTR) {
            for (rn = info.length - 8; rn > 0 && info[rn + 6] == 0.0f; rn -= 8) {
            }
        }
        if (rn >= 0) {
            int ln;
            for (ln = 0; ln < rn && (info[ln + 2] == 0.0f || !lineIsLTR && info[ln + 6] == 0.0f); ln += 8) {
            }
            al = Math.max(0.0f, info[ln + 0]);
            aw = info[rn + 0] + info[rn + 2] - al;
        }
        return new Rectangle2D.Float(al, at, aw, ah);
    }

    public Rectangle2D createItalicBounds() {
        float ia = this.cm.italicAngle;
        Rectangle2D lb = this.getLogicalBounds();
        float l = (float)lb.getMinX();
        float t = -this.cm.ascent;
        float r = (float)lb.getMaxX();
        float b = this.cm.descent;
        if (ia != 0.0f) {
            if (ia > 0.0f) {
                l -= ia * (b - this.cm.ssOffset);
                r -= ia * (t - this.cm.ssOffset);
            } else {
                l -= ia * (t - this.cm.ssOffset);
                r -= ia * (b - this.cm.ssOffset);
            }
        }
        return new Rectangle2D.Float(l, t, r - l, b - t);
    }

    private final StandardGlyphVector getGV() {
        if (this.gv == null) {
            this.gv = this.createGV();
        }
        return this.gv;
    }

    protected StandardGlyphVector createGV() {
        FontRenderContext frc = this.source.getFRC();
        int flags = this.source.getLayoutFlags();
        char[] context = this.source.getChars();
        int start = this.source.getStart();
        int length = this.source.getLength();
        GlyphLayout gl = GlyphLayout.get(null);
        this.gv = gl.layout(this.font, frc, context, start, length, flags, null);
        GlyphLayout.done(gl);
        return this.gv;
    }

    @Override
    public int getNumCharacters() {
        return this.source.getLength();
    }

    @Override
    public CoreMetrics getCoreMetrics() {
        return this.cm;
    }

    @Override
    public float getCharX(int index) {
        this.validate(index);
        return this.getCharinfo()[this.l2v(index) * 8 + 0];
    }

    @Override
    public float getCharY(int index) {
        this.validate(index);
        return this.getCharinfo()[this.l2v(index) * 8 + 1];
    }

    @Override
    public float getCharAdvance(int index) {
        this.validate(index);
        return this.getCharinfo()[this.l2v(index) * 8 + 2];
    }

    @Override
    public Rectangle2D handleGetCharVisualBounds(int index) {
        this.validate(index);
        float[] charinfo = this.getCharinfo();
        index = this.l2v(index) * 8;
        return new Rectangle2D.Float(charinfo[index + 4], charinfo[index + 5], charinfo[index + 6], charinfo[index + 7]);
    }

    @Override
    public Rectangle2D getCharVisualBounds(int index, float x, float y) {
        Rectangle2D bounds = this.decorator.getCharVisualBounds(this, index);
        if (x != 0.0f || y != 0.0f) {
            bounds.setRect(bounds.getX() + (double)x, bounds.getY() + (double)y, bounds.getWidth(), bounds.getHeight());
        }
        return bounds;
    }

    private void validate(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index " + index + " < 0");
        }
        if (index >= this.source.getLength()) {
            throw new IllegalArgumentException("index " + index + " < " + this.source.getLength());
        }
    }

    @Override
    public int logicalToVisual(int logicalIndex) {
        this.validate(logicalIndex);
        return this.l2v(logicalIndex);
    }

    @Override
    public int visualToLogical(int visualIndex) {
        this.validate(visualIndex);
        return this.v2l(visualIndex);
    }

    @Override
    public int getLineBreakIndex(int start, float width) {
        float[] charinfo = this.getCharinfo();
        int length = this.source.getLength();
        --start;
        while (width >= 0.0f && ++start < length) {
            float adv = charinfo[this.l2v(start) * 8 + 2];
            width -= adv;
        }
        return start;
    }

    @Override
    public float getAdvanceBetween(int start, int limit) {
        float a = 0.0f;
        float[] charinfo = this.getCharinfo();
        --start;
        while (++start < limit) {
            a += charinfo[this.l2v(start) * 8 + 2];
        }
        return a;
    }

    @Override
    public boolean caretAtOffsetIsValid(int offset) {
        if (offset == 0 || offset == this.source.getLength()) {
            return true;
        }
        char c = this.source.getChars()[this.source.getStart() + offset];
        if (c == '\t' || c == '\n' || c == '\r') {
            return true;
        }
        int v = this.l2v(offset);
        return this.getCharinfo()[v * 8 + 2] != 0.0f;
    }

    private final float[] getCharinfo() {
        if (this.charinfo == null) {
            this.charinfo = this.createCharinfo();
        }
        return this.charinfo;
    }

    protected float[] createCharinfo() {
        boolean ltr;
        int minIndex;
        StandardGlyphVector gv = this.getGV();
        float[] glyphinfo = null;
        try {
            glyphinfo = gv.getGlyphInfo();
        }
        catch (Exception e) {
            System.out.println(this.source);
        }
        int numGlyphs = gv.getNumGlyphs();
        int[] indices = gv.getGlyphCharIndices(0, numGlyphs, null);
        boolean DEBUG = false;
        if (DEBUG) {
            System.err.println("number of glyphs: " + numGlyphs);
            for (int i = 0; i < numGlyphs; ++i) {
                System.err.println("g: " + i + ", x: " + glyphinfo[i * 8 + 0] + ", a: " + glyphinfo[i * 8 + 2] + ", n: " + indices[i]);
            }
        }
        int maxIndex = minIndex = indices[0];
        int nextMin = 0;
        int cp = 0;
        int cx = 0;
        int gp = 0;
        int gx = 0;
        int gxlimit = numGlyphs;
        int pdelta = 8;
        int xdelta = 1;
        boolean bl = ltr = (this.source.getLayoutFlags() & 1) == 0;
        if (!ltr) {
            maxIndex = minIndex = indices[numGlyphs - 1];
            nextMin = 0;
            cp = glyphinfo.length - 8;
            cx = 0;
            gp = glyphinfo.length - 8;
            gx = numGlyphs - 1;
            gxlimit = -1;
            pdelta = -8;
            xdelta = -1;
        }
        float cposl = 0.0f;
        float cposr = 0.0f;
        float cvisl = 0.0f;
        float cvist = 0.0f;
        float cvisr = 0.0f;
        float cvisb = 0.0f;
        float baseline = 0.0f;
        boolean mustCopy = false;
        while (gx != gxlimit) {
            boolean haveCopy = false;
            int clusterExtraGlyphs = 0;
            maxIndex = minIndex = indices[gx];
            gx += xdelta;
            gp += pdelta;
            while (gx != gxlimit && (glyphinfo[gp + 2] == 0.0f || minIndex != nextMin || indices[gx] <= maxIndex || maxIndex - minIndex > clusterExtraGlyphs)) {
                float rvisw;
                if (!haveCopy) {
                    int gps = gp - pdelta;
                    cposl = glyphinfo[gps + 0];
                    cposr = cposl + glyphinfo[gps + 2];
                    cvisl = glyphinfo[gps + 4];
                    cvist = glyphinfo[gps + 5];
                    cvisr = cvisl + glyphinfo[gps + 6];
                    cvisb = cvist + glyphinfo[gps + 7];
                    haveCopy = true;
                }
                ++clusterExtraGlyphs;
                float radvx = glyphinfo[gp + 2];
                if (radvx != 0.0f) {
                    float rposx = glyphinfo[gp + 0];
                    cposl = Math.min(cposl, rposx);
                    cposr = Math.max(cposr, rposx + radvx);
                }
                if ((rvisw = glyphinfo[gp + 6]) != 0.0f) {
                    float rvisx = glyphinfo[gp + 4];
                    float rvisy = glyphinfo[gp + 5];
                    cvisl = Math.min(cvisl, rvisx);
                    cvist = Math.min(cvist, rvisy);
                    cvisr = Math.max(cvisr, rvisx + rvisw);
                    cvisb = Math.max(cvisb, rvisy + glyphinfo[gp + 7]);
                }
                minIndex = Math.min(minIndex, indices[gx]);
                maxIndex = Math.max(maxIndex, indices[gx]);
                gx += xdelta;
                gp += pdelta;
            }
            if (DEBUG) {
                System.out.println("minIndex = " + minIndex + ", maxIndex = " + maxIndex);
            }
            nextMin = maxIndex + 1;
            glyphinfo[cp + 1] = baseline;
            glyphinfo[cp + 3] = 0.0f;
            if (haveCopy) {
                glyphinfo[cp + 0] = cposl;
                glyphinfo[cp + 2] = cposr - cposl;
                glyphinfo[cp + 4] = cvisl;
                glyphinfo[cp + 5] = cvist;
                glyphinfo[cp + 6] = cvisr - cvisl;
                glyphinfo[cp + 7] = cvisb - cvist;
                if (maxIndex - minIndex < clusterExtraGlyphs) {
                    mustCopy = true;
                }
                if (minIndex < maxIndex) {
                    if (!ltr) {
                        cposr = cposl;
                    }
                    cvisr -= cvisl;
                    cvisb -= cvist;
                    int iMinIndex = minIndex;
                    int icp = cp / 8;
                    while (minIndex < maxIndex) {
                        ++minIndex;
                        cx += xdelta;
                        if (((cp += pdelta) < 0 || cp >= glyphinfo.length) && DEBUG) {
                            System.out.println("minIndex = " + iMinIndex + ", maxIndex = " + maxIndex + ", cp = " + icp);
                        }
                        glyphinfo[cp + 0] = cposr;
                        glyphinfo[cp + 1] = baseline;
                        glyphinfo[cp + 2] = 0.0f;
                        glyphinfo[cp + 3] = 0.0f;
                        glyphinfo[cp + 4] = cvisl;
                        glyphinfo[cp + 5] = cvist;
                        glyphinfo[cp + 6] = cvisr;
                        glyphinfo[cp + 7] = cvisb;
                    }
                }
                haveCopy = false;
            } else if (mustCopy) {
                int gpr = gp - pdelta;
                glyphinfo[cp + 0] = glyphinfo[gpr + 0];
                glyphinfo[cp + 2] = glyphinfo[gpr + 2];
                glyphinfo[cp + 4] = glyphinfo[gpr + 4];
                glyphinfo[cp + 5] = glyphinfo[gpr + 5];
                glyphinfo[cp + 6] = glyphinfo[gpr + 6];
                glyphinfo[cp + 7] = glyphinfo[gpr + 7];
            }
            cp += pdelta;
            cx += xdelta;
        }
        if (mustCopy && !ltr) {
            System.arraycopy(glyphinfo, cp -= pdelta, glyphinfo, 0, glyphinfo.length - cp);
        }
        if (DEBUG) {
            char[] chars = this.source.getChars();
            int start = this.source.getStart();
            int length = this.source.getLength();
            System.out.println("char info for " + length + " characters");
            int i = 0;
            while (i < length * 8) {
                System.out.println(" ch: " + Integer.toHexString(chars[start + this.v2l(i / 8)]) + " x: " + glyphinfo[i++] + " y: " + glyphinfo[i++] + " xa: " + glyphinfo[i++] + " ya: " + glyphinfo[i++] + " l: " + glyphinfo[i++] + " t: " + glyphinfo[i++] + " w: " + glyphinfo[i++] + " h: " + glyphinfo[i++]);
            }
        }
        return glyphinfo;
    }

    protected int l2v(int index) {
        return (this.source.getLayoutFlags() & 1) == 0 ? index : this.source.getLength() - 1 - index;
    }

    protected int v2l(int index) {
        return (this.source.getLayoutFlags() & 1) == 0 ? index : this.source.getLength() - 1 - index;
    }

    @Override
    public TextLineComponent getSubset(int start, int limit, int dir) {
        return new ExtendedTextSourceLabel(this.source.getSubSource(start, limit - start, dir), this.decorator);
    }

    public String toString() {
        return this.source.toString(false);
    }

    @Override
    public int getNumJustificationInfos() {
        return this.getGV().getNumGlyphs();
    }

    @Override
    public void getJustificationInfos(GlyphJustificationInfo[] infos, int infoStart, int charStart, int charLimit) {
        boolean ltr;
        StandardGlyphVector gv = this.getGV();
        float[] charinfo = this.getCharinfo();
        float size = gv.getFont().getSize2D();
        GlyphJustificationInfo nullInfo = new GlyphJustificationInfo(0.0f, false, 3, 0.0f, 0.0f, false, 3, 0.0f, 0.0f);
        GlyphJustificationInfo spaceInfo = new GlyphJustificationInfo(size, true, 1, 0.0f, size, true, 1, 0.0f, size / 4.0f);
        GlyphJustificationInfo kanjiInfo = new GlyphJustificationInfo(size, true, 2, size, size, false, 3, 0.0f, 0.0f);
        char[] chars = this.source.getChars();
        int offset = this.source.getStart();
        int numGlyphs = gv.getNumGlyphs();
        int minGlyph = 0;
        int maxGlyph = numGlyphs;
        boolean bl = ltr = (this.source.getLayoutFlags() & 1) == 0;
        if (charStart != 0 || charLimit != this.source.getLength()) {
            if (ltr) {
                minGlyph = charStart;
                maxGlyph = charLimit;
            } else {
                minGlyph = numGlyphs - charLimit;
                maxGlyph = numGlyphs - charStart;
            }
        }
        for (int i = 0; i < numGlyphs; ++i) {
            GlyphJustificationInfo info = null;
            if (i >= minGlyph && i < maxGlyph) {
                int ci;
                char c;
                info = charinfo[i * 8 + 2] == 0.0f ? nullInfo : (Character.isWhitespace(c = chars[offset + (ci = this.v2l(i))]) ? spaceInfo : (c >= '\u4e00' && c < '\ua000' || c >= '\uac00' && c < '\ud7b0' || c >= '\uf900' && c < '\ufb00' ? kanjiInfo : nullInfo));
            }
            infos[infoStart + i] = info;
        }
    }

    @Override
    public TextLineComponent applyJustificationDeltas(float[] deltas, int deltaStart, boolean[] flags) {
        float[] newCharinfo = (float[])this.getCharinfo().clone();
        flags[0] = false;
        StandardGlyphVector newgv = (StandardGlyphVector)this.getGV().clone();
        float[] newPositions = newgv.getGlyphPositions(null);
        int numGlyphs = newgv.getNumGlyphs();
        char[] chars = this.source.getChars();
        int offset = this.source.getStart();
        float deltaPos = 0.0f;
        for (int i = 0; i < numGlyphs; ++i) {
            if (Character.isWhitespace(chars[offset + this.v2l(i)])) {
                int n = i * 2;
                newPositions[n] = newPositions[n] + deltaPos;
                float deltaAdv = deltas[deltaStart + i * 2] + deltas[deltaStart + i * 2 + 1];
                int n2 = i * 8 + 0;
                newCharinfo[n2] = newCharinfo[n2] + deltaPos;
                int n3 = i * 8 + 4;
                newCharinfo[n3] = newCharinfo[n3] + deltaPos;
                int n4 = i * 8 + 2;
                newCharinfo[n4] = newCharinfo[n4] + deltaAdv;
                deltaPos += deltaAdv;
                continue;
            }
            int n = i * 2;
            newPositions[n] = newPositions[n] + (deltaPos += deltas[deltaStart + i * 2]);
            int n5 = i * 8 + 0;
            newCharinfo[n5] = newCharinfo[n5] + deltaPos;
            int n6 = i * 8 + 4;
            newCharinfo[n6] = newCharinfo[n6] + deltaPos;
            deltaPos += deltas[deltaStart + i * 2 + 1];
        }
        int n = numGlyphs * 2;
        newPositions[n] = newPositions[n] + deltaPos;
        newgv.setGlyphPositions(newPositions);
        ExtendedTextSourceLabel result = new ExtendedTextSourceLabel(this.source, this.decorator);
        result.gv = newgv;
        result.charinfo = newCharinfo;
        return result;
    }
}

