/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.AdapterMethodHandle;
import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.CountingMethodHandle;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.FilterGeneric;
import java.lang.invoke.FilterOneArgument;
import java.lang.invoke.FromGeneric;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.ToGeneric;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import sun.invoke.empty.Empty;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.VerifyType;
import sun.invoke.util.Wrapper;
import sun.misc.Unsafe;

abstract class MethodHandleImpl {
    private static final MemberName.Factory LOOKUP = MemberName.Factory.INSTANCE;
    static MethodHandle SELECT_ALTERNATIVE;
    static MethodHandle THROW_EXCEPTION;

    MethodHandleImpl() {
    }

    static void initStatics() {
    }

    static MethodHandle findMethod(MemberName method, boolean doDispatch, Class<?> lookupClass) throws IllegalAccessException {
        Class<?> arrayType;
        DirectMethodHandle mh;
        MethodType mtype = method.getMethodType();
        if (!method.isStatic()) {
            Class<?> recvType = method.getDeclaringClass();
            mtype = mtype.insertParameterTypes(0, recvType);
        }
        if (!(mh = new DirectMethodHandle(mtype, method, doDispatch, lookupClass)).isValid()) {
            throw method.makeAccessException("no direct method handle", lookupClass);
        }
        assert (mh.type() == mtype);
        if (!method.isVarargs()) {
            return mh;
        }
        int argc = mtype.parameterCount();
        if (argc != 0 && (arrayType = mtype.parameterType(argc - 1)).isArray()) {
            return AdapterMethodHandle.makeVarargsCollector(mh, arrayType);
        }
        throw method.makeAccessException("cannot make variable arity", null);
    }

    static MethodHandle makeAllocator(MethodHandle rawConstructor) {
        Class<?> allocateClass;
        MethodType rawConType = rawConstructor.type();
        if (AdapterMethodHandle.canCollectArguments(rawConType, MethodType.methodType(allocateClass = rawConType.parameterType(0)), 0, true)) {
            MethodHandle returner = MethodHandles.identity(allocateClass);
            MethodType ctype = rawConType.insertParameterTypes(0, allocateClass).changeReturnType(allocateClass);
            MethodHandle cookedConstructor = AdapterMethodHandle.makeCollectArguments(returner, rawConstructor, 1, false);
            assert (cookedConstructor.type().equals((Object)ctype));
            ctype = ctype.dropParameterTypes(0, 1);
            cookedConstructor = AdapterMethodHandle.makeCollectArguments(cookedConstructor, returner, 0, true);
            AllocateObject allocator = new AllocateObject(allocateClass);
            assert (allocator.type().equals((Object)MethodType.methodType(allocateClass)));
            ctype = ctype.dropParameterTypes(0, 1);
            MethodHandle fold = MethodHandleImpl.foldArguments(cookedConstructor, ctype, 0, allocator);
            return fold;
        }
        assert (MethodHandleNatives.workaroundWithoutRicochetFrames());
        MethodHandle allocator = AllocateObject.make(allocateClass, rawConstructor);
        assert (allocator.type().equals((Object)rawConType.dropParameterTypes(0, 1).changeReturnType(rawConType.parameterType(0))));
        return allocator;
    }

    static MethodHandle accessField(MemberName member, boolean isSetter, Class<?> lookupClass) {
        FieldAccessor mh = new FieldAccessor(member, isSetter);
        return mh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MethodHandle accessArrayElement(Class<?> arrayClass, boolean isSetter) {
        if (!arrayClass.isArray()) {
            throw MethodHandleStatics.newIllegalArgumentException("not an array: " + arrayClass);
        }
        Class<?> elemClass = arrayClass.getComponentType();
        MethodHandle[] mhs = FieldAccessor.ARRAY_CACHE.get(elemClass);
        if (mhs == null) {
            if (!FieldAccessor.doCache(elemClass)) {
                return FieldAccessor.ahandle(arrayClass, isSetter);
            }
            mhs = new MethodHandle[]{FieldAccessor.ahandle(arrayClass, false), FieldAccessor.ahandle(arrayClass, true)};
            if (mhs[0].type().parameterType(0) == Class.class) {
                mhs[0] = mhs[0].bindTo(elemClass);
                mhs[1] = mhs[1].bindTo(elemClass);
            }
            HashMap<Class<?>, MethodHandle[]> hashMap = FieldAccessor.ARRAY_CACHE;
            synchronized (hashMap) {
            }
            FieldAccessor.ARRAY_CACHE.put(elemClass, mhs);
        }
        return mhs[isSetter ? 1 : 0];
    }

    static MethodHandle bindReceiver(MethodHandle target, Object receiver) {
        DirectMethodHandle dmh;
        Object info;
        if (receiver == null) {
            return null;
        }
        if (target instanceof AdapterMethodHandle && ((AdapterMethodHandle)target).conversionOp() == 0 && (info = MethodHandleNatives.getTargetInfo(target)) instanceof DirectMethodHandle && (dmh = (DirectMethodHandle)info).type().parameterType(0).isAssignableFrom(receiver.getClass())) {
            BoundMethodHandle bmh = new BoundMethodHandle(dmh, receiver, 0);
            MethodType newType = target.type().dropParameterTypes(0, 1);
            return MethodHandleImpl.convertArguments(bmh, newType, bmh.type(), 0);
        }
        if (target instanceof DirectMethodHandle) {
            return new BoundMethodHandle((DirectMethodHandle)target, receiver, 0);
        }
        return null;
    }

    static MethodHandle bindArgument(MethodHandle target, int argnum, Object receiver) {
        return new BoundMethodHandle(target, receiver, argnum);
    }

    static MethodHandle permuteArguments(MethodHandle target, MethodType newType, MethodType oldType, int[] permutationOrNull) {
        int i;
        assert (oldType.parameterCount() == target.type().parameterCount());
        int outargs = oldType.parameterCount();
        int inargs = newType.parameterCount();
        if (permutationOrNull.length != outargs) {
            throw MethodHandleStatics.newIllegalArgumentException("wrong number of arguments in permutation");
        }
        Class[] callTypeArgs = new Class[outargs];
        for (int i2 = 0; i2 < outargs; ++i2) {
            callTypeArgs[i2] = newType.parameterType(permutationOrNull[i2]);
        }
        MethodType callType = MethodType.methodType(oldType.returnType(), callTypeArgs);
        target = MethodHandleImpl.convertArguments(target, callType, oldType, 0);
        assert (target != null);
        oldType = target.type();
        ArrayList<Integer> goal = new ArrayList<Integer>();
        ArrayList<Integer> state = new ArrayList<Integer>();
        ArrayList<Integer> drops = new ArrayList<Integer>();
        ArrayList<Integer> dups = new ArrayList<Integer>();
        int TOKEN = 10;
        for (i = 0; i < outargs; ++i) {
            state.add(permutationOrNull[i] * 10);
        }
        for (i = 0; i < inargs; ++i) {
            if (state.contains(i * 10)) {
                goal.add(i * 10);
                continue;
            }
            drops.add(i);
        }
        while (state.size() > goal.size()) {
            for (int i2 = 0; i2 < state.size(); ++i2) {
                int arg1 = (Integer)state.get(i2);
                int i1 = state.indexOf(arg1);
                if (i1 == i2) continue;
                int arg2 = inargs++ * 10;
                state.set(i2, arg2);
                dups.add(goal.indexOf(arg1));
                goal.add(arg2);
            }
        }
        assert (state.size() == goal.size());
        int size = goal.size();
        while (!state.equals(goal)) {
            int bestRotArg = -100;
            int bestRotLen = 0;
            int thisRotArg = -100;
            int thisRotLen = 0;
            for (int i3 = 0; i3 < size; ++i3) {
                int arg = (Integer)state.get(i3);
                if (arg == thisRotArg + 10) {
                    thisRotArg = arg;
                    if (bestRotLen >= ++thisRotLen) continue;
                    bestRotLen = thisRotLen;
                    bestRotArg = thisRotArg;
                    continue;
                }
                thisRotLen = 0;
                thisRotArg = -100;
                int wantArg = (Integer)goal.get(i3);
                boolean MAX_ARG_ROTATION = true;
                if (arg == wantArg || arg < wantArg - 10 || arg > wantArg + 10) continue;
                thisRotArg = arg;
                thisRotLen = 1;
            }
            if (bestRotLen >= 2) {
                int dstEnd = state.indexOf(bestRotArg);
                int srcEnd = goal.indexOf(bestRotArg);
                int rotBy = dstEnd - srcEnd;
                int dstBeg = dstEnd - (bestRotLen - 1);
                int srcBeg = srcEnd - (bestRotLen - 1);
                assert ((dstEnd | dstBeg | srcEnd | srcBeg) >= 0);
                int rotBeg = Math.min(dstBeg, srcBeg);
                int rotEnd = Math.max(dstEnd, srcEnd);
                int score = 0;
                for (int i4 = rotBeg; i4 <= rotEnd; ++i4) {
                    if (((Integer)state.get(i4)).intValue() == ((Integer)goal.get(i4)).intValue()) continue;
                    ++score;
                }
                List rotSpan = state.subList(rotBeg, rotEnd + 1);
                Collections.rotate(rotSpan, -rotBy);
                for (int i5 = rotBeg; i5 <= rotEnd; ++i5) {
                    if (((Integer)state.get(i5)).intValue() == ((Integer)goal.get(i5)).intValue()) continue;
                    --score;
                }
                if (score >= 2) {
                    List<Class<?>> ptypes = Arrays.asList(oldType.parameterArray());
                    Collections.rotate(ptypes.subList(rotBeg, rotEnd + 1), -rotBy);
                    MethodType rotType = MethodType.methodType(oldType.returnType(), ptypes);
                    MethodHandle nextTarget = AdapterMethodHandle.makeRotateArguments(rotType, target, rotBeg, rotSpan.size(), rotBy);
                    if (nextTarget != null) {
                        target = nextTarget;
                        oldType = rotType;
                        continue;
                    }
                }
                Collections.rotate(rotSpan, rotBy);
            }
            List<Class<?>> ptypes = Arrays.asList(oldType.parameterArray());
            for (int i6 = 0; i6 < size; ++i6) {
                int arg = (Integer)goal.get(i6);
                if (arg == (Integer)state.get(i6)) continue;
                int j = state.indexOf(arg);
                Collections.swap(ptypes, i6, j);
                MethodType swapType = MethodType.methodType(oldType.returnType(), ptypes);
                target = AdapterMethodHandle.makeSwapArguments(swapType, target, i6, j);
                if (target == null) {
                    throw MethodHandleStatics.newIllegalArgumentException("cannot swap");
                }
                assert (target.type() == swapType);
                oldType = swapType;
                Collections.swap(state, i6, j);
            }
            assert (state.equals(goal));
        }
        while (!dups.isEmpty()) {
            int dup0;
            int grab = dups.size() - 1;
            int dupArgPos = (Integer)dups.get(grab);
            int dupArgCount = 1;
            while (grab - 1 >= 0 && (dup0 = ((Integer)dups.get(grab - 1)).intValue()) == dupArgPos - 1) {
                --dupArgPos;
                ++dupArgCount;
                --grab;
            }
            dups.subList(grab, dups.size()).clear();
            List<Class<?>> ptypes = oldType.parameterList();
            ptypes = ptypes.subList(0, ptypes.size() - dupArgCount);
            MethodType dupType = MethodType.methodType(oldType.returnType(), ptypes);
            target = AdapterMethodHandle.makeDupArguments(dupType, target, dupArgPos, dupArgCount);
            if (target == null) {
                throw MethodHandleStatics.newIllegalArgumentException("cannot dup");
            }
            oldType = target.type();
        }
        while (!drops.isEmpty()) {
            int drop1;
            int dropArgCount;
            int dropArgPos = (Integer)drops.get(0);
            for (dropArgCount = 1; dropArgCount < drops.size() && (drop1 = ((Integer)drops.get(dropArgCount)).intValue()) == dropArgPos + dropArgCount; ++dropArgCount) {
            }
            drops.subList(0, dropArgCount).clear();
            List<Class<?>> dropTypes = newType.parameterList().subList(dropArgPos, dropArgPos + dropArgCount);
            MethodType dropType = oldType.insertParameterTypes(dropArgPos, dropTypes);
            target = AdapterMethodHandle.makeDropArguments(dropType, target, dropArgPos, dropArgCount);
            if (target == null) {
                throw MethodHandleStatics.newIllegalArgumentException("cannot drop");
            }
            oldType = target.type();
        }
        target = MethodHandleImpl.convertArguments(target, newType, oldType, 0);
        assert (target != null);
        return target;
    }

    static MethodHandle convertArguments(MethodHandle target, MethodType newType, int level) {
        Class<?> newRT;
        MethodType oldType = target.type();
        if (oldType.equals((Object)newType)) {
            return target;
        }
        assert (level > 1 || oldType.isConvertibleTo(newType));
        MethodHandle retFilter = null;
        Class<?> oldRT = oldType.returnType();
        if (!VerifyType.isNullConversion(oldRT, newRT = newType.returnType())) {
            if (oldRT == Void.TYPE) {
                Wrapper wrap = newRT.isPrimitive() ? Wrapper.forPrimitiveType(newRT) : Wrapper.OBJECT;
                retFilter = ValueConversions.zeroConstantFunction(wrap);
            } else {
                retFilter = MethodHandles.identity(newRT);
                retFilter = MethodHandleImpl.convertArguments(retFilter, retFilter.type().changeParameterType(0, oldRT), level);
            }
            newType = newType.changeReturnType(oldRT);
        }
        MethodHandle res = null;
        IllegalArgumentException ex = null;
        try {
            res = MethodHandleImpl.convertArguments(target, newType, oldType, level);
        }
        catch (IllegalArgumentException ex1) {
            ex = ex1;
        }
        if (res == null) {
            WrongMethodTypeException wmt = new WrongMethodTypeException("cannot convert to " + newType + ": " + target);
            wmt.initCause(ex);
            throw wmt;
        }
        if (retFilter != null) {
            res = MethodHandles.filterReturnValue(res, retFilter);
        }
        return res;
    }

    static MethodHandle convertArguments(MethodHandle target, MethodType newType, MethodType oldType, int level) {
        assert (oldType.parameterCount() == target.type().parameterCount());
        if (newType == oldType) {
            return target;
        }
        if (oldType.parameterCount() != newType.parameterCount()) {
            throw MethodHandleStatics.newIllegalArgumentException("mismatched parameter count", oldType, newType);
        }
        MethodHandle res = AdapterMethodHandle.makePairwiseConvert(newType, target, level);
        if (res != null) {
            return res;
        }
        int argc = oldType.parameterCount();
        assert (MethodHandleNatives.workaroundWithoutRicochetFrames());
        MethodType objType = MethodType.genericMethodType(argc);
        MethodHandle objTarget = AdapterMethodHandle.makePairwiseConvert(objType, target, level);
        if (objTarget == null) {
            objTarget = FromGeneric.make(target);
        }
        if ((res = AdapterMethodHandle.makePairwiseConvert(newType, objTarget, level)) != null) {
            return res;
        }
        return ToGeneric.make(newType, objTarget);
    }

    static MethodHandle spreadArguments(MethodHandle target, Class<?> arrayType, int arrayLength) {
        MethodType oldType = target.type();
        int nargs = oldType.parameterCount();
        int keepPosArgs = nargs - arrayLength;
        MethodType newType = oldType.dropParameterTypes(keepPosArgs, nargs).insertParameterTypes(keepPosArgs, arrayType);
        return MethodHandleImpl.spreadArguments(target, newType, keepPosArgs, arrayType, arrayLength);
    }

    static MethodHandle spreadArgumentsFromPos(MethodHandle target, MethodType newType, int spreadArgPos) {
        int arrayLength = target.type().parameterCount() - spreadArgPos;
        return MethodHandleImpl.spreadArguments(target, newType, spreadArgPos, Object[].class, arrayLength);
    }

    static MethodHandle spreadArguments(MethodHandle target, MethodType newType, int spreadArgPos, Class<?> arrayType, int arrayLength) {
        MethodType oldType = target.type();
        assert (arrayLength == oldType.parameterCount() - spreadArgPos);
        assert (newType.parameterType(spreadArgPos) == arrayType);
        return AdapterMethodHandle.makeSpreadArguments(newType, target, arrayType, spreadArgPos, arrayLength);
    }

    static MethodHandle collectArguments(MethodHandle target, int collectArg, MethodHandle collector) {
        MethodType type = target.type();
        Class<?> collectType = collector.type().returnType();
        assert (collectType != Void.TYPE);
        if (collectType != type.parameterType(collectArg)) {
            target = target.asType(type.changeParameterType(collectArg, collectType));
        }
        MethodType newType = type.dropParameterTypes(collectArg, collectArg + 1).insertParameterTypes(collectArg, collector.type().parameterArray());
        return MethodHandleImpl.collectArguments(target, newType, collectArg, collector);
    }

    static MethodHandle collectArguments(MethodHandle target, MethodType newType, int collectArg, MethodHandle collector) {
        MethodType oldType = target.type();
        MethodType colType = collector.type();
        assert (newType.parameterCount() == collectArg + colType.parameterCount());
        assert (oldType.parameterCount() == collectArg + 1);
        MethodHandle result = null;
        if (AdapterMethodHandle.canCollectArguments(oldType, colType, collectArg, false)) {
            result = AdapterMethodHandle.makeCollectArguments(target, collector, collectArg, false);
        }
        if (result == null) {
            assert (MethodHandleNatives.workaroundWithoutRicochetFrames());
            MethodHandle gtarget = MethodHandleImpl.convertArguments(target, oldType.generic(), oldType, 0);
            MethodHandle gcollector = MethodHandleImpl.convertArguments(collector, colType.generic(), colType, 0);
            if (gtarget == null || gcollector == null) {
                return null;
            }
            MethodHandle gresult = FilterGeneric.makeArgumentCollector(gcollector, gtarget);
            result = MethodHandleImpl.convertArguments(gresult, newType, gresult.type(), 0);
        }
        return result;
    }

    static MethodHandle filterArgument(MethodHandle target, int pos, MethodHandle filter) {
        MethodType gftype;
        MethodType ttype = target.type();
        MethodType ftype = filter.type();
        assert (ftype.parameterCount() == 1);
        MethodHandle result = null;
        if (AdapterMethodHandle.canCollectArguments(ttype, ftype, pos, false) && (result = AdapterMethodHandle.makeCollectArguments(target, filter, pos, false)) != null) {
            return result;
        }
        assert (MethodHandleNatives.workaroundWithoutRicochetFrames());
        MethodType rtype = ttype.changeParameterType(pos, ftype.parameterType(0));
        MethodType gttype = ttype.generic();
        if (ttype != gttype) {
            target = MethodHandleImpl.convertArguments(target, gttype, ttype, 0);
            ttype = gttype;
        }
        if (ftype != (gftype = ftype.generic())) {
            filter = MethodHandleImpl.convertArguments(filter, gftype, ftype, 0);
            ftype = gftype;
        }
        if ((result = ftype == ttype ? FilterOneArgument.make(filter, target) : FilterGeneric.makeArgumentFilter(pos, filter, target)).type() != rtype) {
            result = result.asType(rtype);
        }
        return result;
    }

    static MethodHandle foldArguments(MethodHandle target, MethodType newType, int foldPos, MethodHandle combiner) {
        MethodHandle res;
        MethodType ctype;
        MethodType oldType = target.type();
        if (AdapterMethodHandle.canCollectArguments(oldType, ctype = combiner.type(), foldPos, true) && (res = AdapterMethodHandle.makeCollectArguments(target, combiner, foldPos, true)) != null) {
            return res;
        }
        assert (MethodHandleNatives.workaroundWithoutRicochetFrames());
        if (foldPos != 0) {
            return null;
        }
        MethodHandle gtarget = MethodHandleImpl.convertArguments(target, oldType.generic(), oldType, 0);
        MethodHandle gcombiner = MethodHandleImpl.convertArguments(combiner, ctype.generic(), ctype, 0);
        if (ctype.returnType() == Void.TYPE) {
            gtarget = MethodHandleImpl.dropArguments(gtarget, oldType.generic().insertParameterTypes(foldPos, Object.class), foldPos);
        }
        if (gtarget == null || gcombiner == null) {
            return null;
        }
        MethodHandle gresult = FilterGeneric.makeArgumentFolder(gcombiner, gtarget);
        return MethodHandleImpl.convertArguments(gresult, newType, gresult.type(), 0);
    }

    static MethodHandle dropArguments(MethodHandle target, MethodType newType, int argnum) {
        int drops = newType.parameterCount() - target.type().parameterCount();
        MethodHandle res = AdapterMethodHandle.makeDropArguments(newType, target, argnum, drops);
        if (res != null) {
            return res;
        }
        throw new UnsupportedOperationException("NYI");
    }

    static MethodHandle selectAlternative(boolean testResult, MethodHandle target, MethodHandle fallback) {
        return testResult ? target : fallback;
    }

    static MethodHandle selectAlternative() {
        if (SELECT_ALTERNATIVE != null) {
            return SELECT_ALTERNATIVE;
        }
        try {
            SELECT_ALTERNATIVE = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MethodHandleImpl.class, "selectAlternative", MethodType.methodType(MethodHandle.class, Boolean.TYPE, MethodHandle.class, MethodHandle.class));
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
        return SELECT_ALTERNATIVE;
    }

    static MethodHandle makeGuardWithTest(MethodHandle test, MethodHandle target, MethodHandle fallback) {
        assert (test.type().returnType() == Boolean.TYPE);
        MethodType targetType = target.type();
        MethodType foldTargetType = targetType.insertParameterTypes(0, Boolean.TYPE);
        if (AdapterMethodHandle.canCollectArguments(foldTargetType, test.type(), 0, true) && GuardWithTest.preferRicochetFrame(targetType)) {
            assert (target.type().equals((Object)fallback.type()));
            MethodHandle tailcall = MethodHandles.exactInvoker(target.type());
            MethodHandle select = MethodHandleImpl.selectAlternative();
            select = MethodHandleImpl.bindArgument(select, 2, CountingMethodHandle.wrap(fallback));
            select = MethodHandleImpl.bindArgument(select, 1, CountingMethodHandle.wrap(target));
            MethodHandle filter = MethodHandleImpl.filterArgument(tailcall, 0, select);
            assert (filter.type().parameterType(0) == Boolean.TYPE);
            MethodHandle fold = MethodHandleImpl.foldArguments(filter, filter.type().dropParameterTypes(0, 1), 0, test);
            return fold;
        }
        return GuardWithTest.make(test, target, fallback);
    }

    static MethodHandle makeGuardWithCatch(MethodHandle target, Class<? extends Throwable> exType, MethodHandle catcher) {
        MethodType type = target.type();
        MethodType ctype = catcher.type();
        int nargs = type.parameterCount();
        if (nargs < GuardWithCatch.INVOKES.length) {
            MethodType gtype = type.generic();
            MethodType gcatchType = gtype.insertParameterTypes(0, Throwable.class);
            MethodHandle gtarget = MethodHandleImpl.convertArguments(target, gtype, type, 2);
            MethodHandle gcatcher = MethodHandleImpl.convertArguments(catcher, gcatchType, ctype, 2);
            GuardWithCatch gguard = new GuardWithCatch(gtarget, exType, gcatcher);
            if (gtarget == null || gcatcher == null || gguard == null) {
                return null;
            }
            return MethodHandleImpl.convertArguments(gguard, type, gtype, 2);
        }
        MethodType gtype = MethodType.genericMethodType(0, true);
        MethodType gcatchType = gtype.insertParameterTypes(0, Throwable.class);
        MethodHandle gtarget = MethodHandleImpl.spreadArgumentsFromPos(target, gtype, 0);
        catcher = catcher.asType(ctype.changeParameterType(0, Throwable.class));
        MethodHandle gcatcher = MethodHandleImpl.spreadArgumentsFromPos(catcher, gcatchType, 1);
        GuardWithCatch gguard = new GuardWithCatch(GuardWithCatch.VARARGS_INVOKE, gtarget, exType, gcatcher);
        if (gtarget == null || gcatcher == null || gguard == null) {
            return null;
        }
        return MethodHandleImpl.collectArguments(gguard, type, 0, ValueConversions.varargsArray(nargs)).asType(type);
    }

    static MethodHandle throwException(MethodType type) {
        return AdapterMethodHandle.makeRetypeRaw(type, MethodHandleImpl.throwException());
    }

    static MethodHandle throwException() {
        if (THROW_EXCEPTION != null) {
            return THROW_EXCEPTION;
        }
        try {
            THROW_EXCEPTION = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MethodHandleImpl.class, "throwException", MethodType.methodType(Empty.class, Throwable.class));
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
        return THROW_EXCEPTION;
    }

    static <T extends Throwable> Empty throwException(T t) throws T {
        throw t;
    }

    private static class GuardWithCatch
    extends BoundMethodHandle {
        private final MethodHandle target;
        private final Class<? extends Throwable> exType;
        private final MethodHandle catcher;
        static final MethodHandle[] INVOKES = GuardWithCatch.makeInvokes();
        static final MethodHandle VARARGS_INVOKE;

        GuardWithCatch(MethodHandle target, Class<? extends Throwable> exType, MethodHandle catcher) {
            this(INVOKES[target.type().parameterCount()], target, exType, catcher);
        }

        GuardWithCatch(MethodHandle invoker, MethodHandle target, Class<? extends Throwable> exType, MethodHandle catcher) {
            super(invoker);
            this.target = target;
            this.exType = exType;
            this.catcher = catcher;
        }

        @Override
        String debugString() {
            return MethodHandleStatics.addTypeString(this.target, this);
        }

        private Object invoke_V(Object ... av) throws Throwable {
            try {
                return this.target.invokeExact(av);
            }
            catch (Throwable t) {
                if (!this.exType.isInstance(t)) {
                    throw t;
                }
                return this.catcher.invokeExact(t, av);
            }
        }

        private Object invoke_L0() throws Throwable {
            try {
                return this.target.invokeExact();
            }
            catch (Throwable t) {
                if (!this.exType.isInstance(t)) {
                    throw t;
                }
                return this.catcher.invokeExact(t);
            }
        }

        private Object invoke_L1(Object a0) throws Throwable {
            try {
                return this.target.invokeExact(a0);
            }
            catch (Throwable t) {
                if (!this.exType.isInstance(t)) {
                    throw t;
                }
                return this.catcher.invokeExact(t, a0);
            }
        }

        private Object invoke_L2(Object a0, Object a1) throws Throwable {
            try {
                return this.target.invokeExact(a0, a1);
            }
            catch (Throwable t) {
                if (!this.exType.isInstance(t)) {
                    throw t;
                }
                return this.catcher.invokeExact(t, a0, a1);
            }
        }

        private Object invoke_L3(Object a0, Object a1, Object a2) throws Throwable {
            try {
                return this.target.invokeExact(a0, a1, a2);
            }
            catch (Throwable t) {
                if (!this.exType.isInstance(t)) {
                    throw t;
                }
                return this.catcher.invokeExact(t, a0, a1, a2);
            }
        }

        private Object invoke_L4(Object a0, Object a1, Object a2, Object a3) throws Throwable {
            try {
                return this.target.invokeExact(a0, a1, a2, a3);
            }
            catch (Throwable t) {
                if (!this.exType.isInstance(t)) {
                    throw t;
                }
                return this.catcher.invokeExact(t, a0, a1, a2, a3);
            }
        }

        private Object invoke_L5(Object a0, Object a1, Object a2, Object a3, Object a4) throws Throwable {
            try {
                return this.target.invokeExact(a0, a1, a2, a3, a4);
            }
            catch (Throwable t) {
                if (!this.exType.isInstance(t)) {
                    throw t;
                }
                return this.catcher.invokeExact(t, a0, a1, a2, a3, a4);
            }
        }

        private Object invoke_L6(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5) throws Throwable {
            try {
                return this.target.invokeExact(a0, a1, a2, a3, a4, a5);
            }
            catch (Throwable t) {
                if (!this.exType.isInstance(t)) {
                    throw t;
                }
                return this.catcher.invokeExact(t, a0, a1, a2, a3, a4, a5);
            }
        }

        private Object invoke_L7(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6) throws Throwable {
            try {
                return this.target.invokeExact(a0, a1, a2, a3, a4, a5, a6);
            }
            catch (Throwable t) {
                if (!this.exType.isInstance(t)) {
                    throw t;
                }
                return this.catcher.invokeExact(t, a0, a1, a2, a3, a4, a5, a6);
            }
        }

        private Object invoke_L8(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7) throws Throwable {
            try {
                return this.target.invokeExact(a0, a1, a2, a3, a4, a5, a6, a7);
            }
            catch (Throwable t) {
                if (!this.exType.isInstance(t)) {
                    throw t;
                }
                return this.catcher.invokeExact(t, a0, a1, a2, a3, a4, a5, a6, a7);
            }
        }

        static MethodHandle[] makeInvokes() {
            ArrayList<MethodHandle> invokes = new ArrayList<MethodHandle>();
            MethodHandles.Lookup lookup = MethodHandles.Lookup.IMPL_LOOKUP;
            while (true) {
                int nargs = invokes.size();
                String name = "invoke_L" + nargs;
                MethodHandle invoke = null;
                try {
                    invoke = lookup.findVirtual(GuardWithCatch.class, name, MethodType.genericMethodType(nargs));
                }
                catch (ReflectiveOperationException ex) {
                    // empty catch block
                }
                if (invoke == null) break;
                invokes.add(invoke);
            }
            assert (invokes.size() == 9);
            return invokes.toArray(new MethodHandle[0]);
        }

        static {
            try {
                VARARGS_INVOKE = MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(GuardWithCatch.class, "invoke_V", MethodType.genericMethodType(0, true));
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
        }
    }

    private static class GuardWithTest
    extends BoundMethodHandle {
        private final MethodHandle test;
        private final MethodHandle target;
        private final MethodHandle fallback;
        static final MethodHandle[] INVOKES = GuardWithTest.makeInvokes();
        static final MethodHandle VARARGS_INVOKE;

        private GuardWithTest(MethodHandle invoker, MethodHandle test, MethodHandle target, MethodHandle fallback) {
            super(invoker);
            this.test = test;
            this.target = target;
            this.fallback = fallback;
        }

        static boolean preferRicochetFrame(MethodType type) {
            return true;
        }

        static MethodHandle make(MethodHandle test, MethodHandle target, MethodHandle fallback) {
            MethodType type = target.type();
            int nargs = type.parameterCount();
            if (nargs < INVOKES.length) {
                if (GuardWithTest.preferRicochetFrame(type)) assert (MethodHandleNatives.workaroundWithoutRicochetFrames());
                MethodHandle invoke = INVOKES[nargs];
                MethodType gtype = type.generic();
                assert (invoke.type().dropParameterTypes(0, 1) == gtype);
                MethodHandle gtest = MethodHandleImpl.convertArguments(test, gtype.changeReturnType(Boolean.TYPE), test.type(), 2);
                MethodHandle gtarget = MethodHandleImpl.convertArguments(target, gtype, type, 2);
                MethodHandle gfallback = MethodHandleImpl.convertArguments(fallback, gtype, type, 2);
                if (gtest == null || gtarget == null || gfallback == null) {
                    return null;
                }
                GuardWithTest gguard = new GuardWithTest(invoke, gtest, gtarget, gfallback);
                return MethodHandleImpl.convertArguments(gguard, type, gtype, 2);
            }
            assert (MethodHandleNatives.workaroundWithoutRicochetFrames());
            MethodHandle invoke = VARARGS_INVOKE;
            MethodType gtype = MethodType.genericMethodType(1);
            assert (invoke.type().dropParameterTypes(0, 1) == gtype);
            MethodHandle gtest = MethodHandleImpl.spreadArgumentsFromPos(test, gtype.changeReturnType(Boolean.TYPE), 0);
            MethodHandle gtarget = MethodHandleImpl.spreadArgumentsFromPos(target, gtype, 0);
            MethodHandle gfallback = MethodHandleImpl.spreadArgumentsFromPos(fallback, gtype, 0);
            GuardWithTest gguard = new GuardWithTest(invoke, gtest, gtarget, gfallback);
            if (gtest == null || gtarget == null || gfallback == null) {
                return null;
            }
            return MethodHandleImpl.collectArguments(gguard, type, 0, null);
        }

        @Override
        String debugString() {
            return MethodHandleStatics.addTypeString(this.target, this);
        }

        private Object invoke_V(Object ... av) throws Throwable {
            if (this.test.invokeExact(av)) {
                return this.target.invokeExact(av);
            }
            return this.fallback.invokeExact(av);
        }

        private Object invoke_L0() throws Throwable {
            if (this.test.invokeExact()) {
                return this.target.invokeExact();
            }
            return this.fallback.invokeExact();
        }

        private Object invoke_L1(Object a0) throws Throwable {
            if (this.test.invokeExact(a0)) {
                return this.target.invokeExact(a0);
            }
            return this.fallback.invokeExact(a0);
        }

        private Object invoke_L2(Object a0, Object a1) throws Throwable {
            if (this.test.invokeExact(a0, a1)) {
                return this.target.invokeExact(a0, a1);
            }
            return this.fallback.invokeExact(a0, a1);
        }

        private Object invoke_L3(Object a0, Object a1, Object a2) throws Throwable {
            if (this.test.invokeExact(a0, a1, a2)) {
                return this.target.invokeExact(a0, a1, a2);
            }
            return this.fallback.invokeExact(a0, a1, a2);
        }

        private Object invoke_L4(Object a0, Object a1, Object a2, Object a3) throws Throwable {
            if (this.test.invokeExact(a0, a1, a2, a3)) {
                return this.target.invokeExact(a0, a1, a2, a3);
            }
            return this.fallback.invokeExact(a0, a1, a2, a3);
        }

        private Object invoke_L5(Object a0, Object a1, Object a2, Object a3, Object a4) throws Throwable {
            if (this.test.invokeExact(a0, a1, a2, a3, a4)) {
                return this.target.invokeExact(a0, a1, a2, a3, a4);
            }
            return this.fallback.invokeExact(a0, a1, a2, a3, a4);
        }

        private Object invoke_L6(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5) throws Throwable {
            if (this.test.invokeExact(a0, a1, a2, a3, a4, a5)) {
                return this.target.invokeExact(a0, a1, a2, a3, a4, a5);
            }
            return this.fallback.invokeExact(a0, a1, a2, a3, a4, a5);
        }

        private Object invoke_L7(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6) throws Throwable {
            if (this.test.invokeExact(a0, a1, a2, a3, a4, a5, a6)) {
                return this.target.invokeExact(a0, a1, a2, a3, a4, a5, a6);
            }
            return this.fallback.invokeExact(a0, a1, a2, a3, a4, a5, a6);
        }

        private Object invoke_L8(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7) throws Throwable {
            if (this.test.invokeExact(a0, a1, a2, a3, a4, a5, a6, a7)) {
                return this.target.invokeExact(a0, a1, a2, a3, a4, a5, a6, a7);
            }
            return this.fallback.invokeExact(a0, a1, a2, a3, a4, a5, a6, a7);
        }

        static MethodHandle[] makeInvokes() {
            ArrayList<MethodHandle> invokes = new ArrayList<MethodHandle>();
            MethodHandles.Lookup lookup = MethodHandles.Lookup.IMPL_LOOKUP;
            while (true) {
                int nargs = invokes.size();
                String name = "invoke_L" + nargs;
                MethodHandle invoke = null;
                try {
                    invoke = lookup.findVirtual(GuardWithTest.class, name, MethodType.genericMethodType(nargs));
                }
                catch (ReflectiveOperationException ex) {
                    // empty catch block
                }
                if (invoke == null) break;
                invokes.add(invoke);
            }
            assert (invokes.size() == 9);
            return invokes.toArray(new MethodHandle[0]);
        }

        static {
            try {
                VARARGS_INVOKE = MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(GuardWithTest.class, "invoke_V", MethodType.genericMethodType(0, true));
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
        }
    }

    static final class FieldAccessor<C, V>
    extends BoundMethodHandle {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        final Object base;
        final long offset;
        final String name;
        static final HashMap<Class<?>, MethodHandle[]> ARRAY_CACHE = new HashMap();

        FieldAccessor(MemberName field, boolean isSetter) {
            super(FieldAccessor.fhandle(field.getDeclaringClass(), field.getFieldType(), isSetter, field.isStatic()));
            this.offset = field.getVMIndex();
            this.name = field.getName();
            this.base = FieldAccessor.staticBase(field);
        }

        @Override
        String debugString() {
            return MethodHandleStatics.addTypeString(this.name, this);
        }

        int getFieldI(C obj) {
            return unsafe.getInt(obj, this.offset);
        }

        void setFieldI(C obj, int x) {
            unsafe.putInt(obj, this.offset, x);
        }

        long getFieldJ(C obj) {
            return unsafe.getLong(obj, this.offset);
        }

        void setFieldJ(C obj, long x) {
            unsafe.putLong(obj, this.offset, x);
        }

        float getFieldF(C obj) {
            return unsafe.getFloat(obj, this.offset);
        }

        void setFieldF(C obj, float x) {
            unsafe.putFloat(obj, this.offset, x);
        }

        double getFieldD(C obj) {
            return unsafe.getDouble(obj, this.offset);
        }

        void setFieldD(C obj, double x) {
            unsafe.putDouble(obj, this.offset, x);
        }

        boolean getFieldZ(C obj) {
            return unsafe.getBoolean(obj, this.offset);
        }

        void setFieldZ(C obj, boolean x) {
            unsafe.putBoolean(obj, this.offset, x);
        }

        byte getFieldB(C obj) {
            return unsafe.getByte(obj, this.offset);
        }

        void setFieldB(C obj, byte x) {
            unsafe.putByte(obj, this.offset, x);
        }

        short getFieldS(C obj) {
            return unsafe.getShort(obj, this.offset);
        }

        void setFieldS(C obj, short x) {
            unsafe.putShort(obj, this.offset, x);
        }

        char getFieldC(C obj) {
            return unsafe.getChar(obj, this.offset);
        }

        void setFieldC(C obj, char x) {
            unsafe.putChar(obj, this.offset, x);
        }

        V getFieldL(C obj) {
            return (V)unsafe.getObject(obj, this.offset);
        }

        void setFieldL(C obj, V x) {
            unsafe.putObject(obj, this.offset, x);
        }

        static Object staticBase(final MemberName field) {
            if (!field.isStatic()) {
                return null;
            }
            return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        Class<?> c = field.getDeclaringClass();
                        Field f = c.getDeclaredField(field.getName());
                        return unsafe.staticFieldBase(f);
                    }
                    catch (NoSuchFieldException ee) {
                        throw MethodHandleStatics.uncaughtException(ee);
                    }
                }
            });
        }

        int getStaticI() {
            return unsafe.getInt(this.base, this.offset);
        }

        void setStaticI(int x) {
            unsafe.putInt(this.base, this.offset, x);
        }

        long getStaticJ() {
            return unsafe.getLong(this.base, this.offset);
        }

        void setStaticJ(long x) {
            unsafe.putLong(this.base, this.offset, x);
        }

        float getStaticF() {
            return unsafe.getFloat(this.base, this.offset);
        }

        void setStaticF(float x) {
            unsafe.putFloat(this.base, this.offset, x);
        }

        double getStaticD() {
            return unsafe.getDouble(this.base, this.offset);
        }

        void setStaticD(double x) {
            unsafe.putDouble(this.base, this.offset, x);
        }

        boolean getStaticZ() {
            return unsafe.getBoolean(this.base, this.offset);
        }

        void setStaticZ(boolean x) {
            unsafe.putBoolean(this.base, this.offset, x);
        }

        byte getStaticB() {
            return unsafe.getByte(this.base, this.offset);
        }

        void setStaticB(byte x) {
            unsafe.putByte(this.base, this.offset, x);
        }

        short getStaticS() {
            return unsafe.getShort(this.base, this.offset);
        }

        void setStaticS(short x) {
            unsafe.putShort(this.base, this.offset, x);
        }

        char getStaticC() {
            return unsafe.getChar(this.base, this.offset);
        }

        void setStaticC(char x) {
            unsafe.putChar(this.base, this.offset, x);
        }

        V getStaticL() {
            return (V)unsafe.getObject(this.base, this.offset);
        }

        void setStaticL(V x) {
            unsafe.putObject(this.base, this.offset, x);
        }

        static String fname(Class<?> vclass, boolean isSetter, boolean isStatic) {
            String stem = !isStatic ? (!isSetter ? "getField" : "setField") : (!isSetter ? "getStatic" : "setStatic");
            return stem + Wrapper.basicTypeChar(vclass);
        }

        static MethodType ftype(Class<?> cclass, Class<?> vclass, boolean isSetter, boolean isStatic) {
            if (!isStatic) {
                if (!isSetter) {
                    return MethodType.methodType(vclass, cclass);
                }
                return MethodType.methodType(Void.TYPE, cclass, vclass);
            }
            if (!isSetter) {
                return MethodType.methodType(vclass);
            }
            return MethodType.methodType(Void.TYPE, vclass);
        }

        static MethodHandle fhandle(Class<?> cclass, Class<?> vclass, boolean isSetter, boolean isStatic) {
            MethodHandle mh;
            String name = FieldAccessor.fname(vclass, isSetter, isStatic);
            if (cclass.isPrimitive()) {
                throw MethodHandleStatics.newIllegalArgumentException("primitive " + cclass);
            }
            Class<Object> ecclass = Object.class;
            Class<Object> evclass = vclass;
            if (!evclass.isPrimitive()) {
                evclass = Object.class;
            }
            MethodType type = FieldAccessor.ftype(ecclass, evclass, isSetter, isStatic);
            try {
                mh = MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(FieldAccessor.class, name, type);
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
            if (evclass != vclass || !isStatic && ecclass != cclass) {
                MethodType strongType = FieldAccessor.ftype(cclass, vclass, isSetter, isStatic);
                strongType = strongType.insertParameterTypes(0, FieldAccessor.class);
                mh = MethodHandleImpl.convertArguments(mh, strongType, 0);
            }
            return mh;
        }

        static boolean doCache(Class<?> elemClass) {
            if (elemClass.isPrimitive()) {
                return true;
            }
            ClassLoader cl = elemClass.getClassLoader();
            return cl == null || cl == ClassLoader.getSystemClassLoader();
        }

        static int getElementI(int[] a, int i) {
            return a[i];
        }

        static void setElementI(int[] a, int i, int x) {
            a[i] = x;
        }

        static long getElementJ(long[] a, int i) {
            return a[i];
        }

        static void setElementJ(long[] a, int i, long x) {
            a[i] = x;
        }

        static float getElementF(float[] a, int i) {
            return a[i];
        }

        static void setElementF(float[] a, int i, float x) {
            a[i] = x;
        }

        static double getElementD(double[] a, int i) {
            return a[i];
        }

        static void setElementD(double[] a, int i, double x) {
            a[i] = x;
        }

        static boolean getElementZ(boolean[] a, int i) {
            return a[i];
        }

        static void setElementZ(boolean[] a, int i, boolean x) {
            a[i] = x;
        }

        static byte getElementB(byte[] a, int i) {
            return a[i];
        }

        static void setElementB(byte[] a, int i, byte x) {
            a[i] = x;
        }

        static short getElementS(short[] a, int i) {
            return a[i];
        }

        static void setElementS(short[] a, int i, short x) {
            a[i] = x;
        }

        static char getElementC(char[] a, int i) {
            return a[i];
        }

        static void setElementC(char[] a, int i, char x) {
            a[i] = x;
        }

        static Object getElementL(Object[] a, int i) {
            return a[i];
        }

        static void setElementL(Object[] a, int i, Object x) {
            a[i] = x;
        }

        static <V> V getElementL(Class<V[]> aclass, V[] a, int i) {
            return aclass.cast(a)[i];
        }

        static <V> void setElementL(Class<V[]> aclass, V[] a, int i, V x) {
            aclass.cast(a)[i] = x;
        }

        static String aname(Class<?> aclass, boolean isSetter) {
            Class<?> vclass = aclass.getComponentType();
            if (vclass == null) {
                throw new IllegalArgumentException();
            }
            return (!isSetter ? "getElement" : "setElement") + Wrapper.basicTypeChar(vclass);
        }

        static MethodType atype(Class<?> aclass, boolean isSetter) {
            Class<?> vclass = aclass.getComponentType();
            if (!isSetter) {
                return MethodType.methodType(vclass, aclass, Integer.TYPE);
            }
            return MethodType.methodType(Void.TYPE, aclass, Integer.TYPE, vclass);
        }

        static MethodHandle ahandle(Class<?> aclass, boolean isSetter) {
            MethodHandle mh;
            Class<Object> vclass = aclass.getComponentType();
            String name = FieldAccessor.aname(aclass, isSetter);
            Class<?> caclass = null;
            if (!vclass.isPrimitive() && vclass != Object.class) {
                caclass = aclass;
                aclass = Object[].class;
                vclass = Object.class;
            }
            MethodType type = FieldAccessor.atype(aclass, isSetter);
            if (caclass != null) {
                type = type.insertParameterTypes(0, Class.class);
            }
            try {
                mh = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(FieldAccessor.class, name, type);
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
            if (caclass != null) {
                MethodType strongType = FieldAccessor.atype(caclass, isSetter);
                mh = mh.bindTo(caclass);
                mh = MethodHandleImpl.convertArguments(mh, strongType, 0);
            }
            return mh;
        }
    }

    static final class AllocateObject<C>
    extends BoundMethodHandle {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        private final Class<C> allocateClass;
        private final MethodHandle rawConstructor;
        static final MethodHandle[] INVOKES = AllocateObject.makeInvokes();
        static final MethodHandle VARARGS_INVOKE;
        static final MethodHandle ALLOCATE;
        static final MethodType[] CON_TYPES;
        static final MethodType VARARGS_CON_TYPE;

        private AllocateObject(MethodHandle invoker, Class<C> allocateClass, MethodHandle rawConstructor) {
            super(invoker);
            this.allocateClass = allocateClass;
            this.rawConstructor = rawConstructor;
            assert (MethodHandleNatives.workaroundWithoutRicochetFrames());
        }

        private AllocateObject(Class<C> allocateClass) {
            super(ALLOCATE.asType(MethodType.methodType(allocateClass, AllocateObject.class)));
            this.allocateClass = allocateClass;
            this.rawConstructor = null;
        }

        static MethodHandle make(Class<?> allocateClass, MethodHandle rawConstructor) {
            assert (MethodHandleNatives.workaroundWithoutRicochetFrames());
            MethodType rawConType = rawConstructor.type();
            assert (rawConType.parameterType(0) == allocateClass);
            MethodType newType = rawConType.dropParameterTypes(0, 1).changeReturnType(allocateClass);
            int nargs = rawConType.parameterCount() - 1;
            if (nargs < INVOKES.length) {
                MethodHandle invoke = INVOKES[nargs];
                MethodType conType = CON_TYPES[nargs];
                MethodHandle gcon = MethodHandleImpl.convertArguments(rawConstructor, conType, rawConType, 0);
                if (gcon == null) {
                    return null;
                }
                AllocateObject galloc = new AllocateObject(invoke, allocateClass, gcon);
                assert (galloc.type() == newType.generic());
                return MethodHandleImpl.convertArguments(galloc, newType, galloc.type(), 0);
            }
            MethodHandle invoke = VARARGS_INVOKE;
            MethodType conType = CON_TYPES[nargs];
            MethodHandle gcon = MethodHandleImpl.spreadArgumentsFromPos(rawConstructor, conType, 1);
            if (gcon == null) {
                return null;
            }
            AllocateObject galloc = new AllocateObject(invoke, allocateClass, gcon);
            return MethodHandleImpl.collectArguments(galloc, newType, 1, null);
        }

        @Override
        String debugString() {
            return MethodHandleStatics.addTypeString(this.allocateClass.getSimpleName(), this);
        }

        private C allocate() throws InstantiationException {
            return (C)unsafe.allocateInstance(this.allocateClass);
        }

        private C invoke_V(Object ... av) throws Throwable {
            C obj = this.allocate();
            this.rawConstructor.invokeExact(obj, av);
            return obj;
        }

        private C invoke_L0() throws Throwable {
            C obj = this.allocate();
            this.rawConstructor.invokeExact(obj);
            return obj;
        }

        private C invoke_L1(Object a0) throws Throwable {
            C obj = this.allocate();
            this.rawConstructor.invokeExact(obj, a0);
            return obj;
        }

        private C invoke_L2(Object a0, Object a1) throws Throwable {
            C obj = this.allocate();
            this.rawConstructor.invokeExact(obj, a0, a1);
            return obj;
        }

        private C invoke_L3(Object a0, Object a1, Object a2) throws Throwable {
            C obj = this.allocate();
            this.rawConstructor.invokeExact(obj, a0, a1, a2);
            return obj;
        }

        private C invoke_L4(Object a0, Object a1, Object a2, Object a3) throws Throwable {
            C obj = this.allocate();
            this.rawConstructor.invokeExact(obj, a0, a1, a2, a3);
            return obj;
        }

        private C invoke_L5(Object a0, Object a1, Object a2, Object a3, Object a4) throws Throwable {
            C obj = this.allocate();
            this.rawConstructor.invokeExact(obj, a0, a1, a2, a3, a4);
            return obj;
        }

        private C invoke_L6(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5) throws Throwable {
            C obj = this.allocate();
            this.rawConstructor.invokeExact(obj, a0, a1, a2, a3, a4, a5);
            return obj;
        }

        private C invoke_L7(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6) throws Throwable {
            C obj = this.allocate();
            this.rawConstructor.invokeExact(obj, a0, a1, a2, a3, a4, a5, a6);
            return obj;
        }

        private C invoke_L8(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7) throws Throwable {
            C obj = this.allocate();
            this.rawConstructor.invokeExact(obj, a0, a1, a2, a3, a4, a5, a6, a7);
            return obj;
        }

        static MethodHandle[] makeInvokes() {
            ArrayList<MethodHandle> invokes = new ArrayList<MethodHandle>();
            MethodHandles.Lookup lookup = MethodHandles.Lookup.IMPL_LOOKUP;
            while (true) {
                int nargs = invokes.size();
                String name = "invoke_L" + nargs;
                MethodHandle invoke = null;
                try {
                    invoke = lookup.findVirtual(AllocateObject.class, name, MethodType.genericMethodType(nargs));
                }
                catch (ReflectiveOperationException ex) {
                    // empty catch block
                }
                if (invoke == null) break;
                invokes.add(invoke);
            }
            assert (invokes.size() == 9);
            return invokes.toArray(new MethodHandle[0]);
        }

        static MethodType makeConType(MethodHandle invoke) {
            MethodType invType = invoke.type();
            return invType.changeParameterType(0, Object.class).changeReturnType(Void.TYPE);
        }

        static {
            try {
                VARARGS_INVOKE = MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(AllocateObject.class, "invoke_V", MethodType.genericMethodType(0, true));
                ALLOCATE = MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(AllocateObject.class, "allocate", MethodType.genericMethodType(0));
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
            CON_TYPES = new MethodType[INVOKES.length];
            for (int i = 0; i < INVOKES.length; ++i) {
                AllocateObject.CON_TYPES[i] = AllocateObject.makeConType(INVOKES[i]);
            }
            VARARGS_CON_TYPE = AllocateObject.makeConType(VARARGS_INVOKE);
        }
    }
}

