/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.NameGenerator;
import java.beans.PropertyDescriptor;
import java.beans.Transient;
import java.lang.ref.Reference;
import java.lang.reflect.Method;

public class IndexedPropertyDescriptor
extends PropertyDescriptor {
    private Reference<Class> indexedPropertyTypeRef;
    private Reference<Method> indexedReadMethodRef;
    private Reference<Method> indexedWriteMethodRef;
    private String indexedReadMethodName;
    private String indexedWriteMethodName;

    public IndexedPropertyDescriptor(String propertyName, Class<?> beanClass) throws IntrospectionException {
        this(propertyName, beanClass, "get" + NameGenerator.capitalize(propertyName), "set" + NameGenerator.capitalize(propertyName), "get" + NameGenerator.capitalize(propertyName), "set" + NameGenerator.capitalize(propertyName));
    }

    public IndexedPropertyDescriptor(String propertyName, Class<?> beanClass, String readMethodName, String writeMethodName, String indexedReadMethodName, String indexedWriteMethodName) throws IntrospectionException {
        super(propertyName, beanClass, readMethodName, writeMethodName);
        this.indexedReadMethodName = indexedReadMethodName;
        if (indexedReadMethodName != null && this.getIndexedReadMethod() == null) {
            throw new IntrospectionException("Method not found: " + indexedReadMethodName);
        }
        this.indexedWriteMethodName = indexedWriteMethodName;
        if (indexedWriteMethodName != null && this.getIndexedWriteMethod() == null) {
            throw new IntrospectionException("Method not found: " + indexedWriteMethodName);
        }
        this.findIndexedPropertyType(this.getIndexedReadMethod(), this.getIndexedWriteMethod());
    }

    public IndexedPropertyDescriptor(String propertyName, Method readMethod, Method writeMethod, Method indexedReadMethod, Method indexedWriteMethod) throws IntrospectionException {
        super(propertyName, readMethod, writeMethod);
        this.setIndexedReadMethod0(indexedReadMethod);
        this.setIndexedWriteMethod0(indexedWriteMethod);
        this.setIndexedPropertyType(this.findIndexedPropertyType(indexedReadMethod, indexedWriteMethod));
    }

    IndexedPropertyDescriptor(Class<?> bean, String base, Method read, Method write, Method readIndexed, Method writeIndexed) throws IntrospectionException {
        super(bean, base, read, write);
        this.setIndexedReadMethod0(readIndexed);
        this.setIndexedWriteMethod0(writeIndexed);
        this.setIndexedPropertyType(this.findIndexedPropertyType(readIndexed, writeIndexed));
    }

    public synchronized Method getIndexedReadMethod() {
        Method indexedReadMethod = this.getIndexedReadMethod0();
        if (indexedReadMethod == null) {
            Class[] args;
            Class cls = this.getClass0();
            if (cls == null || this.indexedReadMethodName == null && this.indexedReadMethodRef == null) {
                return null;
            }
            if (this.indexedReadMethodName == null) {
                Class type = this.getIndexedPropertyType0();
                this.indexedReadMethodName = type == Boolean.TYPE || type == null ? "is" + this.getBaseName() : "get" + this.getBaseName();
            }
            if ((indexedReadMethod = Introspector.findMethod(cls, this.indexedReadMethodName, 1, args = new Class[]{Integer.TYPE})) == null) {
                this.indexedReadMethodName = "get" + this.getBaseName();
                indexedReadMethod = Introspector.findMethod(cls, this.indexedReadMethodName, 1, args);
            }
            this.setIndexedReadMethod0(indexedReadMethod);
        }
        return indexedReadMethod;
    }

    public synchronized void setIndexedReadMethod(Method readMethod) throws IntrospectionException {
        this.setIndexedPropertyType(this.findIndexedPropertyType(readMethod, this.getIndexedWriteMethod0()));
        this.setIndexedReadMethod0(readMethod);
    }

    private void setIndexedReadMethod0(Method readMethod) {
        if (readMethod == null) {
            this.indexedReadMethodName = null;
            this.indexedReadMethodRef = null;
            return;
        }
        this.setClass0(readMethod.getDeclaringClass());
        this.indexedReadMethodName = readMethod.getName();
        this.indexedReadMethodRef = IndexedPropertyDescriptor.getSoftReference(readMethod);
        this.setTransient(readMethod.getAnnotation(Transient.class));
    }

    public synchronized Method getIndexedWriteMethod() {
        Method indexedWriteMethod = this.getIndexedWriteMethod0();
        if (indexedWriteMethod == null) {
            Class[] classArray;
            Class<?> type;
            Class cls;
            block9: {
                cls = this.getClass0();
                if (cls == null || this.indexedWriteMethodName == null && this.indexedWriteMethodRef == null) {
                    return null;
                }
                type = this.getIndexedPropertyType0();
                if (type == null) {
                    try {
                        type = this.findIndexedPropertyType(this.getIndexedReadMethod(), null);
                        this.setIndexedPropertyType(type);
                    }
                    catch (IntrospectionException ex) {
                        Class<?> propType = this.getPropertyType();
                        if (!propType.isArray()) break block9;
                        type = propType.getComponentType();
                    }
                }
            }
            if (this.indexedWriteMethodName == null) {
                this.indexedWriteMethodName = "set" + this.getBaseName();
            }
            if (type == null) {
                classArray = null;
            } else {
                Class[] classArray2 = new Class[2];
                classArray2[0] = Integer.TYPE;
                classArray = classArray2;
                classArray2[1] = type;
            }
            Class[] args = classArray;
            indexedWriteMethod = Introspector.findMethod(cls, this.indexedWriteMethodName, 2, args);
            if (indexedWriteMethod != null && !indexedWriteMethod.getReturnType().equals(Void.TYPE)) {
                indexedWriteMethod = null;
            }
            this.setIndexedWriteMethod0(indexedWriteMethod);
        }
        return indexedWriteMethod;
    }

    public synchronized void setIndexedWriteMethod(Method writeMethod) throws IntrospectionException {
        Class type = this.findIndexedPropertyType(this.getIndexedReadMethod(), writeMethod);
        this.setIndexedPropertyType(type);
        this.setIndexedWriteMethod0(writeMethod);
    }

    private void setIndexedWriteMethod0(Method writeMethod) {
        if (writeMethod == null) {
            this.indexedWriteMethodName = null;
            this.indexedWriteMethodRef = null;
            return;
        }
        this.setClass0(writeMethod.getDeclaringClass());
        this.indexedWriteMethodName = writeMethod.getName();
        this.indexedWriteMethodRef = IndexedPropertyDescriptor.getSoftReference(writeMethod);
        this.setTransient(writeMethod.getAnnotation(Transient.class));
    }

    public synchronized Class<?> getIndexedPropertyType() {
        Class type = this.getIndexedPropertyType0();
        if (type == null) {
            try {
                type = this.findIndexedPropertyType(this.getIndexedReadMethod(), this.getIndexedWriteMethod());
                this.setIndexedPropertyType(type);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return type;
    }

    private void setIndexedPropertyType(Class type) {
        this.indexedPropertyTypeRef = IndexedPropertyDescriptor.getWeakReference(type);
    }

    private Class getIndexedPropertyType0() {
        return this.indexedPropertyTypeRef != null ? this.indexedPropertyTypeRef.get() : null;
    }

    private Method getIndexedReadMethod0() {
        return this.indexedReadMethodRef != null ? this.indexedReadMethodRef.get() : null;
    }

    private Method getIndexedWriteMethod0() {
        return this.indexedWriteMethodRef != null ? this.indexedWriteMethodRef.get() : null;
    }

    private Class findIndexedPropertyType(Method indexedReadMethod, Method indexedWriteMethod) throws IntrospectionException {
        Class<?> propertyType;
        Class[] params;
        Class indexedPropertyType = null;
        if (indexedReadMethod != null) {
            params = IndexedPropertyDescriptor.getParameterTypes(this.getClass0(), indexedReadMethod);
            if (params.length != 1) {
                throw new IntrospectionException("bad indexed read method arg count");
            }
            if (params[0] != Integer.TYPE) {
                throw new IntrospectionException("non int index to indexed read method");
            }
            indexedPropertyType = IndexedPropertyDescriptor.getReturnType(this.getClass0(), indexedReadMethod);
            if (indexedPropertyType == Void.TYPE) {
                throw new IntrospectionException("indexed read method returns void");
            }
        }
        if (indexedWriteMethod != null) {
            params = IndexedPropertyDescriptor.getParameterTypes(this.getClass0(), indexedWriteMethod);
            if (params.length != 2) {
                throw new IntrospectionException("bad indexed write method arg count");
            }
            if (params[0] != Integer.TYPE) {
                throw new IntrospectionException("non int index to indexed write method");
            }
            if (indexedPropertyType != null && indexedPropertyType != params[1]) {
                throw new IntrospectionException("type mismatch between indexed read and indexed write methods: " + this.getName());
            }
            indexedPropertyType = params[1];
        }
        if (!((propertyType = this.getPropertyType()) == null || propertyType.isArray() && propertyType.getComponentType() == indexedPropertyType)) {
            throw new IntrospectionException("type mismatch between indexed and non-indexed methods: " + this.getName());
        }
        return indexedPropertyType;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof IndexedPropertyDescriptor) {
            IndexedPropertyDescriptor other = (IndexedPropertyDescriptor)obj;
            Method otherIndexedReadMethod = other.getIndexedReadMethod();
            Method otherIndexedWriteMethod = other.getIndexedWriteMethod();
            if (!this.compareMethods(this.getIndexedReadMethod(), otherIndexedReadMethod)) {
                return false;
            }
            if (!this.compareMethods(this.getIndexedWriteMethod(), otherIndexedWriteMethod)) {
                return false;
            }
            if (this.getIndexedPropertyType() != other.getIndexedPropertyType()) {
                return false;
            }
            return super.equals(obj);
        }
        return false;
    }

    IndexedPropertyDescriptor(PropertyDescriptor x, PropertyDescriptor y) {
        super(x, y);
        if (x instanceof IndexedPropertyDescriptor) {
            IndexedPropertyDescriptor ix = (IndexedPropertyDescriptor)x;
            try {
                Method xw;
                Method xr = ix.getIndexedReadMethod();
                if (xr != null) {
                    this.setIndexedReadMethod(xr);
                }
                if ((xw = ix.getIndexedWriteMethod()) != null) {
                    this.setIndexedWriteMethod(xw);
                }
            }
            catch (IntrospectionException ex) {
                throw new AssertionError((Object)ex);
            }
        }
        if (y instanceof IndexedPropertyDescriptor) {
            IndexedPropertyDescriptor iy = (IndexedPropertyDescriptor)y;
            try {
                Method yw;
                Method yr = iy.getIndexedReadMethod();
                if (yr != null && yr.getDeclaringClass() == this.getClass0()) {
                    this.setIndexedReadMethod(yr);
                }
                if ((yw = iy.getIndexedWriteMethod()) != null && yw.getDeclaringClass() == this.getClass0()) {
                    this.setIndexedWriteMethod(yw);
                }
            }
            catch (IntrospectionException ex) {
                throw new AssertionError((Object)ex);
            }
        }
    }

    IndexedPropertyDescriptor(IndexedPropertyDescriptor old) {
        super(old);
        this.indexedReadMethodRef = old.indexedReadMethodRef;
        this.indexedWriteMethodRef = old.indexedWriteMethodRef;
        this.indexedPropertyTypeRef = old.indexedPropertyTypeRef;
        this.indexedWriteMethodName = old.indexedWriteMethodName;
        this.indexedReadMethodName = old.indexedReadMethodName;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 37 * result + (this.indexedWriteMethodName == null ? 0 : this.indexedWriteMethodName.hashCode());
        result = 37 * result + (this.indexedReadMethodName == null ? 0 : this.indexedReadMethodName.hashCode());
        result = 37 * result + (this.getIndexedPropertyType() == null ? 0 : this.getIndexedPropertyType().hashCode());
        return result;
    }

    @Override
    void appendTo(StringBuilder sb) {
        super.appendTo(sb);
        IndexedPropertyDescriptor.appendTo(sb, "indexedPropertyType", this.indexedPropertyTypeRef);
        IndexedPropertyDescriptor.appendTo(sb, "indexedReadMethod", this.indexedReadMethodRef);
        IndexedPropertyDescriptor.appendTo(sb, "indexedWriteMethod", this.indexedWriteMethodRef);
    }
}

