/*
 * Decompiled with CFR 0.152.
 */
package com.sun.naming.internal;

import com.sun.naming.internal.FactoryEnumeration;
import com.sun.naming.internal.NamedWeakReference;
import com.sun.naming.internal.VersionHelper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public final class ResourceManager {
    private static final String PROVIDER_RESOURCE_FILE_NAME = "jndiprovider.properties";
    private static final String APP_RESOURCE_FILE_NAME = "jndi.properties";
    private static final String JRELIB_PROPERTY_FILE_NAME = "jndi.properties";
    private static final String[] listProperties = new String[]{"java.naming.factory.object", "java.naming.factory.url.pkgs", "java.naming.factory.state", "java.naming.factory.control"};
    private static final VersionHelper helper = VersionHelper.getVersionHelper();
    private static final WeakHashMap propertiesCache = new WeakHashMap(11);
    private static final WeakHashMap factoryCache = new WeakHashMap(11);
    private static final WeakHashMap urlFactoryCache = new WeakHashMap(11);
    private static final WeakReference NO_FACTORY = new WeakReference<Object>(null);

    private ResourceManager() {
    }

    public static Hashtable getInitialEnvironment(Hashtable env) throws NamingException {
        String[] props = VersionHelper.PROPS;
        if (env == null) {
            env = new Hashtable(11);
        }
        Object applet = env.get("java.naming.applet");
        String[] jndiSysProps = helper.getJndiProperties();
        for (int i = 0; i < props.length; ++i) {
            Object val = env.get(props[i]);
            if (val != null) continue;
            if (applet != null) {
                val = AppletParameter.get(applet, props[i]);
            }
            if (val == null) {
                Object v = val = jndiSysProps != null ? jndiSysProps[i] : helper.getJndiProperty(i);
            }
            if (val == null) continue;
            env.put(props[i], val);
        }
        ResourceManager.mergeTables(env, ResourceManager.getApplicationResources());
        return env;
    }

    public static String getProperty(String propName, Hashtable env, Context ctx, boolean concat) throws NamingException {
        String val1;
        String string = val1 = env != null ? (String)env.get(propName) : null;
        if (ctx == null || val1 != null && !concat) {
            return val1;
        }
        String val2 = (String)ResourceManager.getProviderResource(ctx).get(propName);
        if (val1 == null) {
            return val2;
        }
        if (val2 == null || !concat) {
            return val1;
        }
        return val1 + ":" + val2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FactoryEnumeration getFactories(String propName, Hashtable env, Context ctx) throws NamingException {
        String facProp = ResourceManager.getProperty(propName, env, ctx, true);
        if (facProp == null) {
            return null;
        }
        ClassLoader loader = helper.getContextClassLoader();
        HashMap perLoaderCache = null;
        AbstractMap abstractMap = factoryCache;
        synchronized (abstractMap) {
            perLoaderCache = (HashMap)factoryCache.get(loader);
            if (perLoaderCache == null) {
                perLoaderCache = new HashMap(11);
                factoryCache.put(loader, perLoaderCache);
            }
        }
        abstractMap = perLoaderCache;
        synchronized (abstractMap) {
            ArrayList<NamedWeakReference> factories = (ArrayList<NamedWeakReference>)perLoaderCache.get(facProp);
            if (factories != null) {
                return factories.size() == 0 ? null : new FactoryEnumeration(factories, loader);
            }
            StringTokenizer parser = new StringTokenizer(facProp, ":");
            factories = new ArrayList<NamedWeakReference>(5);
            while (parser.hasMoreTokens()) {
                try {
                    String className = parser.nextToken();
                    Class c = helper.loadClass(className, loader);
                    factories.add(new NamedWeakReference(c, className));
                }
                catch (Exception e) {}
            }
            perLoaderCache.put(facProp, factories);
            return new FactoryEnumeration(factories, loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getFactory(String propName, Hashtable env, Context ctx, String classSuffix, String defaultPkgPrefix) throws NamingException {
        String facProp = ResourceManager.getProperty(propName, env, ctx, true);
        facProp = facProp != null ? facProp + ":" + defaultPkgPrefix : defaultPkgPrefix;
        ClassLoader loader = helper.getContextClassLoader();
        String key = classSuffix + " " + facProp;
        HashMap<String, WeakReference> perLoaderCache = null;
        AbstractMap abstractMap = urlFactoryCache;
        synchronized (abstractMap) {
            perLoaderCache = (HashMap<String, WeakReference>)urlFactoryCache.get(loader);
            if (perLoaderCache == null) {
                perLoaderCache = new HashMap<String, WeakReference>(11);
                urlFactoryCache.put(loader, perLoaderCache);
            }
        }
        abstractMap = perLoaderCache;
        synchronized (abstractMap) {
            Object factory = null;
            WeakReference factoryRef = (WeakReference)perLoaderCache.get(key);
            if (factoryRef == NO_FACTORY) {
                return null;
            }
            if (factoryRef != null && (factory = (Object)factoryRef.get()) != null) {
                return factory;
            }
            StringTokenizer parser = new StringTokenizer(facProp, ":");
            while (factory == null && parser.hasMoreTokens()) {
                String className = parser.nextToken() + classSuffix;
                try {
                    factory = helper.loadClass(className, loader).newInstance();
                }
                catch (InstantiationException e) {
                    NamingException ne = new NamingException("Cannot instantiate " + className);
                    ne.setRootCause(e);
                    throw ne;
                }
                catch (IllegalAccessException e) {
                    NamingException ne = new NamingException("Cannot access " + className);
                    ne.setRootCause(e);
                    throw ne;
                }
                catch (Exception e) {
                }
            }
            perLoaderCache.put(key, factory != null ? new WeakReference<Object>(factory) : NO_FACTORY);
            return factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Hashtable getProviderResource(Object obj) throws NamingException {
        if (obj == null) {
            return new Hashtable(1);
        }
        WeakHashMap weakHashMap = propertiesCache;
        synchronized (weakHashMap) {
            Class<?> c = obj.getClass();
            Hashtable props = (Hashtable)propertiesCache.get(c);
            if (props != null) {
                return props;
            }
            props = new Properties();
            InputStream istream = helper.getResourceAsStream(c, PROVIDER_RESOURCE_FILE_NAME);
            if (istream != null) {
                try {
                    ((Properties)props).load(istream);
                }
                catch (IOException e) {
                    ConfigurationException ne = new ConfigurationException("Error reading provider resource file for " + c);
                    ne.setRootCause(e);
                    throw ne;
                }
            }
            propertiesCache.put(c, props);
            return props;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Hashtable getApplicationResources() throws NamingException {
        ClassLoader cl = helper.getContextClassLoader();
        WeakHashMap weakHashMap = propertiesCache;
        synchronized (weakHashMap) {
            Properties result = (Properties)propertiesCache.get(cl);
            if (result != null) {
                return result;
            }
            try {
                NamingEnumeration resources = helper.getResources(cl, "jndi.properties");
                while (resources.hasMore()) {
                    Properties props = new Properties();
                    props.load((InputStream)resources.next());
                    if (result == null) {
                        result = props;
                        continue;
                    }
                    ResourceManager.mergeTables(result, props);
                }
                InputStream istream = helper.getJavaHomeLibStream("jndi.properties");
                if (istream != null) {
                    Properties props = new Properties();
                    props.load(istream);
                    if (result == null) {
                        result = props;
                    } else {
                        ResourceManager.mergeTables(result, props);
                    }
                }
            }
            catch (IOException e) {
                ConfigurationException ne = new ConfigurationException("Error reading application resource file");
                ne.setRootCause(e);
                throw ne;
            }
            if (result == null) {
                result = new Hashtable(11);
            }
            propertiesCache.put(cl, result);
            return result;
        }
    }

    private static void mergeTables(Hashtable props1, Hashtable props2) {
        Enumeration keys = props2.keys();
        while (keys.hasMoreElements()) {
            String prop = (String)keys.nextElement();
            Object val1 = props1.get(prop);
            if (val1 == null) {
                props1.put(prop, props2.get(prop));
                continue;
            }
            if (!ResourceManager.isListProperty(prop)) continue;
            String val2 = (String)props2.get(prop);
            props1.put(prop, (String)val1 + ":" + val2);
        }
    }

    private static boolean isListProperty(String prop) {
        prop = prop.intern();
        for (int i = 0; i < listProperties.length; ++i) {
            if (prop != listProperties[i]) continue;
            return true;
        }
        return false;
    }

    private static class AppletParameter {
        private static final Class<?> clazz = AppletParameter.getClass("java.applet.Applet");
        private static final Method getMethod = AppletParameter.getMethod(clazz, "getParameter", String.class);

        private AppletParameter() {
        }

        private static Class<?> getClass(String name) {
            try {
                return Class.forName(name, true, null);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        private static Method getMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
            if (clazz != null) {
                try {
                    return clazz.getMethod(name, paramTypes);
                }
                catch (NoSuchMethodException e) {
                    throw new AssertionError((Object)e);
                }
            }
            return null;
        }

        static Object get(Object applet, String name) {
            if (clazz == null || !clazz.isInstance(applet)) {
                throw new ClassCastException(applet.getClass().getName());
            }
            try {
                return getMethod.invoke(applet, name);
            }
            catch (InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException iae) {
                throw new AssertionError((Object)iae);
            }
        }
    }
}

