/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SunFileReader;
import com.sun.media.sound.WaveFileFormat;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class WaveFileReader
extends SunFileReader {
    private static final int MAX_READ_LENGTH = 12;
    public static final AudioFileFormat.Type[] types = new AudioFileFormat.Type[]{AudioFileFormat.Type.WAVE};

    @Override
    public AudioFileFormat getAudioFileFormat(InputStream stream) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat aff = this.getFMT(stream, true);
        stream.reset();
        return aff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat fileFormat = null;
        try (InputStream urlStream = url.openStream();){
            fileFormat = this.getFMT(urlStream, false);
        }
        return fileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat fileFormat = null;
        try (FileInputStream fis = new FileInputStream(file);){
            fileFormat = this.getFMT(fis, false);
        }
        return fileFormat;
    }

    @Override
    public AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat fileFormat = this.getFMT(stream, true);
        return new AudioInputStream(stream, fileFormat.getFormat(), fileFormat.getFrameLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        InputStream urlStream = url.openStream();
        AudioFileFormat fileFormat = null;
        try {
            fileFormat = this.getFMT(urlStream, false);
        }
        finally {
            if (fileFormat == null) {
                urlStream.close();
            }
        }
        return new AudioInputStream(urlStream, fileFormat.getFormat(), fileFormat.getFrameLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fis = new FileInputStream(file);
        AudioFileFormat fileFormat = null;
        try {
            fileFormat = this.getFMT(fis, false);
        }
        finally {
            if (fileFormat == null) {
                fis.close();
            }
        }
        return new AudioInputStream(fis, fileFormat.getFormat(), fileFormat.getFrameLength());
    }

    private AudioFileFormat getFMT(InputStream stream, boolean doReset) throws UnsupportedAudioFileException, IOException {
        int totallength;
        int nread = 0;
        int length = 0;
        short wav_type = 0;
        AudioFormat.Encoding encoding = null;
        DataInputStream dis = new DataInputStream(stream);
        if (doReset) {
            dis.mark(12);
        }
        int magic = dis.readInt();
        int fileLength = this.rllong(dis);
        int waveMagic = dis.readInt();
        if (fileLength <= 0) {
            fileLength = -1;
            totallength = -1;
        } else {
            totallength = fileLength + 8;
        }
        if (magic != 1380533830 || waveMagic != 1463899717) {
            if (doReset) {
                dis.reset();
            }
            throw new UnsupportedAudioFileException("not a WAVE file");
        }
        try {
            while (true) {
                int fmt = dis.readInt();
                nread += 4;
                if (fmt != 1718449184) {
                    length = this.rllong(dis);
                    nread += 4;
                    if (length % 2 > 0) {
                        ++length;
                    }
                    nread += dis.skipBytes(length);
                    continue;
                }
                break;
            }
        }
        catch (EOFException eof) {
            throw new UnsupportedAudioFileException("Not a valid WAV file");
        }
        length = this.rllong(dis);
        int endLength = (nread += 4) + length;
        wav_type = this.rlshort(dis);
        nread += 2;
        if (wav_type == 1) {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
        } else if (wav_type == 6) {
            encoding = AudioFormat.Encoding.ALAW;
        } else if (wav_type == 7) {
            encoding = AudioFormat.Encoding.ULAW;
        } else {
            throw new UnsupportedAudioFileException("Not a supported WAV file");
        }
        short channels = this.rlshort(dis);
        nread += 2;
        long sampleRate = this.rllong(dis);
        nread += 4;
        long avgBytesPerSec = this.rllong(dis);
        nread += 4;
        short blockAlign = this.rlshort(dis);
        nread += 2;
        short sampleSizeInBits = this.rlshort(dis);
        nread += 2;
        if (sampleSizeInBits == 8 && encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            encoding = AudioFormat.Encoding.PCM_UNSIGNED;
        }
        if (length % 2 != 0) {
            ++length;
        }
        if (endLength > nread) {
            nread += dis.skipBytes(endLength - nread);
        }
        nread = 0;
        try {
            while (true) {
                int datahdr = dis.readInt();
                nread += 4;
                if (datahdr != 1684108385) {
                    int thisLength = this.rllong(dis);
                    nread += 4;
                    if (thisLength % 2 > 0) {
                        ++thisLength;
                    }
                    nread += dis.skipBytes(thisLength);
                    continue;
                }
                break;
            }
        }
        catch (EOFException eof) {
            throw new UnsupportedAudioFileException("Not a valid WAV file");
        }
        int dataLength = this.rllong(dis);
        nread += 4;
        AudioFormat format = new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, WaveFileReader.calculatePCMFrameSize(sampleSizeInBits, channels), sampleRate, false);
        return new WaveFileFormat(AudioFileFormat.Type.WAVE, totallength, format, dataLength / format.getFrameSize());
    }
}

