/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AutoClosingClip;
import com.sun.media.sound.DataPusher;
import com.sun.media.sound.Toolkit;
import java.applet.AudioClip;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class JavaSoundAudioClip
implements AudioClip,
MetaEventListener,
LineListener {
    private static final boolean DEBUG = false;
    private static final int BUFFER_SIZE = 16384;
    private long lastPlayCall = 0L;
    private static final int MINIMUM_PLAY_DELAY = 30;
    private byte[] loadedAudio = null;
    private int loadedAudioByteLength = 0;
    private AudioFormat loadedAudioFormat = null;
    private AutoClosingClip clip = null;
    private boolean clipLooping = false;
    private DataPusher datapusher = null;
    private Sequencer sequencer = null;
    private Sequence sequence = null;
    private boolean sequencerloop = false;
    private static final long CLIP_THRESHOLD = 0x100000L;
    private static final int STREAM_BUFFER_SIZE = 1024;

    public JavaSoundAudioClip(InputStream in) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(in, 1024);
        bis.mark(1024);
        boolean success = false;
        try {
            AudioInputStream as = AudioSystem.getAudioInputStream(bis);
            success = this.loadAudioData(as);
            if (success) {
                success = false;
                if ((long)this.loadedAudioByteLength < 0x100000L) {
                    success = this.createClip();
                }
                if (!success) {
                    success = this.createSourceDataLine();
                }
            }
        }
        catch (UnsupportedAudioFileException e) {
            try {
                MidiFileFormat mff = MidiSystem.getMidiFileFormat(bis);
                success = this.createSequencer(bis);
            }
            catch (InvalidMidiDataException e1) {
                success = false;
            }
        }
        if (!success) {
            throw new IOException("Unable to create AudioClip from input stream");
        }
    }

    @Override
    public synchronized void play() {
        this.startImpl(false);
    }

    @Override
    public synchronized void loop() {
        this.startImpl(true);
    }

    private synchronized void startImpl(boolean loop) {
        block17: {
            long currentTime = System.currentTimeMillis();
            long diff = currentTime - this.lastPlayCall;
            if (diff < 30L) {
                return;
            }
            this.lastPlayCall = currentTime;
            try {
                if (this.clip != null) {
                    if (!this.clip.isOpen()) {
                        this.clip.open(this.loadedAudioFormat, this.loadedAudio, 0, this.loadedAudioByteLength);
                    } else {
                        this.clip.flush();
                        if (loop != this.clipLooping) {
                            this.clip.stop();
                        }
                    }
                    this.clip.setFramePosition(0);
                    if (loop) {
                        this.clip.loop(-1);
                    } else {
                        this.clip.start();
                    }
                    this.clipLooping = loop;
                    break block17;
                }
                if (this.datapusher != null) {
                    this.datapusher.start(loop);
                    break block17;
                }
                if (this.sequencer == null) break block17;
                this.sequencerloop = loop;
                if (this.sequencer.isRunning()) {
                    this.sequencer.setMicrosecondPosition(0L);
                }
                if (!this.sequencer.isOpen()) {
                    try {
                        this.sequencer.open();
                        this.sequencer.setSequence(this.sequence);
                    }
                    catch (InvalidMidiDataException e1) {
                    }
                    catch (MidiUnavailableException e2) {
                        // empty catch block
                    }
                }
                this.sequencer.addMetaEventListener(this);
                try {
                    this.sequencer.start();
                }
                catch (Exception e) {}
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void stop() {
        this.lastPlayCall = 0L;
        if (this.clip != null) {
            try {
                this.clip.flush();
            }
            catch (Exception e1) {
                // empty catch block
            }
            try {
                this.clip.stop();
            }
            catch (Exception e2) {}
        } else if (this.datapusher != null) {
            this.datapusher.stop();
        } else if (this.sequencer != null) {
            try {
                this.sequencerloop = false;
                this.sequencer.addMetaEventListener(this);
                this.sequencer.stop();
            }
            catch (Exception e3) {
                // empty catch block
            }
            try {
                this.sequencer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void update(LineEvent event) {
    }

    @Override
    public synchronized void meta(MetaMessage message) {
        if (message.getType() == 47) {
            if (this.sequencerloop) {
                this.sequencer.setMicrosecondPosition(0L);
                this.loop();
            } else {
                this.stop();
            }
        }
    }

    public String toString() {
        return this.getClass().toString();
    }

    protected void finalize() {
        if (this.clip != null) {
            this.clip.close();
        }
        if (this.datapusher != null) {
            this.datapusher.close();
        }
        if (this.sequencer != null) {
            this.sequencer.close();
        }
    }

    private boolean loadAudioData(AudioInputStream as) throws IOException, UnsupportedAudioFileException {
        if ((as = Toolkit.getPCMConvertedAudioInputStream(as)) == null) {
            return false;
        }
        this.loadedAudioFormat = as.getFormat();
        long frameLen = as.getFrameLength();
        int frameSize = this.loadedAudioFormat.getFrameSize();
        long byteLen = -1L;
        if (frameLen != -1L && frameLen > 0L && frameSize != -1 && frameSize > 0) {
            byteLen = frameLen * (long)frameSize;
        }
        if (byteLen != -1L) {
            this.readStream(as, byteLen);
        } else {
            this.readStream(as);
        }
        return true;
    }

    private void readStream(AudioInputStream as, long byteLen) throws IOException {
        int intLen = byteLen > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)byteLen;
        this.loadedAudio = new byte[intLen];
        this.loadedAudioByteLength = 0;
        while (true) {
            int bytesRead;
            if ((bytesRead = as.read(this.loadedAudio, this.loadedAudioByteLength, intLen - this.loadedAudioByteLength)) <= 0) break;
            this.loadedAudioByteLength += bytesRead;
        }
        as.close();
    }

    private void readStream(AudioInputStream as) throws IOException {
        DirectBAOS baos = new DirectBAOS();
        byte[] buffer = new byte[16384];
        int bytesRead = 0;
        int totalBytesRead = 0;
        while (true) {
            if ((bytesRead = as.read(buffer, 0, buffer.length)) <= 0) break;
            totalBytesRead += bytesRead;
            baos.write(buffer, 0, bytesRead);
        }
        as.close();
        this.loadedAudio = baos.getInternalBuffer();
        this.loadedAudioByteLength = totalBytesRead;
    }

    private boolean createClip() {
        try {
            DataLine.Info info = new DataLine.Info(Clip.class, this.loadedAudioFormat);
            if (!AudioSystem.isLineSupported(info)) {
                return false;
            }
            Line line = AudioSystem.getLine(info);
            if (!(line instanceof AutoClosingClip)) {
                return false;
            }
            this.clip = (AutoClosingClip)line;
            this.clip.setAutoClosing(true);
        }
        catch (Exception e) {
            return false;
        }
        return this.clip != null;
    }

    private boolean createSourceDataLine() {
        try {
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.loadedAudioFormat);
            if (!AudioSystem.isLineSupported(info)) {
                return false;
            }
            SourceDataLine source = (SourceDataLine)AudioSystem.getLine(info);
            this.datapusher = new DataPusher(source, this.loadedAudioFormat, this.loadedAudio, this.loadedAudioByteLength);
        }
        catch (Exception e) {
            return false;
        }
        return this.datapusher != null;
    }

    private boolean createSequencer(BufferedInputStream in) throws IOException {
        try {
            this.sequencer = MidiSystem.getSequencer();
        }
        catch (MidiUnavailableException me) {
            return false;
        }
        if (this.sequencer == null) {
            return false;
        }
        try {
            this.sequence = MidiSystem.getSequence(in);
            if (this.sequence == null) {
                return false;
            }
        }
        catch (InvalidMidiDataException e) {
            return false;
        }
        return true;
    }

    private static class DirectBAOS
    extends ByteArrayOutputStream {
        public byte[] getInternalBuffer() {
            return this.buf;
        }
    }
}

