/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orbutil.threadpool;

import com.sun.corba.se.impl.orbutil.threadpool.TimeoutException;
import com.sun.corba.se.impl.orbutil.threadpool.WorkQueueImpl;
import com.sun.corba.se.spi.monitoring.LongMonitoredAttributeBase;
import com.sun.corba.se.spi.monitoring.MonitoredObject;
import com.sun.corba.se.spi.monitoring.MonitoringFactories;
import com.sun.corba.se.spi.orbutil.threadpool.NoSuchWorkQueueException;
import com.sun.corba.se.spi.orbutil.threadpool.ThreadPool;
import com.sun.corba.se.spi.orbutil.threadpool.Work;
import com.sun.corba.se.spi.orbutil.threadpool.WorkQueue;

public class ThreadPoolImpl
implements ThreadPool {
    private static int threadCounter = 0;
    private WorkQueue workQueue;
    private int availableWorkerThreads = 0;
    private int currentThreadCount = 0;
    private int minWorkerThreads = 0;
    private int maxWorkerThreads = 0;
    private long inactivityTimeout;
    private boolean boundedThreadPool = false;
    private long processedCount = 1L;
    private long totalTimeTaken = 0L;
    private Object lock = new Object();
    private String name;
    private MonitoredObject threadpoolMonitoredObject;
    private ThreadGroup threadGroup;

    public ThreadPoolImpl(ThreadGroup tg, String threadpoolName) {
        this.inactivityTimeout = 120000L;
        this.maxWorkerThreads = Integer.MAX_VALUE;
        this.workQueue = new WorkQueueImpl(this);
        this.threadGroup = tg;
        this.name = threadpoolName;
        this.initializeMonitoring();
    }

    public ThreadPoolImpl(String threadpoolName) {
        this(Thread.currentThread().getThreadGroup(), threadpoolName);
    }

    public ThreadPoolImpl(int minSize, int maxSize, long timeout, String threadpoolName) {
        this.minWorkerThreads = minSize;
        this.maxWorkerThreads = maxSize;
        this.inactivityTimeout = timeout;
        this.boundedThreadPool = true;
        this.workQueue = new WorkQueueImpl(this);
        this.name = threadpoolName;
        for (int i = 0; i < this.minWorkerThreads; ++i) {
            this.createWorkerThread();
        }
        this.initializeMonitoring();
    }

    private void initializeMonitoring() {
        MonitoredObject root = MonitoringFactories.getMonitoringManagerFactory().createMonitoringManager("orb", null).getRootMonitoredObject();
        MonitoredObject threadPoolMonitoringObjectRoot = root.getChild("threadpool");
        if (threadPoolMonitoringObjectRoot == null) {
            threadPoolMonitoringObjectRoot = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject("threadpool", "Monitoring for all ThreadPool instances");
            root.addChild(threadPoolMonitoringObjectRoot);
        }
        this.threadpoolMonitoredObject = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject(this.name, "Monitoring for a ThreadPool");
        threadPoolMonitoringObjectRoot.addChild(this.threadpoolMonitoredObject);
        LongMonitoredAttributeBase b1 = new LongMonitoredAttributeBase("currentNumberOfThreads", "Current number of total threads in the ThreadPool"){

            @Override
            public Object getValue() {
                return new Long(ThreadPoolImpl.this.currentNumberOfThreads());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(b1);
        LongMonitoredAttributeBase b2 = new LongMonitoredAttributeBase("numberOfAvailableThreads", "Current number of total threads in the ThreadPool"){

            @Override
            public Object getValue() {
                return new Long(ThreadPoolImpl.this.numberOfAvailableThreads());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(b2);
        LongMonitoredAttributeBase b3 = new LongMonitoredAttributeBase("numberOfBusyThreads", "Number of busy threads in the ThreadPool"){

            @Override
            public Object getValue() {
                return new Long(ThreadPoolImpl.this.numberOfBusyThreads());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(b3);
        LongMonitoredAttributeBase b4 = new LongMonitoredAttributeBase("averageWorkCompletionTime", "Average elapsed time taken to complete a work item by the ThreadPool"){

            @Override
            public Object getValue() {
                return new Long(ThreadPoolImpl.this.averageWorkCompletionTime());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(b4);
        LongMonitoredAttributeBase b5 = new LongMonitoredAttributeBase("currentProcessedCount", "Number of Work items processed by the ThreadPool"){

            @Override
            public Object getValue() {
                return new Long(ThreadPoolImpl.this.currentProcessedCount());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(b5);
        this.threadpoolMonitoredObject.addChild(((WorkQueueImpl)this.workQueue).getMonitoredObject());
    }

    MonitoredObject getMonitoredObject() {
        return this.threadpoolMonitoredObject;
    }

    @Override
    public WorkQueue getAnyWorkQueue() {
        return this.workQueue;
    }

    @Override
    public WorkQueue getWorkQueue(int queueId) throws NoSuchWorkQueueException {
        if (queueId != 0) {
            throw new NoSuchWorkQueueException();
        }
        return this.workQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyForAvailableWork(WorkQueue aWorkQueue) {
        Object object = this.lock;
        synchronized (object) {
            if (this.availableWorkerThreads == 0) {
                this.createWorkerThread();
            } else {
                aWorkQueue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void createWorkerThread() {
        WorkerThread thread;
        Object object = this.lock;
        synchronized (object) {
            if (this.boundedThreadPool) {
                if (this.currentThreadCount >= this.maxWorkerThreads) {
                    return;
                }
                thread = new WorkerThread(this.threadGroup, this.getName());
                ++this.currentThreadCount;
            } else {
                thread = new WorkerThread(this.threadGroup, this.getName());
                ++this.currentThreadCount;
            }
        }
        try {
            thread.setDaemon(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        thread.start();
    }

    @Override
    public int minimumNumberOfThreads() {
        return this.minWorkerThreads;
    }

    @Override
    public int maximumNumberOfThreads() {
        return this.maxWorkerThreads;
    }

    @Override
    public long idleTimeoutForThreads() {
        return this.inactivityTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int currentNumberOfThreads() {
        Object object = this.lock;
        synchronized (object) {
            return this.currentThreadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int numberOfAvailableThreads() {
        Object object = this.lock;
        synchronized (object) {
            return this.availableWorkerThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int numberOfBusyThreads() {
        Object object = this.lock;
        synchronized (object) {
            return this.currentThreadCount - this.availableWorkerThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long averageWorkCompletionTime() {
        Object object = this.lock;
        synchronized (object) {
            return this.totalTimeTaken / this.processedCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long currentProcessedCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.processedCount;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int numberOfWorkQueues() {
        return 1;
    }

    private static synchronized int getUniqueThreadId() {
        return threadCounter++;
    }

    private class WorkerThread
    extends Thread {
        private Work currentWork;
        private int threadId;
        private String threadPoolName;
        private StringBuffer workerThreadName;

        WorkerThread(ThreadGroup tg, String threadPoolName) {
            super(tg, "Idle");
            this.threadId = 0;
            this.workerThreadName = new StringBuffer();
            this.threadId = ThreadPoolImpl.getUniqueThreadId();
            this.threadPoolName = threadPoolName;
            this.setName(this.composeWorkerThreadName(threadPoolName, "Idle"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object;
                try {
                    while (true) {
                        Object object2 = ThreadPoolImpl.this.lock;
                        synchronized (object2) {
                            ThreadPoolImpl.this.availableWorkerThreads++;
                        }
                        this.currentWork = ((WorkQueueImpl)ThreadPoolImpl.this.workQueue).requestWork(ThreadPoolImpl.this.inactivityTimeout);
                        object2 = ThreadPoolImpl.this.lock;
                        synchronized (object2) {
                            ThreadPoolImpl.this.availableWorkerThreads--;
                            if (ThreadPoolImpl.this.availableWorkerThreads == 0 && ThreadPoolImpl.this.workQueue.workItemsInQueue() > 0) {
                                ThreadPoolImpl.this.createWorkerThread();
                            }
                        }
                        this.setName(this.composeWorkerThreadName(this.threadPoolName, Integer.toString(this.threadId)));
                        long start = System.currentTimeMillis();
                        try {
                            this.currentWork.doWork();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        long end = System.currentTimeMillis();
                        Object object3 = ThreadPoolImpl.this.lock;
                        synchronized (object3) {
                            ThreadPoolImpl.this.totalTimeTaken += end - start;
                            ThreadPoolImpl.this.processedCount++;
                        }
                        this.currentWork = null;
                        this.setName(this.composeWorkerThreadName(this.threadPoolName, "Idle"));
                    }
                }
                catch (TimeoutException e) {
                    object = ThreadPoolImpl.this.lock;
                    synchronized (object) {
                        ThreadPoolImpl.this.availableWorkerThreads--;
                        if (ThreadPoolImpl.this.currentThreadCount > ThreadPoolImpl.this.minWorkerThreads) {
                            ThreadPoolImpl.this.currentThreadCount--;
                            return;
                        }
                    }
                }
                catch (InterruptedException ie) {
                    object = ThreadPoolImpl.this.lock;
                    synchronized (object) {
                        ThreadPoolImpl.this.availableWorkerThreads--;
                    }
                }
                catch (Throwable e) {
                    object = ThreadPoolImpl.this.lock;
                    synchronized (object) {
                        ThreadPoolImpl.this.availableWorkerThreads--;
                    }
                }
            }
        }

        private String composeWorkerThreadName(String poolName, String workerName) {
            this.workerThreadName.setLength(0);
            this.workerThreadName.append("p: ").append(poolName);
            this.workerThreadName.append("; w: ").append(workerName);
            return this.workerThreadName.toString();
        }
    }
}

