/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.AlgorithmConstraints;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import sun.security.util.KeyLength;

final class SignatureAndHashAlgorithm {
    static final int SUPPORTED_ALG_PRIORITY_MAX_NUM = 240;
    private static final Set<CryptoPrimitive> SIGNATURE_PRIMITIVE_SET = EnumSet.of(CryptoPrimitive.SIGNATURE);
    private static final Map<Integer, SignatureAndHashAlgorithm> supportedMap = Collections.synchronizedSortedMap(new TreeMap());
    private static final Map<Integer, SignatureAndHashAlgorithm> priorityMap = Collections.synchronizedSortedMap(new TreeMap());
    private HashAlgorithm hash;
    private SignatureAlgorithm signature;
    private int id;
    private String algorithm;
    private int priority;

    private SignatureAndHashAlgorithm(HashAlgorithm hash, SignatureAlgorithm signature, String algorithm, int priority) {
        this.hash = hash;
        this.signature = signature;
        this.algorithm = algorithm;
        this.id = (hash.value & 0xFF) << 8 | signature.value & 0xFF;
        this.priority = priority;
    }

    private SignatureAndHashAlgorithm(String algorithm, int id, int sequence) {
        this.hash = HashAlgorithm.valueOf(id >> 8 & 0xFF);
        this.signature = SignatureAlgorithm.valueOf(id & 0xFF);
        this.algorithm = algorithm;
        this.id = id;
        this.priority = 240 + sequence + 1;
    }

    static SignatureAndHashAlgorithm valueOf(int hash, int signature, int sequence) {
        int id = (hash &= 0xFF) << 8 | (signature &= 0xFF);
        SignatureAndHashAlgorithm signAlg = supportedMap.get(id);
        if (signAlg == null) {
            signAlg = new SignatureAndHashAlgorithm("Unknown (hash:0x" + Integer.toString(hash, 16) + ", signature:0x" + Integer.toString(signature, 16) + ")", id, sequence);
        }
        return signAlg;
    }

    int getHashValue() {
        return this.id >> 8 & 0xFF;
    }

    int getSignatureValue() {
        return this.id & 0xFF;
    }

    String getAlgorithmName() {
        return this.algorithm;
    }

    static int sizeInRecord() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Collection<SignatureAndHashAlgorithm> getSupportedAlgorithms(AlgorithmConstraints constraints) {
        ArrayList<SignatureAndHashAlgorithm> supported = new ArrayList<SignatureAndHashAlgorithm>();
        Map<Integer, SignatureAndHashAlgorithm> map = priorityMap;
        synchronized (map) {
            for (SignatureAndHashAlgorithm sigAlg : priorityMap.values()) {
                if (sigAlg.priority > 240 || !constraints.permits(SIGNATURE_PRIMITIVE_SET, sigAlg.algorithm, null)) continue;
                supported.add(sigAlg);
            }
        }
        return supported;
    }

    static Collection<SignatureAndHashAlgorithm> getSupportedAlgorithms(Collection<SignatureAndHashAlgorithm> algorithms) {
        ArrayList<SignatureAndHashAlgorithm> supported = new ArrayList<SignatureAndHashAlgorithm>();
        for (SignatureAndHashAlgorithm sigAlg : algorithms) {
            if (sigAlg.priority > 240) continue;
            supported.add(sigAlg);
        }
        return supported;
    }

    static String[] getAlgorithmNames(Collection<SignatureAndHashAlgorithm> algorithms) {
        ArrayList<String> algorithmNames = new ArrayList<String>();
        if (algorithms != null) {
            for (SignatureAndHashAlgorithm sigAlg : algorithms) {
                algorithmNames.add(sigAlg.algorithm);
            }
        }
        String[] array = new String[algorithmNames.size()];
        return algorithmNames.toArray(array);
    }

    static Set<String> getHashAlgorithmNames(Collection<SignatureAndHashAlgorithm> algorithms) {
        HashSet<String> algorithmNames = new HashSet<String>();
        if (algorithms != null) {
            for (SignatureAndHashAlgorithm sigAlg : algorithms) {
                if (sigAlg.hash.value <= 0) continue;
                algorithmNames.add(sigAlg.hash.standardName);
            }
        }
        return algorithmNames;
    }

    static String getHashAlgorithmName(SignatureAndHashAlgorithm algorithm) {
        return algorithm.hash.standardName;
    }

    private static void supports(HashAlgorithm hash, SignatureAlgorithm signature, String algorithm, int priority) {
        SignatureAndHashAlgorithm pair = new SignatureAndHashAlgorithm(hash, signature, algorithm, priority);
        if (supportedMap.put(pair.id, pair) != null) {
            throw new RuntimeException("Duplicate SignatureAndHashAlgorithm definition, id: " + pair.id);
        }
        if (priorityMap.put(pair.priority, pair) != null) {
            throw new RuntimeException("Duplicate SignatureAndHashAlgorithm definition, priority: " + pair.priority);
        }
    }

    static SignatureAndHashAlgorithm getPreferableAlgorithm(Collection<SignatureAndHashAlgorithm> algorithms, String expected) {
        return SignatureAndHashAlgorithm.getPreferableAlgorithm(algorithms, expected, null);
    }

    static SignatureAndHashAlgorithm getPreferableAlgorithm(Collection<SignatureAndHashAlgorithm> algorithms, String expected, PrivateKey signingKey) {
        if (expected == null && !algorithms.isEmpty()) {
            for (SignatureAndHashAlgorithm sigAlg : algorithms) {
                if (sigAlg.priority > 240) continue;
                return sigAlg;
            }
            return null;
        }
        if (expected == null) {
            return null;
        }
        int maxDigestLength = Integer.MAX_VALUE;
        if (signingKey != null && "rsa".equalsIgnoreCase(signingKey.getAlgorithm()) && expected.equalsIgnoreCase("rsa")) {
            int keySize = KeyLength.getKeySize((Key)signingKey);
            if (keySize >= 768) {
                maxDigestLength = HashAlgorithm.SHA512.length;
            } else if (keySize >= 512 && keySize < 768) {
                maxDigestLength = HashAlgorithm.SHA256.length;
            } else if (keySize > 0 && keySize < 512) {
                maxDigestLength = HashAlgorithm.SHA1.length;
            }
        }
        for (SignatureAndHashAlgorithm algorithm : algorithms) {
            int signValue = algorithm.id & 0xFF;
            if (!(expected.equalsIgnoreCase("rsa") && signValue == SignatureAlgorithm.RSA.value ? algorithm.hash.length <= maxDigestLength : expected.equalsIgnoreCase("dsa") && signValue == SignatureAlgorithm.DSA.value || expected.equalsIgnoreCase("ecdsa") && signValue == SignatureAlgorithm.ECDSA.value || expected.equalsIgnoreCase("ec") && signValue == SignatureAlgorithm.ECDSA.value)) continue;
            return algorithm;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Map<Integer, SignatureAndHashAlgorithm> map = supportedMap;
        synchronized (map) {
            int p = 240;
            SignatureAndHashAlgorithm.supports(HashAlgorithm.MD5, SignatureAlgorithm.RSA, "MD5withRSA", --p);
            SignatureAndHashAlgorithm.supports(HashAlgorithm.SHA1, SignatureAlgorithm.DSA, "SHA1withDSA", --p);
            SignatureAndHashAlgorithm.supports(HashAlgorithm.SHA1, SignatureAlgorithm.RSA, "SHA1withRSA", --p);
            SignatureAndHashAlgorithm.supports(HashAlgorithm.SHA1, SignatureAlgorithm.ECDSA, "SHA1withECDSA", --p);
            SignatureAndHashAlgorithm.supports(HashAlgorithm.SHA224, SignatureAlgorithm.RSA, "SHA224withRSA", --p);
            SignatureAndHashAlgorithm.supports(HashAlgorithm.SHA224, SignatureAlgorithm.ECDSA, "SHA224withECDSA", --p);
            SignatureAndHashAlgorithm.supports(HashAlgorithm.SHA256, SignatureAlgorithm.RSA, "SHA256withRSA", --p);
            SignatureAndHashAlgorithm.supports(HashAlgorithm.SHA256, SignatureAlgorithm.ECDSA, "SHA256withECDSA", --p);
            SignatureAndHashAlgorithm.supports(HashAlgorithm.SHA384, SignatureAlgorithm.RSA, "SHA384withRSA", --p);
            SignatureAndHashAlgorithm.supports(HashAlgorithm.SHA384, SignatureAlgorithm.ECDSA, "SHA384withECDSA", --p);
            SignatureAndHashAlgorithm.supports(HashAlgorithm.SHA512, SignatureAlgorithm.RSA, "SHA512withRSA", --p);
            SignatureAndHashAlgorithm.supports(HashAlgorithm.SHA512, SignatureAlgorithm.ECDSA, "SHA512withECDSA", --p);
        }
    }

    static enum SignatureAlgorithm {
        UNDEFINED("undefined", -1),
        ANONYMOUS("anonymous", 0),
        RSA("rsa", 1),
        DSA("dsa", 2),
        ECDSA("ecdsa", 3);

        final String name;
        final int value;

        private SignatureAlgorithm(String name, int value) {
            this.name = name;
            this.value = value;
        }

        static SignatureAlgorithm valueOf(int value) {
            SignatureAlgorithm algorithm = UNDEFINED;
            switch (value) {
                case 0: {
                    algorithm = ANONYMOUS;
                    break;
                }
                case 1: {
                    algorithm = RSA;
                    break;
                }
                case 2: {
                    algorithm = DSA;
                    break;
                }
                case 3: {
                    algorithm = ECDSA;
                }
            }
            return algorithm;
        }
    }

    static enum HashAlgorithm {
        UNDEFINED("undefined", "", -1, -1),
        NONE("none", "NONE", 0, -1),
        MD5("md5", "MD5", 1, 16),
        SHA1("sha1", "SHA-1", 2, 20),
        SHA224("sha224", "SHA-224", 3, 28),
        SHA256("sha256", "SHA-256", 4, 32),
        SHA384("sha384", "SHA-384", 5, 48),
        SHA512("sha512", "SHA-512", 6, 64);

        final String name;
        final String standardName;
        final int value;
        final int length;

        private HashAlgorithm(String name, String standardName, int value, int length) {
            this.name = name;
            this.standardName = standardName;
            this.value = value;
            this.length = length;
        }

        static HashAlgorithm valueOf(int value) {
            HashAlgorithm algorithm = UNDEFINED;
            switch (value) {
                case 0: {
                    algorithm = NONE;
                    break;
                }
                case 1: {
                    algorithm = MD5;
                    break;
                }
                case 2: {
                    algorithm = SHA1;
                    break;
                }
                case 3: {
                    algorithm = SHA224;
                    break;
                }
                case 4: {
                    algorithm = SHA256;
                    break;
                }
                case 5: {
                    algorithm = SHA384;
                    break;
                }
                case 6: {
                    algorithm = SHA512;
                }
            }
            return algorithm;
        }
    }
}

