/*
 * Decompiled with CFR 0.152.
 */
package org.classpath.icedtea.pulseaudio;

import java.util.Arrays;
import org.classpath.icedtea.pulseaudio.EventLoop;
import org.classpath.icedtea.pulseaudio.SecurityWrapper;

class Operation {
    private byte[] operationPointer;
    private EventLoop eventLoop;
    public static long RUNNING = -1L;
    public static long DONE = -1L;
    public static long CANCELLED = -1L;

    private static native void init_constants();

    private static long checkNativeOperationState(long value) {
        if (!Arrays.asList(RUNNING, DONE, CANCELLED).contains(value)) {
            throw new IllegalStateException("Unknown operation state: " + value);
        }
        return value;
    }

    private native void native_ref();

    private native void native_unref();

    private native long native_get_state();

    Operation(byte[] operationPointer) {
        assert (operationPointer != null);
        this.operationPointer = operationPointer;
        this.eventLoop = EventLoop.getEventLoop();
    }

    protected void finalize() throws Throwable {
        assert (this.operationPointer == null);
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addReference() {
        assert (this.operationPointer != null);
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            this.native_ref();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseReference() {
        assert (this.operationPointer != null);
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            this.native_unref();
        }
        this.operationPointer = null;
    }

    boolean isNull() {
        return this.operationPointer == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getState() {
        assert (this.operationPointer != null);
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            return Operation.checkNativeOperationState(this.native_get_state());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForCompletion() {
        assert (this.operationPointer != null);
        boolean interrupted = false;
        do {
            Object object = this.eventLoop.threadLock;
            synchronized (object) {
                if (this.getState() == DONE) {
                    return;
                }
                try {
                    this.eventLoop.threadLock.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        } while (this.getState() != DONE);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    static {
        SecurityWrapper.loadNativeLibrary();
        Operation.init_constants();
    }
}

