/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.text.TextAction;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

class Notepad
extends JPanel {
    private static ResourceBundle resources;
    private static final String EXIT_AFTER_PAINT = "-exit";
    private static boolean exitAfterFirstPaint;
    private JTextComponent editor;
    private Map<Object, Action> commands;
    private Map<String, JMenuItem> menuItems;
    private JMenuBar menubar;
    private JToolBar toolbar;
    private JComponent status;
    private JFrame elementTreeFrame;
    protected ElementTreePanel elementTreePanel;
    protected FileDialog fileDialog;
    protected UndoableEditListener undoHandler = new UndoHandler();
    protected UndoManager undo = new UndoManager();
    public static final String imageSuffix = "Image";
    public static final String labelSuffix = "Label";
    public static final String actionSuffix = "Action";
    public static final String tipSuffix = "Tooltip";
    public static final String openAction = "open";
    public static final String newAction = "new";
    public static final String saveAction = "save";
    public static final String exitAction = "exit";
    public static final String showElementTreeAction = "showElementTree";
    private UndoAction undoAction = new UndoAction();
    private RedoAction redoAction = new RedoAction();
    private Action[] defaultActions = new Action[]{new NewAction(), new OpenAction(), new SaveAction(), new ExitAction(), new ShowElementTreeAction(), this.undoAction, this.redoAction};

    @Override
    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (exitAfterFirstPaint) {
            System.exit(0);
        }
    }

    Notepad() {
        super(true);
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.editor = this.createEditor();
        this.editor.getDocument().addUndoableEditListener(this.undoHandler);
        this.commands = new HashMap<Object, Action>();
        Action[] actions = this.getActions();
        for (int i = 0; i < actions.length; ++i) {
            Action a = actions[i];
            this.commands.put(a.getValue("Name"), a);
        }
        JScrollPane scroller = new JScrollPane();
        JViewport port = scroller.getViewport();
        port.add(this.editor);
        try {
            String vpFlag = resources.getString("ViewportBackingStore");
            Boolean bs = Boolean.valueOf(vpFlag);
            port.setScrollMode(bs != false ? 2 : 1);
        }
        catch (MissingResourceException ignored) {
            // empty catch block
        }
        this.menuItems = new HashMap<String, JMenuItem>();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("North", this.createToolbar());
        panel.add("Center", scroller);
        this.add("Center", panel);
        this.add("South", this.createStatusbar());
    }

    public static void main(String[] args) {
        try {
            if (args.length > 0 && args[0].equals(EXIT_AFTER_PAINT)) {
                exitAfterFirstPaint = true;
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JFrame frame = new JFrame();
                    frame.setTitle(resources.getString("Title"));
                    frame.setBackground(Color.lightGray);
                    frame.getContentPane().setLayout(new BorderLayout());
                    Notepad notepad = new Notepad();
                    frame.getContentPane().add("Center", notepad);
                    frame.setJMenuBar(notepad.createMenubar());
                    frame.addWindowListener(new AppCloser());
                    frame.pack();
                    frame.setSize(500, 600);
                    frame.setVisible(true);
                }
            });
        }
        catch (Throwable t) {
            Logger.getLogger(Notepad.class.getName()).log(Level.SEVERE, "uncaught exception", t);
        }
    }

    public Action[] getActions() {
        return TextAction.augmentList(this.editor.getActions(), this.defaultActions);
    }

    protected JTextComponent createEditor() {
        JTextArea c = new JTextArea();
        c.setDragEnabled(true);
        ((JComponent)c).setFont(new Font("monospaced", 0, 12));
        return c;
    }

    protected JTextComponent getEditor() {
        return this.editor;
    }

    protected Frame getFrame() {
        for (Container p = this.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof Frame)) continue;
            return (Frame)p;
        }
        return null;
    }

    protected JMenuItem createMenuItem(String cmd) {
        String astr;
        JMenuItem mi = new JMenuItem(this.getResourceString(cmd + labelSuffix));
        URL url = this.getResource(cmd + imageSuffix);
        if (url != null) {
            mi.setHorizontalTextPosition(4);
            mi.setIcon(new ImageIcon(url));
        }
        if ((astr = this.getResourceString(cmd + actionSuffix)) == null) {
            astr = cmd;
        }
        mi.setActionCommand(astr);
        Action a = this.getAction(astr);
        if (a != null) {
            mi.addActionListener(a);
            a.addPropertyChangeListener(this.createActionChangeListener(mi));
            mi.setEnabled(a.isEnabled());
        } else {
            mi.setEnabled(false);
        }
        this.menuItems.put(cmd, mi);
        return mi;
    }

    protected JMenuItem getMenuItem(String cmd) {
        return this.menuItems.get(cmd);
    }

    protected Action getAction(String cmd) {
        return this.commands.get(cmd);
    }

    protected String getResourceString(String nm) {
        String str;
        try {
            str = resources.getString(nm);
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    protected URL getResource(String key) {
        String name = this.getResourceString(key);
        if (name != null) {
            URL url = this.getClass().getResource(name);
            return url;
        }
        return null;
    }

    protected Container getToolbar() {
        return this.toolbar;
    }

    protected JMenuBar getMenubar() {
        return this.menubar;
    }

    protected Component createStatusbar() {
        this.status = new StatusBar();
        return this.status;
    }

    protected void resetUndoManager() {
        this.undo.discardAllEdits();
        this.undoAction.update();
        this.redoAction.update();
    }

    private Component createToolbar() {
        this.toolbar = new JToolBar();
        String[] toolKeys = this.tokenize(this.getResourceString("toolbar"));
        for (int i = 0; i < toolKeys.length; ++i) {
            if (toolKeys[i].equals("-")) {
                this.toolbar.add(Box.createHorizontalStrut(5));
                continue;
            }
            this.toolbar.add(this.createTool(toolKeys[i]));
        }
        this.toolbar.add(Box.createHorizontalGlue());
        return this.toolbar;
    }

    protected Component createTool(String key) {
        return this.createToolbarButton(key);
    }

    protected JButton createToolbarButton(String key) {
        Action a;
        URL url = this.getResource(key + imageSuffix);
        JButton b = new JButton((Icon)new ImageIcon(url)){

            @Override
            public float getAlignmentY() {
                return 0.5f;
            }
        };
        b.setRequestFocusEnabled(false);
        b.setMargin(new Insets(1, 1, 1, 1));
        String astr = this.getResourceString(key + actionSuffix);
        if (astr == null) {
            astr = key;
        }
        if ((a = this.getAction(astr)) != null) {
            b.setActionCommand(astr);
            b.addActionListener(a);
        } else {
            b.setEnabled(false);
        }
        String tip = this.getResourceString(key + tipSuffix);
        if (tip != null) {
            b.setToolTipText(tip);
        }
        return b;
    }

    protected String[] tokenize(String input) {
        ArrayList<String> v = new ArrayList<String>();
        StringTokenizer t = new StringTokenizer(input);
        while (t.hasMoreTokens()) {
            v.add(t.nextToken());
        }
        String[] cmd = new String[v.size()];
        for (int i = 0; i < cmd.length; ++i) {
            cmd[i] = (String)v.get(i);
        }
        return cmd;
    }

    protected JMenuBar createMenubar() {
        JMenuBar mb = new JMenuBar();
        String[] menuKeys = this.tokenize(this.getResourceString("menubar"));
        for (int i = 0; i < menuKeys.length; ++i) {
            JMenu m = this.createMenu(menuKeys[i]);
            if (m == null) continue;
            mb.add(m);
        }
        this.menubar = mb;
        return mb;
    }

    protected JMenu createMenu(String key) {
        String[] itemKeys = this.tokenize(this.getResourceString(key));
        JMenu menu = new JMenu(this.getResourceString(key + labelSuffix));
        for (int i = 0; i < itemKeys.length; ++i) {
            if (itemKeys[i].equals("-")) {
                menu.addSeparator();
                continue;
            }
            JMenuItem mi = this.createMenuItem(itemKeys[i]);
            menu.add(mi);
        }
        return menu;
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem b) {
        return new ActionChangedListener(b);
    }

    static {
        try {
            resources = ResourceBundle.getBundle("resources.Notepad", Locale.getDefault());
        }
        catch (MissingResourceException mre) {
            System.err.println("resources/Notepad.properties not found");
            System.exit(1);
        }
    }

    class FileSaver
    extends Thread {
        Document doc;
        File f;

        FileSaver(File f, Document doc) {
            this.setPriority(4);
            this.f = f;
            this.doc = doc;
        }

        @Override
        public void run() {
            try {
                Notepad.this.status.removeAll();
                JProgressBar progress = new JProgressBar();
                progress.setMinimum(0);
                progress.setMaximum(this.doc.getLength());
                Notepad.this.status.add(progress);
                Notepad.this.status.revalidate();
                FileWriter out = new FileWriter(this.f);
                Segment text = new Segment();
                text.setPartialReturn(true);
                int charsLeft = this.doc.getLength();
                int offset = 0;
                while (charsLeft > 0) {
                    this.doc.getText(offset, Math.min(4096, charsLeft), text);
                    ((Writer)out).write(text.array, text.offset, text.count);
                    charsLeft -= text.count;
                    progress.setValue(offset += text.count);
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        Logger.getLogger(FileSaver.class.getName()).log(Level.SEVERE, null, e);
                    }
                }
                ((Writer)out).flush();
                ((Writer)out).close();
            }
            catch (IOException e) {
                final String msg = e.getMessage();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(Notepad.this.getFrame(), "Could not save file: " + msg, "Error saving file", 0);
                    }
                });
            }
            catch (BadLocationException e) {
                System.err.println(e.getMessage());
            }
            Notepad.this.status.removeAll();
            Notepad.this.status.revalidate();
        }
    }

    class FileLoader
    extends Thread {
        Document doc;
        File f;

        FileLoader(File f, Document doc) {
            this.setPriority(4);
            this.f = f;
            this.doc = doc;
        }

        @Override
        public void run() {
            try {
                int nch;
                Notepad.this.status.removeAll();
                JProgressBar progress = new JProgressBar();
                progress.setMinimum(0);
                progress.setMaximum((int)this.f.length());
                Notepad.this.status.add(progress);
                Notepad.this.status.revalidate();
                FileReader in = new FileReader(this.f);
                char[] buff = new char[4096];
                while ((nch = ((Reader)in).read(buff, 0, buff.length)) != -1) {
                    this.doc.insertString(this.doc.getLength(), new String(buff, 0, nch), null);
                    progress.setValue(progress.getValue() + nch);
                }
            }
            catch (IOException e) {
                final String msg = e.getMessage();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(Notepad.this.getFrame(), "Could not open file: " + msg, "Error opening file", 0);
                    }
                });
            }
            catch (BadLocationException e) {
                System.err.println(e.getMessage());
            }
            this.doc.addUndoableEditListener(Notepad.this.undoHandler);
            Notepad.this.status.removeAll();
            Notepad.this.status.revalidate();
            Notepad.this.resetUndoManager();
            if (Notepad.this.elementTreePanel != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Notepad.this.elementTreePanel.setEditor(Notepad.this.getEditor());
                    }
                });
            }
        }
    }

    class ShowElementTreeAction
    extends AbstractAction {
        ShowElementTreeAction() {
            super(Notepad.showElementTreeAction);
        }

        ShowElementTreeAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Notepad.this.elementTreeFrame == null) {
                try {
                    String title = resources.getString("ElementTreeFrameTitle");
                    Notepad.this.elementTreeFrame = new JFrame(title);
                }
                catch (MissingResourceException mre) {
                    Notepad.this.elementTreeFrame = new JFrame();
                }
                Notepad.this.elementTreeFrame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent weeee) {
                        Notepad.this.elementTreeFrame.setVisible(false);
                    }
                });
                Container fContentPane = Notepad.this.elementTreeFrame.getContentPane();
                fContentPane.setLayout(new BorderLayout());
                Notepad.this.elementTreePanel = new ElementTreePanel(Notepad.this.getEditor());
                fContentPane.add(Notepad.this.elementTreePanel);
                Notepad.this.elementTreeFrame.pack();
            }
            Notepad.this.elementTreeFrame.setVisible(true);
        }
    }

    class ExitAction
    extends AbstractAction {
        ExitAction() {
            super(Notepad.exitAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }

    class NewAction
    extends AbstractAction {
        NewAction() {
            super(Notepad.newAction);
        }

        NewAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Document oldDoc = Notepad.this.getEditor().getDocument();
            if (oldDoc != null) {
                oldDoc.removeUndoableEditListener(Notepad.this.undoHandler);
            }
            Notepad.this.getEditor().setDocument(new PlainDocument());
            Notepad.this.getEditor().getDocument().addUndoableEditListener(Notepad.this.undoHandler);
            Notepad.this.resetUndoManager();
            Notepad.this.getFrame().setTitle(resources.getString("Title"));
            Notepad.this.revalidate();
        }
    }

    class SaveAction
    extends AbstractAction {
        SaveAction() {
            super(Notepad.saveAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            Frame frame = Notepad.this.getFrame();
            int ret = chooser.showSaveDialog(frame);
            if (ret != 0) {
                return;
            }
            File f = chooser.getSelectedFile();
            frame.setTitle(f.getName());
            FileSaver saver = new FileSaver(f, Notepad.this.editor.getDocument());
            saver.start();
        }
    }

    class OpenAction
    extends NewAction {
        OpenAction() {
            super(Notepad.openAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            Frame frame = Notepad.this.getFrame();
            int ret = chooser.showOpenDialog(frame);
            if (ret != 0) {
                return;
            }
            File f = chooser.getSelectedFile();
            if (f.isFile() && f.canRead()) {
                Document oldDoc = Notepad.this.getEditor().getDocument();
                if (oldDoc != null) {
                    oldDoc.removeUndoableEditListener(Notepad.this.undoHandler);
                }
                if (Notepad.this.elementTreePanel != null) {
                    Notepad.this.elementTreePanel.setEditor(null);
                }
                Notepad.this.getEditor().setDocument(new PlainDocument());
                frame.setTitle(f.getName());
                FileLoader loader = new FileLoader(f, Notepad.this.editor.getDocument());
                loader.start();
            } else {
                JOptionPane.showMessageDialog(Notepad.this.getFrame(), "Could not open file: " + f, "Error opening file", 0);
            }
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Notepad.this.undo.redo();
            }
            catch (CannotRedoException ex) {
                Logger.getLogger(RedoAction.class.getName()).log(Level.SEVERE, "Unable to redo", ex);
            }
            this.update();
            Notepad.this.undoAction.update();
        }

        protected void update() {
            if (Notepad.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", Notepad.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Notepad.this.undo.undo();
            }
            catch (CannotUndoException ex) {
                Logger.getLogger(UndoAction.class.getName()).log(Level.SEVERE, "Unable to undo", ex);
            }
            this.update();
            Notepad.this.redoAction.update();
        }

        protected void update() {
            if (Notepad.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", Notepad.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }

    class StatusBar
    extends JComponent {
        public StatusBar() {
            this.setLayout(new BoxLayout(this, 0));
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            Notepad.this.undo.addEdit(e.getEdit());
            Notepad.this.undoAction.update();
            Notepad.this.redoAction.update();
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem mi) {
            this.menuItem = mi;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (e.getPropertyName().equals("Name")) {
                String text = (String)e.getNewValue();
                this.menuItem.setText(text);
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                this.menuItem.setEnabled(enabledState);
            }
        }
    }

    protected static final class AppCloser
    extends WindowAdapter {
        protected AppCloser() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }
}

