/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Arrays;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Utilities;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XMBean;

public class XMBeanInfo
extends JPanel {
    private static final Color lightYellow = new Color(255, 255, 128);
    private final int NAME_COLUMN = 0;
    private final int VALUE_COLUMN = 1;
    private final String[] columnNames = new String[]{Resources.getText("Name", new Object[0]), Resources.getText("Value", new Object[0])};
    private JTable infoTable = new JTable();
    private JTable descTable = new JTable();
    private JPanel infoBorderPanel = new JPanel(new BorderLayout());
    private JPanel descBorderPanel = new JPanel(new BorderLayout());
    private static MBeanInfoTableCellRenderer renderer = new MBeanInfoTableCellRenderer();
    private static TableCellEditor editor = new MBeanInfoTableCellEditor(new JTextField());

    public XMBeanInfo() {
        super(new GridLayout(2, 1));
        this.infoTable.setModel(new ReadOnlyDefaultTableModel());
        this.infoTable.setRowSelectionAllowed(false);
        this.infoTable.setColumnSelectionAllowed(false);
        this.infoTable.getTableHeader().setReorderingAllowed(false);
        ((DefaultTableModel)this.infoTable.getModel()).setColumnIdentifiers(this.columnNames);
        this.infoTable.getColumnModel().getColumn(0).setPreferredWidth(140);
        this.infoTable.getColumnModel().getColumn(0).setMaxWidth(140);
        this.infoTable.getColumnModel().getColumn(0).setCellRenderer(renderer);
        this.infoTable.getColumnModel().getColumn(1).setCellRenderer(renderer);
        this.infoTable.getColumnModel().getColumn(0).setCellEditor(editor);
        this.infoTable.getColumnModel().getColumn(1).setCellEditor(editor);
        this.infoTable.addKeyListener(new Utils.CopyKeyAdapter());
        this.infoTable.setAutoResizeMode(2);
        JScrollPane infoTableScrollPane = new JScrollPane(this.infoTable);
        this.infoBorderPanel.setBorder(BorderFactory.createTitledBorder("MBeanInfoPlaceHolder"));
        this.infoBorderPanel.add(infoTableScrollPane);
        this.descTable.setModel(new ReadOnlyDefaultTableModel());
        this.descTable.setRowSelectionAllowed(false);
        this.descTable.setColumnSelectionAllowed(false);
        this.descTable.getTableHeader().setReorderingAllowed(false);
        ((DefaultTableModel)this.descTable.getModel()).setColumnIdentifiers(this.columnNames);
        this.descTable.getColumnModel().getColumn(0).setPreferredWidth(140);
        this.descTable.getColumnModel().getColumn(0).setMaxWidth(140);
        this.descTable.getColumnModel().getColumn(0).setCellRenderer(renderer);
        this.descTable.getColumnModel().getColumn(1).setCellRenderer(renderer);
        this.descTable.getColumnModel().getColumn(0).setCellEditor(editor);
        this.descTable.getColumnModel().getColumn(1).setCellEditor(editor);
        this.descTable.addKeyListener(new Utils.CopyKeyAdapter());
        this.descTable.setAutoResizeMode(2);
        JScrollPane descTableScrollPane = new JScrollPane(this.descTable);
        this.descBorderPanel.setBorder(BorderFactory.createTitledBorder(Resources.getText("Descriptor", new Object[0])));
        this.descBorderPanel.add(descTableScrollPane);
        this.add(this.infoBorderPanel);
        this.add(this.descBorderPanel);
    }

    public void emptyInfoTable() {
        DefaultTableModel tableModel = (DefaultTableModel)this.infoTable.getModel();
        while (tableModel.getRowCount() > 0) {
            tableModel.removeRow(0);
        }
    }

    public void emptyDescTable() {
        DefaultTableModel tableModel = (DefaultTableModel)this.descTable.getModel();
        while (tableModel.getRowCount() > 0) {
            tableModel.removeRow(0);
        }
    }

    private void addDescriptor(Descriptor desc, String text) {
        if (desc != null && desc.getFieldNames().length > 0) {
            DefaultTableModel tableModel = (DefaultTableModel)this.descTable.getModel();
            Object[] rowData = new Object[]{new TableRowDivider(text), new TableRowDivider("")};
            tableModel.addRow(rowData);
            for (String fieldName : desc.getFieldNames()) {
                rowData[0] = fieldName;
                Object fieldValue = desc.getFieldValue(fieldName);
                rowData[1] = fieldValue instanceof boolean[] ? Arrays.toString((boolean[])fieldValue) : (fieldValue instanceof byte[] ? Arrays.toString((byte[])fieldValue) : (fieldValue instanceof char[] ? Arrays.toString((char[])fieldValue) : (fieldValue instanceof double[] ? Arrays.toString((double[])fieldValue) : (fieldValue instanceof float[] ? Arrays.toString((float[])fieldValue) : (fieldValue instanceof int[] ? Arrays.toString((int[])fieldValue) : (fieldValue instanceof long[] ? Arrays.toString((long[])fieldValue) : (fieldValue instanceof short[] ? Arrays.toString((short[])fieldValue) : (fieldValue instanceof Object[] ? Arrays.toString((Object[])fieldValue) : fieldValue))))))));
                tableModel.addRow(rowData);
            }
            tableModel.newDataAvailable(new TableModelEvent(tableModel));
        }
    }

    public void addMBeanInfo(XMBean mbean, MBeanInfo mbeanInfo) {
        this.emptyInfoTable();
        this.emptyDescTable();
        ((TitledBorder)this.infoBorderPanel.getBorder()).setTitle(Resources.getText("MBeanInfo", new Object[0]));
        String text = Resources.getText("Info", new Object[0]) + ":";
        DefaultTableModel tableModel = (DefaultTableModel)this.infoTable.getModel();
        Object[] rowData = new Object[]{new TableRowDivider(text), new TableRowDivider("")};
        tableModel.addRow(rowData);
        rowData[0] = Resources.getText("ObjectName", new Object[0]);
        rowData[1] = mbean.getObjectName();
        tableModel.addRow(rowData);
        rowData[0] = Resources.getText("ClassName", new Object[0]);
        rowData[1] = mbeanInfo.getClassName();
        tableModel.addRow(rowData);
        rowData[0] = Resources.getText("Description", new Object[0]);
        rowData[1] = mbeanInfo.getDescription();
        tableModel.addRow(rowData);
        this.addDescriptor(mbeanInfo.getDescriptor(), text);
        int i = 0;
        for (MBeanConstructorInfo mbci : mbeanInfo.getConstructors()) {
            this.addMBeanConstructorInfo(mbci, Resources.getText("Constructor", new Object[0]) + "-" + i + ":");
            int j = 0;
            for (MBeanParameterInfo mbpi : mbci.getSignature()) {
                this.addMBeanParameterInfo(mbpi, Resources.getText("Parameter", new Object[0]) + "-" + i + "-" + j + ":");
                ++j;
            }
            ++i;
        }
        tableModel.newDataAvailable(new TableModelEvent(tableModel));
    }

    public void addMBeanAttributeInfo(MBeanAttributeInfo mbai) {
        this.emptyInfoTable();
        this.emptyDescTable();
        ((TitledBorder)this.infoBorderPanel.getBorder()).setTitle(Resources.getText("MBeanAttributeInfo", new Object[0]));
        String text = Resources.getText("Attribute", new Object[0]) + ":";
        DefaultTableModel tableModel = (DefaultTableModel)this.infoTable.getModel();
        Object[] rowData = new Object[]{new TableRowDivider(text), new TableRowDivider("")};
        tableModel.addRow(rowData);
        rowData[0] = Resources.getText("Name", new Object[0]);
        rowData[1] = mbai.getName();
        tableModel.addRow(rowData);
        rowData[0] = Resources.getText("Description", new Object[0]);
        rowData[1] = mbai.getDescription();
        tableModel.addRow(rowData);
        rowData[0] = Resources.getText("Readable", new Object[0]);
        rowData[1] = mbai.isReadable();
        tableModel.addRow(rowData);
        rowData[0] = Resources.getText("Writable", new Object[0]);
        rowData[1] = mbai.isWritable();
        tableModel.addRow(rowData);
        rowData[0] = Resources.getText("Is", new Object[0]);
        rowData[1] = mbai.isIs();
        tableModel.addRow(rowData);
        rowData[0] = Resources.getText("Type", new Object[0]);
        rowData[1] = mbai.getType();
        tableModel.addRow(rowData);
        this.addDescriptor(mbai.getDescriptor(), text);
        tableModel.newDataAvailable(new TableModelEvent(tableModel));
    }

    public void addMBeanOperationInfo(MBeanOperationInfo mboi) {
        this.emptyInfoTable();
        this.emptyDescTable();
        ((TitledBorder)this.infoBorderPanel.getBorder()).setTitle(Resources.getText("MBeanOperationInfo", new Object[0]));
        String text = Resources.getText("Operation", new Object[0]) + ":";
        DefaultTableModel tableModel = (DefaultTableModel)this.infoTable.getModel();
        Object[] rowData = new Object[]{new TableRowDivider(text), new TableRowDivider("")};
        tableModel.addRow(rowData);
        rowData[0] = Resources.getText("Name", new Object[0]);
        rowData[1] = mboi.getName();
        tableModel.addRow(rowData);
        rowData[0] = Resources.getText("Description", new Object[0]);
        rowData[1] = mboi.getDescription();
        tableModel.addRow(rowData);
        rowData[0] = Resources.getText("Impact", new Object[0]);
        switch (mboi.getImpact()) {
            case 0: {
                rowData[1] = Resources.getText("INFO", new Object[0]);
                break;
            }
            case 1: {
                rowData[1] = Resources.getText("ACTION", new Object[0]);
                break;
            }
            case 2: {
                rowData[1] = Resources.getText("ACTION_INFO", new Object[0]);
                break;
            }
            case 3: {
                rowData[1] = Resources.getText("UNKNOWN", new Object[0]);
            }
        }
        tableModel.addRow(rowData);
        rowData[0] = Resources.getText("ReturnType", new Object[0]);
        rowData[1] = mboi.getReturnType();
        tableModel.addRow(rowData);
        this.addDescriptor(mboi.getDescriptor(), text);
        int i = 0;
        for (MBeanParameterInfo mbpi : mboi.getSignature()) {
            this.addMBeanParameterInfo(mbpi, Resources.getText("Parameter", new Object[0]) + "-" + i++ + ":");
        }
        tableModel.newDataAvailable(new TableModelEvent(tableModel));
    }

    public void addMBeanNotificationInfo(MBeanNotificationInfo mbni) {
        this.emptyInfoTable();
        this.emptyDescTable();
        ((TitledBorder)this.infoBorderPanel.getBorder()).setTitle(Resources.getText("MBeanNotificationInfo", new Object[0]));
        String text = Resources.getText("Notification", new Object[0]) + ":";
        DefaultTableModel tableModel = (DefaultTableModel)this.infoTable.getModel();
        Object[] rowData = new Object[]{new TableRowDivider(text), new TableRowDivider("")};
        tableModel.addRow(rowData);
        rowData[0] = Resources.getText("Name", new Object[0]);
        rowData[1] = mbni.getName();
        tableModel.addRow(rowData);
        rowData[0] = Resources.getText("Description", new Object[0]);
        rowData[1] = mbni.getDescription();
        tableModel.addRow(rowData);
        rowData[0] = Resources.getText("NotifTypes", new Object[0]);
        rowData[1] = Arrays.toString(mbni.getNotifTypes());
        tableModel.addRow(rowData);
        this.addDescriptor(mbni.getDescriptor(), text);
        tableModel.newDataAvailable(new TableModelEvent(tableModel));
    }

    private void addMBeanConstructorInfo(MBeanConstructorInfo mbci, String text) {
        DefaultTableModel tableModel = (DefaultTableModel)this.infoTable.getModel();
        Object[] rowData = new Object[]{new TableRowDivider(text), new TableRowDivider("")};
        tableModel.addRow(rowData);
        rowData[0] = Resources.getText("Name", new Object[0]);
        rowData[1] = mbci.getName();
        tableModel.addRow(rowData);
        rowData[0] = Resources.getText("Description", new Object[0]);
        rowData[1] = mbci.getDescription();
        tableModel.addRow(rowData);
        this.addDescriptor(mbci.getDescriptor(), text);
        tableModel.newDataAvailable(new TableModelEvent(tableModel));
    }

    private void addMBeanParameterInfo(MBeanParameterInfo mbpi, String text) {
        DefaultTableModel tableModel = (DefaultTableModel)this.infoTable.getModel();
        Object[] rowData = new Object[]{new TableRowDivider(text), new TableRowDivider("")};
        tableModel.addRow(rowData);
        rowData[0] = Resources.getText("Name", new Object[0]);
        rowData[1] = mbpi.getName();
        tableModel.addRow(rowData);
        rowData[0] = Resources.getText("Description", new Object[0]);
        rowData[1] = mbpi.getDescription();
        tableModel.addRow(rowData);
        rowData[0] = Resources.getText("Type", new Object[0]);
        rowData[1] = mbpi.getType();
        tableModel.addRow(rowData);
        this.addDescriptor(mbpi.getDescriptor(), text);
        tableModel.newDataAvailable(new TableModelEvent(tableModel));
    }

    private static class MBeanInfoTableCellEditor
    extends Utils.ReadOnlyTableCellEditor {
        public MBeanInfoTableCellEditor(JTextField tf) {
            super(tf);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component comp = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (value instanceof TableRowDivider) {
                JLabel label = new JLabel(value.toString());
                label.setBackground(Utilities.ensureContrast(lightYellow, label.getForeground()));
                label.setOpaque(true);
                return label;
            }
            return comp;
        }
    }

    private static class MBeanInfoTableCellRenderer
    extends DefaultTableCellRenderer {
        private MBeanInfoTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof TableRowDivider) {
                JLabel label = new JLabel(value.toString());
                label.setBackground(Utilities.ensureContrast(lightYellow, label.getForeground()));
                label.setOpaque(true);
                return label;
            }
            return comp;
        }
    }

    private static class TableRowDivider {
        private String tableRowDividerText;

        public TableRowDivider(String tableRowDividerText) {
            this.tableRowDividerText = tableRowDividerText;
        }

        public String toString() {
            return this.tableRowDividerText;
        }
    }

    private static class ReadOnlyDefaultTableModel
    extends DefaultTableModel {
        private ReadOnlyDefaultTableModel() {
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }
    }
}

