/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import com.sun.tools.jconsole.JConsoleContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import sun.tools.jconsole.Formatter;
import sun.tools.jconsole.PlotterPanel;
import sun.tools.jconsole.Resources;

public class Plotter
extends JComponent
implements Accessible,
ActionListener,
PropertyChangeListener {
    static final String[] rangeNames = new String[]{Resources.getText(" 1 min", new Object[0]), Resources.getText(" 5 min", new Object[0]), Resources.getText("10 min", new Object[0]), Resources.getText("30 min", new Object[0]), Resources.getText(" 1 hour", new Object[0]), Resources.getText(" 2 hours", new Object[0]), Resources.getText(" 3 hours", new Object[0]), Resources.getText(" 6 hours", new Object[0]), Resources.getText("12 hours", new Object[0]), Resources.getText(" 1 day", new Object[0]), Resources.getText(" 7 days", new Object[0]), Resources.getText(" 1 month", new Object[0]), Resources.getText(" 3 months", new Object[0]), Resources.getText(" 6 months", new Object[0]), Resources.getText(" 1 year", new Object[0]), Resources.getText("All", new Object[0])};
    static final int[] rangeValues = new int[]{1, 5, 10, 30, 60, 120, 180, 360, 720, 1440, 10080, 44640, 133920, 267840, 527040, -1};
    static final long SECOND = 1000L;
    static final long MINUTE = 60000L;
    static final long HOUR = 3600000L;
    static final long DAY = 86400000L;
    static final Color bgColor = new Color(250, 250, 250);
    static final Color defaultColor = Color.blue.darker();
    static final int ARRAY_SIZE_INCREMENT = 4000;
    private static Stroke dashedStroke;
    private TimeStamps times = new TimeStamps();
    private ArrayList<Sequence> seqs = new ArrayList();
    private JPopupMenu popupMenu;
    private JMenu timeRangeMenu;
    private JRadioButtonMenuItem[] menuRBs;
    private JMenuItem saveAsMI;
    private JFileChooser saveFC;
    private int viewRange = -1;
    private Unit unit;
    private int decimals;
    private double decimalsMultiplier;
    private Border border = null;
    private Rectangle r = new Rectangle(1, 1, 1, 1);
    private Font smallFont = null;
    private int topMargin = 10;
    private int bottomMargin = 45;
    private int leftMargin = 65;
    private int rightMargin = 70;
    private final boolean displayLegend;

    public Plotter() {
        this(Unit.NONE, 0);
    }

    public Plotter(Unit unit) {
        this(unit, 0);
    }

    public Plotter(Unit unit, int decimals) {
        this(unit, decimals, true);
    }

    public Plotter(Unit unit, int decimals, boolean displayLegend) {
        this.displayLegend = displayLegend;
        this.setUnit(unit);
        this.setDecimals(decimals);
        this.enableEvents(16L);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (Plotter.this.getParent() instanceof PlotterPanel) {
                    Plotter.this.getParent().requestFocusInWindow();
                }
            }
        });
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public void setDecimals(int decimals) {
        this.decimals = decimals;
        this.decimalsMultiplier = Math.pow(10.0, decimals);
    }

    public void createSequence(String key, String name, Color color, boolean isPlotted) {
        Sequence seq = this.getSequence(key);
        if (seq == null) {
            seq = new Sequence(key);
        }
        seq.name = name;
        seq.color = color != null ? color : defaultColor;
        seq.isPlotted = isPlotted;
        this.seqs.add(seq);
    }

    public void setUseDashedTransitions(String key, boolean b) {
        Sequence seq = this.getSequence(key);
        if (seq != null) {
            seq.transitionStroke = b ? Plotter.getDashedStroke() : null;
        }
    }

    public void setIsPlotted(String key, boolean isPlotted) {
        Sequence seq = this.getSequence(key);
        if (seq != null) {
            seq.isPlotted = isPlotted;
        }
    }

    public synchronized void addValues(long time, long ... values) {
        assert (values.length == this.seqs.size());
        this.times.add(time);
        for (int i = 0; i < values.length; ++i) {
            this.seqs.get(i).add(values[i]);
        }
        this.repaint();
    }

    private Sequence getSequence(String key) {
        for (Sequence seq : this.seqs) {
            if (!seq.key.equals(key)) continue;
            return seq;
        }
        return null;
    }

    public int getViewRange() {
        return this.viewRange;
    }

    public void setViewRange(int minutes) {
        if (minutes != this.viewRange) {
            int oldValue = this.viewRange;
            this.viewRange = minutes;
            this.firePropertyChange("viewRange", oldValue, this.viewRange);
            if (this.popupMenu != null) {
                for (int i = 0; i < this.menuRBs.length; ++i) {
                    if (rangeValues[i] != this.viewRange) continue;
                    this.menuRBs[i].setSelected(true);
                    break;
                }
            }
            this.repaint();
        }
    }

    @Override
    public JPopupMenu getComponentPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu(Resources.getText("Chart:", new Object[0]));
            this.timeRangeMenu = new JMenu(Resources.getText("Plotter.timeRangeMenu", new Object[0]));
            this.timeRangeMenu.setMnemonic(Resources.getMnemonicInt("Plotter.timeRangeMenu"));
            this.popupMenu.add(this.timeRangeMenu);
            this.menuRBs = new JRadioButtonMenuItem[rangeNames.length];
            ButtonGroup rbGroup = new ButtonGroup();
            for (int i = 0; i < rangeNames.length; ++i) {
                this.menuRBs[i] = new JRadioButtonMenuItem(rangeNames[i]);
                rbGroup.add(this.menuRBs[i]);
                this.menuRBs[i].addActionListener(this);
                if (this.viewRange == rangeValues[i]) {
                    this.menuRBs[i].setSelected(true);
                }
                this.timeRangeMenu.add(this.menuRBs[i]);
            }
            this.popupMenu.addSeparator();
            this.saveAsMI = new JMenuItem(Resources.getText("Plotter.saveAsMenuItem", new Object[0]));
            this.saveAsMI.setMnemonic(Resources.getMnemonicInt("Plotter.saveAsMenuItem"));
            this.saveAsMI.addActionListener(this);
            this.popupMenu.add(this.saveAsMI);
        }
        return this.popupMenu;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        JComponent src = (JComponent)ev.getSource();
        if (src == this.saveAsMI) {
            this.saveAs();
        } else {
            int index = this.timeRangeMenu.getPopupMenu().getComponentIndex(src);
            this.setViewRange(rangeValues[index]);
        }
    }

    private void saveAs() {
        int ret;
        if (this.saveFC == null) {
            this.saveFC = new SaveDataFileChooser();
        }
        if ((ret = this.saveFC.showSaveDialog(this)) == 0) {
            this.saveDataToFile(this.saveFC.getSelectedFile());
        }
    }

    private void saveDataToFile(File file) {
        try {
            PrintStream out = new PrintStream(new FileOutputStream(file));
            out.print("Time");
            for (Sequence seq : this.seqs) {
                out.print("," + seq.name);
            }
            out.println();
            if (this.seqs.size() > 0 && this.seqs.get((int)0).size > 0) {
                for (int i = 0; i < this.seqs.get((int)0).size; ++i) {
                    double excelTime = Formatter.toExcelTime(this.times.time(i));
                    out.print(String.format(Locale.ENGLISH, "%.6f", excelTime));
                    for (Sequence seq : this.seqs) {
                        out.print("," + this.getFormattedValue(seq.value(i), false));
                    }
                    out.println();
                }
            }
            out.close();
            JOptionPane.showMessageDialog(this, Resources.getText("FileChooser.savedFile", file.getAbsolutePath(), file.length()));
        }
        catch (IOException ex) {
            String msg = ex.getLocalizedMessage();
            String path = file.getAbsolutePath();
            if (msg.startsWith(path)) {
                msg = msg.substring(path.length()).trim();
            }
            JOptionPane.showMessageDialog(this, Resources.getText("FileChooser.saveFailed.message", path, msg), Resources.getText("FileChooser.saveFailed.title", new Object[0]), 0);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int i;
        int pointsPerPixel;
        super.paintComponent(g);
        Color oldColor = g.getColor();
        Font oldFont = g.getFont();
        Color fg = this.getForeground();
        Color bg = this.getBackground();
        boolean bgIsLight = bg.getRed() > 200 && bg.getGreen() > 200 && bg.getBlue() > 200;
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.smallFont == null) {
            this.smallFont = oldFont.deriveFont(9.0f);
        }
        this.r.x = this.leftMargin - 5;
        this.r.y = this.topMargin - 8;
        this.r.width = this.getWidth() - this.leftMargin - this.rightMargin;
        this.r.height = this.getHeight() - this.topMargin - this.bottomMargin + 16;
        if (this.border == null) {
            this.border = new BevelBorder(1, this.getBackground().brighter().brighter(), this.getBackground().brighter(), this.getBackground().darker().darker(), this.getBackground().darker());
        }
        this.border.paintBorder(this, g, this.r.x, this.r.y, this.r.width, this.r.height);
        g.setColor(bgColor);
        g.fillRect(this.r.x + 2, this.r.y + 2, this.r.width - 4, this.r.height - 4);
        g.setColor(oldColor);
        long tMin = Long.MAX_VALUE;
        long tMax = Long.MIN_VALUE;
        long vMin = Long.MAX_VALUE;
        long vMax = 1L;
        int w = this.getWidth() - this.rightMargin - this.leftMargin - 10;
        int h = this.getHeight() - this.topMargin - this.bottomMargin;
        if (this.times.size > 1) {
            tMin = Math.min(tMin, this.times.time(0));
            tMax = Math.max(tMax, this.times.time(this.times.size - 1));
        }
        long viewRangeMS = this.viewRange > 0 ? (long)this.viewRange * 60000L : Math.max(tMax - tMin, 60000L);
        for (Sequence seq : this.seqs) {
            if (seq.size > 0) {
                for (int i2 = 0; i2 < seq.size; ++i2) {
                    long val;
                    if (seq.size != 1 && this.times.time(i2) < tMax - viewRangeMS || (val = seq.value(i2)) <= Long.MIN_VALUE) continue;
                    vMax = Math.max(vMax, val);
                    vMin = Math.min(vMin, val);
                }
            } else {
                vMin = 0L;
            }
            if (this.unit != Unit.BYTES && seq.isPlotted) continue;
            break;
        }
        vMax = this.normalizeMax(vMax);
        if (vMin > 0L) {
            vMin = vMax / vMin > 4L ? 0L : this.normalizeMin(vMin);
        }
        g.setColor(fg);
        int x = this.leftMargin - 18;
        int y = this.topMargin;
        FontMetrics fm = g.getFontMetrics();
        g.drawLine(x, y, x, y + h);
        int n = 5;
        if (("" + vMax).startsWith("2")) {
            n = 4;
        } else if (("" + vMax).startsWith("3")) {
            n = 6;
        } else if (("" + vMax).startsWith("4")) {
            n = 4;
        } else if (("" + vMax).startsWith("6")) {
            n = 6;
        } else if (("" + vMax).startsWith("7")) {
            n = 7;
        } else if (("" + vMax).startsWith("8")) {
            n = 8;
        } else if (("" + vMax).startsWith("9")) {
            n = 3;
        }
        ArrayList<Long> tickValues = new ArrayList<Long>();
        tickValues.add(vMin);
        for (int i3 = 0; i3 < n; ++i3) {
            long v = (long)i3 * vMax / (long)n;
            if (v <= vMin) continue;
            tickValues.add(v);
        }
        tickValues.add(vMax);
        n = tickValues.size();
        String[] tickStrings = new String[n];
        for (int i4 = 0; i4 < n; ++i4) {
            long v = (Long)tickValues.get(i4);
            tickStrings[i4] = this.getSizeString(v, vMax);
        }
        if (this.decimals > 0) {
            boolean trimLast = true;
            boolean removedDecimalPoint = false;
            do {
                for (String str : tickStrings) {
                    if (str.endsWith("0") || str.endsWith(".")) continue;
                    trimLast = false;
                    break;
                }
                if (!trimLast) continue;
                if (tickStrings[0].endsWith(".")) {
                    removedDecimalPoint = true;
                }
                for (int i5 = 0; i5 < n; ++i5) {
                    String str = tickStrings[i5];
                    tickStrings[i5] = str.substring(0, str.length() - 1);
                }
            } while (trimLast && !removedDecimalPoint);
        }
        int lastY = Integer.MAX_VALUE;
        for (int i6 = 0; i6 < n; ++i6) {
            long v = (Long)tickValues.get(i6);
            y = this.topMargin + h - (int)((long)h * (v - vMin) / (vMax - vMin));
            g.drawLine(x - 2, y, x + 2, y);
            String s = tickStrings[i6];
            if (this.unit == Unit.PERCENT) {
                s = s + "%";
            }
            int sx = x - 6 - fm.stringWidth(s);
            if (y < lastY - 13) {
                if (this.checkLeftMargin(sx)) {
                    return;
                }
                g.drawString(s, sx, y + 4);
            }
            g.setColor(Color.lightGray);
            g.drawLine(this.r.x + 4, y, this.r.x + this.r.width - 4, y);
            g.setColor(fg);
            lastY = y;
        }
        x = this.leftMargin;
        y = this.topMargin + h + 15;
        g.drawLine(x, y, x + w, y);
        long t1 = tMax;
        if (t1 <= 0L) {
            t1 = System.currentTimeMillis();
        }
        long tz = Formatter.timeDF.getTimeZone().getOffset(t1);
        long tickInterval = this.calculateTickInterval(w, 40, viewRangeMS);
        if (tickInterval > 10800000L) {
            tickInterval = this.calculateTickInterval(w, 80, viewRangeMS);
        }
        for (long t0 = tickInterval - (t1 - viewRangeMS + tz) % tickInterval; t0 < viewRangeMS; t0 += tickInterval) {
            x = this.leftMargin + (int)((long)w * t0 / viewRangeMS);
            g.drawLine(x, y - 2, x, y + 2);
            long t = t1 - viewRangeMS + t0;
            String str = Formatter.formatClockTime(t);
            g.drawString(str, x, y + 16);
            if ((t + tz) % 86400000L == 0L) {
                str = Formatter.formatDate(t);
                g.drawString(str, x, y + 27);
            }
            g.setColor(Color.lightGray);
            g.drawLine(x, this.topMargin, x, this.topMargin + h);
            g.setColor(fg);
        }
        int start = 0;
        int nValues = 0;
        int nLists = this.seqs.size();
        if (nLists > 0) {
            nValues = this.seqs.get((int)0).size;
        }
        if (nValues == 0) {
            g.setColor(oldColor);
            return;
        }
        Sequence seq = this.seqs.get(0);
        for (int p = 0; p < seq.size; ++p) {
            if (this.times.time(p) < tMax - viewRangeMS) continue;
            start = p;
            break;
        }
        if ((pointsPerPixel = (nValues - start) / w) < 4) {
            pointsPerPixel = 1;
        }
        for (int i7 = nLists - 1; i7 >= 0; --i7) {
            int x0 = this.leftMargin;
            int y0 = this.topMargin + h + 1;
            Sequence seq2 = this.seqs.get(i7);
            if (!seq2.isPlotted || seq2.size <= 0) continue;
            for (int pass = 0; pass < 2; ++pass) {
                g.setColor(pass == 0 ? Color.white : seq2.color);
                int x1 = -1;
                long v1 = -1L;
                for (int p = start; p < nValues; p += pointsPerPixel) {
                    if (pointsPerPixel > 1 && p >= nValues - pointsPerPixel) {
                        p = nValues - 1;
                    }
                    int x2 = (int)((long)w * (this.times.time(p) - (t1 - viewRangeMS)) / viewRangeMS);
                    long v2 = seq2.value(p);
                    if (v2 >= vMin && v2 <= vMax) {
                        int y2 = (int)((long)h * (v2 - vMin) / (vMax - vMin));
                        if (x1 >= 0 && v1 >= vMin && v1 <= vMax) {
                            int y1 = (int)((long)h * (v1 - vMin) / (vMax - vMin));
                            if (y1 == y2) {
                                g.fillRect(x0 + x1, y0 - y1 - pass, x2 - x1, 1);
                            } else {
                                Graphics2D g2d = (Graphics2D)g;
                                Stroke oldStroke = null;
                                if (seq2.transitionStroke != null) {
                                    oldStroke = g2d.getStroke();
                                    g2d.setStroke(seq2.transitionStroke);
                                }
                                g.drawLine(x0 + x1, y0 - y1 - pass, x0 + x2, y0 - y2 - pass);
                                if (oldStroke != null) {
                                    g2d.setStroke(oldStroke);
                                }
                            }
                        }
                    }
                    x1 = x2;
                    v1 = v2;
                }
            }
            long v = seq2.value(seq2.size - 1);
            if (v >= vMin && v <= vMax) {
                if (bgIsLight) {
                    g.setColor(seq2.color);
                } else {
                    g.setColor(fg);
                }
                x = this.r.x + this.r.width + 2;
                y = this.topMargin + h - (int)((long)h * (v - vMin) / (vMax - vMin));
                g.fillPolygon(new int[]{x + 2, x + 6, x + 6}, new int[]{y, y + 3, y - 3}, 3);
            }
            g.setColor(fg);
        }
        int[] valueStringSlots = new int[nLists];
        for (i = 0; i < nLists; ++i) {
            valueStringSlots[i] = -1;
        }
        for (i = 0; i < nLists; ++i) {
            Sequence seq3 = this.seqs.get(i);
            if (!seq3.isPlotted || seq3.size <= 0) continue;
            long v = seq3.value(seq3.size - 1);
            if (v >= vMin && v <= vMax) {
                x = this.r.x + this.r.width + 2;
                y = this.topMargin + h - (int)((long)h * (v - vMin) / (vMax - vMin));
                int y2 = this.getValueStringSlot(valueStringSlots, y, 20, i);
                g.setFont(this.smallFont);
                if (bgIsLight) {
                    g.setColor(seq3.color);
                } else {
                    g.setColor(fg);
                }
                String curValue = this.getFormattedValue(v, true);
                if (this.unit == Unit.PERCENT) {
                    curValue = curValue + "%";
                }
                int valWidth = fm.stringWidth(curValue);
                String legend = this.displayLegend ? seq3.name : "";
                int legendWidth = fm.stringWidth(legend);
                if (this.checkRightMargin(valWidth) || this.checkRightMargin(legendWidth)) {
                    return;
                }
                g.drawString(legend, x + 17, Math.min(this.topMargin + h, y2 + 3 - 10));
                g.drawString(curValue, x + 17, Math.min(this.topMargin + h + 10, y2 + 3));
                if (y2 > y + 3) {
                    g.drawLine(x + 9, y + 2, x + 14, y2);
                } else if (y2 < y - 3) {
                    g.drawLine(x + 9, y - 2, x + 14, y2);
                }
            }
            g.setFont(oldFont);
            g.setColor(fg);
        }
        g.setColor(oldColor);
    }

    private boolean checkLeftMargin(int x) {
        if (x < 2) {
            this.leftMargin += 2 - x;
            SwingUtilities.getWindowAncestor(this).repaint();
            return true;
        }
        return false;
    }

    private boolean checkRightMargin(int w) {
        if (w + 2 > this.rightMargin) {
            this.rightMargin = w + 2;
            SwingUtilities.getWindowAncestor(this).repaint();
            return true;
        }
        return false;
    }

    private int getValueStringSlot(int[] slots, int y, int h, int i) {
        for (int s = 0; s < slots.length; ++s) {
            if (slots[s] >= y && slots[s] < y + h) {
                if (slots[s] > h) {
                    return this.getValueStringSlot(slots, slots[s] - h, h, i);
                }
                return this.getValueStringSlot(slots, slots[s] + h, h, i);
            }
            if (y < h || slots[s] <= y - h || slots[s] >= y) continue;
            return this.getValueStringSlot(slots, slots[s] + h, h, i);
        }
        slots[i] = y;
        return y;
    }

    private long calculateTickInterval(int w, int hGap, long viewRangeMS) {
        long tickInterval = viewRangeMS * (long)hGap / (long)w;
        tickInterval = tickInterval < 60000L ? 60000L : (tickInterval < 300000L ? 300000L : (tickInterval < 600000L ? 600000L : (tickInterval < 1800000L ? 1800000L : (tickInterval < 3600000L ? 3600000L : (tickInterval < 10800000L ? 10800000L : (tickInterval < 21600000L ? 21600000L : (tickInterval < 43200000L ? 43200000L : (tickInterval < 86400000L ? 86400000L : this.normalizeMax(tickInterval / 86400000L) * 86400000L))))))));
        return tickInterval;
    }

    private long normalizeMin(long l) {
        int exp = (int)Math.log10(l);
        long multiple = (long)Math.pow(10.0, exp);
        int i = (int)(l / multiple);
        return (long)i * multiple;
    }

    private long normalizeMax(long l) {
        int exp = (int)Math.log10(l);
        long multiple = (long)Math.pow(10.0, exp);
        int i = (int)(l / multiple);
        l = (long)(i + 1) * multiple;
        return l;
    }

    private String getFormattedValue(long v, boolean groupDigits) {
        String str;
        String fmt = "%";
        if (groupDigits) {
            fmt = fmt + ",";
        }
        if (this.decimals > 0) {
            fmt = fmt + "." + this.decimals + "f";
            str = String.format(fmt, (double)v / this.decimalsMultiplier);
        } else {
            fmt = fmt + "d";
            str = String.format(fmt, v);
        }
        return str;
    }

    private String getSizeString(long v, long vMax) {
        String s = this.unit == Unit.BYTES && this.decimals == 0 ? Formatter.formatBytes(v, vMax) : this.getFormattedValue(v, true);
        return s;
    }

    private static synchronized Stroke getDashedStroke() {
        if (dashedStroke == null) {
            dashedStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{2.0f, 3.0f}, 0.0f);
        }
        return dashedStroke;
    }

    private static Object extendArray(Object a1) {
        int n = Array.getLength(a1);
        Object a2 = Array.newInstance(a1.getClass().getComponentType(), n + 4000);
        System.arraycopy(a1, 0, a2, 0, n);
        return a2;
    }

    long getValue() {
        return 0L;
    }

    long getLastTimeStamp() {
        return this.times.time(this.times.size - 1);
    }

    long getLastValue(String key) {
        Sequence seq = this.getSequence(key);
        return seq != null && seq.size > 0 ? seq.value(seq.size - 1) : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        String prop = ev.getPropertyName();
        if (prop == "connectionState") {
            JConsoleContext.ConnectionState newState = (JConsoleContext.ConnectionState)((Object)ev.getNewValue());
            switch (newState) {
                case DISCONNECTED: {
                    Plotter plotter = this;
                    synchronized (plotter) {
                        long time = System.currentTimeMillis();
                        this.times.add(time);
                        for (Sequence seq : this.seqs) {
                            seq.add(Long.MIN_VALUE);
                        }
                        break;
                    }
                }
            }
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessiblePlotter();
        }
        return this.accessibleContext;
    }

    protected class AccessiblePlotter
    extends JComponent.AccessibleJComponent {
        private static final long serialVersionUID = -3847205410473510922L;

        protected AccessiblePlotter() {
            super(Plotter.this);
            this.setAccessibleName(Resources.getText("Plotter.accessibleName", new Object[0]));
        }

        @Override
        public String getAccessibleName() {
            String name = super.getAccessibleName();
            if (Plotter.this.seqs.size() > 0 && ((Sequence)((Plotter)Plotter.this).seqs.get((int)0)).size > 0) {
                String keyValueList = "";
                for (Sequence seq : Plotter.this.seqs) {
                    if (!seq.isPlotted) continue;
                    String value = "null";
                    if (seq.size > 0) {
                        value = Plotter.this.unit == Unit.BYTES ? Resources.getText("Size Bytes", seq.value(seq.size - 1)) : Plotter.this.getFormattedValue(seq.value(seq.size - 1), false) + (Plotter.this.unit == Unit.PERCENT ? "%" : "");
                    }
                    keyValueList = keyValueList + Resources.getText("Plotter.accessibleName.keyAndValue", seq.key, value);
                }
                name = name + "\n" + keyValueList + ".";
            } else {
                name = name + "\n" + Resources.getText("Plotter.accessibleName.noData", new Object[0]);
            }
            return name;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.CANVAS;
        }
    }

    private static class SaveDataFileChooser
    extends JFileChooser {
        private static final long serialVersionUID = -5182890922369369669L;

        SaveDataFileChooser() {
            this.setFileFilter(new FileNameExtensionFilter("CSV file", "csv"));
        }

        @Override
        public void approveSelection() {
            File file = this.getSelectedFile();
            if (file != null) {
                FileFilter filter = this.getFileFilter();
                if (filter != null && filter instanceof FileNameExtensionFilter) {
                    String[] extensions = ((FileNameExtensionFilter)filter).getExtensions();
                    boolean goodExt = false;
                    for (String ext : extensions) {
                        if (!file.getName().toLowerCase().endsWith("." + ext.toLowerCase())) continue;
                        goodExt = true;
                        break;
                    }
                    if (!goodExt) {
                        file = new File(file.getParent(), file.getName() + "." + extensions[0]);
                    }
                }
                if (file.exists()) {
                    String okStr = Resources.getText("FileChooser.fileExists.okOption", new Object[0]);
                    String cancelStr = Resources.getText("FileChooser.fileExists.cancelOption", new Object[0]);
                    int ret = JOptionPane.showOptionDialog(this, Resources.getText("FileChooser.fileExists.message", file.getName()), Resources.getText("FileChooser.fileExists.title", new Object[0]), 2, 2, null, new Object[]{okStr, cancelStr}, okStr);
                    if (ret != 0) {
                        return;
                    }
                }
                this.setSelectedFile(file);
            }
            super.approveSelection();
        }
    }

    private static class Sequence {
        String key;
        String name;
        Color color;
        boolean isPlotted;
        Stroke transitionStroke = null;
        Object values = new byte[4000 + (int)(Math.random() * 100.0)];
        int size = 0;

        public Sequence(String key) {
            this.key = key;
        }

        public long value(int i) {
            return Array.getLong(this.values, i);
        }

        public void add(long value) {
            if ((this.values instanceof byte[] || this.values instanceof short[] || this.values instanceof int[]) && value > Integer.MAX_VALUE) {
                long[] la = new long[Array.getLength(this.values)];
                for (int i = 0; i < this.size; ++i) {
                    la[i] = Array.getLong(this.values, i);
                }
                this.values = la;
            } else if ((this.values instanceof byte[] || this.values instanceof short[]) && value > 32767L) {
                int[] ia = new int[Array.getLength(this.values)];
                for (int i = 0; i < this.size; ++i) {
                    ia[i] = Array.getInt(this.values, i);
                }
                this.values = ia;
            } else if (this.values instanceof byte[] && value > 127L) {
                short[] sa = new short[Array.getLength(this.values)];
                for (int i = 0; i < this.size; ++i) {
                    sa[i] = Array.getShort(this.values, i);
                }
                this.values = sa;
            }
            if (Array.getLength(this.values) == this.size) {
                this.values = Plotter.extendArray(this.values);
            }
            if (this.values instanceof long[]) {
                ((long[])this.values)[this.size] = value;
            } else if (this.values instanceof int[]) {
                ((int[])this.values)[this.size] = (int)value;
            } else if (this.values instanceof short[]) {
                ((short[])this.values)[this.size] = (short)value;
            } else {
                ((byte[])this.values)[this.size] = (byte)value;
            }
            ++this.size;
        }
    }

    private static class TimeStamps {
        long[] offsets = new long[0];
        int[] indices = new int[0];
        int[] rtimes = new int[4000];
        int size = 0;

        private TimeStamps() {
        }

        public long time(int i) {
            long offset = 0L;
            for (int j = this.indices.length - 1; j >= 0; --j) {
                if (i < this.indices[j]) continue;
                offset = this.offsets[j];
                break;
            }
            return offset + (long)this.rtimes[i];
        }

        public void add(long time) {
            int n = this.offsets.length;
            if (n == 0 || time - this.offsets[n - 1] > Integer.MAX_VALUE) {
                this.offsets = Arrays.copyOf(this.offsets, n + 1);
                this.offsets[n] = time;
                this.indices = Arrays.copyOf(this.indices, n + 1);
                this.indices[n] = this.size;
            }
            if (this.rtimes.length == this.size) {
                this.rtimes = (int[])Plotter.extendArray(this.rtimes);
            }
            this.rtimes[this.size] = (int)(time - this.offsets[this.offsets.length - 1]);
            ++this.size;
        }
    }

    public static enum Unit {
        NONE,
        BYTES,
        PERCENT;

    }
}

