/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.CharsetMapping;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.SJIS;

public class SJIS_0213
extends Charset {
    static CharsetMapping mapping = CharsetMapping.get(SJIS_0213.class.getResourceAsStream("sjis0213.dat"));

    public SJIS_0213() {
        super("x-SJIS_0213", ExtendedCharsets.aliasesFor("SJIS_0213"));
    }

    @Override
    public boolean contains(Charset cs) {
        return cs.name().equals("US-ASCII") || cs instanceof SJIS || cs instanceof SJIS_0213;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    protected static class Encoder
    extends CharsetEncoder {
        protected static final int UNMAPPABLE = 65533;
        protected static final int MAX_SINGLEBYTE = 255;
        private CharsetMapping.Entry comp = new CharsetMapping.Entry();
        char leftoverBase = '\u0000';

        protected Encoder(Charset cs) {
            super(cs, 2.0f, 2.0f);
        }

        @Override
        public boolean canEncode(char c) {
            return this.encodeChar(c) != 65533;
        }

        protected int encodeChar(char ch) {
            return mapping.encodeChar(ch);
        }

        protected int encodeSurrogate(char hi, char lo) {
            return mapping.encodeSurrogate(hi, lo);
        }

        protected int encodeComposite(char base, char cc) {
            this.comp.cp = base;
            this.comp.cp2 = cc;
            return mapping.encodeComposite(this.comp);
        }

        protected boolean isCompositeBase(char ch) {
            this.comp.cp = ch;
            return mapping.isCompositeBase(this.comp);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult encodeArrayLoop(CharBuffer src, ByteBuffer dst) {
            char[] sa = src.array();
            int sp = src.arrayOffset() + src.position();
            int sl = src.arrayOffset() + src.limit();
            byte[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            try {
                while (sp < sl) {
                    int db;
                    char c = sa[sp];
                    if (this.leftoverBase != '\u0000') {
                        boolean isComp = false;
                        db = this.encodeComposite(this.leftoverBase, c);
                        if (db == 65533) {
                            db = this.encodeChar(this.leftoverBase);
                        } else {
                            isComp = true;
                        }
                        if (dl - dp < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        da[dp++] = (byte)(db >> 8);
                        da[dp++] = (byte)db;
                        this.leftoverBase = '\u0000';
                        if (isComp) {
                            ++sp;
                            continue;
                        }
                    }
                    if (this.isCompositeBase(c)) {
                        this.leftoverBase = c;
                    } else {
                        db = this.encodeChar(c);
                        if (db <= 255) {
                            if (dl <= dp) {
                                CoderResult isComp = CoderResult.OVERFLOW;
                                return isComp;
                            }
                            da[dp++] = (byte)db;
                        } else if (db != 65533) {
                            if (dl - dp < 2) {
                                CoderResult isComp = CoderResult.OVERFLOW;
                                return isComp;
                            }
                            da[dp++] = (byte)(db >> 8);
                            da[dp++] = (byte)db;
                        } else if (Character.isHighSurrogate(c)) {
                            if (sp + 1 == sl) {
                                CoderResult isComp = CoderResult.UNDERFLOW;
                                return isComp;
                            }
                            char c2 = sa[sp + 1];
                            if (!Character.isLowSurrogate(c2)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                return coderResult;
                            }
                            db = this.encodeSurrogate(c, c2);
                            if (db == 65533) {
                                CoderResult coderResult = CoderResult.unmappableForLength(2);
                                return coderResult;
                            }
                            if (dl - dp < 2) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            da[dp++] = (byte)(db >> 8);
                            da[dp++] = (byte)db;
                            ++sp;
                        } else {
                            if (Character.isLowSurrogate(c)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                return coderResult;
                            }
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    ++sp;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult encodeBufferLoop(CharBuffer src, ByteBuffer dst) {
            int mark = src.position();
            try {
                while (src.hasRemaining()) {
                    int db;
                    char c = src.get();
                    if (this.leftoverBase != '\u0000') {
                        boolean isComp = false;
                        db = this.encodeComposite(this.leftoverBase, c);
                        if (db == 65533) {
                            db = this.encodeChar(this.leftoverBase);
                        } else {
                            isComp = true;
                        }
                        if (dst.remaining() < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        dst.put((byte)(db >> 8));
                        dst.put((byte)db);
                        this.leftoverBase = '\u0000';
                        if (isComp) {
                            ++mark;
                            continue;
                        }
                    }
                    if (this.isCompositeBase(c)) {
                        this.leftoverBase = c;
                    } else {
                        db = this.encodeChar(c);
                        if (db <= 255) {
                            if (dst.remaining() < 1) {
                                CoderResult isComp = CoderResult.OVERFLOW;
                                return isComp;
                            }
                            dst.put((byte)db);
                        } else if (db != 65533) {
                            if (dst.remaining() < 2) {
                                CoderResult isComp = CoderResult.OVERFLOW;
                                return isComp;
                            }
                            dst.put((byte)(db >> 8));
                            dst.put((byte)db);
                        } else if (Character.isHighSurrogate(c)) {
                            if (!src.hasRemaining()) {
                                CoderResult isComp = CoderResult.UNDERFLOW;
                                return isComp;
                            }
                            char c2 = src.get();
                            if (!Character.isLowSurrogate(c2)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                return coderResult;
                            }
                            db = this.encodeSurrogate(c, c2);
                            if (db == 65533) {
                                CoderResult coderResult = CoderResult.unmappableForLength(2);
                                return coderResult;
                            }
                            if (dst.remaining() < 2) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            dst.put((byte)(db >> 8));
                            dst.put((byte)db);
                            ++mark;
                        } else {
                            if (Character.isLowSurrogate(c)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                return coderResult;
                            }
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    ++mark;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.encodeArrayLoop(src, dst);
            }
            return this.encodeBufferLoop(src, dst);
        }

        @Override
        protected CoderResult implFlush(ByteBuffer dst) {
            if (this.leftoverBase > '\u0000') {
                if (dst.remaining() < 2) {
                    return CoderResult.OVERFLOW;
                }
                int db = this.encodeChar(this.leftoverBase);
                dst.put((byte)(db >> 8));
                dst.put((byte)db);
                this.leftoverBase = '\u0000';
            }
            return CoderResult.UNDERFLOW;
        }

        @Override
        protected void implReset() {
            this.leftoverBase = '\u0000';
        }
    }

    protected static class Decoder
    extends CharsetDecoder {
        protected static final char UNMAPPABLE = '\ufffd';
        private char[] cc = new char[2];
        private CharsetMapping.Entry comp = new CharsetMapping.Entry();

        protected Decoder(Charset cs) {
            super(cs, 0.5f, 1.0f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeArrayLoop(ByteBuffer src, CharBuffer dst) {
            int sp;
            byte[] sa = src.array();
            int sl = src.arrayOffset() + src.limit();
            char[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            try {
                int inSize;
                for (sp = src.arrayOffset() + src.position(); sp < sl; sp += inSize) {
                    int b1 = sa[sp] & 0xFF;
                    char c = this.decodeSingle(b1);
                    inSize = 1;
                    int outSize = 1;
                    char[] cc = null;
                    if (c == '\ufffd') {
                        if (sl - sp < 2) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        int b2 = sa[sp + 1] & 0xFF;
                        c = this.decodeDouble(b1, b2);
                        ++inSize;
                        if (c == '\ufffd') {
                            cc = this.decodeDoubleEx(b1, b2);
                            if (cc == null) {
                                if (this.decodeSingle(b2) == '\ufffd') {
                                    CoderResult coderResult = CoderResult.unmappableForLength(2);
                                    return coderResult;
                                }
                                CoderResult coderResult = CoderResult.unmappableForLength(1);
                                return coderResult;
                            }
                            ++outSize;
                        }
                    }
                    if (dl - dp < outSize) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    if (outSize == 2) {
                        da[dp++] = cc[0];
                        da[dp++] = cc[1];
                        continue;
                    }
                    da[dp++] = c;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer src, CharBuffer dst) {
            int mark = src.position();
            try {
                while (src.hasRemaining()) {
                    char[] cc = null;
                    int b1 = src.get() & 0xFF;
                    char c = this.decodeSingle(b1);
                    int inSize = 1;
                    int outSize = 1;
                    if (c == '\ufffd') {
                        if (src.remaining() < 1) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        int b2 = src.get() & 0xFF;
                        ++inSize;
                        c = this.decodeDouble(b1, b2);
                        if (c == '\ufffd') {
                            cc = this.decodeDoubleEx(b1, b2);
                            if (cc == null) {
                                if (this.decodeSingle(b2) == '\ufffd') {
                                    CoderResult coderResult = CoderResult.unmappableForLength(2);
                                    return coderResult;
                                }
                                CoderResult coderResult = CoderResult.unmappableForLength(1);
                                return coderResult;
                            }
                            ++outSize;
                        }
                    }
                    if (dst.remaining() < outSize) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    if (outSize == 2) {
                        dst.put((char)cc[0]);
                        dst.put((char)cc[1]);
                    } else {
                        dst.put(c);
                    }
                    mark += inSize;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.decodeArrayLoop(src, dst);
            }
            return this.decodeBufferLoop(src, dst);
        }

        protected char decodeSingle(int b) {
            return mapping.decodeSingle(b);
        }

        protected char decodeDouble(int b1, int b2) {
            return mapping.decodeDouble(b1, b2);
        }

        protected char[] decodeDoubleEx(int b1, int b2) {
            int db = b1 << 8 | b2;
            if (mapping.decodeSurrogate(db, this.cc) != null) {
                return this.cc;
            }
            this.comp.bs = db;
            if (mapping.decodeComposite(this.comp, this.cc) != null) {
                return this.cc;
            }
            return null;
        }
    }
}

