/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jar;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sun.misc.JarIndex;
import sun.tools.jar.CommandLine;
import sun.tools.jar.JarException;

public class Main {
    String program;
    PrintStream out;
    PrintStream err;
    String fname;
    String mname;
    String ename;
    String zname = "";
    String[] files;
    String rootjar = null;
    Map<String, File> entryMap = new HashMap<String, File>();
    Set<File> entries = new LinkedHashSet<File>();
    Set<String> paths = new HashSet<String>();
    boolean cflag;
    boolean uflag;
    boolean xflag;
    boolean tflag;
    boolean vflag;
    boolean flag0;
    boolean Mflag;
    boolean iflag;
    static final String MANIFEST_DIR = "META-INF/";
    static final String VERSION = "1.0";
    private static ResourceBundle rsrc;
    private static final boolean useExtractionTime;
    private boolean ok;
    private byte[] copyBuf = new byte[8192];
    private HashSet<String> jarPaths = new HashSet();

    private String getMsg(String key) {
        try {
            return rsrc.getString(key);
        }
        catch (MissingResourceException e) {
            throw new Error("Error in message file");
        }
    }

    private String formatMsg(String key, String arg) {
        String msg = this.getMsg(key);
        String[] args = new String[]{arg};
        return MessageFormat.format(msg, args);
    }

    private String formatMsg2(String key, String arg, String arg1) {
        String msg = this.getMsg(key);
        String[] args = new String[]{arg, arg1};
        return MessageFormat.format(msg, args);
    }

    public Main(PrintStream out, PrintStream err, String program) {
        this.out = out;
        this.err = err;
        this.program = program;
    }

    private static File createTempFileInSameDirectoryAs(File file) throws IOException {
        File dir = file.getParentFile();
        if (dir == null) {
            dir = new File(".");
        }
        return Files.createTempFile(dir.toPath(), "jartmp", null, new FileAttribute[0]).toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean run(String[] args) {
        block36: {
            this.ok = true;
            if (!this.parseArgs(args)) {
                return false;
            }
            try {
                if ((this.cflag || this.uflag) && this.fname != null) {
                    this.zname = this.fname.replace(File.separatorChar, '/');
                    if (this.zname.startsWith("./")) {
                        this.zname = this.zname.substring(2);
                    }
                }
                if (this.cflag) {
                    FileOutputStream out;
                    Manifest manifest = null;
                    FileInputStream in = null;
                    if (!this.Mflag) {
                        if (this.mname != null) {
                            in = new FileInputStream(this.mname);
                            manifest = new Manifest(new BufferedInputStream(in));
                        } else {
                            manifest = new Manifest();
                        }
                        this.addVersion(manifest);
                        this.addCreatedBy(manifest);
                        if (this.isAmbiguousMainClass(manifest)) {
                            if (in != null) {
                                ((InputStream)in).close();
                            }
                            return false;
                        }
                        if (this.ename != null) {
                            this.addMainClass(manifest, this.ename);
                        }
                    }
                    if (this.fname != null) {
                        out = new FileOutputStream(this.fname);
                    } else {
                        out = new FileOutputStream(FileDescriptor.out);
                        if (this.vflag) {
                            this.vflag = false;
                        }
                    }
                    this.expand(null, this.files, false);
                    this.create(new BufferedOutputStream(out, 4096), manifest);
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    ((OutputStream)out).close();
                    break block36;
                }
                if (this.uflag) {
                    FileOutputStream out;
                    FileInputStream in;
                    File inputFile = null;
                    File tmpFile = null;
                    if (this.fname != null) {
                        inputFile = new File(this.fname);
                        tmpFile = Main.createTempFileInSameDirectoryAs(inputFile);
                        in = new FileInputStream(inputFile);
                        out = new FileOutputStream(tmpFile);
                    } else {
                        in = new FileInputStream(FileDescriptor.in);
                        out = new FileOutputStream(FileDescriptor.out);
                        this.vflag = false;
                    }
                    FileInputStream manifest = !this.Mflag && this.mname != null ? new FileInputStream(this.mname) : null;
                    this.expand(null, this.files, true);
                    boolean updateOk = this.update(in, new BufferedOutputStream(out), manifest, null);
                    if (this.ok) {
                        this.ok = updateOk;
                    }
                    in.close();
                    out.close();
                    if (manifest != null) {
                        ((InputStream)manifest).close();
                    }
                    if (this.fname != null) {
                        inputFile.delete();
                        if (!tmpFile.renameTo(inputFile)) {
                            tmpFile.delete();
                            throw new IOException(this.getMsg("error.write.file"));
                        }
                        tmpFile.delete();
                    }
                    break block36;
                }
                if (this.tflag) {
                    this.replaceFSC(this.files);
                    if (this.fname != null) {
                        this.list(this.fname, this.files);
                        break block36;
                    }
                    try (FileInputStream in = new FileInputStream(FileDescriptor.in);){
                        this.list(new BufferedInputStream(in), this.files);
                        break block36;
                    }
                }
                if (this.xflag) {
                    this.replaceFSC(this.files);
                    if (this.fname != null && this.files != null) {
                        this.extract(this.fname, this.files);
                        break block36;
                    }
                    try (FileInputStream in = this.fname == null ? new FileInputStream(FileDescriptor.in) : new FileInputStream(this.fname);){
                        this.extract(new BufferedInputStream(in), this.files);
                        break block36;
                    }
                }
                if (this.iflag) {
                    this.genIndex(this.rootjar, this.files);
                }
            }
            catch (IOException e) {
                this.fatalError(e);
                this.ok = false;
            }
            catch (Error ee) {
                ee.printStackTrace();
                this.ok = false;
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.ok = false;
            }
        }
        this.out.flush();
        this.err.flush();
        return this.ok;
    }

    boolean parseArgs(String[] args) {
        try {
            args = CommandLine.parse(args);
        }
        catch (FileNotFoundException e) {
            this.fatalError(this.formatMsg("error.cant.open", e.getMessage()));
            return false;
        }
        catch (IOException e) {
            this.fatalError(e);
            return false;
        }
        int count = 1;
        try {
            String flags = args[0];
            if (flags.startsWith("-")) {
                flags = flags.substring(1);
            }
            block20: for (int i = 0; i < flags.length(); ++i) {
                switch (flags.charAt(i)) {
                    case 'c': {
                        if (this.xflag || this.tflag || this.uflag || this.iflag) {
                            this.usageError();
                            return false;
                        }
                        this.cflag = true;
                        continue block20;
                    }
                    case 'u': {
                        if (this.cflag || this.xflag || this.tflag || this.iflag) {
                            this.usageError();
                            return false;
                        }
                        this.uflag = true;
                        continue block20;
                    }
                    case 'x': {
                        if (this.cflag || this.uflag || this.tflag || this.iflag) {
                            this.usageError();
                            return false;
                        }
                        this.xflag = true;
                        continue block20;
                    }
                    case 't': {
                        if (this.cflag || this.uflag || this.xflag || this.iflag) {
                            this.usageError();
                            return false;
                        }
                        this.tflag = true;
                        continue block20;
                    }
                    case 'M': {
                        this.Mflag = true;
                        continue block20;
                    }
                    case 'v': {
                        this.vflag = true;
                        continue block20;
                    }
                    case 'f': {
                        this.fname = args[count++];
                        continue block20;
                    }
                    case 'm': {
                        this.mname = args[count++];
                        continue block20;
                    }
                    case '0': {
                        this.flag0 = true;
                        continue block20;
                    }
                    case 'i': {
                        if (this.cflag || this.uflag || this.xflag || this.tflag) {
                            this.usageError();
                            return false;
                        }
                        this.rootjar = args[count++];
                        this.iflag = true;
                        continue block20;
                    }
                    case 'e': {
                        this.ename = args[count++];
                        continue block20;
                    }
                    default: {
                        this.error(this.formatMsg("error.illegal.option", String.valueOf(flags.charAt(i))));
                        this.usageError();
                        return false;
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.usageError();
            return false;
        }
        if (!(this.cflag || this.tflag || this.xflag || this.uflag || this.iflag)) {
            this.error(this.getMsg("error.bad.option"));
            this.usageError();
            return false;
        }
        int n = args.length - count;
        if (n > 0) {
            int k = 0;
            String[] nameBuf = new String[n];
            try {
                for (int i = count; i < args.length; ++i) {
                    if (args[i].equals("-C")) {
                        String dir;
                        dir = (dir = args[++i]).endsWith(File.separator) ? dir : dir + File.separator;
                        dir = dir.replace(File.separatorChar, '/');
                        while (dir.indexOf("//") > -1) {
                            dir = dir.replace("//", "/");
                        }
                        this.paths.add(dir.replace(File.separatorChar, '/'));
                        nameBuf[k++] = dir + args[++i];
                        continue;
                    }
                    nameBuf[k++] = args[i];
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.usageError();
                return false;
            }
            this.files = new String[k];
            System.arraycopy(nameBuf, 0, this.files, 0, k);
        } else {
            if (this.cflag && this.mname == null) {
                this.error(this.getMsg("error.bad.cflag"));
                this.usageError();
                return false;
            }
            if (this.uflag) {
                if (this.mname != null || this.ename != null) {
                    return true;
                }
                this.error(this.getMsg("error.bad.uflag"));
                this.usageError();
                return false;
            }
        }
        return true;
    }

    void expand(File dir, String[] files, boolean isUpdate) {
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File f = dir == null ? new File(files[i]) : new File(dir, files[i]);
            if (f.isFile()) {
                if (!this.entries.add(f) || !isUpdate) continue;
                this.entryMap.put(this.entryName(f.getPath()), f);
                continue;
            }
            if (f.isDirectory()) {
                if (!this.entries.add(f)) continue;
                if (isUpdate) {
                    String dirPath = f.getPath();
                    dirPath = dirPath.endsWith(File.separator) ? dirPath : dirPath + File.separator;
                    this.entryMap.put(this.entryName(dirPath), f);
                }
                this.expand(f, f.list(), isUpdate);
                continue;
            }
            this.error(this.formatMsg("error.nosuch.fileordir", String.valueOf(f)));
            this.ok = false;
        }
    }

    void create(OutputStream out, Manifest manifest) throws IOException {
        JarOutputStream zos = new JarOutputStream(out);
        if (this.flag0) {
            zos.setMethod(0);
        }
        if (manifest != null) {
            if (this.vflag) {
                this.output(this.getMsg("out.added.manifest"));
            }
            ZipEntry e = new ZipEntry(MANIFEST_DIR);
            e.setTime(System.currentTimeMillis());
            e.setSize(0L);
            e.setCrc(0L);
            ((ZipOutputStream)zos).putNextEntry(e);
            e = new ZipEntry("META-INF/MANIFEST.MF");
            e.setTime(System.currentTimeMillis());
            if (this.flag0) {
                this.crc32Manifest(e, manifest);
            }
            ((ZipOutputStream)zos).putNextEntry(e);
            manifest.write(zos);
            zos.closeEntry();
        }
        for (File file : this.entries) {
            this.addFile(zos, file);
        }
        zos.close();
    }

    private char toUpperCaseASCII(char c) {
        return c < 'a' || c > 'z' ? c : (char)(c + 65 - 97);
    }

    private boolean equalsIgnoreCase(String s, String upper) {
        assert (upper.toUpperCase(Locale.ENGLISH).equals(upper));
        int len = s.length();
        if (len != upper.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c2;
            char c1 = s.charAt(i);
            if (c1 == (c2 = upper.charAt(i)) || this.toUpperCaseASCII(c1) == c2) continue;
            return false;
        }
        return true;
    }

    boolean update(InputStream in, OutputStream out, InputStream newManifest, JarIndex jarIndex) throws IOException {
        ZipInputStream zis = new ZipInputStream(in);
        JarOutputStream zos = new JarOutputStream(out);
        ZipEntry e = null;
        boolean foundManifest = false;
        boolean updateOk = true;
        if (jarIndex != null) {
            this.addIndex(jarIndex, zos);
        }
        while ((e = zis.getNextEntry()) != null) {
            String name = e.getName();
            boolean isManifestEntry = this.equalsIgnoreCase(name, "META-INF/MANIFEST.MF");
            if (jarIndex != null && this.equalsIgnoreCase(name, "META-INF/INDEX.LIST") || this.Mflag && isManifestEntry) continue;
            if (isManifestEntry && (newManifest != null || this.ename != null)) {
                foundManifest = true;
                if (newManifest != null) {
                    FileInputStream fis = new FileInputStream(this.mname);
                    boolean ambiguous = this.isAmbiguousMainClass(new Manifest(fis));
                    fis.close();
                    if (ambiguous) {
                        return false;
                    }
                }
                Manifest old = new Manifest(zis);
                if (newManifest != null) {
                    old.read(newManifest);
                }
                this.updateManifest(old, zos);
                continue;
            }
            if (!this.entryMap.containsKey(name)) {
                ZipEntry e2 = new ZipEntry(name);
                e2.setMethod(e.getMethod());
                e2.setTime(e.getTime());
                e2.setComment(e.getComment());
                e2.setExtra(e.getExtra());
                if (e.getMethod() == 0) {
                    e2.setSize(e.getSize());
                    e2.setCrc(e.getCrc());
                }
                ((ZipOutputStream)zos).putNextEntry(e2);
                this.copy((InputStream)zis, (OutputStream)zos);
                continue;
            }
            File f = this.entryMap.get(name);
            this.addFile(zos, f);
            this.entryMap.remove(name);
            this.entries.remove(f);
        }
        for (File f : this.entries) {
            this.addFile(zos, f);
        }
        if (!foundManifest) {
            if (newManifest != null) {
                Manifest m = new Manifest(newManifest);
                boolean bl = updateOk = !this.isAmbiguousMainClass(m);
                if (updateOk) {
                    this.updateManifest(m, zos);
                }
            } else if (this.ename != null) {
                this.updateManifest(new Manifest(), zos);
            }
        }
        zis.close();
        zos.close();
        return updateOk;
    }

    private void addIndex(JarIndex index, ZipOutputStream zos) throws IOException {
        ZipEntry e = new ZipEntry("META-INF/INDEX.LIST");
        e.setTime(System.currentTimeMillis());
        if (this.flag0) {
            CRC32OutputStream os = new CRC32OutputStream();
            index.write(os);
            os.updateEntry(e);
        }
        zos.putNextEntry(e);
        index.write(zos);
        zos.closeEntry();
    }

    private void updateManifest(Manifest m, ZipOutputStream zos) throws IOException {
        this.addVersion(m);
        this.addCreatedBy(m);
        if (this.ename != null) {
            this.addMainClass(m, this.ename);
        }
        ZipEntry e = new ZipEntry("META-INF/MANIFEST.MF");
        e.setTime(System.currentTimeMillis());
        if (this.flag0) {
            this.crc32Manifest(e, m);
        }
        zos.putNextEntry(e);
        m.write(zos);
        if (this.vflag) {
            this.output(this.getMsg("out.update.manifest"));
        }
    }

    private String entryName(String name) {
        name = name.replace(File.separatorChar, '/');
        String matchPath = "";
        for (String path : this.paths) {
            if (!name.startsWith(path) || path.length() <= matchPath.length()) continue;
            matchPath = path;
        }
        if ((name = name.substring(matchPath.length())).startsWith("/")) {
            name = name.substring(1);
        } else if (name.startsWith("./")) {
            name = name.substring(2);
        }
        return name;
    }

    private void addVersion(Manifest m) {
        Attributes global = m.getMainAttributes();
        if (global.getValue(Attributes.Name.MANIFEST_VERSION) == null) {
            global.put(Attributes.Name.MANIFEST_VERSION, VERSION);
        }
    }

    private void addCreatedBy(Manifest m) {
        Attributes global = m.getMainAttributes();
        if (global.getValue(new Attributes.Name("Created-By")) == null) {
            String javaVendor = System.getProperty("java.vendor");
            String jdkVersion = System.getProperty("java.version");
            global.put(new Attributes.Name("Created-By"), jdkVersion + " (" + javaVendor + ")");
        }
    }

    private void addMainClass(Manifest m, String mainApp) {
        Attributes global = m.getMainAttributes();
        global.put(Attributes.Name.MAIN_CLASS, mainApp);
    }

    private boolean isAmbiguousMainClass(Manifest m) {
        Attributes global;
        if (this.ename != null && (global = m.getMainAttributes()).get(Attributes.Name.MAIN_CLASS) != null) {
            this.error(this.getMsg("error.bad.eflag"));
            this.usageError();
            return true;
        }
        return false;
    }

    void addFile(ZipOutputStream zos, File file) throws IOException {
        long size;
        String name = file.getPath();
        boolean isDir = file.isDirectory();
        if (isDir) {
            String string = name = name.endsWith(File.separator) ? name : name + File.separator;
        }
        if ((name = this.entryName(name)).equals("") || name.equals(".") || name.equals(this.zname)) {
            return;
        }
        if ((name.equals(MANIFEST_DIR) || name.equals("META-INF/MANIFEST.MF")) && !this.Mflag) {
            if (this.vflag) {
                this.output(this.formatMsg("out.ignore.entry", name));
            }
            return;
        }
        long l = size = isDir ? 0L : file.length();
        if (this.vflag) {
            this.out.print(this.formatMsg("out.adding", name));
        }
        ZipEntry e = new ZipEntry(name);
        e.setTime(file.lastModified());
        if (size == 0L) {
            e.setMethod(0);
            e.setSize(0L);
            e.setCrc(0L);
        } else if (this.flag0) {
            this.crc32File(e, file);
        }
        zos.putNextEntry(e);
        if (!isDir) {
            this.copy(file, (OutputStream)zos);
        }
        zos.closeEntry();
        if (this.vflag) {
            size = e.getSize();
            long csize = e.getCompressedSize();
            this.out.print(this.formatMsg2("out.size", String.valueOf(size), String.valueOf(csize)));
            if (e.getMethod() == 8) {
                long ratio = 0L;
                if (size != 0L) {
                    ratio = (size - csize) * 100L / size;
                }
                this.output(this.formatMsg("out.deflated", String.valueOf(ratio)));
            } else {
                this.output(this.getMsg("out.stored"));
            }
        }
    }

    private void copy(InputStream from, OutputStream to) throws IOException {
        int n;
        while ((n = from.read(this.copyBuf)) != -1) {
            to.write(this.copyBuf, 0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(File from, OutputStream to) throws IOException {
        try (FileInputStream in = new FileInputStream(from);){
            this.copy((InputStream)in, to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(InputStream from, File to) throws IOException {
        try (FileOutputStream out = new FileOutputStream(to);){
            this.copy(from, (OutputStream)out);
        }
    }

    private void crc32Manifest(ZipEntry e, Manifest m) throws IOException {
        CRC32OutputStream os = new CRC32OutputStream();
        m.write(os);
        os.updateEntry(e);
    }

    private void crc32File(ZipEntry e, File f) throws IOException {
        CRC32OutputStream os = new CRC32OutputStream();
        this.copy(f, (OutputStream)os);
        if (os.n != f.length()) {
            throw new JarException(this.formatMsg("error.incorrect.length", f.getPath()));
        }
        os.updateEntry(e);
    }

    void replaceFSC(String[] files) {
        if (files != null) {
            for (String file : files) {
                file = file.replace(File.separatorChar, '/');
            }
        }
    }

    Set<ZipEntry> newDirSet() {
        return new HashSet<ZipEntry>(){

            @Override
            public boolean add(ZipEntry e) {
                return e == null || useExtractionTime ? false : super.add(e);
            }
        };
    }

    void updateLastModifiedTime(Set<ZipEntry> zes) throws IOException {
        for (ZipEntry ze : zes) {
            long lastModified = ze.getTime();
            if (lastModified == -1L) continue;
            File f = new File(ze.getName().replace('/', File.separatorChar));
            f.setLastModified(lastModified);
        }
    }

    void extract(InputStream in, String[] files) throws IOException {
        ZipEntry e;
        ZipInputStream zis = new ZipInputStream(in);
        Set<ZipEntry> dirs = this.newDirSet();
        block0: while ((e = zis.getNextEntry()) != null) {
            if (files == null) {
                dirs.add(this.extractFile(zis, e));
                continue;
            }
            String name = e.getName();
            for (String file : files) {
                if (!name.startsWith(file)) continue;
                dirs.add(this.extractFile(zis, e));
                continue block0;
            }
        }
        this.updateLastModifiedTime(dirs);
    }

    void extract(String fname, String[] files) throws IOException {
        ZipFile zf = new ZipFile(fname);
        Set<ZipEntry> dirs = this.newDirSet();
        Enumeration<? extends ZipEntry> zes = zf.entries();
        block0: while (zes.hasMoreElements()) {
            ZipEntry e = zes.nextElement();
            if (files == null) {
                dirs.add(this.extractFile(zf.getInputStream(e), e));
                continue;
            }
            String name = e.getName();
            for (String file : files) {
                if (!name.startsWith(file)) continue;
                dirs.add(this.extractFile(zf.getInputStream(e), e));
                continue block0;
            }
        }
        zf.close();
        this.updateLastModifiedTime(dirs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ZipEntry extractFile(InputStream is, ZipEntry e) throws IOException {
        long lastModified;
        ZipEntry rc = null;
        String name = e.getName();
        File f = new File(e.getName().replace('/', File.separatorChar));
        if (e.isDirectory()) {
            if (f.exists()) {
                if (!f.isDirectory()) {
                    throw new IOException(this.formatMsg("error.create.dir", f.getPath()));
                }
            } else {
                if (!f.mkdirs()) {
                    throw new IOException(this.formatMsg("error.create.dir", f.getPath()));
                }
                rc = e;
            }
            if (this.vflag) {
                this.output(this.formatMsg("out.create", name));
            }
        } else {
            File d;
            if (!(f.getParent() == null || ((d = new File(f.getParent())).exists() || d.mkdirs()) && d.isDirectory())) {
                throw new IOException(this.formatMsg("error.create.dir", d.getPath()));
            }
            try {
                this.copy(is, f);
            }
            finally {
                if (is instanceof ZipInputStream) {
                    ((ZipInputStream)is).closeEntry();
                } else {
                    is.close();
                }
            }
            if (this.vflag) {
                if (e.getMethod() == 8) {
                    this.output(this.formatMsg("out.inflated", name));
                } else {
                    this.output(this.formatMsg("out.extracted", name));
                }
            }
        }
        if (!useExtractionTime && (lastModified = e.getTime()) != -1L) {
            f.setLastModified(lastModified);
        }
        return rc;
    }

    void list(InputStream in, String[] files) throws IOException {
        ZipEntry e;
        ZipInputStream zis = new ZipInputStream(in);
        while ((e = zis.getNextEntry()) != null) {
            zis.closeEntry();
            this.printEntry(e, files);
        }
    }

    void list(String fname, String[] files) throws IOException {
        ZipFile zf = new ZipFile(fname);
        Enumeration<? extends ZipEntry> zes = zf.entries();
        while (zes.hasMoreElements()) {
            this.printEntry(zes.nextElement(), files);
        }
        zf.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpIndex(String rootjar, JarIndex index) throws IOException {
        block5: {
            File jarFile = new File(rootjar);
            Path jarPath = jarFile.toPath();
            Path tmpPath = Main.createTempFileInSameDirectoryAs(jarFile).toPath();
            try {
                if (!this.update(Files.newInputStream(jarPath, new OpenOption[0]), Files.newOutputStream(tmpPath, new OpenOption[0]), null, index)) break block5;
                try {
                    Files.move(tmpPath, jarPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new IOException(this.getMsg("error.write.file"), e);
                }
            }
            finally {
                Files.deleteIfExists(tmpPath);
            }
        }
    }

    List<String> getJarPath(String jar2) throws IOException {
        String value;
        Attributes attr;
        Manifest man;
        ArrayList<String> files = new ArrayList<String>();
        files.add(jar2);
        this.jarPaths.add(jar2);
        String path = jar2.substring(0, Math.max(0, jar2.lastIndexOf(47) + 1));
        JarFile rf = new JarFile(jar2.replace('/', File.separatorChar));
        if (rf != null && (man = rf.getManifest()) != null && (attr = man.getMainAttributes()) != null && (value = attr.getValue(Attributes.Name.CLASS_PATH)) != null) {
            StringTokenizer st = new StringTokenizer(value);
            while (st.hasMoreTokens()) {
                String ajar = st.nextToken();
                if (ajar.endsWith("/") || this.jarPaths.contains(ajar = path.concat(ajar))) continue;
                files.addAll(this.getJarPath(ajar));
            }
        }
        rf.close();
        return files;
    }

    void genIndex(String rootjar, String[] files) throws IOException {
        List<String> jars = this.getJarPath(rootjar);
        int njars = jars.size();
        if (njars == 1 && files != null) {
            for (int i = 0; i < files.length; ++i) {
                jars.addAll(this.getJarPath(files[i]));
            }
            njars = jars.size();
        }
        String[] jarfiles = jars.toArray(new String[njars]);
        JarIndex index = new JarIndex(jarfiles);
        this.dumpIndex(rootjar, index);
    }

    void printEntry(ZipEntry e, String[] files) throws IOException {
        if (files == null) {
            this.printEntry(e);
        } else {
            String name = e.getName();
            for (String file : files) {
                if (!name.startsWith(file)) continue;
                this.printEntry(e);
                return;
            }
        }
    }

    void printEntry(ZipEntry e) throws IOException {
        if (this.vflag) {
            StringBuilder sb = new StringBuilder();
            String s = Long.toString(e.getSize());
            for (int i = 6 - s.length(); i > 0; --i) {
                sb.append(' ');
            }
            sb.append(s).append(' ').append(new Date(e.getTime()).toString());
            sb.append(' ').append(e.getName());
            this.output(sb.toString());
        } else {
            this.output(e.getName());
        }
    }

    void usageError() {
        this.error(this.getMsg("usage"));
    }

    void fatalError(Exception e) {
        e.printStackTrace();
    }

    void fatalError(String s) {
        this.error(this.program + ": " + s);
    }

    protected void output(String s) {
        this.out.println(s);
    }

    protected void error(String s) {
        this.err.println(s);
    }

    public static void main(String[] args) {
        Main jartool = new Main(System.out, System.err, "jar");
        System.exit(jartool.run(args) ? 0 : 1);
    }

    static {
        useExtractionTime = Boolean.getBoolean("sun.tools.jar.useExtractionTime");
        try {
            rsrc = ResourceBundle.getBundle("sun.tools.jar.resources.jar");
        }
        catch (MissingResourceException e) {
            throw new Error("Fatal: Resource for jar is missing");
        }
    }

    private static class CRC32OutputStream
    extends OutputStream {
        final CRC32 crc = new CRC32();
        long n = 0L;

        CRC32OutputStream() {
        }

        @Override
        public void write(int r) throws IOException {
            this.crc.update(r);
            ++this.n;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.crc.update(b, off, len);
            this.n += (long)len;
        }

        public void updateEntry(ZipEntry e) {
            e.setMethod(0);
            e.setSize(this.n);
            e.setCrc(this.crc.getValue());
        }
    }
}

