/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.util.Enumeration;
import sun.security.util.BitArray;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;

public class ReasonFlags {
    public static final String UNUSED = "unused";
    public static final String KEY_COMPROMISE = "key_compromise";
    public static final String CA_COMPROMISE = "ca_compromise";
    public static final String AFFILIATION_CHANGED = "affiliation_changed";
    public static final String SUPERSEDED = "superseded";
    public static final String CESSATION_OF_OPERATION = "cessation_of_operation";
    public static final String CERTIFICATE_HOLD = "certificate_hold";
    public static final String PRIVILEGE_WITHDRAWN = "privilege_withdrawn";
    public static final String AA_COMPROMISE = "aa_compromise";
    private static final String[] NAMES = new String[]{"unused", "key_compromise", "ca_compromise", "affiliation_changed", "superseded", "cessation_of_operation", "certificate_hold", "privilege_withdrawn", "aa_compromise"};
    private boolean[] bitString;

    private static int name2Index(String name) throws IOException {
        for (int i = 0; i < NAMES.length; ++i) {
            if (!NAMES[i].equalsIgnoreCase(name)) continue;
            return i;
        }
        throw new IOException("Name not recognized by ReasonFlags");
    }

    private boolean isSet(int position) {
        return this.bitString[position];
    }

    private void set(int position, boolean val) {
        if (position >= this.bitString.length) {
            boolean[] tmp = new boolean[position + 1];
            System.arraycopy(this.bitString, 0, tmp, 0, this.bitString.length);
            this.bitString = tmp;
        }
        this.bitString[position] = val;
    }

    public ReasonFlags(byte[] reasons) {
        this.bitString = new BitArray(reasons.length * 8, reasons).toBooleanArray();
    }

    public ReasonFlags(boolean[] reasons) {
        this.bitString = reasons;
    }

    public ReasonFlags(BitArray reasons) {
        this.bitString = reasons.toBooleanArray();
    }

    public ReasonFlags(DerInputStream in) throws IOException {
        DerValue derVal = in.getDerValue();
        this.bitString = derVal.getUnalignedBitString(true).toBooleanArray();
    }

    public ReasonFlags(DerValue derVal) throws IOException {
        this.bitString = derVal.getUnalignedBitString(true).toBooleanArray();
    }

    public boolean[] getFlags() {
        return this.bitString;
    }

    public void set(String name, Object obj) throws IOException {
        if (!(obj instanceof Boolean)) {
            throw new IOException("Attribute must be of type Boolean.");
        }
        boolean val = (Boolean)obj;
        this.set(ReasonFlags.name2Index(name), val);
    }

    public Object get(String name) throws IOException {
        return this.isSet(ReasonFlags.name2Index(name));
    }

    public void delete(String name) throws IOException {
        this.set(name, Boolean.FALSE);
    }

    public String toString() {
        String s = "Reason Flags [\n";
        try {
            if (this.isSet(0)) {
                s = s + "  Unused\n";
            }
            if (this.isSet(1)) {
                s = s + "  Key Compromise\n";
            }
            if (this.isSet(2)) {
                s = s + "  CA Compromise\n";
            }
            if (this.isSet(3)) {
                s = s + "  Affiliation_Changed\n";
            }
            if (this.isSet(4)) {
                s = s + "  Superseded\n";
            }
            if (this.isSet(5)) {
                s = s + "  Cessation Of Operation\n";
            }
            if (this.isSet(6)) {
                s = s + "  Certificate Hold\n";
            }
            if (this.isSet(7)) {
                s = s + "  Privilege Withdrawn\n";
            }
            if (this.isSet(8)) {
                s = s + "  AA Compromise\n";
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        s = s + "]\n";
        return s;
    }

    public void encode(DerOutputStream out) throws IOException {
        out.putTruncatedUnalignedBitString(new BitArray(this.bitString));
    }

    public Enumeration<String> getElements() {
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        for (int i = 0; i < NAMES.length; ++i) {
            elements.addElement(NAMES[i]);
        }
        return elements.elements();
    }
}

