/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.wrapper;

import java.io.IOException;
import java.security.Provider;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSExceptionImpl;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.jgss.wrapper.GSSLibStub;
import sun.security.jgss.wrapper.SunNativeProvider;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.ObjectIdentifier;

public class GSSNameElement
implements GSSNameSpi {
    long pName = 0L;
    private String printableName;
    private Oid printableType;
    private GSSLibStub cStub;
    static final GSSNameElement DEF_ACCEPTOR = new GSSNameElement();

    private static Oid getNativeNameType(Oid nameType, GSSLibStub stub) {
        if (GSSUtil.NT_GSS_KRB5_PRINCIPAL.equals(nameType)) {
            Oid[] supportedNTs = null;
            try {
                supportedNTs = stub.inquireNamesForMech();
            }
            catch (GSSException ge) {
                if (ge.getMajor() == 2 && GSSUtil.isSpNegoMech(stub.getMech())) {
                    try {
                        stub = GSSLibStub.getInstance(GSSUtil.GSS_KRB5_MECH_OID);
                        supportedNTs = stub.inquireNamesForMech();
                    }
                    catch (GSSException ge2) {
                        SunNativeProvider.debug("Name type list unavailable: " + ge2.getMajorString());
                    }
                }
                SunNativeProvider.debug("Name type list unavailable: " + ge.getMajorString());
            }
            if (supportedNTs != null) {
                for (int i = 0; i < supportedNTs.length; ++i) {
                    if (!supportedNTs[i].equals(nameType)) continue;
                    return nameType;
                }
                SunNativeProvider.debug("Override " + nameType + " with mechanism default(null)");
                return null;
            }
        }
        return nameType;
    }

    private GSSNameElement() {
        this.printableName = "<DEFAULT ACCEPTOR>";
    }

    GSSNameElement(long pNativeName, GSSLibStub stub) throws GSSException {
        assert (stub != null);
        if (pNativeName == 0L) {
            throw new GSSException(3);
        }
        this.pName = pNativeName;
        this.cStub = stub;
        this.setPrintables();
    }

    GSSNameElement(byte[] nameBytes, Oid nameType, GSSLibStub stub) throws GSSException {
        assert (stub != null);
        if (nameBytes == null) {
            throw new GSSException(3);
        }
        this.cStub = stub;
        byte[] name = nameBytes;
        if (nameType != null && GSSName.NT_EXPORT_NAME.equals(nameType = GSSNameElement.getNativeNameType(nameType, stub))) {
            byte[] mechBytes = null;
            DerOutputStream dout = new DerOutputStream();
            Oid mech = this.cStub.getMech();
            try {
                dout.putOID(new ObjectIdentifier(mech.toString()));
            }
            catch (IOException e) {
                throw new GSSExceptionImpl(11, e);
            }
            mechBytes = dout.toByteArray();
            name = new byte[4 + mechBytes.length + 4 + nameBytes.length];
            int pos = 0;
            name[pos++] = 4;
            name[pos++] = 1;
            name[pos++] = (byte)(mechBytes.length >>> 8);
            name[pos++] = (byte)mechBytes.length;
            System.arraycopy(mechBytes, 0, name, pos, mechBytes.length);
            pos += mechBytes.length;
            name[pos++] = (byte)(nameBytes.length >>> 24);
            name[pos++] = (byte)(nameBytes.length >>> 16);
            name[pos++] = (byte)(nameBytes.length >>> 8);
            name[pos++] = (byte)nameBytes.length;
            System.arraycopy(nameBytes, 0, name, pos, nameBytes.length);
        }
        this.pName = this.cStub.importName(name, nameType);
        this.setPrintables();
        SunNativeProvider.debug("Imported " + this.printableName + " w/ type " + this.printableType);
    }

    private void setPrintables() throws GSSException {
        Object[] printables = null;
        printables = this.cStub.displayName(this.pName);
        assert (printables != null && printables.length == 2);
        this.printableName = (String)printables[0];
        assert (this.printableName != null);
        this.printableType = (Oid)printables[1];
        if (this.printableType == null) {
            this.printableType = GSSName.NT_USER_NAME;
        }
    }

    public String getKrbName() throws GSSException {
        long mName = 0L;
        GSSLibStub stub = this.cStub;
        if (!GSSUtil.isKerberosMech(this.cStub.getMech())) {
            stub = GSSLibStub.getInstance(GSSUtil.GSS_KRB5_MECH_OID);
        }
        mName = stub.canonicalizeName(this.pName);
        Object[] printables2 = stub.displayName(mName);
        stub.releaseName(mName);
        SunNativeProvider.debug("Got kerberized name: " + printables2[0]);
        return (String)printables2[0];
    }

    @Override
    public Provider getProvider() {
        return SunNativeProvider.INSTANCE;
    }

    @Override
    public boolean equals(GSSNameSpi other) throws GSSException {
        if (!(other instanceof GSSNameElement)) {
            return false;
        }
        return this.cStub.compareName(this.pName, ((GSSNameElement)other).pName);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof GSSNameElement)) {
            return false;
        }
        try {
            return this.equals((GSSNameElement)other);
        }
        catch (GSSException ex) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return new Long(this.pName).hashCode();
    }

    @Override
    public byte[] export() throws GSSException {
        byte[] nameVal = this.cStub.exportName(this.pName);
        int pos = 0;
        if (nameVal[pos++] != 4 || nameVal[pos++] != 1) {
            throw new GSSException(3);
        }
        int mechOidLen = (0xFF & nameVal[pos++]) << 8 | 0xFF & nameVal[pos++];
        ObjectIdentifier temp = null;
        try {
            DerInputStream din = new DerInputStream(nameVal, pos, mechOidLen);
            temp = new ObjectIdentifier(din);
        }
        catch (IOException e) {
            throw new GSSExceptionImpl(3, e);
        }
        Oid mech2 = new Oid(temp.toString());
        assert (mech2.equals(this.getMechanism()));
        pos += mechOidLen;
        int mechPortionLen = (0xFF & nameVal[pos++]) << 24 | (0xFF & nameVal[pos++]) << 16 | (0xFF & nameVal[pos++]) << 8 | 0xFF & nameVal[pos++];
        byte[] mechPortion = new byte[mechPortionLen];
        System.arraycopy(nameVal, pos, mechPortion, 0, mechPortionLen);
        return mechPortion;
    }

    @Override
    public Oid getMechanism() {
        return this.cStub.getMech();
    }

    @Override
    public String toString() {
        return this.printableName;
    }

    @Override
    public Oid getStringNameType() {
        return this.printableType;
    }

    @Override
    public boolean isAnonymousName() {
        return GSSName.NT_ANONYMOUS.equals(this.printableType);
    }

    public void dispose() {
        if (this.pName != 0L) {
            this.cStub.releaseName(this.pName);
            this.pName = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }
}

