/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.ReadPendingException;
import java.nio.channels.WritePendingException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import sun.net.NetHooks;
import sun.nio.ch.AlreadyBoundException;
import sun.nio.ch.AsynchronousChannelGroupImpl;
import sun.nio.ch.Cancellable;
import sun.nio.ch.CompletedFuture;
import sun.nio.ch.Groupable;
import sun.nio.ch.Invoker;
import sun.nio.ch.Net;
import sun.nio.ch.Util;

abstract class AsynchronousSocketChannelImpl
extends AsynchronousSocketChannel
implements Cancellable,
Groupable {
    protected final FileDescriptor fd;
    protected final Object stateLock = new Object();
    protected volatile SocketAddress localAddress = null;
    protected volatile SocketAddress remoteAddress = null;
    static final int ST_UNINITIALIZED = -1;
    static final int ST_UNCONNECTED = 0;
    static final int ST_PENDING = 1;
    static final int ST_CONNECTED = 2;
    protected volatile int state = -1;
    private final Object readLock = new Object();
    private boolean reading;
    private boolean readShutdown;
    private boolean readKilled;
    private final Object writeLock = new Object();
    private boolean writing;
    private boolean writeShutdown;
    private boolean writeKilled;
    private final ReadWriteLock closeLock = new ReentrantReadWriteLock();
    private volatile boolean open = true;

    AsynchronousSocketChannelImpl(AsynchronousChannelGroupImpl group) throws IOException {
        super(group.provider());
        this.fd = Net.socket(true);
        this.state = 0;
    }

    AsynchronousSocketChannelImpl(AsynchronousChannelGroupImpl group, FileDescriptor fd, InetSocketAddress remote) throws IOException {
        super(group.provider());
        this.fd = fd;
        this.state = 2;
        this.localAddress = Net.localAddress(fd);
        this.remoteAddress = remote;
    }

    @Override
    public final boolean isOpen() {
        return this.open;
    }

    final void begin() throws IOException {
        this.closeLock.readLock().lock();
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    final void end() {
        this.closeLock.readLock().unlock();
    }

    abstract void implClose() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        this.closeLock.writeLock().lock();
        try {
            if (!this.open) {
                return;
            }
            this.open = false;
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
        this.implClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void enableReading(boolean killed) {
        Object object = this.readLock;
        synchronized (object) {
            this.reading = false;
            if (killed) {
                this.readKilled = true;
            }
        }
    }

    final void enableReading() {
        this.enableReading(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void enableWriting(boolean killed) {
        Object object = this.writeLock;
        synchronized (object) {
            this.writing = false;
            if (killed) {
                this.writeKilled = true;
            }
        }
    }

    final void enableWriting() {
        this.enableWriting(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void killReading() {
        Object object = this.readLock;
        synchronized (object) {
            this.readKilled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void killWriting() {
        Object object = this.writeLock;
        synchronized (object) {
            this.writeKilled = true;
        }
    }

    final void killConnect() {
        this.killReading();
        this.killWriting();
    }

    abstract <A> Future<Void> implConnect(SocketAddress var1, A var2, CompletionHandler<Void, ? super A> var3);

    @Override
    public final Future<Void> connect(SocketAddress remote) {
        return this.implConnect(remote, null, null);
    }

    @Override
    public final <A> void connect(SocketAddress remote, A attachment, CompletionHandler<Void, ? super A> handler) {
        if (handler == null) {
            throw new NullPointerException("'handler' is null");
        }
        this.implConnect(remote, attachment, handler);
    }

    abstract <V extends Number, A> Future<V> implRead(boolean var1, ByteBuffer var2, ByteBuffer[] var3, long var4, TimeUnit var6, A var7, CompletionHandler<V, ? super A> var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V extends Number, A> Future<V> read(boolean isScatteringRead, ByteBuffer dst, ByteBuffer[] dsts, long timeout, TimeUnit unit, A att, CompletionHandler<V, ? super A> handler) {
        if (!this.isOpen()) {
            ClosedChannelException e = new ClosedChannelException();
            if (handler == null) {
                return CompletedFuture.withFailure(e);
            }
            Invoker.invoke(this, handler, att, null, e);
            return null;
        }
        if (this.remoteAddress == null) {
            throw new NotYetConnectedException();
        }
        boolean hasSpaceToRead = isScatteringRead || dst.hasRemaining();
        boolean shutdown = false;
        Object object = this.readLock;
        synchronized (object) {
            if (this.readKilled) {
                throw new IllegalStateException("Reading not allowed due to timeout or cancellation");
            }
            if (this.reading) {
                throw new ReadPendingException();
            }
            if (this.readShutdown) {
                shutdown = true;
            } else if (hasSpaceToRead) {
                this.reading = true;
            }
        }
        if (shutdown || !hasSpaceToRead) {
            Number result = isScatteringRead ? (Number)(shutdown ? Long.valueOf(-1L) : Long.valueOf(0L)) : (Number)(shutdown ? -1 : 0);
            if (handler == null) {
                return CompletedFuture.withResult(result);
            }
            Invoker.invoke(this, handler, att, result, null);
            return null;
        }
        return this.implRead(isScatteringRead, dst, dsts, timeout, unit, att, handler);
    }

    @Override
    public final Future<Integer> read(ByteBuffer dst) {
        if (dst.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        return this.read(false, dst, null, 0L, TimeUnit.MILLISECONDS, null, null);
    }

    @Override
    public final <A> void read(ByteBuffer dst, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
        if (handler == null) {
            throw new NullPointerException("'handler' is null");
        }
        if (dst.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        this.read(false, dst, null, timeout, unit, attachment, handler);
    }

    @Override
    public final <A> void read(ByteBuffer[] dsts, int offset, int length, long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler) {
        if (handler == null) {
            throw new NullPointerException("'handler' is null");
        }
        if (offset < 0 || length < 0 || offset > dsts.length - length) {
            throw new IndexOutOfBoundsException();
        }
        ByteBuffer[] bufs = Util.subsequence(dsts, offset, length);
        for (int i = 0; i < bufs.length; ++i) {
            if (!bufs[i].isReadOnly()) continue;
            throw new IllegalArgumentException("Read-only buffer");
        }
        this.read(true, null, bufs, timeout, unit, attachment, handler);
    }

    abstract <V extends Number, A> Future<V> implWrite(boolean var1, ByteBuffer var2, ByteBuffer[] var3, long var4, TimeUnit var6, A var7, CompletionHandler<V, ? super A> var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V extends Number, A> Future<V> write(boolean isGatheringWrite, ByteBuffer src, ByteBuffer[] srcs, long timeout, TimeUnit unit, A att, CompletionHandler<V, ? super A> handler) {
        boolean hasDataToWrite = isGatheringWrite || src.hasRemaining();
        boolean closed = false;
        if (this.isOpen()) {
            if (this.remoteAddress == null) {
                throw new NotYetConnectedException();
            }
            Object object = this.writeLock;
            synchronized (object) {
                if (this.writeKilled) {
                    throw new IllegalStateException("Writing not allowed due to timeout or cancellation");
                }
                if (this.writing) {
                    throw new WritePendingException();
                }
                if (this.writeShutdown) {
                    closed = true;
                } else if (hasDataToWrite) {
                    this.writing = true;
                }
            }
        } else {
            closed = true;
        }
        if (closed) {
            ClosedChannelException e = new ClosedChannelException();
            if (handler == null) {
                return CompletedFuture.withFailure(e);
            }
            Invoker.invoke(this, handler, att, null, e);
            return null;
        }
        if (!hasDataToWrite) {
            Number result;
            Number number = result = isGatheringWrite ? (Number)0L : (Number)0;
            if (handler == null) {
                return CompletedFuture.withResult(result);
            }
            Invoker.invoke(this, handler, att, result, null);
            return null;
        }
        return this.implWrite(isGatheringWrite, src, srcs, timeout, unit, att, handler);
    }

    @Override
    public final Future<Integer> write(ByteBuffer src) {
        return this.write(false, src, null, 0L, TimeUnit.MILLISECONDS, null, null);
    }

    @Override
    public final <A> void write(ByteBuffer src, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
        if (handler == null) {
            throw new NullPointerException("'handler' is null");
        }
        this.write(false, src, null, timeout, unit, attachment, handler);
    }

    @Override
    public final <A> void write(ByteBuffer[] srcs, int offset, int length, long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler) {
        if (handler == null) {
            throw new NullPointerException("'handler' is null");
        }
        if (offset < 0 || length < 0 || offset > srcs.length - length) {
            throw new IndexOutOfBoundsException();
        }
        srcs = Util.subsequence(srcs, offset, length);
        this.write(true, null, srcs, timeout, unit, attachment, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AsynchronousSocketChannel bind(SocketAddress local) throws IOException {
        try {
            this.begin();
            Object object = this.stateLock;
            synchronized (object) {
                if (this.state == 1) {
                    throw new ConnectionPendingException();
                }
                if (this.localAddress != null) {
                    throw new AlreadyBoundException();
                }
                InetSocketAddress isa = local == null ? new InetSocketAddress(0) : Net.checkAddress(local);
                NetHooks.beforeTcpBind(this.fd, isa.getAddress(), isa.getPort());
                Net.bind(this.fd, isa.getAddress(), isa.getPort());
                this.localAddress = Net.localAddress(this.fd);
            }
        }
        finally {
            this.end();
        }
        return this;
    }

    @Override
    public final SocketAddress getLocalAddress() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.localAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> AsynchronousSocketChannel setOption(SocketOption<T> name, T value) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(name)) {
            throw new UnsupportedOperationException("'" + name + "' not supported");
        }
        try {
            this.begin();
            if (this.writeShutdown) {
                throw new IOException("Connection has been shutdown for writing");
            }
            Net.setSocketOption(this.fd, Net.UNSPEC, name, value);
            AsynchronousSocketChannelImpl asynchronousSocketChannelImpl = this;
            return asynchronousSocketChannelImpl;
        }
        finally {
            this.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> T getOption(SocketOption<T> name) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(name)) {
            throw new UnsupportedOperationException("'" + name + "' not supported");
        }
        try {
            this.begin();
            Object object = Net.getSocketOption(this.fd, Net.UNSPEC, name);
            return (T)object;
        }
        finally {
            this.end();
        }
    }

    @Override
    public final Set<SocketOption<?>> supportedOptions() {
        return DefaultOptionsHolder.defaultOptions;
    }

    @Override
    public final SocketAddress getRemoteAddress() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.remoteAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AsynchronousSocketChannel shutdownInput() throws IOException {
        try {
            this.begin();
            if (this.remoteAddress == null) {
                throw new NotYetConnectedException();
            }
            Object object = this.readLock;
            synchronized (object) {
                if (!this.readShutdown) {
                    Net.shutdown(this.fd, 0);
                    this.readShutdown = true;
                }
            }
        }
        finally {
            this.end();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AsynchronousSocketChannel shutdownOutput() throws IOException {
        try {
            this.begin();
            if (this.remoteAddress == null) {
                throw new NotYetConnectedException();
            }
            Object object = this.writeLock;
            synchronized (object) {
                if (!this.writeShutdown) {
                    Net.shutdown(this.fd, 1);
                    this.writeShutdown = true;
                }
            }
        }
        finally {
            this.end();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append('[');
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                sb.append("closed");
            } else {
                switch (this.state) {
                    case 0: {
                        sb.append("unconnected");
                        break;
                    }
                    case 1: {
                        sb.append("connection-pending");
                        break;
                    }
                    case 2: {
                        sb.append("connected");
                        if (this.readShutdown) {
                            sb.append(" ishut");
                        }
                        if (!this.writeShutdown) break;
                        sb.append(" oshut");
                    }
                }
                if (this.localAddress != null) {
                    sb.append(" local=");
                    sb.append(this.localAddress.toString());
                }
                if (this.remoteAddress != null) {
                    sb.append(" remote=");
                    sb.append(this.remoteAddress.toString());
                }
            }
        }
        sb.append(']');
        return sb.toString();
    }

    private static class DefaultOptionsHolder {
        static final Set<SocketOption<?>> defaultOptions = DefaultOptionsHolder.defaultOptions();

        private DefaultOptionsHolder() {
        }

        private static Set<SocketOption<?>> defaultOptions() {
            HashSet<SocketOption<Comparable<Integer>>> set = new HashSet<SocketOption<Comparable<Integer>>>(5);
            set.add(StandardSocketOptions.SO_SNDBUF);
            set.add(StandardSocketOptions.SO_RCVBUF);
            set.add(StandardSocketOptions.SO_KEEPALIVE);
            set.add(StandardSocketOptions.SO_REUSEADDR);
            set.add(StandardSocketOptions.TCP_NODELAY);
            return Collections.unmodifiableSet(set);
        }
    }
}

