/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.VMOption;
import java.io.InvalidObjectException;
import java.lang.management.LockInfo;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryUsage;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import sun.management.LockDataConverter;
import sun.management.MemoryNotifInfoCompositeData;
import sun.management.MemoryUsageCompositeData;
import sun.management.MonitorInfoCompositeData;
import sun.management.ThreadInfoCompositeData;
import sun.management.VMOptionCompositeData;

public abstract class MappedMXBeanType {
    private static final WeakHashMap<Type, MappedMXBeanType> convertedTypes;
    boolean isBasicType = false;
    OpenType openType = inProgress;
    Class mappedTypeClass;
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String[] mapIndexNames;
    private static final String[] mapItemNames;
    private static final Class<?> COMPOSITE_DATA_CLASS;
    private static final OpenType inProgress;
    private static final OpenType[] simpleTypes;

    static synchronized MappedMXBeanType newMappedType(Type javaType) throws OpenDataException {
        MappedMXBeanType mt = null;
        if (javaType instanceof Class) {
            Class c = (Class)javaType;
            mt = c.isEnum() ? new EnumMXBeanType(c) : (c.isArray() ? new ArrayMXBeanType(c) : new CompositeDataMXBeanType(c));
        } else if (javaType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)javaType;
            Type rawType = pt.getRawType();
            if (rawType instanceof Class) {
                Class rc = (Class)rawType;
                if (rc == List.class) {
                    mt = new ListMXBeanType(pt);
                } else if (rc == Map.class) {
                    mt = new MapMXBeanType(pt);
                }
            }
        } else if (javaType instanceof GenericArrayType) {
            GenericArrayType t = (GenericArrayType)javaType;
            mt = new GenericArrayMXBeanType(t);
        }
        if (mt == null) {
            throw new OpenDataException(javaType + " is not a supported MXBean type.");
        }
        convertedTypes.put(javaType, mt);
        return mt;
    }

    static synchronized MappedMXBeanType newBasicType(Class c, OpenType ot) throws OpenDataException {
        BasicMXBeanType mt = new BasicMXBeanType(c, ot);
        convertedTypes.put(c, mt);
        return mt;
    }

    static synchronized MappedMXBeanType getMappedType(Type t) throws OpenDataException {
        MappedMXBeanType mt = convertedTypes.get(t);
        if (mt == null) {
            mt = MappedMXBeanType.newMappedType(t);
        }
        if (mt.getOpenType() instanceof InProgress) {
            throw new OpenDataException("Recursive data structure");
        }
        return mt;
    }

    public static synchronized OpenType toOpenType(Type t) throws OpenDataException {
        MappedMXBeanType mt = MappedMXBeanType.getMappedType(t);
        return mt.getOpenType();
    }

    public static Object toJavaTypeData(Object openData, Type t) throws OpenDataException, InvalidObjectException {
        if (openData == null) {
            return null;
        }
        MappedMXBeanType mt = MappedMXBeanType.getMappedType(t);
        return mt.toJavaTypeData(openData);
    }

    public static Object toOpenTypeData(Object data, Type t) throws OpenDataException {
        if (data == null) {
            return null;
        }
        MappedMXBeanType mt = MappedMXBeanType.getMappedType(t);
        return mt.toOpenTypeData(data);
    }

    OpenType getOpenType() {
        return this.openType;
    }

    boolean isBasicType() {
        return this.isBasicType;
    }

    String getTypeName() {
        return this.getMappedTypeClass().getName();
    }

    Class getMappedTypeClass() {
        return this.mappedTypeClass;
    }

    abstract Type getJavaType();

    abstract String getName();

    abstract Object toOpenTypeData(Object var1) throws OpenDataException;

    abstract Object toJavaTypeData(Object var1) throws OpenDataException, InvalidObjectException;

    private static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    static {
        InProgress t;
        convertedTypes = new WeakHashMap();
        mapIndexNames = new String[]{KEY};
        mapItemNames = new String[]{KEY, VALUE};
        COMPOSITE_DATA_CLASS = CompositeData.class;
        try {
            t = new InProgress();
        }
        catch (OpenDataException e) {
            throw new AssertionError((Object)e);
        }
        inProgress = t;
        simpleTypes = new OpenType[]{SimpleType.BIGDECIMAL, SimpleType.BIGINTEGER, SimpleType.BOOLEAN, SimpleType.BYTE, SimpleType.CHARACTER, SimpleType.DATE, SimpleType.DOUBLE, SimpleType.FLOAT, SimpleType.INTEGER, SimpleType.LONG, SimpleType.OBJECTNAME, SimpleType.SHORT, SimpleType.STRING, SimpleType.VOID};
        try {
            for (int i = 0; i < simpleTypes.length; ++i) {
                Class<?> c;
                OpenType t2 = simpleTypes[i];
                try {
                    c = Class.forName(t2.getClassName(), false, String.class.getClassLoader());
                    MappedMXBeanType.newBasicType(c, t2);
                }
                catch (ClassNotFoundException e) {
                    throw new AssertionError((Object)e);
                }
                catch (OpenDataException e) {
                    throw new AssertionError((Object)e);
                }
                if (!c.getName().startsWith("java.lang.")) continue;
                try {
                    Field typeField = c.getField("TYPE");
                    Class primitiveType = (Class)typeField.get(null);
                    MappedMXBeanType.newBasicType(primitiveType, t2);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
        catch (OpenDataException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class InProgress
    extends OpenType {
        private static final String description = "Marker to detect recursive type use -- internal use only!";
        private static final long serialVersionUID = -3413063475064374490L;

        InProgress() throws OpenDataException {
            super("java.lang.String", "java.lang.String", description);
        }

        @Override
        public String toString() {
            return description;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object o) {
            return false;
        }

        @Override
        public boolean isValue(Object o) {
            return false;
        }
    }

    static class CompositeDataMXBeanType
    extends MappedMXBeanType {
        final Class<?> javaClass;
        final boolean isCompositeData;
        Method fromMethod = null;

        CompositeDataMXBeanType(Class c) throws OpenDataException {
            this.javaClass = c;
            this.mappedTypeClass = COMPOSITE_DATA_CLASS;
            try {
                this.fromMethod = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                    @Override
                    public Method run() throws NoSuchMethodException {
                        return CompositeDataMXBeanType.this.javaClass.getMethod("from", COMPOSITE_DATA_CLASS);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                // empty catch block
            }
            if (COMPOSITE_DATA_CLASS.isAssignableFrom(c)) {
                this.isCompositeData = true;
                this.openType = null;
            } else {
                this.isCompositeData = false;
                Method[] methods = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

                    @Override
                    public Method[] run() {
                        return CompositeDataMXBeanType.this.javaClass.getMethods();
                    }
                });
                ArrayList<String> names = new ArrayList<String>();
                ArrayList<OpenType> types = new ArrayList<OpenType>();
                for (int i = 0; i < methods.length; ++i) {
                    String rest;
                    Method method = methods[i];
                    String name = method.getName();
                    Type type = method.getGenericReturnType();
                    if (name.startsWith("get")) {
                        rest = name.substring(3);
                    } else {
                        if (!name.startsWith("is") || !(type instanceof Class) || (Class)type != Boolean.TYPE) continue;
                        rest = name.substring(2);
                    }
                    if (rest.equals("") || method.getParameterTypes().length > 0 || type == Void.TYPE || rest.equals("Class")) continue;
                    names.add(MappedMXBeanType.decapitalize(rest));
                    types.add(CompositeDataMXBeanType.toOpenType(type));
                }
                String[] nameArray = names.toArray(new String[0]);
                this.openType = new CompositeType(c.getName(), c.getName(), nameArray, nameArray, types.toArray(new OpenType[0]));
            }
        }

        @Override
        Type getJavaType() {
            return this.javaClass;
        }

        @Override
        String getName() {
            return this.javaClass.getName();
        }

        @Override
        Object toOpenTypeData(Object data) throws OpenDataException {
            if (data instanceof MemoryUsage) {
                return MemoryUsageCompositeData.toCompositeData((MemoryUsage)data);
            }
            if (data instanceof ThreadInfo) {
                return ThreadInfoCompositeData.toCompositeData((ThreadInfo)data);
            }
            if (data instanceof LockInfo) {
                if (data instanceof MonitorInfo) {
                    return MonitorInfoCompositeData.toCompositeData((MonitorInfo)data);
                }
                return LockDataConverter.toLockInfoCompositeData((LockInfo)data);
            }
            if (data instanceof MemoryNotificationInfo) {
                return MemoryNotifInfoCompositeData.toCompositeData((MemoryNotificationInfo)data);
            }
            if (data instanceof VMOption) {
                return VMOptionCompositeData.toCompositeData((VMOption)data);
            }
            if (this.isCompositeData) {
                CompositeData cd = (CompositeData)data;
                CompositeType ct = cd.getCompositeType();
                String[] itemNames = ct.keySet().toArray(new String[0]);
                Object[] itemValues = cd.getAll(itemNames);
                return new CompositeDataSupport(ct, itemNames, itemValues);
            }
            throw new OpenDataException(this.javaClass.getName() + " is not supported for platform MXBeans");
        }

        @Override
        Object toJavaTypeData(Object data) throws OpenDataException, InvalidObjectException {
            if (this.fromMethod == null) {
                throw new AssertionError((Object)"Does not support data conversion");
            }
            try {
                return this.fromMethod.invoke(null, data);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                OpenDataException ode = new OpenDataException("Failed to invoke " + this.fromMethod.getName() + " to convert CompositeData " + " to " + this.javaClass.getName());
                ode.initCause(e);
                throw ode;
            }
        }
    }

    static class MapMXBeanType
    extends MappedMXBeanType {
        final ParameterizedType javaType;
        final MappedMXBeanType keyType;
        final MappedMXBeanType valueType;
        final String typeName;

        MapMXBeanType(ParameterizedType pt) throws OpenDataException {
            this.javaType = pt;
            Type[] argTypes = pt.getActualTypeArguments();
            assert (argTypes.length == 2);
            this.keyType = MapMXBeanType.getMappedType(argTypes[0]);
            this.valueType = MapMXBeanType.getMappedType(argTypes[1]);
            this.typeName = "Map<" + this.keyType.getName() + "," + this.valueType.getName() + ">";
            OpenType[] mapItemTypes = new OpenType[]{this.keyType.getOpenType(), this.valueType.getOpenType()};
            CompositeType rowType = new CompositeType(this.typeName, this.typeName, mapItemNames, mapItemNames, mapItemTypes);
            this.openType = new TabularType(this.typeName, this.typeName, rowType, mapIndexNames);
            this.mappedTypeClass = TabularData.class;
        }

        @Override
        Type getJavaType() {
            return this.javaType;
        }

        @Override
        String getName() {
            return this.typeName;
        }

        @Override
        Object toOpenTypeData(Object data) throws OpenDataException {
            Map map = (Map)data;
            TabularType tabularType = (TabularType)this.openType;
            TabularDataSupport table = new TabularDataSupport(tabularType);
            CompositeType rowType = tabularType.getRowType();
            for (Map.Entry entry : map.entrySet()) {
                Object key = this.keyType.toOpenTypeData(entry.getKey());
                Object value = this.valueType.toOpenTypeData(entry.getValue());
                CompositeDataSupport row = new CompositeDataSupport(rowType, mapItemNames, new Object[]{key, value});
                table.put(row);
            }
            return table;
        }

        @Override
        Object toJavaTypeData(Object data) throws OpenDataException, InvalidObjectException {
            TabularData td = (TabularData)data;
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            for (CompositeData row : td.values()) {
                Object key = this.keyType.toJavaTypeData(row.get(MappedMXBeanType.KEY));
                Object value = this.valueType.toJavaTypeData(row.get(MappedMXBeanType.VALUE));
                result.put(key, value);
            }
            return result;
        }
    }

    static class ListMXBeanType
    extends MappedMXBeanType {
        final ParameterizedType javaType;
        final MappedMXBeanType paramType;
        final String typeName;

        ListMXBeanType(ParameterizedType pt) throws OpenDataException {
            this.javaType = pt;
            Type[] argTypes = pt.getActualTypeArguments();
            assert (argTypes.length == 1);
            if (!(argTypes[0] instanceof Class)) {
                throw new OpenDataException("Element Type for " + pt + " not supported");
            }
            Class et = (Class)argTypes[0];
            if (et.isArray()) {
                throw new OpenDataException("Element Type for " + pt + " not supported");
            }
            this.paramType = ListMXBeanType.getMappedType(et);
            this.typeName = "List<" + this.paramType.getName() + ">";
            try {
                this.mappedTypeClass = Class.forName("[L" + this.paramType.getTypeName() + ";");
            }
            catch (ClassNotFoundException e) {
                OpenDataException ode = new OpenDataException("Array class not found");
                ode.initCause(e);
                throw ode;
            }
            this.openType = new ArrayType(1, this.paramType.getOpenType());
        }

        @Override
        Type getJavaType() {
            return this.javaType;
        }

        @Override
        String getName() {
            return this.typeName;
        }

        @Override
        Object toOpenTypeData(Object data) throws OpenDataException {
            List list = (List)data;
            Object[] openArray = (Object[])Array.newInstance(this.paramType.getMappedTypeClass(), list.size());
            int i = 0;
            for (Object o : list) {
                openArray[i++] = this.paramType.toOpenTypeData(o);
            }
            return openArray;
        }

        @Override
        Object toJavaTypeData(Object data) throws OpenDataException, InvalidObjectException {
            Object[] openArray = (Object[])data;
            ArrayList<Object> result = new ArrayList<Object>(openArray.length);
            for (Object o : openArray) {
                result.add(this.paramType.toJavaTypeData(o));
            }
            return result;
        }
    }

    static class GenericArrayMXBeanType
    extends ArrayMXBeanType {
        final GenericArrayType gtype;

        GenericArrayMXBeanType(GenericArrayType gat) throws OpenDataException {
            this.gtype = gat;
            this.componentType = GenericArrayMXBeanType.getMappedType(gat.getGenericComponentType());
            StringBuilder className = new StringBuilder();
            Type elementType = gat;
            int dim = 0;
            while (elementType instanceof GenericArrayType) {
                className.append('[');
                GenericArrayType et = elementType;
                elementType = et.getGenericComponentType();
                ++dim;
            }
            this.baseElementType = GenericArrayMXBeanType.getMappedType(elementType);
            if (elementType instanceof Class && ((Class)elementType).isPrimitive()) {
                className = new StringBuilder(gat.toString());
            } else {
                className.append("L" + this.baseElementType.getTypeName() + ";");
            }
            try {
                this.mappedTypeClass = Class.forName(className.toString());
            }
            catch (ClassNotFoundException e) {
                OpenDataException ode = new OpenDataException("Cannot obtain array class");
                ode.initCause(e);
                throw ode;
            }
            this.openType = new ArrayType(dim, this.baseElementType.getOpenType());
        }

        @Override
        Type getJavaType() {
            return this.gtype;
        }

        @Override
        String getName() {
            return this.gtype.toString();
        }
    }

    static class ArrayMXBeanType
    extends MappedMXBeanType {
        final Class arrayClass;
        protected MappedMXBeanType componentType;
        protected MappedMXBeanType baseElementType;

        ArrayMXBeanType(Class c) throws OpenDataException {
            this.arrayClass = c;
            this.componentType = ArrayMXBeanType.getMappedType(c.getComponentType());
            StringBuilder className = new StringBuilder();
            Class<?> et = c;
            int dim = 0;
            while (et.isArray()) {
                className.append('[');
                et = et.getComponentType();
                ++dim;
            }
            this.baseElementType = ArrayMXBeanType.getMappedType(et);
            if (et.isPrimitive()) {
                className = new StringBuilder(c.getName());
            } else {
                className.append("L" + this.baseElementType.getTypeName() + ";");
            }
            try {
                this.mappedTypeClass = Class.forName(className.toString());
            }
            catch (ClassNotFoundException e) {
                OpenDataException ode = new OpenDataException("Cannot obtain array class");
                ode.initCause(e);
                throw ode;
            }
            this.openType = new ArrayType(dim, this.baseElementType.getOpenType());
        }

        protected ArrayMXBeanType() {
            this.arrayClass = null;
        }

        @Override
        Type getJavaType() {
            return this.arrayClass;
        }

        @Override
        String getName() {
            return this.arrayClass.getName();
        }

        @Override
        Object toOpenTypeData(Object data) throws OpenDataException {
            if (this.baseElementType.isBasicType()) {
                return data;
            }
            Object[] array = (Object[])data;
            Object[] openArray = (Object[])Array.newInstance(this.componentType.getMappedTypeClass(), array.length);
            int i = 0;
            for (Object o : array) {
                openArray[i] = o == null ? null : this.componentType.toOpenTypeData(o);
                ++i;
            }
            return openArray;
        }

        @Override
        Object toJavaTypeData(Object data) throws OpenDataException, InvalidObjectException {
            if (this.baseElementType.isBasicType()) {
                return data;
            }
            Object[] openArray = (Object[])data;
            Object[] array = (Object[])Array.newInstance((Class)this.componentType.getJavaType(), openArray.length);
            int i = 0;
            for (Object o : openArray) {
                array[i] = o == null ? null : this.componentType.toJavaTypeData(o);
                ++i;
            }
            return array;
        }
    }

    static class EnumMXBeanType
    extends MappedMXBeanType {
        final Class enumClass;

        EnumMXBeanType(Class c) {
            this.enumClass = c;
            this.openType = SimpleType.STRING;
            this.mappedTypeClass = String.class;
        }

        @Override
        Type getJavaType() {
            return this.enumClass;
        }

        @Override
        String getName() {
            return this.enumClass.getName();
        }

        @Override
        Object toOpenTypeData(Object data) throws OpenDataException {
            return ((Enum)data).name();
        }

        @Override
        Object toJavaTypeData(Object data) throws OpenDataException, InvalidObjectException {
            try {
                return Enum.valueOf(this.enumClass, (String)data);
            }
            catch (IllegalArgumentException e) {
                InvalidObjectException ioe = new InvalidObjectException("Enum constant named " + (String)data + " is missing");
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    static class BasicMXBeanType
    extends MappedMXBeanType {
        final Class basicType;

        BasicMXBeanType(Class c, OpenType openType) {
            this.basicType = c;
            this.openType = openType;
            this.mappedTypeClass = c;
            this.isBasicType = true;
        }

        @Override
        Type getJavaType() {
            return this.basicType;
        }

        @Override
        String getName() {
            return this.basicType.getName();
        }

        @Override
        Object toOpenTypeData(Object data) throws OpenDataException {
            return data;
        }

        @Override
        Object toJavaTypeData(Object data) throws OpenDataException, InvalidObjectException {
            return data;
        }
    }
}

