/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.datatransfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ClassLoaderObjectInputStream
extends ObjectInputStream {
    private final Map<Set<String>, ClassLoader> map;

    public ClassLoaderObjectInputStream(InputStream is, Map<Set<String>, ClassLoader> map) throws IOException {
        super(is);
        if (map == null) {
            throw new NullPointerException("Null map");
        }
        this.map = map;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        String className = classDesc.getName();
        HashSet<String> s = new HashSet<String>(1);
        s.add(className);
        ClassLoader classLoader = this.map.get(s);
        return Class.forName(className, false, classLoader);
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        HashSet<String> s = new HashSet<String>(interfaces.length);
        for (int i = 0; i < interfaces.length; ++i) {
            s.add(interfaces[i]);
        }
        ClassLoader classLoader = this.map.get(s);
        ClassLoader nonPublicLoader = null;
        boolean hasNonPublicInterface = false;
        Class[] classObjs = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> cl = Class.forName(interfaces[i], false, classLoader);
            if ((cl.getModifiers() & 1) == 0) {
                if (hasNonPublicInterface) {
                    if (nonPublicLoader != cl.getClassLoader()) {
                        throw new IllegalAccessError("conflicting non-public interface class loaders");
                    }
                } else {
                    nonPublicLoader = cl.getClassLoader();
                    hasNonPublicInterface = true;
                }
            }
            classObjs[i] = cl;
        }
        try {
            return Proxy.getProxyClass(hasNonPublicInterface ? nonPublicLoader : classLoader, classObjs);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }
}

