/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.HashMap;
import sun.awt.SunToolkit;
import sun.awt.X11.Native;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XEmbedChildProxy;
import sun.awt.X11.XEmbedChildProxyPeer;
import sun.awt.X11.XEmbedHelper;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XKeyEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XlibWrapper;

public class XEmbeddingContainer
extends XEmbedHelper
implements XEventDispatcher {
    HashMap children = new HashMap();
    XWindow embedder;
    static Field bdata;

    XEmbeddingContainer() {
    }

    void install(XWindow embedder) {
        this.embedder = embedder;
        XToolkit.addEventDispatcher(embedder.getWindow(), this);
    }

    void deinstall() {
        XToolkit.removeEventDispatcher(this.embedder.getWindow(), this);
    }

    void add(long child) {
        if (this.checkXEmbed(child)) {
            Component proxy = this.createChildProxy(child);
            ((Container)this.embedder.getTarget()).add("Center", proxy);
            if (proxy.getPeer() != null) {
                this.children.put(child, proxy.getPeer());
            }
        }
    }

    Component createChildProxy(long child) {
        return new XEmbedChildProxy(this, child);
    }

    void notifyChildEmbedded(long child) {
        this.sendMessage(child, 0, this.embedder.getWindow(), 0L, 0L);
    }

    void childResized(Component child) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkXEmbed(long child) {
        long data = unsafe.allocateMemory(8L);
        try {
            if (XEmbedInfo.getAtomData(child, data, 2)) {
                int protocol = unsafe.getInt(data);
                int flags = unsafe.getInt(data);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            unsafe.freeMemory(data);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detachChild(long child) {
        XToolkit.awtLock();
        try {
            XlibWrapper.XUnmapWindow(XToolkit.getDisplay(), child);
            XlibWrapper.XReparentWindow(XToolkit.getDisplay(), child, XToolkit.getDefaultRootWindow(), 0, 0);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    void focusGained(long child) {
        this.sendMessage(child, 4, 0L, 0L, 0L);
    }

    void focusLost(long child) {
        this.sendMessage(child, 5);
    }

    XEmbedChildProxyPeer getChild(long child) {
        return (XEmbedChildProxyPeer)this.children.get(child);
    }

    public void handleClientMessage(XEvent xev) {
        XClientMessageEvent msg = xev.get_xclient();
        if (msg.get_message_type() == XEmbed.getAtom()) {
            switch ((int)msg.get_data(1)) {
                case 3: {
                    long child = msg.get_data(2);
                    this.getChild(child).requestXEmbedFocus();
                }
            }
        }
    }

    @Override
    public void dispatchEvent(XEvent xev) {
        switch (xev.get_type()) {
            case 33: {
                this.handleClientMessage(xev);
            }
        }
    }

    byte[] getBData(KeyEvent e) {
        try {
            if (bdata == null) {
                bdata = SunToolkit.getField(AWTEvent.class, "bdata");
            }
            return (byte[])bdata.get(e);
        }
        catch (IllegalAccessException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forwardKeyEvent(long child, KeyEvent e) {
        byte[] bdata = this.getBData(e);
        long data = Native.toData(bdata);
        if (data == 0L) {
            return;
        }
        XKeyEvent ke = new XKeyEvent(data);
        ke.set_window(child);
        XToolkit.awtLock();
        try {
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), child, false, 0L, data);
        }
        finally {
            XToolkit.awtUnlock();
        }
        XlibWrapper.unsafe.freeMemory(data);
    }
}

