/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.mbeanserver.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.management.Descriptor;
import javax.management.ImmutableDescriptor;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.XMLParseException;
import sun.reflect.misc.ReflectUtil;

public class DescriptorSupport
implements Descriptor {
    private static final long oldSerialVersionUID = 8071560848919417985L;
    private static final long newSerialVersionUID = -6292969195866300415L;
    private static final ObjectStreamField[] oldSerialPersistentFields;
    private static final ObjectStreamField[] newSerialPersistentFields;
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static final String serialForm;
    private transient SortedMap<String, Object> descriptorMap;
    private static final String currClass = "DescriptorSupport";
    private static final String[] entities;
    private static final Map<String, Character> entityToCharMap;
    private static final String[] charToEntityMap;

    public DescriptorSupport() {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "DescriptorSupport()", "Constructor");
        }
        this.init(null);
    }

    public DescriptorSupport(int initNumFields) throws MBeanException, RuntimeOperationsException {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "Descriptor(initNumFields = " + initNumFields + ")", "Constructor");
        }
        if (initNumFields <= 0) {
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "Descriptor(initNumFields)", "Illegal arguments: initNumFields <= 0");
            }
            String msg = "Descriptor field limit invalid: " + initNumFields;
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            throw new RuntimeOperationsException(iae, msg);
        }
        this.init(null);
    }

    public DescriptorSupport(DescriptorSupport inDescr) {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "Descriptor(Descriptor)", "Constructor");
        }
        if (inDescr == null) {
            this.init(null);
        } else {
            this.init(inDescr.descriptorMap);
        }
    }

    public DescriptorSupport(String inStr) throws MBeanException, RuntimeOperationsException, XMLParseException {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "Descriptor(String = '" + inStr + "')", "Constructor");
        }
        if (inStr == null) {
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "Descriptor(String = null)", "Illegal arguments");
            }
            String msg = "String in parameter is null";
            IllegalArgumentException iae = new IllegalArgumentException("String in parameter is null");
            throw new RuntimeOperationsException(iae, "String in parameter is null");
        }
        String lowerInStr = inStr.toLowerCase();
        if (!lowerInStr.startsWith("<descriptor>") || !lowerInStr.endsWith("</descriptor>")) {
            throw new XMLParseException("No <descriptor>, </descriptor> pair");
        }
        this.init(null);
        StringTokenizer st = new StringTokenizer(inStr, "<> \t\n\r\f");
        boolean inFld = false;
        boolean inDesc = false;
        String fieldName = null;
        String fieldValue = null;
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equalsIgnoreCase("FIELD")) {
                inFld = true;
                continue;
            }
            if (tok.equalsIgnoreCase("/FIELD")) {
                if (fieldName != null && fieldValue != null) {
                    fieldName = fieldName.substring(fieldName.indexOf(34) + 1, fieldName.lastIndexOf(34));
                    Object fieldValueObject = DescriptorSupport.parseQuotedFieldValue(fieldValue);
                    this.setField(fieldName, fieldValueObject);
                }
                fieldName = null;
                fieldValue = null;
                inFld = false;
                continue;
            }
            if (tok.equalsIgnoreCase("DESCRIPTOR")) {
                inDesc = true;
                continue;
            }
            if (tok.equalsIgnoreCase("/DESCRIPTOR")) {
                inDesc = false;
                fieldName = null;
                fieldValue = null;
                inFld = false;
                continue;
            }
            if (!inFld || !inDesc) continue;
            int eq_separator = tok.indexOf("=");
            if (eq_separator > 0) {
                String kwPart = tok.substring(0, eq_separator);
                String valPart = tok.substring(eq_separator + 1);
                if (kwPart.equalsIgnoreCase("NAME")) {
                    fieldName = valPart;
                    continue;
                }
                if (kwPart.equalsIgnoreCase("VALUE")) {
                    fieldValue = valPart;
                    continue;
                }
                String msg = "Expected `name' or `value', got `" + tok + "'";
                throw new XMLParseException(msg);
            }
            String msg = "Expected `keyword=value', got `" + tok + "'";
            throw new XMLParseException(msg);
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "Descriptor(XMLString)", "Exit");
        }
    }

    public DescriptorSupport(String[] fieldNames, Object[] fieldValues) throws RuntimeOperationsException {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "Descriptor(fieldNames,fieldObjects)", "Constructor");
        }
        if (fieldNames == null || fieldValues == null || fieldNames.length != fieldValues.length) {
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "Descriptor(fieldNames,fieldObjects)", "Illegal arguments");
            }
            String msg = "Null or invalid fieldNames or fieldValues";
            IllegalArgumentException iae = new IllegalArgumentException("Null or invalid fieldNames or fieldValues");
            throw new RuntimeOperationsException(iae, "Null or invalid fieldNames or fieldValues");
        }
        this.init(null);
        for (int i = 0; i < fieldNames.length; ++i) {
            this.setField(fieldNames[i], fieldValues[i]);
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "Descriptor(fieldNames,fieldObjects)", "Exit");
        }
    }

    public DescriptorSupport(String ... fields) {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "Descriptor(String... fields)", "Constructor");
        }
        this.init(null);
        if (fields == null || fields.length == 0) {
            return;
        }
        this.init(null);
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i] == null || fields[i].equals("")) continue;
            int eq_separator = fields[i].indexOf("=");
            if (eq_separator < 0) {
                if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "Descriptor(String... fields)", "Illegal arguments: field does not have '=' as a name and value separator");
                }
                String msg = "Field in invalid format: no equals sign";
                IllegalArgumentException iae = new IllegalArgumentException("Field in invalid format: no equals sign");
                throw new RuntimeOperationsException(iae, "Field in invalid format: no equals sign");
            }
            String fieldName = fields[i].substring(0, eq_separator);
            String fieldValue = null;
            if (eq_separator < fields[i].length()) {
                fieldValue = fields[i].substring(eq_separator + 1);
            }
            if (fieldName.equals("")) {
                if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "Descriptor(String... fields)", "Illegal arguments: fieldName is empty");
                }
                String msg = "Field in invalid format: no fieldName";
                IllegalArgumentException iae = new IllegalArgumentException("Field in invalid format: no fieldName");
                throw new RuntimeOperationsException(iae, "Field in invalid format: no fieldName");
            }
            this.setField(fieldName, fieldValue);
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "Descriptor(String... fields)", "Exit");
        }
    }

    private void init(Map<String, ?> initMap) {
        this.descriptorMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        if (initMap != null) {
            this.descriptorMap.putAll(initMap);
        }
    }

    @Override
    public synchronized Object getFieldValue(String fieldName) throws RuntimeOperationsException {
        if (fieldName == null || fieldName.equals("")) {
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "getFieldValue(String fieldName)", "Illegal arguments: null field name");
            }
            String msg = "Fieldname requested is null";
            IllegalArgumentException iae = new IllegalArgumentException("Fieldname requested is null");
            throw new RuntimeOperationsException(iae, "Fieldname requested is null");
        }
        Object retValue = this.descriptorMap.get(fieldName);
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "getFieldValue(String fieldName = " + fieldName + ")", "Returns '" + retValue + "'");
        }
        return retValue;
    }

    @Override
    public synchronized void setField(String fieldName, Object fieldValue) throws RuntimeOperationsException {
        if (fieldName == null || fieldName.equals("")) {
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "setField(fieldName,fieldValue)", "Illegal arguments: null or empty field name");
            }
            String msg = "Field name to be set is null or empty";
            IllegalArgumentException iae = new IllegalArgumentException("Field name to be set is null or empty");
            throw new RuntimeOperationsException(iae, "Field name to be set is null or empty");
        }
        if (!this.validateField(fieldName, fieldValue)) {
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "setField(fieldName,fieldValue)", "Illegal arguments");
            }
            String msg = "Field value invalid: " + fieldName + "=" + fieldValue;
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            throw new RuntimeOperationsException(iae, msg);
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "setField(fieldName,fieldValue)", "Entry: setting '" + fieldName + "' to '" + fieldValue + "'");
        }
        this.descriptorMap.put(fieldName, fieldValue);
    }

    @Override
    public synchronized String[] getFields() {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "getFields()", "Entry");
        }
        int numberOfEntries = this.descriptorMap.size();
        String[] responseFields = new String[numberOfEntries];
        Set<Map.Entry<String, Object>> returnedSet = this.descriptorMap.entrySet();
        int i = 0;
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "getFields()", "Returning " + numberOfEntries + " fields");
        }
        for (Map.Entry<String, Object> currElement : returnedSet) {
            if (currElement == null) {
                if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "getFields()", "Element is null");
                }
            } else {
                Object currValue = currElement.getValue();
                responseFields[i] = currValue == null ? currElement.getKey() + "=" : (currValue instanceof String ? currElement.getKey() + "=" + currValue.toString() : currElement.getKey() + "=(" + currValue.toString() + ")");
            }
            ++i;
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "getFields()", "Exit");
        }
        return responseFields;
    }

    @Override
    public synchronized String[] getFieldNames() {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "getFieldNames()", "Entry");
        }
        int numberOfEntries = this.descriptorMap.size();
        String[] responseFields = new String[numberOfEntries];
        Set<Map.Entry<String, Object>> returnedSet = this.descriptorMap.entrySet();
        int i = 0;
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "getFieldNames()", "Returning " + numberOfEntries + " fields");
        }
        for (Map.Entry<String, Object> currElement : returnedSet) {
            if (currElement == null || currElement.getKey() == null) {
                if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "getFieldNames()", "Field is null");
                }
            } else {
                responseFields[i] = currElement.getKey().toString();
            }
            ++i;
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "getFieldNames()", "Exit");
        }
        return responseFields;
    }

    @Override
    public synchronized Object[] getFieldValues(String ... fieldNames) {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "getFieldValues(String... fieldNames)", "Entry");
        }
        int numberOfEntries = fieldNames == null ? this.descriptorMap.size() : fieldNames.length;
        Object[] responseFields = new Object[numberOfEntries];
        int i = 0;
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "getFieldValues(String... fieldNames)", "Returning " + numberOfEntries + " fields");
        }
        if (fieldNames == null) {
            for (Object value : this.descriptorMap.values()) {
                responseFields[i++] = value;
            }
        } else {
            for (i = 0; i < fieldNames.length; ++i) {
                responseFields[i] = fieldNames[i] == null || fieldNames[i].equals("") ? null : this.getFieldValue(fieldNames[i]);
            }
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "getFieldValues(String... fieldNames)", "Exit");
        }
        return responseFields;
    }

    @Override
    public synchronized void setFields(String[] fieldNames, Object[] fieldValues) throws RuntimeOperationsException {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "setFields(fieldNames,fieldValues)", "Entry");
        }
        if (fieldNames == null || fieldValues == null || fieldNames.length != fieldValues.length) {
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "setFields(fieldNames,fieldValues)", "Illegal arguments");
            }
            String msg = "fieldNames and fieldValues are null or invalid";
            IllegalArgumentException iae = new IllegalArgumentException("fieldNames and fieldValues are null or invalid");
            throw new RuntimeOperationsException(iae, "fieldNames and fieldValues are null or invalid");
        }
        for (int i = 0; i < fieldNames.length; ++i) {
            if (fieldNames[i] == null || fieldNames[i].equals("")) {
                if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "setFields(fieldNames,fieldValues)", "Null field name encountered at element " + i);
                }
                String msg = "fieldNames is null or invalid";
                IllegalArgumentException iae = new IllegalArgumentException("fieldNames is null or invalid");
                throw new RuntimeOperationsException(iae, "fieldNames is null or invalid");
            }
            this.setField(fieldNames[i], fieldValues[i]);
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "setFields(fieldNames,fieldValues)", "Exit");
        }
    }

    @Override
    public synchronized Object clone() throws RuntimeOperationsException {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "clone()", "Entry");
        }
        return new DescriptorSupport(this);
    }

    @Override
    public synchronized void removeField(String fieldName) {
        if (fieldName == null || fieldName.equals("")) {
            return;
        }
        this.descriptorMap.remove(fieldName);
    }

    @Override
    public synchronized boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Descriptor)) {
            return false;
        }
        if (o instanceof ImmutableDescriptor) {
            return o.equals(this);
        }
        return new ImmutableDescriptor(this.descriptorMap).equals(o);
    }

    @Override
    public synchronized int hashCode() {
        int size = this.descriptorMap.size();
        return Util.hashCode(this.descriptorMap.keySet().toArray(new String[size]), this.descriptorMap.values().toArray(new Object[size]));
    }

    @Override
    public synchronized boolean isValid() throws RuntimeOperationsException {
        Set<Map.Entry<String, Object>> returnedSet;
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "isValid()", "Entry");
        }
        if ((returnedSet = this.descriptorMap.entrySet()) == null) {
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "isValid()", "Returns false (null set)");
            }
            return false;
        }
        String thisName = (String)this.getFieldValue("name");
        String thisDescType = (String)this.getFieldValue("descriptorType");
        if (thisName == null || thisDescType == null || thisName.equals("") || thisDescType.equals("")) {
            return false;
        }
        for (Map.Entry<String, Object> currElement : returnedSet) {
            if (currElement == null || currElement.getValue() == null || this.validateField(currElement.getKey().toString(), currElement.getValue().toString())) continue;
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "isValid()", "Field " + currElement.getKey() + "=" + currElement.getValue() + " is not valid");
            }
            return false;
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "isValid()", "Returns true");
        }
        return true;
    }

    private boolean validateField(String fldName, Object fldValue) {
        boolean nameOrDescriptorType;
        if (fldName == null || fldName.equals("")) {
            return false;
        }
        String SfldValue = "";
        boolean isAString = false;
        if (fldValue != null && fldValue instanceof String) {
            SfldValue = (String)fldValue;
            isAString = true;
        }
        boolean bl = nameOrDescriptorType = fldName.equalsIgnoreCase("Name") || fldName.equalsIgnoreCase("DescriptorType");
        if (nameOrDescriptorType || fldName.equalsIgnoreCase("SetMethod") || fldName.equalsIgnoreCase("GetMethod") || fldName.equalsIgnoreCase("Role") || fldName.equalsIgnoreCase("Class")) {
            if (fldValue == null || !isAString) {
                return false;
            }
            return !nameOrDescriptorType || !SfldValue.equals("");
        }
        if (fldName.equalsIgnoreCase("visibility")) {
            long v;
            if (fldValue != null && isAString) {
                v = this.toNumeric(SfldValue);
            } else if (fldValue instanceof Integer) {
                v = ((Integer)fldValue).intValue();
            } else {
                return false;
            }
            return v >= 1L && v <= 4L;
        }
        if (fldName.equalsIgnoreCase("severity")) {
            long v;
            if (fldValue != null && isAString) {
                v = this.toNumeric(SfldValue);
            } else if (fldValue instanceof Integer) {
                v = ((Integer)fldValue).intValue();
            } else {
                return false;
            }
            return v >= 0L && v <= 6L;
        }
        if (fldName.equalsIgnoreCase("PersistPolicy")) {
            return fldValue != null && isAString && (SfldValue.equalsIgnoreCase("OnUpdate") || SfldValue.equalsIgnoreCase("OnTimer") || SfldValue.equalsIgnoreCase("NoMoreOftenThan") || SfldValue.equalsIgnoreCase("Always") || SfldValue.equalsIgnoreCase("Never") || SfldValue.equalsIgnoreCase("OnUnregister"));
        }
        if (fldName.equalsIgnoreCase("PersistPeriod") || fldName.equalsIgnoreCase("CurrencyTimeLimit") || fldName.equalsIgnoreCase("LastUpdatedTimeStamp") || fldName.equalsIgnoreCase("LastReturnedTimeStamp")) {
            long v;
            if (fldValue != null && isAString) {
                v = this.toNumeric(SfldValue);
            } else if (fldValue instanceof Number) {
                v = ((Number)fldValue).longValue();
            } else {
                return false;
            }
            return v >= -1L;
        }
        if (fldName.equalsIgnoreCase("log")) {
            return fldValue instanceof Boolean || isAString && (SfldValue.equalsIgnoreCase("T") || SfldValue.equalsIgnoreCase("true") || SfldValue.equalsIgnoreCase("F") || SfldValue.equalsIgnoreCase("false"));
        }
        return true;
    }

    public synchronized String toXMLString() {
        StringBuilder buf = new StringBuilder("<Descriptor>");
        Set<Map.Entry<String, Object>> returnedSet = this.descriptorMap.entrySet();
        for (Map.Entry<String, Object> currElement : returnedSet) {
            String svalue;
            String name = currElement.getKey();
            Object value = currElement.getValue();
            String valueString = null;
            if (!(!(value instanceof String) || (svalue = (String)value).startsWith("(") && svalue.endsWith(")"))) {
                valueString = DescriptorSupport.quote(svalue);
            }
            if (valueString == null) {
                valueString = DescriptorSupport.makeFieldValue(value);
            }
            buf.append("<field name=\"").append(name).append("\" value=\"").append(valueString).append("\"></field>");
        }
        buf.append("</Descriptor>");
        return buf.toString();
    }

    private static boolean isMagic(char c) {
        return c < charToEntityMap.length && charToEntityMap[c] != null;
    }

    private static String quote(String s) {
        boolean found = false;
        for (int i = 0; i < s.length(); ++i) {
            if (!DescriptorSupport.isMagic(s.charAt(i))) continue;
            found = true;
            break;
        }
        if (!found) {
            return s;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (DescriptorSupport.isMagic(c)) {
                buf.append(charToEntityMap[c]);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private static String unquote(String s) throws XMLParseException {
        if (!s.startsWith("\"") || !s.endsWith("\"")) {
            throw new XMLParseException("Value must be quoted: <" + s + ">");
        }
        StringBuilder buf = new StringBuilder();
        int len = s.length() - 1;
        for (int i = 1; i < len; ++i) {
            Character quoted;
            int semi;
            char c = s.charAt(i);
            if (c == '&' && (semi = s.indexOf(59, i + 1)) >= 0 && (quoted = entityToCharMap.get(s.substring(i, semi + 1))) != null) {
                buf.append(quoted);
                i = semi;
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private static String makeFieldValue(Object value) {
        if (value == null) {
            return "(null)";
        }
        Class<?> valueClass = value.getClass();
        try {
            valueClass.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            String msg = "Class " + valueClass + " does not have a public " + "constructor with a single string arg";
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            throw new RuntimeOperationsException(iae, "Cannot make XML descriptor");
        }
        catch (SecurityException e) {
            // empty catch block
        }
        String quotedValueString = DescriptorSupport.quote(value.toString());
        return "(" + valueClass.getName() + "/" + quotedValueString + ")";
    }

    private static Object parseQuotedFieldValue(String s) throws XMLParseException {
        Constructor<?> constr;
        if ((s = DescriptorSupport.unquote(s)).equalsIgnoreCase("(null)")) {
            return null;
        }
        if (!s.startsWith("(") || !s.endsWith(")")) {
            return s;
        }
        int slash = s.indexOf(47);
        if (slash < 0) {
            return s.substring(1, s.length() - 1);
        }
        String className = s.substring(1, slash);
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader == null) {
                ReflectUtil.checkPackageAccess(className);
            }
            Class<?> c = Class.forName(className, false, contextClassLoader);
            constr = c.getConstructor(String.class);
        }
        catch (Exception e) {
            throw new XMLParseException(e, "Cannot parse value: <" + s + ">");
        }
        String arg = s.substring(slash + 1, s.length() - 1);
        try {
            return constr.newInstance(arg);
        }
        catch (Exception e) {
            String msg = "Cannot construct instance of " + className + " with arg: <" + s + ">";
            throw new XMLParseException(e, msg);
        }
    }

    public synchronized String toString() {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "toString()", "Entry");
        }
        String respStr = "";
        String[] fields = this.getFields();
        if (fields == null || fields.length == 0) {
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "toString()", "Empty Descriptor");
            }
            return respStr;
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "toString()", "Printing " + fields.length + " fields");
        }
        for (int i = 0; i < fields.length; ++i) {
            respStr = i == fields.length - 1 ? respStr.concat(fields[i]) : respStr.concat(fields[i] + ", ");
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINEST, DescriptorSupport.class.getName(), "toString()", "Exit returning " + respStr);
        }
        return respStr;
    }

    private long toNumeric(String inStr) {
        try {
            return Long.parseLong(inStr);
        }
        catch (Exception e) {
            return -2L;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        Map descriptor = (Map)Util.cast(fields.get("descriptor", null));
        this.init(null);
        if (descriptor != null) {
            this.descriptorMap.putAll(descriptor);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        HashMap<Object, Object> descriptor;
        SortedMap<String, Object> startMap;
        ObjectOutputStream.PutField fields = out.putFields();
        boolean compat = "1.0".equals(serialForm);
        if (compat) {
            fields.put("currClass", currClass);
        }
        if ((startMap = this.descriptorMap).containsKey("targetObject")) {
            startMap = new TreeMap<String, Object>(this.descriptorMap);
            startMap.remove("targetObject");
        }
        if (compat || "1.2.0".equals(serialForm) || "1.2.1".equals(serialForm)) {
            descriptor = new HashMap();
            for (Map.Entry<String, Object> entry : startMap.entrySet()) {
                descriptor.put(entry.getKey().toLowerCase(), entry.getValue());
            }
        } else {
            descriptor = new HashMap<String, Object>(startMap);
        }
        fields.put("descriptor", descriptor);
        out.writeFields();
    }

    static {
        int i;
        oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("descriptor", HashMap.class), new ObjectStreamField("currClass", String.class)};
        newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("descriptor", HashMap.class)};
        String form = null;
        boolean compat = false;
        try {
            GetPropertyAction act = new GetPropertyAction("jmx.serial.form");
            form = AccessController.doPrivileged(act);
            compat = "1.0".equals(form);
        }
        catch (Exception e) {
            // empty catch block
        }
        serialForm = form;
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = 8071560848919417985L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = -6292969195866300415L;
        }
        entities = new String[]{" &#32;", "\"&quot;", "<&lt;", ">&gt;", "&&amp;", "\r&#13;", "\t&#9;", "\n&#10;", "\f&#12;"};
        entityToCharMap = new HashMap<String, Character>();
        char maxChar = '\u0000';
        for (i = 0; i < entities.length; ++i) {
            char c = entities[i].charAt(0);
            if (c <= maxChar) continue;
            maxChar = c;
        }
        charToEntityMap = new String[maxChar + 1];
        for (i = 0; i < entities.length; ++i) {
            String entity;
            char c = entities[i].charAt(0);
            DescriptorSupport.charToEntityMap[c] = entity = entities[i].substring(1);
            entityToCharMap.put(entity, Character.valueOf(c));
        }
    }
}

