/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.io.FileDescriptor;
import java.nio.Bits;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;

public abstract class MappedByteBuffer
extends ByteBuffer {
    private final FileDescriptor fd;

    MappedByteBuffer(int mark, int pos, int lim, int cap, FileDescriptor fd) {
        super(mark, pos, lim, cap);
        this.fd = fd;
    }

    MappedByteBuffer(int mark, int pos, int lim, int cap) {
        super(mark, pos, lim, cap);
        this.fd = null;
    }

    private void checkMapped() {
        if (this.fd == null) {
            throw new UnsupportedOperationException();
        }
    }

    private long mappingOffset() {
        int ps = Bits.pageSize();
        long offset = this.address % (long)ps;
        return offset >= 0L ? offset : (long)ps + offset;
    }

    private long mappingAddress(long mappingOffset) {
        return this.address - mappingOffset;
    }

    private long mappingLength(long mappingOffset) {
        return (long)this.capacity() + mappingOffset;
    }

    public final boolean isLoaded() {
        this.checkMapped();
        if (this.address == 0L || this.capacity() == 0) {
            return true;
        }
        long offset = this.mappingOffset();
        long length = this.mappingLength(offset);
        return this.isLoaded0(this.mappingAddress(offset), length, Bits.pageCount(length));
    }

    public final MappedByteBuffer load() {
        this.checkMapped();
        if (this.address == 0L || this.capacity() == 0) {
            return this;
        }
        long offset = this.mappingOffset();
        long length = this.mappingLength(offset);
        this.load0(this.mappingAddress(offset), length);
        Unsafe unsafe = Unsafe.getUnsafe();
        int ps = Bits.pageSize();
        int count = Bits.pageCount(length);
        long a = this.mappingAddress(offset);
        for (int i = 0; i < count; ++i) {
            unsafe.getByte(a);
            a += (long)ps;
        }
        return this;
    }

    public final MappedByteBuffer force() {
        this.checkMapped();
        if (this.address != 0L && this.capacity() != 0) {
            long offset = this.mappingOffset();
            this.force0(this.fd, this.mappingAddress(offset), this.mappingLength(offset));
        }
        return this;
    }

    private native boolean isLoaded0(long var1, long var3, int var5);

    private native void load0(long var1, long var3);

    private native void force0(FileDescriptor var1, long var2, long var4);
}

