/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public final class Inet6Address
extends InetAddress {
    static final int INADDRSZ = 16;
    private transient int cached_scope_id = 0;
    byte[] ipaddress;
    private int scope_id = 0;
    private boolean scope_id_set = false;
    private transient NetworkInterface scope_ifname = null;
    private boolean scope_ifname_set = false;
    private static final long serialVersionUID = 6880410070516793377L;
    private static final int INT16SZ = 2;
    private String ifname;

    Inet6Address() {
        this.hostName = null;
        this.ipaddress = new byte[16];
        this.family = 2;
    }

    Inet6Address(String hostName, byte[] addr, int scope_id) {
        this.hostName = hostName;
        if (addr.length == 16) {
            this.family = 2;
            this.ipaddress = (byte[])addr.clone();
        }
        if (scope_id >= 0) {
            this.scope_id = scope_id;
            this.scope_id_set = true;
        }
    }

    Inet6Address(String hostName, byte[] addr) {
        try {
            this.initif(hostName, addr, null);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    Inet6Address(String hostName, byte[] addr, NetworkInterface nif) throws UnknownHostException {
        this.initif(hostName, addr, nif);
    }

    Inet6Address(String hostName, byte[] addr, String ifname) throws UnknownHostException {
        this.initstr(hostName, addr, ifname);
    }

    public static Inet6Address getByAddress(String host, byte[] addr, NetworkInterface nif) throws UnknownHostException {
        if (host != null && host.length() > 0 && host.charAt(0) == '[' && host.charAt(host.length() - 1) == ']') {
            host = host.substring(1, host.length() - 1);
        }
        if (addr != null && addr.length == 16) {
            return new Inet6Address(host, addr, nif);
        }
        throw new UnknownHostException("addr is of illegal length");
    }

    public static Inet6Address getByAddress(String host, byte[] addr, int scope_id) throws UnknownHostException {
        if (host != null && host.length() > 0 && host.charAt(0) == '[' && host.charAt(host.length() - 1) == ']') {
            host = host.substring(1, host.length() - 1);
        }
        if (addr != null && addr.length == 16) {
            return new Inet6Address(host, addr, scope_id);
        }
        throw new UnknownHostException("addr is of illegal length");
    }

    private void initstr(String hostName, byte[] addr, String ifname) throws UnknownHostException {
        try {
            NetworkInterface nif = NetworkInterface.getByName(ifname);
            if (nif == null) {
                throw new UnknownHostException("no such interface " + ifname);
            }
            this.initif(hostName, addr, nif);
        }
        catch (SocketException e) {
            throw new UnknownHostException("SocketException thrown" + ifname);
        }
    }

    private void initif(String hostName, byte[] addr, NetworkInterface nif) throws UnknownHostException {
        this.hostName = hostName;
        if (addr.length == 16) {
            this.family = 2;
            this.ipaddress = (byte[])addr.clone();
        }
        if (nif != null) {
            this.scope_ifname = nif;
            this.scope_ifname_set = true;
            this.scope_id = this.deriveNumericScope(nif);
            this.scope_id_set = true;
        }
    }

    private boolean differentLocalAddressTypes(Inet6Address other) {
        if (this.isLinkLocalAddress() && !other.isLinkLocalAddress()) {
            return false;
        }
        return !this.isSiteLocalAddress() || other.isSiteLocalAddress();
    }

    private int deriveNumericScope(NetworkInterface ifc) throws UnknownHostException {
        Enumeration<InetAddress> addresses = ifc.getInetAddresses();
        while (addresses.hasMoreElements()) {
            Inet6Address ia6_addr;
            InetAddress addr = addresses.nextElement();
            if (!(addr instanceof Inet6Address) || !this.differentLocalAddressTypes(ia6_addr = (Inet6Address)addr)) continue;
            return ia6_addr.scope_id;
        }
        throw new UnknownHostException("no scope_id found");
    }

    private int deriveNumericScope(String ifname) throws UnknownHostException {
        Enumeration<NetworkInterface> en;
        try {
            en = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new UnknownHostException("could not enumerate local network interfaces");
        }
        while (en.hasMoreElements()) {
            NetworkInterface ifc = en.nextElement();
            if (!ifc.getName().equals(ifname)) continue;
            Enumeration<InetAddress> addresses = ifc.getInetAddresses();
            while (addresses.hasMoreElements()) {
                Inet6Address ia6_addr;
                InetAddress addr = addresses.nextElement();
                if (!(addr instanceof Inet6Address) || !this.differentLocalAddressTypes(ia6_addr = (Inet6Address)addr)) continue;
                return ia6_addr.scope_id;
            }
        }
        throw new UnknownHostException("No matching address found for interface : " + ifname);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.scope_ifname = null;
        this.scope_ifname_set = false;
        s.defaultReadObject();
        if (this.ifname != null && !"".equals(this.ifname)) {
            try {
                this.scope_ifname = NetworkInterface.getByName(this.ifname);
                if (this.scope_ifname == null) {
                    this.scope_id_set = false;
                    this.scope_ifname_set = false;
                    this.scope_id = 0;
                } else {
                    try {
                        this.scope_id = this.deriveNumericScope(this.scope_ifname);
                    }
                    catch (UnknownHostException e) {}
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        this.ipaddress = (byte[])this.ipaddress.clone();
        if (this.ipaddress.length != 16) {
            throw new InvalidObjectException("invalid address length: " + this.ipaddress.length);
        }
        if (this.family != 2) {
            throw new InvalidObjectException("invalid address family type");
        }
    }

    @Override
    public boolean isMulticastAddress() {
        return (this.ipaddress[0] & 0xFF) == 255;
    }

    @Override
    public boolean isAnyLocalAddress() {
        byte test = 0;
        for (int i = 0; i < 16; ++i) {
            test = (byte)(test | this.ipaddress[i]);
        }
        return test == 0;
    }

    @Override
    public boolean isLoopbackAddress() {
        byte test = 0;
        for (int i = 0; i < 15; ++i) {
            test = (byte)(test | this.ipaddress[i]);
        }
        return test == 0 && this.ipaddress[15] == 1;
    }

    @Override
    public boolean isLinkLocalAddress() {
        return (this.ipaddress[0] & 0xFF) == 254 && (this.ipaddress[1] & 0xC0) == 128;
    }

    @Override
    public boolean isSiteLocalAddress() {
        return (this.ipaddress[0] & 0xFF) == 254 && (this.ipaddress[1] & 0xC0) == 192;
    }

    @Override
    public boolean isMCGlobal() {
        return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 14;
    }

    @Override
    public boolean isMCNodeLocal() {
        return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 1;
    }

    @Override
    public boolean isMCLinkLocal() {
        return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 2;
    }

    @Override
    public boolean isMCSiteLocal() {
        return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 5;
    }

    @Override
    public boolean isMCOrgLocal() {
        return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 8;
    }

    @Override
    public byte[] getAddress() {
        return (byte[])this.ipaddress.clone();
    }

    public int getScopeId() {
        return this.scope_id;
    }

    public NetworkInterface getScopedInterface() {
        return this.scope_ifname;
    }

    @Override
    public String getHostAddress() {
        String s = Inet6Address.numericToTextFormat(this.ipaddress);
        if (this.scope_ifname_set) {
            s = s + "%" + this.scope_ifname.getName();
        } else if (this.scope_id_set) {
            s = s + "%" + this.scope_id;
        }
        return s;
    }

    @Override
    public int hashCode() {
        if (this.ipaddress != null) {
            int hash = 0;
            int i = 0;
            while (i < 16) {
                int component = 0;
                for (int j = 0; j < 4 && i < 16; ++j, ++i) {
                    component = (component << 8) + this.ipaddress[i];
                }
                hash += component;
            }
            return hash;
        }
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Inet6Address)) {
            return false;
        }
        Inet6Address inetAddr = (Inet6Address)obj;
        for (int i = 0; i < 16; ++i) {
            if (this.ipaddress[i] == inetAddr.ipaddress[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isIPv4CompatibleAddress() {
        return this.ipaddress[0] == 0 && this.ipaddress[1] == 0 && this.ipaddress[2] == 0 && this.ipaddress[3] == 0 && this.ipaddress[4] == 0 && this.ipaddress[5] == 0 && this.ipaddress[6] == 0 && this.ipaddress[7] == 0 && this.ipaddress[8] == 0 && this.ipaddress[9] == 0 && this.ipaddress[10] == 0 && this.ipaddress[11] == 0;
    }

    static String numericToTextFormat(byte[] src) {
        StringBuffer sb = new StringBuffer(39);
        for (int i = 0; i < 8; ++i) {
            sb.append(Integer.toHexString(src[i << 1] << 8 & 0xFF00 | src[(i << 1) + 1] & 0xFF));
            if (i >= 7) continue;
            sb.append(":");
        }
        return sb.toString();
    }

    private static native void init();

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        if (this.scope_ifname_set) {
            this.ifname = this.scope_ifname.getName();
        }
        s.defaultWriteObject();
    }

    static {
        Inet6Address.init();
    }
}

