/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.FilterGeneric;
import java.lang.invoke.FromGeneric;
import java.lang.invoke.InvokeGeneric;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.SpreadGeneric;
import java.lang.invoke.ToGeneric;
import sun.invoke.util.Wrapper;

class MethodTypeForm {
    final int[] argToSlotTable;
    final int[] slotToArgTable;
    final long argCounts;
    final long primCounts;
    final int vmslots;
    private Object vmlayout;
    final MethodType erasedType;
    MethodType primsAsBoxes;
    MethodType primArgsAsBoxes;
    MethodType primsAsInts;
    MethodType primsAsLongs;
    MethodType primsAtEnd;
    ToGeneric toGeneric;
    FromGeneric fromGeneric;
    SpreadGeneric[] spreadGeneric;
    FilterGeneric filterGeneric;
    MethodHandle genericInvoker;
    public static final int NO_CHANGE = 0;
    public static final int ERASE = 1;
    public static final int WRAP = 2;
    public static final int UNWRAP = 3;
    public static final int INTS = 4;
    public static final int LONGS = 5;
    public static final int RAW_RETURN = 6;

    public MethodType erasedType() {
        return this.erasedType;
    }

    protected MethodTypeForm(MethodType erasedType) {
        int i;
        int ptypeCount;
        this.erasedType = erasedType;
        Class<?>[] ptypes = erasedType.ptypes();
        int pslotCount = ptypeCount = ptypes.length;
        int rtypeCount = 1;
        int rslotCount = 1;
        int[] argToSlotTab = null;
        int[] slotToArgTab = null;
        int pac = 0;
        int lac = 0;
        int prc = 0;
        int lrc = 0;
        Class<?>[] epts = ptypes;
        for (int i2 = 0; i2 < epts.length; ++i2) {
            Class<?> pt = epts[i2];
            if (pt == Object.class) continue;
            assert (pt.isPrimitive());
            ++pac;
            if (!MethodTypeForm.hasTwoArgSlots(pt)) continue;
            ++lac;
        }
        pslotCount += lac;
        Class<?> rt = erasedType.returnType();
        if (rt != Object.class) {
            ++prc;
            if (MethodTypeForm.hasTwoArgSlots(rt)) {
                ++lrc;
            }
            if (rt == Void.TYPE) {
                rslotCount = 0;
                rtypeCount = 0;
            } else {
                rslotCount += lrc;
            }
        }
        if (lac != 0) {
            int slot = ptypeCount + lac;
            slotToArgTab = new int[slot + 1];
            argToSlotTab = new int[1 + ptypeCount];
            argToSlotTab[0] = slot;
            for (i = 0; i < epts.length; ++i) {
                Class<?> pt = epts[i];
                if (MethodTypeForm.hasTwoArgSlots(pt)) {
                    --slot;
                }
                slotToArgTab[--slot] = i + 1;
                argToSlotTab[1 + i] = slot;
            }
            assert (slot == 0);
        }
        this.primCounts = MethodTypeForm.pack(lrc, prc, lac, pac);
        this.argCounts = MethodTypeForm.pack(rslotCount, rtypeCount, pslotCount, ptypeCount);
        if (slotToArgTab == null) {
            int slot = ptypeCount;
            slotToArgTab = new int[slot + 1];
            argToSlotTab = new int[1 + ptypeCount];
            argToSlotTab[0] = slot;
            for (i = 0; i < ptypeCount; ++i) {
                slotToArgTab[--slot] = i + 1;
                argToSlotTab[1 + i] = slot;
            }
        }
        this.argToSlotTable = argToSlotTab;
        this.slotToArgTable = slotToArgTab;
        if (pslotCount >= 256) {
            throw MethodHandleStatics.newIllegalArgumentException("too many arguments");
        }
        this.vmslots = this.parameterSlotCount();
        if (!this.hasPrimitives()) {
            this.primsAsBoxes = erasedType;
            this.primArgsAsBoxes = erasedType;
            this.primsAsInts = erasedType;
            this.primsAsLongs = erasedType;
            this.primsAtEnd = erasedType;
        }
    }

    public MethodType primsAsBoxes() {
        MethodType ct = this.primsAsBoxes;
        if (ct != null) {
            return ct;
        }
        MethodType t = this.erasedType;
        ct = MethodTypeForm.canonicalize(this.erasedType, 2, 2);
        if (ct == null) {
            ct = t;
        }
        this.primsAsBoxes = ct;
        return this.primsAsBoxes;
    }

    public MethodType primArgsAsBoxes() {
        MethodType ct = this.primArgsAsBoxes;
        if (ct != null) {
            return ct;
        }
        MethodType t = this.erasedType;
        ct = MethodTypeForm.canonicalize(this.erasedType, 6, 2);
        if (ct == null) {
            ct = t;
        }
        this.primArgsAsBoxes = ct;
        return this.primArgsAsBoxes;
    }

    public MethodType primsAsInts() {
        MethodType ct = this.primsAsInts;
        if (ct != null) {
            return ct;
        }
        MethodType t = this.erasedType;
        ct = MethodTypeForm.canonicalize(t, 6, 4);
        if (ct == null) {
            ct = t;
        }
        this.primsAsInts = ct;
        return this.primsAsInts;
    }

    public MethodType primsAsLongs() {
        MethodType ct = this.primsAsLongs;
        if (ct != null) {
            return ct;
        }
        MethodType t = this.erasedType;
        ct = MethodTypeForm.canonicalize(t, 6, 5);
        if (ct == null) {
            ct = t;
        }
        this.primsAsLongs = ct;
        return this.primsAsLongs;
    }

    public MethodType primsAtEnd() {
        MethodType ct = this.primsAtEnd;
        if (ct != null) {
            return ct;
        }
        MethodType t = this.erasedType;
        int pac = this.primitiveParameterCount();
        if (pac == 0) {
            this.primsAtEnd = t;
            return this.primsAtEnd;
        }
        int argc = this.parameterCount();
        int lac = this.longPrimitiveParameterCount();
        if (pac == argc && (lac == 0 || lac == argc)) {
            this.primsAtEnd = t;
            return this.primsAtEnd;
        }
        int[] reorder = MethodTypeForm.primsAtEndOrder(t);
        this.primsAtEnd = ct = MethodTypeForm.reorderParameters(t, reorder, null);
        return this.primsAtEnd;
    }

    public static int[] primsAtEndOrder(MethodType mt) {
        MethodTypeForm form = mt.form();
        if (form.primsAtEnd == form.erasedType) {
            return null;
        }
        int argc = form.parameterCount();
        int[] paramOrder = new int[argc];
        int pac = form.primitiveParameterCount();
        int lac = form.longPrimitiveParameterCount();
        int rfill = 0;
        int ifill = argc - pac;
        int lfill = argc - lac;
        Class<?>[] ptypes = mt.ptypes();
        boolean changed = false;
        int i = 0;
        while (i < ptypes.length) {
            Class<?> pt = ptypes[i];
            int ord = !pt.isPrimitive() ? rfill++ : (!MethodTypeForm.hasTwoArgSlots(pt) ? ifill++ : lfill++);
            if (ord != i) {
                changed = true;
            }
            assert (paramOrder[ord] == 0);
            paramOrder[ord] = i++;
        }
        assert (rfill == argc - pac && ifill == argc - lac && lfill == argc);
        if (!changed) {
            form.primsAtEnd = form.erasedType;
            return null;
        }
        return paramOrder;
    }

    public static MethodType reorderParameters(MethodType mt, int[] newParamOrder, Class<?>[] moreParams) {
        if (newParamOrder == null) {
            return mt;
        }
        Class<?>[] ptypes = mt.ptypes();
        Class[] ntypes = new Class[newParamOrder.length];
        int maxParam = ptypes.length + (moreParams == null ? 0 : moreParams.length);
        boolean changed = ntypes.length != ptypes.length;
        for (int i = 0; i < newParamOrder.length; ++i) {
            int param = newParamOrder[i];
            if (param != i) {
                changed = true;
            }
            Class<?> nt = param < ptypes.length ? ptypes[param] : (param == maxParam ? mt.returnType() : moreParams[param - ptypes.length]);
            ntypes[i] = nt;
        }
        if (!changed) {
            return mt;
        }
        return MethodType.makeImpl(mt.returnType(), ntypes, true);
    }

    private static boolean hasTwoArgSlots(Class<?> type) {
        return type == Long.TYPE || type == Double.TYPE;
    }

    private static long pack(int a, int b, int c, int d) {
        assert (((a | b | c | d) & 0xFFFF0000) == 0);
        long hw = a << 16 | b;
        long lw = c << 16 | d;
        return hw << 32 | lw;
    }

    private static char unpack(long packed, int word) {
        assert (word <= 3);
        return (char)(packed >> (3 - word) * 16);
    }

    public int parameterCount() {
        return MethodTypeForm.unpack(this.argCounts, 3);
    }

    public int parameterSlotCount() {
        return MethodTypeForm.unpack(this.argCounts, 2);
    }

    public int returnCount() {
        return MethodTypeForm.unpack(this.argCounts, 1);
    }

    public int returnSlotCount() {
        return MethodTypeForm.unpack(this.argCounts, 0);
    }

    public int primitiveParameterCount() {
        return MethodTypeForm.unpack(this.primCounts, 3);
    }

    public int longPrimitiveParameterCount() {
        return MethodTypeForm.unpack(this.primCounts, 2);
    }

    public int primitiveReturnCount() {
        return MethodTypeForm.unpack(this.primCounts, 1);
    }

    public int longPrimitiveReturnCount() {
        return MethodTypeForm.unpack(this.primCounts, 0);
    }

    public boolean hasPrimitives() {
        return this.primCounts != 0L;
    }

    public boolean hasLongPrimitives() {
        return (this.longPrimitiveParameterCount() | this.longPrimitiveReturnCount()) != 0;
    }

    public int parameterToArgSlot(int i) {
        return this.argToSlotTable[1 + i];
    }

    public int argSlotToParameter(int argSlot) {
        return this.slotToArgTable[argSlot] - 1;
    }

    static MethodTypeForm findForm(MethodType mt) {
        MethodType erased = MethodTypeForm.canonicalize(mt, 1, 1);
        if (erased == null) {
            return new MethodTypeForm(mt);
        }
        return erased.form();
    }

    public static MethodType canonicalize(MethodType mt, int howRet, int howArgs) {
        Class<?>[] ptypes = mt.ptypes();
        Class<?>[] ptc = MethodTypeForm.canonicalizes(ptypes, howArgs);
        Class<?> rtype = mt.returnType();
        Class<?> rtc = MethodTypeForm.canonicalize(rtype, howRet);
        if (ptc == null && rtc == null) {
            return null;
        }
        if (rtc == null) {
            rtc = rtype;
        }
        if (ptc == null) {
            ptc = ptypes;
        }
        return MethodType.makeImpl(rtc, ptc, true);
    }

    static Class<?> canonicalize(Class<?> t, int how) {
        if (t != Object.class) {
            if (!t.isPrimitive()) {
                switch (how) {
                    case 3: {
                        Class<?> ct = Wrapper.asPrimitiveType(t);
                        if (ct == t) break;
                        return ct;
                    }
                    case 1: 
                    case 6: {
                        return Object.class;
                    }
                }
            } else if (t == Void.TYPE) {
                switch (how) {
                    case 6: {
                        return Integer.TYPE;
                    }
                    case 2: {
                        return Void.class;
                    }
                }
            } else {
                switch (how) {
                    case 2: {
                        return Wrapper.asWrapperType(t);
                    }
                    case 4: {
                        if (t == Integer.TYPE || t == Long.TYPE) {
                            return null;
                        }
                        if (t == Double.TYPE) {
                            return Long.TYPE;
                        }
                        return Integer.TYPE;
                    }
                    case 5: {
                        if (t == Long.TYPE) {
                            return null;
                        }
                        return Long.TYPE;
                    }
                    case 6: {
                        if (t == Integer.TYPE || t == Long.TYPE || t == Float.TYPE || t == Double.TYPE) {
                            return null;
                        }
                        return Integer.TYPE;
                    }
                }
            }
        }
        return null;
    }

    static Class<?>[] canonicalizes(Class<?>[] ts, int how) {
        Class[] cs = null;
        int imax = ts.length;
        for (int i = 0; i < imax; ++i) {
            Class<?> c = MethodTypeForm.canonicalize(ts[i], how);
            if (c == Void.TYPE) {
                c = null;
            }
            if (c == null) continue;
            if (cs == null) {
                cs = (Class[])ts.clone();
            }
            cs[i] = c;
        }
        return cs;
    }

    void notifyGenericMethodType() {
        if (this.genericInvoker != null) {
            return;
        }
        try {
            this.genericInvoker = InvokeGeneric.generalInvokerOf(this.erasedType);
        }
        catch (Exception ex) {
            InternalError err = new InternalError("Exception while resolving inexact invoke");
            err.initCause(ex);
            throw err;
        }
    }

    public String toString() {
        return "Form" + this.erasedType;
    }
}

