/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.AdapterMethodHandle;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.VerifyAccess;
import sun.invoke.util.Wrapper;
import sun.reflect.Reflection;

public class MethodHandles {
    private static final MemberName.Factory IMPL_NAMES = MemberName.getFactory();

    private MethodHandles() {
    }

    public static Lookup lookup() {
        return new Lookup();
    }

    public static Lookup publicLookup() {
        return Lookup.PUBLIC_LOOKUP;
    }

    public static MethodHandle arrayElementGetter(Class<?> arrayClass) throws IllegalArgumentException {
        return MethodHandleImpl.accessArrayElement(arrayClass, false);
    }

    public static MethodHandle arrayElementSetter(Class<?> arrayClass) throws IllegalArgumentException {
        return MethodHandleImpl.accessArrayElement(arrayClass, true);
    }

    public static MethodHandle spreadInvoker(MethodType type, int leadingArgCount) {
        if (leadingArgCount < 0 || leadingArgCount > type.parameterCount()) {
            throw new IllegalArgumentException("bad argument count " + leadingArgCount);
        }
        return type.invokers().spreadInvoker(leadingArgCount);
    }

    public static MethodHandle exactInvoker(MethodType type) {
        return type.invokers().exactInvoker();
    }

    public static MethodHandle invoker(MethodType type) {
        return type.invokers().generalInvoker();
    }

    static <T0, T1> T1 checkValue(Class<T0> t0, Class<T1> t1, Object value) throws ClassCastException {
        if (t0 == t1) {
            if (t0.isPrimitive()) {
                return Wrapper.asPrimitiveType(t1).cast(value);
            }
            return Wrapper.OBJECT.convert(value, t1);
        }
        boolean prim0 = t0.isPrimitive();
        boolean prim1 = t1.isPrimitive();
        if (!prim0) {
            Wrapper.OBJECT.convert(value, t0);
            if (!prim1) {
                return Wrapper.OBJECT.convert(value, t1);
            }
            Wrapper w1 = Wrapper.forPrimitiveType(t1);
            return w1.convert(value, t1);
        }
        Wrapper.asWrapperType(t0).cast(value);
        Wrapper w1 = Wrapper.forPrimitiveType(t1);
        return w1.convert(value, t1);
    }

    static Object checkValue(Class<?> T1, Object value) throws ClassCastException {
        Class T0 = value == null ? Object.class : value.getClass();
        return MethodHandles.checkValue(T0, T1, value);
    }

    public static MethodHandle explicitCastArguments(MethodHandle target, MethodType newType) {
        return MethodHandleImpl.convertArguments(target, newType, 2);
    }

    public static MethodHandle permuteArguments(MethodHandle target, MethodType newType, int ... reorder) {
        MethodType oldType = target.type();
        MethodHandles.checkReorder(reorder, newType, oldType);
        return MethodHandleImpl.permuteArguments(target, newType, oldType, reorder);
    }

    private static void checkReorder(int[] reorder, MethodType newType, MethodType oldType) {
        if (newType.returnType() != oldType.returnType()) {
            throw MethodHandleStatics.newIllegalArgumentException("return types do not match", oldType, newType);
        }
        if (reorder.length == oldType.parameterCount()) {
            int limit = newType.parameterCount();
            boolean bad = false;
            for (int j = 0; j < reorder.length; ++j) {
                Class<?> dst;
                int i = reorder[j];
                if (i < 0 || i >= limit) {
                    bad = true;
                    break;
                }
                Class<?> src = newType.parameterType(i);
                if (src == (dst = oldType.parameterType(j))) continue;
                throw MethodHandleStatics.newIllegalArgumentException("parameter types do not match after reorder", oldType, newType);
            }
            if (!bad) {
                return;
            }
        }
        throw MethodHandleStatics.newIllegalArgumentException("bad reorder array: " + Arrays.toString(reorder));
    }

    public static MethodHandle constant(Class<?> type, Object value) {
        if (type.isPrimitive()) {
            if (type == Void.TYPE) {
                throw MethodHandleStatics.newIllegalArgumentException("void type");
            }
            Wrapper w = Wrapper.forPrimitiveType(type);
            return MethodHandles.insertArguments(MethodHandles.identity(type), 0, w.convert(value, type));
        }
        return MethodHandles.identity(type).bindTo(type.cast(value));
    }

    public static MethodHandle identity(Class<?> type) {
        if (type == Void.TYPE) {
            throw MethodHandleStatics.newIllegalArgumentException("void type");
        }
        if (type == Object.class) {
            return ValueConversions.identity();
        }
        if (type.isPrimitive()) {
            return ValueConversions.identity(Wrapper.forPrimitiveType(type));
        }
        return AdapterMethodHandle.makeRetypeRaw(MethodType.methodType(type, type), ValueConversions.identity());
    }

    public static MethodHandle insertArguments(MethodHandle target, int pos, Object ... values) {
        int insCount = values.length;
        MethodType oldType = target.type();
        int outargs = oldType.parameterCount();
        int inargs = outargs - insCount;
        if (inargs < 0) {
            throw MethodHandleStatics.newIllegalArgumentException("too many values to insert");
        }
        if (pos < 0 || pos > inargs) {
            throw MethodHandleStatics.newIllegalArgumentException("no argument type to append");
        }
        MethodHandle result = target;
        for (int i = 0; i < insCount; ++i) {
            MethodHandle bmh;
            Object value = values[i];
            Class<?> valueType = oldType.parameterType(pos + i);
            value = MethodHandles.checkValue(valueType, value);
            result = pos == 0 && !valueType.isPrimitive() && (bmh = MethodHandleImpl.bindReceiver(result, value)) != null ? bmh : MethodHandleImpl.bindArgument(result, pos, value);
        }
        return result;
    }

    public static MethodHandle dropArguments(MethodHandle target, int pos, List<Class<?>> valueTypes) {
        MethodType oldType = target.type();
        if (valueTypes.size() == 0) {
            return target;
        }
        int outargs = oldType.parameterCount();
        int inargs = outargs + valueTypes.size();
        if (pos < 0 || pos >= inargs) {
            throw MethodHandleStatics.newIllegalArgumentException("no argument type to remove");
        }
        ArrayList ptypes = new ArrayList(oldType.parameterList());
        ptypes.addAll(pos, valueTypes);
        MethodType newType = MethodType.methodType(oldType.returnType(), ptypes);
        return MethodHandleImpl.dropArguments(target, newType, pos);
    }

    public static MethodHandle dropArguments(MethodHandle target, int pos, Class<?> ... valueTypes) {
        return MethodHandles.dropArguments(target, pos, Arrays.asList(valueTypes));
    }

    public static MethodHandle filterArguments(MethodHandle target, int pos, MethodHandle ... filters) {
        MethodType targetType = target.type();
        MethodHandle adapter = target;
        MethodType adapterType = null;
        assert ((adapterType = targetType) != null);
        int maxPos = targetType.parameterCount();
        if (pos + filters.length > maxPos) {
            throw MethodHandleStatics.newIllegalArgumentException("too many filters");
        }
        int curPos = pos - 1;
        for (MethodHandle filter : filters) {
            ++curPos;
            if (filter == null) continue;
            adapter = MethodHandles.filterArgument(adapter, curPos, filter);
            assert ((adapterType = adapterType.changeParameterType(curPos, filter.type().parameterType(0))) != null);
        }
        assert (adapterType.equals((Object)adapter.type()));
        return adapter;
    }

    static MethodHandle filterArgument(MethodHandle target, int pos, MethodHandle filter) {
        MethodType targetType = target.type();
        MethodType filterType = filter.type();
        if (filterType.parameterCount() != 1 || filterType.returnType() != targetType.parameterType(pos)) {
            throw MethodHandleStatics.newIllegalArgumentException("target and filter types do not match", targetType, filterType);
        }
        return MethodHandleImpl.filterArgument(target, pos, filter);
    }

    public static MethodHandle filterReturnValue(MethodHandle target, MethodHandle filter) {
        MethodType targetType = target.type();
        MethodType filterType = filter.type();
        Class<?> rtype = targetType.returnType();
        int filterValues = filterType.parameterCount();
        if (filterValues == 0 ? rtype != Void.TYPE : rtype != filterType.parameterType(0)) {
            throw MethodHandleStatics.newIllegalArgumentException("target and filter types do not match", target, filter);
        }
        MethodType newType = targetType.changeReturnType(filterType.returnType());
        MethodHandle result = null;
        if (AdapterMethodHandle.canCollectArguments(filterType, targetType, 0, false) && (result = AdapterMethodHandle.makeCollectArguments(filter, target, 0, false)) != null) {
            return result;
        }
        assert (MethodHandleNatives.workaroundWithoutRicochetFrames());
        MethodHandle returner = MethodHandles.dropArguments(filter, filterValues, targetType.parameterList());
        result = MethodHandles.foldArguments(returner, target);
        assert (result.type().equals((Object)newType));
        return result;
    }

    public static MethodHandle foldArguments(MethodHandle target, MethodHandle combiner) {
        boolean ok;
        int pos = 0;
        MethodType targetType = target.type();
        MethodType combinerType = combiner.type();
        int foldPos = pos;
        int foldArgs = combinerType.parameterCount();
        int foldVals = combinerType.returnType() == Void.TYPE ? 0 : 1;
        int afterInsertPos = foldPos + foldVals;
        boolean bl = ok = targetType.parameterCount() >= afterInsertPos + foldArgs;
        if (ok && !combinerType.parameterList().equals(targetType.parameterList().subList(afterInsertPos, afterInsertPos + foldArgs))) {
            ok = false;
        }
        if (ok && foldVals != 0 && !combinerType.returnType().equals(targetType.parameterType(0))) {
            ok = false;
        }
        if (!ok) {
            throw MethodHandles.misMatchedTypes("target and combiner types", targetType, combinerType);
        }
        MethodType newType = targetType.dropParameterTypes(foldPos, afterInsertPos);
        MethodHandle res = MethodHandleImpl.foldArguments(target, newType, foldPos, combiner);
        if (res == null) {
            throw MethodHandleStatics.newIllegalArgumentException("cannot fold from " + newType + " to " + targetType);
        }
        return res;
    }

    public static MethodHandle guardWithTest(MethodHandle test, MethodHandle target, MethodHandle fallback) {
        List<Class<?>> gargs;
        MethodType ftype;
        MethodType gtype = test.type();
        MethodType ttype = target.type();
        if (!ttype.equals((Object)(ftype = fallback.type()))) {
            throw MethodHandles.misMatchedTypes("target and fallback types", ttype, ftype);
        }
        if (gtype.returnType() != Boolean.TYPE) {
            throw MethodHandleStatics.newIllegalArgumentException("guard type is not a predicate " + gtype);
        }
        List<Class<?>> targs = ttype.parameterList();
        if (!targs.equals(gargs = gtype.parameterList())) {
            int tpc;
            int gpc = gargs.size();
            if (gpc >= (tpc = targs.size()) || !targs.subList(0, gpc).equals(gargs)) {
                throw MethodHandles.misMatchedTypes("target and test types", ttype, gtype);
            }
            test = MethodHandles.dropArguments(test, gpc, targs.subList(gpc, tpc));
            gtype = test.type();
        }
        return MethodHandleImpl.makeGuardWithTest(test, target, fallback);
    }

    static RuntimeException misMatchedTypes(String what, MethodType t1, MethodType t2) {
        return MethodHandleStatics.newIllegalArgumentException(what + " must match: " + t1 + " != " + t2);
    }

    public static MethodHandle catchException(MethodHandle target, Class<? extends Throwable> exType, MethodHandle handler) {
        MethodType ttype = target.type();
        MethodType htype = handler.type();
        if (htype.parameterCount() < 1 || !htype.parameterType(0).isAssignableFrom(exType)) {
            throw MethodHandleStatics.newIllegalArgumentException("handler does not accept exception type " + exType);
        }
        if (htype.returnType() != ttype.returnType()) {
            throw MethodHandles.misMatchedTypes("target and handler return types", ttype, htype);
        }
        List<Class<?>> targs = ttype.parameterList();
        List<Class<?>> hargs = htype.parameterList();
        if (!targs.equals(hargs = hargs.subList(1, hargs.size()))) {
            int tpc;
            int hpc = hargs.size();
            if (hpc >= (tpc = targs.size()) || !targs.subList(0, hpc).equals(hargs)) {
                throw MethodHandles.misMatchedTypes("target and handler types", ttype, htype);
            }
            handler = MethodHandles.dropArguments(handler, 1 + hpc, targs.subList(hpc, tpc));
            htype = handler.type();
        }
        return MethodHandleImpl.makeGuardWithCatch(target, exType, handler);
    }

    public static MethodHandle throwException(Class<?> returnType, Class<? extends Throwable> exType) {
        return MethodHandleImpl.throwException(MethodType.methodType(returnType, exType));
    }

    static {
        MethodHandleImpl.initStatics();
    }

    public static final class Lookup {
        private final Class<?> lookupClass;
        private final int allowedModes;
        public static final int PUBLIC = 1;
        public static final int PRIVATE = 2;
        public static final int PROTECTED = 4;
        public static final int PACKAGE = 8;
        private static final int ALL_MODES = 15;
        private static final int TRUSTED = -1;
        static final Lookup PUBLIC_LOOKUP;
        static final Lookup IMPL_LOOKUP;
        private static final boolean ALLOW_NESTMATE_ACCESS = false;

        private static int fixmods(int mods) {
            return (mods &= 7) != 0 ? mods : 8;
        }

        public Class<?> lookupClass() {
            return this.lookupClass;
        }

        private Class<?> lookupClassOrNull() {
            return this.allowedModes == -1 ? null : this.lookupClass;
        }

        public int lookupModes() {
            return this.allowedModes & 0xF;
        }

        Lookup() {
            this(Lookup.getCallerClassAtEntryPoint(false), 15);
            Lookup.checkUnprivilegedlookupClass(this.lookupClass);
        }

        Lookup(Class<?> lookupClass) {
            this(lookupClass, 15);
        }

        private Lookup(Class<?> lookupClass, int allowedModes) {
            this.lookupClass = lookupClass;
            this.allowedModes = allowedModes;
        }

        public Lookup in(Class<?> requestedLookupClass) {
            requestedLookupClass.getClass();
            if (this.allowedModes == -1) {
                return new Lookup(requestedLookupClass, 15);
            }
            if (requestedLookupClass == this.lookupClass) {
                return this;
            }
            int newModes = this.allowedModes & 0xB;
            if ((newModes & 8) != 0 && !VerifyAccess.isSamePackage(this.lookupClass, requestedLookupClass)) {
                newModes &= 0xFFFFFFF5;
            }
            if ((newModes & 2) != 0 && !VerifyAccess.isSamePackageMember(this.lookupClass, requestedLookupClass)) {
                newModes &= 0xFFFFFFFD;
            }
            if ((newModes & 1) != 0 && !VerifyAccess.isClassAccessible(requestedLookupClass, this.lookupClass, this.allowedModes)) {
                newModes = 0;
            }
            Lookup.checkUnprivilegedlookupClass(requestedLookupClass);
            return new Lookup(requestedLookupClass, newModes);
        }

        private static void checkUnprivilegedlookupClass(Class<?> lookupClass) {
            String name = lookupClass.getName();
            if (name.startsWith("java.lang.invoke.")) {
                throw MethodHandleStatics.newIllegalArgumentException("illegal lookupClass: " + lookupClass);
            }
        }

        public String toString() {
            String cname = this.lookupClass.getName();
            switch (this.allowedModes) {
                case 0: {
                    return cname + "/noaccess";
                }
                case 1: {
                    return cname + "/public";
                }
                case 9: {
                    return cname + "/package";
                }
                case 11: {
                    return cname + "/private";
                }
                case 15: {
                    return cname;
                }
                case -1: {
                    return "/trusted";
                }
            }
            cname = cname + "/" + Integer.toHexString(this.allowedModes);
            assert (false) : cname;
            return cname;
        }

        private static Class<?> getCallerClassAtEntryPoint(boolean inSubroutine) {
            int CALLER_DEPTH = 4;
            assert (Reflection.getCallerClass(2) == Lookup.class);
            assert (Reflection.getCallerClass(3) == (inSubroutine ? Lookup.class : MethodHandles.class));
            return Reflection.getCallerClass(4);
        }

        public MethodHandle findStatic(Class<?> refc, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            MemberName method = this.resolveOrFail(refc, name, type, true);
            this.checkSecurityManager(refc, method);
            return this.accessStatic(refc, method);
        }

        private MethodHandle accessStatic(Class<?> refc, MemberName method) throws IllegalAccessException {
            this.checkMethod(refc, method, true);
            return MethodHandleImpl.findMethod(method, false, this.lookupClassOrNull());
        }

        private MethodHandle resolveStatic(Class<?> refc, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            MemberName method = this.resolveOrFail(refc, name, type, true);
            return this.accessStatic(refc, method);
        }

        public MethodHandle findVirtual(Class<?> refc, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            MemberName method = this.resolveOrFail(refc, name, type, false);
            this.checkSecurityManager(refc, method);
            return this.accessVirtual(refc, method);
        }

        private MethodHandle resolveVirtual(Class<?> refc, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            MemberName method = this.resolveOrFail(refc, name, type, false);
            return this.accessVirtual(refc, method);
        }

        private MethodHandle accessVirtual(Class<?> refc, MemberName method) throws IllegalAccessException {
            this.checkMethod(refc, method, false);
            MethodHandle mh = MethodHandleImpl.findMethod(method, true, this.lookupClassOrNull());
            return this.restrictProtectedReceiver(method, mh);
        }

        public MethodHandle findConstructor(Class<?> refc, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            String name = "<init>";
            MemberName ctor = this.resolveOrFail(refc, name, type, false, false, this.lookupClassOrNull());
            this.checkSecurityManager(refc, ctor);
            return this.accessConstructor(refc, ctor);
        }

        private MethodHandle accessConstructor(Class<?> refc, MemberName ctor) throws IllegalAccessException {
            assert (ctor.isConstructor());
            this.checkAccess(refc, ctor);
            MethodHandle rawMH = MethodHandleImpl.findMethod(ctor, false, this.lookupClassOrNull());
            MethodHandle allocMH = MethodHandleImpl.makeAllocator(rawMH);
            return Lookup.fixVarargs(allocMH, rawMH);
        }

        private MethodHandle resolveConstructor(Class<?> refc, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            String name = "<init>";
            MemberName ctor = this.resolveOrFail(refc, name, type, false, false, this.lookupClassOrNull());
            return this.accessConstructor(refc, ctor);
        }

        private static MethodHandle fixVarargs(MethodHandle mh, MethodHandle matchMH) {
            boolean va2;
            boolean va1 = mh.isVarargsCollector();
            if (va1 == (va2 = matchMH.isVarargsCollector())) {
                return mh;
            }
            if (va2) {
                MethodType type = mh.type();
                int arity = type.parameterCount();
                return mh.asVarargsCollector(type.parameterType(arity - 1));
            }
            return mh.asFixedArity();
        }

        public MethodHandle findSpecial(Class<?> refc, String name, MethodType type, Class<?> specialCaller) throws NoSuchMethodException, IllegalAccessException {
            this.checkSpecialCaller(specialCaller);
            MemberName method = this.resolveOrFail(refc, name, type, false, false, specialCaller);
            this.checkSecurityManager(refc, method);
            return this.accessSpecial(refc, method, specialCaller);
        }

        private MethodHandle accessSpecial(Class<?> refc, MemberName method, Class<?> specialCaller) throws NoSuchMethodException, IllegalAccessException {
            this.checkMethod(refc, method, false);
            MethodHandle mh = MethodHandleImpl.findMethod(method, false, specialCaller);
            return this.restrictReceiver(method, mh, specialCaller);
        }

        private MethodHandle resolveSpecial(Class<?> refc, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            Class<?> specialCaller = this.lookupClass();
            this.checkSpecialCaller(specialCaller);
            MemberName method = this.resolveOrFail(refc, name, type, false, false, specialCaller);
            return this.accessSpecial(refc, method, specialCaller);
        }

        public MethodHandle findGetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName field = this.resolveOrFail(refc, name, type, false);
            this.checkSecurityManager(refc, field);
            return this.makeAccessor(refc, field, false, false, 0);
        }

        private MethodHandle resolveGetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName field = this.resolveOrFail(refc, name, type, false);
            return this.makeAccessor(refc, field, false, false, 0);
        }

        public MethodHandle findSetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName field = this.resolveOrFail(refc, name, type, false);
            this.checkSecurityManager(refc, field);
            return this.makeAccessor(refc, field, false, true, 0);
        }

        private MethodHandle resolveSetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName field = this.resolveOrFail(refc, name, type, false);
            return this.makeAccessor(refc, field, false, true, 0);
        }

        public MethodHandle findStaticGetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName field = this.resolveOrFail(refc, name, type, true);
            this.checkSecurityManager(refc, field);
            return this.makeAccessor(refc, field, false, false, 1);
        }

        private MethodHandle resolveStaticGetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName field = this.resolveOrFail(refc, name, type, true);
            return this.makeAccessor(refc, field, false, false, 1);
        }

        public MethodHandle findStaticSetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName field = this.resolveOrFail(refc, name, type, true);
            this.checkSecurityManager(refc, field);
            return this.makeAccessor(refc, field, false, true, 1);
        }

        private MethodHandle resolveStaticSetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName field = this.resolveOrFail(refc, name, type, true);
            return this.makeAccessor(refc, field, false, true, 1);
        }

        public MethodHandle bind(Object receiver, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            Class<?> refc = receiver.getClass();
            MemberName method = this.resolveOrFail(refc, name, type, false);
            this.checkSecurityManager(refc, method);
            this.checkMethod(refc, method, false);
            MethodHandle dmh = MethodHandleImpl.findMethod(method, true, this.lookupClassOrNull());
            MethodHandle bmh = MethodHandleImpl.bindReceiver(dmh, receiver);
            if (bmh == null) {
                throw method.makeAccessException("no access", this);
            }
            return Lookup.fixVarargs(bmh, dmh);
        }

        public MethodHandle unreflect(Method m) throws IllegalAccessException {
            MemberName method = new MemberName(m);
            assert (method.isMethod());
            if (m.isAccessible()) {
                return MethodHandleImpl.findMethod(method, true, null);
            }
            this.checkMethod(method.getDeclaringClass(), method, method.isStatic());
            MethodHandle mh = MethodHandleImpl.findMethod(method, true, this.lookupClassOrNull());
            return this.restrictProtectedReceiver(method, mh);
        }

        public MethodHandle unreflectSpecial(Method m, Class<?> specialCaller) throws IllegalAccessException {
            this.checkSpecialCaller(specialCaller);
            MemberName method = new MemberName(m);
            assert (method.isMethod());
            this.checkMethod(m.getDeclaringClass(), method, false);
            MethodHandle mh = MethodHandleImpl.findMethod(method, false, this.lookupClassOrNull());
            return this.restrictReceiver(method, mh, specialCaller);
        }

        public MethodHandle unreflectConstructor(Constructor c) throws IllegalAccessException {
            MethodHandle rawCtor;
            MemberName ctor = new MemberName(c);
            assert (ctor.isConstructor());
            if (c.isAccessible()) {
                rawCtor = MethodHandleImpl.findMethod(ctor, false, null);
            } else {
                this.checkAccess(c.getDeclaringClass(), ctor);
                rawCtor = MethodHandleImpl.findMethod(ctor, false, this.lookupClassOrNull());
            }
            MethodHandle allocator = MethodHandleImpl.makeAllocator(rawCtor);
            return Lookup.fixVarargs(allocator, rawCtor);
        }

        public MethodHandle unreflectGetter(Field f) throws IllegalAccessException {
            return this.makeAccessor(f.getDeclaringClass(), new MemberName(f), f.isAccessible(), false, -1);
        }

        public MethodHandle unreflectSetter(Field f) throws IllegalAccessException {
            return this.makeAccessor(f.getDeclaringClass(), new MemberName(f), f.isAccessible(), true, -1);
        }

        MemberName resolveOrFail(Class<?> refc, String name, Class<?> type, boolean isStatic) throws NoSuchFieldException, IllegalAccessException {
            this.checkSymbolicClass(refc);
            name.getClass();
            type.getClass();
            int mods = isStatic ? 8 : 0;
            return IMPL_NAMES.resolveOrFail(new MemberName(refc, name, type, mods), true, this.lookupClassOrNull(), NoSuchFieldException.class);
        }

        MemberName resolveOrFail(Class<?> refc, String name, MethodType type, boolean isStatic) throws NoSuchMethodException, IllegalAccessException {
            this.checkSymbolicClass(refc);
            name.getClass();
            type.getClass();
            int mods = isStatic ? 8 : 0;
            return IMPL_NAMES.resolveOrFail(new MemberName(refc, name, type, mods), true, this.lookupClassOrNull(), NoSuchMethodException.class);
        }

        MemberName resolveOrFail(Class<?> refc, String name, MethodType type, boolean isStatic, boolean searchSupers, Class<?> specialCaller) throws NoSuchMethodException, IllegalAccessException {
            this.checkSymbolicClass(refc);
            name.getClass();
            type.getClass();
            int mods = isStatic ? 8 : 0;
            return IMPL_NAMES.resolveOrFail(new MemberName(refc, name, type, mods), searchSupers, specialCaller, NoSuchMethodException.class);
        }

        void checkSymbolicClass(Class<?> refc) throws IllegalAccessException {
            Class<?> caller = this.lookupClassOrNull();
            if (caller != null && !VerifyAccess.isClassAccessible(refc, caller, this.allowedModes)) {
                throw new MemberName(refc).makeAccessException("symbolic reference class is not public", this);
            }
        }

        void checkSecurityManager(Class<?> refc, MemberName m) {
            Class<?> callerClass;
            SecurityManager smgr = System.getSecurityManager();
            if (smgr == null) {
                return;
            }
            if (this.allowedModes == -1) {
                return;
            }
            smgr.checkMemberAccess(refc, 0);
            Class<?> clazz = callerClass = (this.allowedModes & 2) != 0 ? this.lookupClass : Lookup.getCallerClassAtEntryPoint(true);
            if (!VerifyAccess.classLoaderIsAncestor(this.lookupClass, refc) || callerClass != this.lookupClass && !VerifyAccess.classLoaderIsAncestor(callerClass, refc)) {
                smgr.checkPackageAccess(VerifyAccess.getPackageName(refc));
            }
            if (m.isPublic()) {
                return;
            }
            Class<?> defc = m.getDeclaringClass();
            smgr.checkMemberAccess(defc, 1);
            if (defc != refc) {
                smgr.checkPackageAccess(VerifyAccess.getPackageName(defc));
            }
        }

        void checkMethod(Class<?> refc, MemberName m, boolean wantStatic) throws IllegalAccessException {
            String message;
            if (m.isConstructor()) {
                message = "expected a method, not a constructor";
            } else if (!m.isMethod()) {
                message = "expected a method";
            } else if (wantStatic != m.isStatic()) {
                message = wantStatic ? "expected a static method" : "expected a non-static method";
            } else {
                this.checkAccess(refc, m);
                return;
            }
            throw m.makeAccessException(message, this);
        }

        void checkAccess(Class<?> refc, MemberName m) throws IllegalAccessException {
            int allowedModes = this.allowedModes;
            if (allowedModes == -1) {
                return;
            }
            int mods = m.getModifiers();
            if (Modifier.isPublic(mods) && Modifier.isPublic(refc.getModifiers()) && allowedModes != 0) {
                return;
            }
            int requestedModes = Lookup.fixmods(mods);
            if ((requestedModes & allowedModes) != 0 && VerifyAccess.isMemberAccessible(refc, m.getDeclaringClass(), mods, this.lookupClass(), allowedModes)) {
                return;
            }
            if ((requestedModes & ~allowedModes & 4) != 0 && (allowedModes & 8) != 0 && VerifyAccess.isSamePackage(m.getDeclaringClass(), this.lookupClass())) {
                return;
            }
            throw m.makeAccessException(this.accessFailedMessage(refc, m), this);
        }

        String accessFailedMessage(Class<?> refc, MemberName m) {
            boolean classOK;
            Class<?> defc = m.getDeclaringClass();
            int mods = m.getModifiers();
            boolean bl = classOK = Modifier.isPublic(defc.getModifiers()) && (defc == refc || Modifier.isPublic(refc.getModifiers()));
            if (!classOK && (this.allowedModes & 8) != 0) {
                boolean bl2 = classOK = VerifyAccess.isClassAccessible(defc, this.lookupClass(), 15) && (defc == refc || VerifyAccess.isClassAccessible(refc, this.lookupClass(), 15));
            }
            if (!classOK) {
                return "class is not public";
            }
            if (Modifier.isPublic(mods)) {
                return "access to public member failed";
            }
            if (Modifier.isPrivate(mods)) {
                return "member is private";
            }
            if (Modifier.isProtected(mods)) {
                return "member is protected";
            }
            return "member is private to package";
        }

        void checkSpecialCaller(Class<?> specialCaller) throws IllegalAccessException {
            if (this.allowedModes == -1) {
                return;
            }
            if ((this.allowedModes & 2) == 0 || specialCaller != this.lookupClass()) {
                throw new MemberName(specialCaller).makeAccessException("no private access for invokespecial", this);
            }
        }

        MethodHandle restrictProtectedReceiver(MemberName method, MethodHandle mh) throws IllegalAccessException {
            if (!method.isProtected() || method.isStatic() || this.allowedModes == -1 || method.getDeclaringClass() == this.lookupClass() || VerifyAccess.isSamePackage(method.getDeclaringClass(), this.lookupClass())) {
                return mh;
            }
            return this.restrictReceiver(method, mh, this.lookupClass());
        }

        MethodHandle restrictReceiver(MemberName method, MethodHandle mh, Class<?> caller) throws IllegalAccessException {
            assert (!method.isStatic());
            Class<?> defc = method.getDeclaringClass();
            if (defc.isInterface() || !defc.isAssignableFrom(caller)) {
                throw method.makeAccessException("caller class must be a subclass below the method", caller);
            }
            MethodType rawType = mh.type();
            if (rawType.parameterType(0) == caller) {
                return mh;
            }
            MethodType narrowType = rawType.changeParameterType(0, caller);
            MethodHandle narrowMH = MethodHandleImpl.convertArguments(mh, narrowType, rawType, 0);
            return Lookup.fixVarargs(narrowMH, mh);
        }

        MethodHandle makeAccessor(Class<?> refc, MemberName field, boolean trusted, boolean isSetter, int checkStatic) throws IllegalAccessException {
            assert (field.isField());
            if (checkStatic >= 0 && checkStatic != 0 != field.isStatic()) {
                throw field.makeAccessException(checkStatic != 0 ? "expected a static field" : "expected a non-static field", this);
            }
            if (trusted) {
                return MethodHandleImpl.accessField(field, isSetter, null);
            }
            this.checkAccess(refc, field);
            MethodHandle mh = MethodHandleImpl.accessField(field, isSetter, this.lookupClassOrNull());
            return this.restrictProtectedReceiver(field, mh);
        }

        MethodHandle linkMethodHandleConstant(int refKind, Class<?> defc, String name, Object type) throws ReflectiveOperationException {
            switch (refKind) {
                case 1: {
                    return this.resolveGetter(defc, name, (Class)type);
                }
                case 2: {
                    return this.resolveStaticGetter(defc, name, (Class)type);
                }
                case 3: {
                    return this.resolveSetter(defc, name, (Class)type);
                }
                case 4: {
                    return this.resolveStaticSetter(defc, name, (Class)type);
                }
                case 5: {
                    return this.resolveVirtual(defc, name, (MethodType)type);
                }
                case 6: {
                    return this.resolveStatic(defc, name, (MethodType)type);
                }
                case 7: {
                    return this.resolveSpecial(defc, name, (MethodType)type);
                }
                case 8: {
                    return this.resolveConstructor(defc, (MethodType)type);
                }
                case 9: {
                    return this.resolveVirtual(defc, name, (MethodType)type);
                }
            }
            throw new ReflectiveOperationException("bad MethodHandle constant #" + refKind + " " + name + " : " + type);
        }

        static {
            IMPL_NAMES.getClass();
            PUBLIC_LOOKUP = new Lookup(Object.class, 1);
            IMPL_LOOKUP = new Lookup(Object.class, -1);
        }
    }
}

