/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.AdapterMethodHandle;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import sun.invoke.empty.Empty;

class Invokers {
    private final MethodType targetType;
    private MethodHandle exactInvoker;
    private MethodHandle erasedInvoker;
    MethodHandle erasedInvokerWithDrops;
    private MethodHandle generalInvoker;
    private MethodHandle varargsInvoker;
    private final MethodHandle[] spreadInvokers;
    private MethodHandle uninitializedCallSite;
    private static MethodHandle THROW_UCS = null;

    Invokers(MethodType targetType) {
        this.targetType = targetType;
        this.spreadInvokers = new MethodHandle[targetType.parameterCount() + 1];
    }

    static MethodType invokerType(MethodType targetType) {
        return targetType.insertParameterTypes(0, MethodHandle.class);
    }

    MethodHandle exactInvoker() {
        MethodHandle invoker = this.exactInvoker;
        if (invoker != null) {
            return invoker;
        }
        this.exactInvoker = invoker = this.lookupInvoker("invokeExact");
        return invoker;
    }

    MethodHandle generalInvoker() {
        MethodHandle invoker = this.generalInvoker;
        if (invoker != null) {
            return invoker;
        }
        this.generalInvoker = invoker = this.lookupInvoker("invoke");
        return invoker;
    }

    private MethodHandle lookupInvoker(String name) {
        MethodHandle invoker;
        try {
            invoker = MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(MethodHandle.class, name, this.targetType);
        }
        catch (ReflectiveOperationException ex) {
            throw new InternalError("JVM cannot find invoker for " + this.targetType);
        }
        assert (Invokers.invokerType(this.targetType) == invoker.type());
        assert (!invoker.isVarargsCollector());
        return invoker;
    }

    MethodHandle erasedInvoker() {
        MethodHandle xinvoker = this.exactInvoker();
        MethodHandle invoker = this.erasedInvoker;
        if (invoker != null) {
            return invoker;
        }
        MethodType erasedType = this.targetType.erase();
        this.erasedInvoker = invoker = xinvoker.asType(Invokers.invokerType(erasedType));
        return invoker;
    }

    MethodHandle spreadInvoker(int leadingArgCount) {
        MethodHandle vaInvoker = this.spreadInvokers[leadingArgCount];
        if (vaInvoker != null) {
            return vaInvoker;
        }
        MethodHandle gInvoker = this.generalInvoker();
        int spreadArgCount = this.targetType.parameterCount() - leadingArgCount;
        this.spreadInvokers[leadingArgCount] = vaInvoker = gInvoker.asSpreader(Object[].class, spreadArgCount);
        return vaInvoker;
    }

    MethodHandle varargsInvoker() {
        MethodHandle vaInvoker = this.varargsInvoker;
        if (vaInvoker != null) {
            return vaInvoker;
        }
        this.varargsInvoker = vaInvoker = this.spreadInvoker(0).asType(Invokers.invokerType(MethodType.genericMethodType(0, true)));
        return vaInvoker;
    }

    MethodHandle uninitializedCallSite() {
        MethodHandle invoker = this.uninitializedCallSite;
        if (invoker != null) {
            return invoker;
        }
        if (this.targetType.parameterCount() > 0) {
            MethodType type0 = this.targetType.dropParameterTypes(0, this.targetType.parameterCount());
            Invokers invokers0 = type0.invokers();
            invoker = MethodHandles.dropArguments(invokers0.uninitializedCallSite(), 0, this.targetType.parameterList());
            assert (invoker.type().equals((Object)this.targetType));
            this.uninitializedCallSite = invoker;
            return invoker;
        }
        if (THROW_UCS == null) {
            try {
                THROW_UCS = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(CallSite.class, "uninitializedCallSite", MethodType.methodType(Empty.class));
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException(ex);
            }
        }
        invoker = AdapterMethodHandle.makeRetypeRaw(this.targetType, THROW_UCS);
        assert (invoker.type().equals((Object)this.targetType));
        this.uninitializedCallSite = invoker;
        return invoker;
    }

    public String toString() {
        return "Invokers" + this.targetType;
    }
}

