/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AudioFloatInputStream;
import com.sun.media.sound.SoftAbstractResampler;
import com.sun.media.sound.SoftAudioBuffer;
import com.sun.media.sound.SoftCubicResampler;
import com.sun.media.sound.SoftLanczosResampler;
import com.sun.media.sound.SoftLinearResampler;
import com.sun.media.sound.SoftLinearResampler2;
import com.sun.media.sound.SoftMixingMixer;
import com.sun.media.sound.SoftPointResampler;
import com.sun.media.sound.SoftSincResampler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

public abstract class SoftMixingDataLine
implements DataLine {
    public static final FloatControl.Type CHORUS_SEND = new FloatControl.Type("Chorus Send"){};
    private Gain gain_control = new Gain();
    private Mute mute_control = new Mute();
    private Balance balance_control = new Balance();
    private Pan pan_control = new Pan();
    private ReverbSend reverbsend_control = new ReverbSend();
    private ChorusSend chorussend_control = new ChorusSend();
    private ApplyReverb apply_reverb = new ApplyReverb();
    private Control[] controls;
    protected float leftgain = 1.0f;
    protected float rightgain = 1.0f;
    protected float eff1gain = 0.0f;
    protected float eff2gain = 0.0f;
    protected List<LineListener> listeners = new ArrayList<LineListener>();
    protected Object control_mutex;
    protected SoftMixingMixer mixer;
    protected DataLine.Info info;

    protected abstract void processControlLogic();

    protected abstract void processAudioLogic(SoftAudioBuffer[] var1);

    protected SoftMixingDataLine(SoftMixingMixer mixer, DataLine.Info info) {
        this.mixer = mixer;
        this.info = info;
        this.control_mutex = mixer.control_mutex;
        this.controls = new Control[]{this.gain_control, this.mute_control, this.balance_control, this.pan_control, this.reverbsend_control, this.chorussend_control, this.apply_reverb};
        this.calcVolume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calcVolume() {
        Object object = this.control_mutex;
        synchronized (object) {
            double gain = Math.pow(10.0, (double)this.gain_control.getValue() / 20.0);
            if (this.mute_control.getValue()) {
                gain = 0.0;
            }
            this.leftgain = (float)gain;
            this.rightgain = (float)gain;
            if (this.mixer.getFormat().getChannels() > 1) {
                double balance = this.balance_control.getValue();
                if (balance > 0.0) {
                    this.leftgain = (float)((double)this.leftgain * (1.0 - balance));
                } else {
                    this.rightgain = (float)((double)this.rightgain * (1.0 + balance));
                }
            }
        }
        this.eff1gain = (float)Math.pow(10.0, (double)this.reverbsend_control.getValue() / 20.0);
        this.eff2gain = (float)Math.pow(10.0, (double)this.chorussend_control.getValue() / 20.0);
        if (!this.apply_reverb.getValue()) {
            this.eff1gain = 0.0f;
        }
    }

    protected void sendEvent(LineEvent event) {
        LineListener[] listener_array;
        if (this.listeners.size() == 0) {
            return;
        }
        for (LineListener listener : listener_array = this.listeners.toArray(new LineListener[this.listeners.size()])) {
            listener.update(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLineListener(LineListener listener) {
        Object object = this.control_mutex;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLineListener(LineListener listener) {
        Object object = this.control_mutex;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    @Override
    public Line.Info getLineInfo() {
        return this.info;
    }

    @Override
    public Control getControl(Control.Type control) {
        if (control != null) {
            for (int i = 0; i < this.controls.length; ++i) {
                if (this.controls[i].getType() != control) continue;
                return this.controls[i];
            }
        }
        throw new IllegalArgumentException("Unsupported control type : " + control);
    }

    @Override
    public Control[] getControls() {
        return Arrays.copyOf(this.controls, this.controls.length);
    }

    @Override
    public boolean isControlSupported(Control.Type control) {
        if (control != null) {
            for (int i = 0; i < this.controls.length; ++i) {
                if (this.controls[i].getType() != control) continue;
                return true;
            }
        }
        return false;
    }

    private class ChorusSend
    extends FloatControl {
        private ChorusSend() {
            super(CHORUS_SEND, -80.0f, 6.0206f, 0.625f, -1, -80.0f, "dB", "Minimum", "", "Maximum");
        }

        @Override
        public void setValue(float newValue) {
            super.setValue(newValue);
            SoftMixingDataLine.this.balance_control.setValue(newValue);
        }
    }

    private class ReverbSend
    extends FloatControl {
        private ReverbSend() {
            super(FloatControl.Type.REVERB_SEND, -80.0f, 6.0206f, 0.625f, -1, -80.0f, "dB", "Minimum", "", "Maximum");
        }

        @Override
        public void setValue(float newValue) {
            super.setValue(newValue);
            SoftMixingDataLine.this.balance_control.setValue(newValue);
        }
    }

    private class Pan
    extends FloatControl {
        private Pan() {
            super(FloatControl.Type.PAN, -1.0f, 1.0f, 0.0078125f, -1, 0.0f, "", "Left", "Center", "Right");
        }

        @Override
        public void setValue(float newValue) {
            super.setValue(newValue);
            SoftMixingDataLine.this.balance_control.setValue(newValue);
        }

        @Override
        public float getValue() {
            return SoftMixingDataLine.this.balance_control.getValue();
        }
    }

    private class Balance
    extends FloatControl {
        private Balance() {
            super(FloatControl.Type.BALANCE, -1.0f, 1.0f, 0.0078125f, -1, 0.0f, "", "Left", "Center", "Right");
        }

        @Override
        public void setValue(float newValue) {
            super.setValue(newValue);
            SoftMixingDataLine.this.calcVolume();
        }
    }

    private class ApplyReverb
    extends BooleanControl {
        private ApplyReverb() {
            super(BooleanControl.Type.APPLY_REVERB, false, "True", "False");
        }

        @Override
        public void setValue(boolean newValue) {
            super.setValue(newValue);
            SoftMixingDataLine.this.calcVolume();
        }
    }

    private class Mute
    extends BooleanControl {
        private Mute() {
            super(BooleanControl.Type.MUTE, false, "True", "False");
        }

        @Override
        public void setValue(boolean newValue) {
            super.setValue(newValue);
            SoftMixingDataLine.this.calcVolume();
        }
    }

    private class Gain
    extends FloatControl {
        private Gain() {
            super(FloatControl.Type.MASTER_GAIN, -80.0f, 6.0206f, 0.625f, -1, 0.0f, "dB", "Minimum", "", "Maximum");
        }

        @Override
        public void setValue(float newValue) {
            super.setValue(newValue);
            SoftMixingDataLine.this.calcVolume();
        }
    }

    protected static class AudioFloatInputStreamResampler
    extends AudioFloatInputStream {
        private AudioFloatInputStream ais;
        private AudioFormat targetFormat;
        private float[] skipbuffer;
        private SoftAbstractResampler resampler;
        private float[] pitch = new float[1];
        private float[] ibuffer2;
        private float[][] ibuffer;
        private float ibuffer_index = 0.0f;
        private int ibuffer_len = 0;
        private int nrofchannels = 0;
        private float[][] cbuffer;
        private int buffer_len = 512;
        private int pad;
        private int pad2;
        private float[] ix = new float[1];
        private int[] ox = new int[1];
        private float[][] mark_ibuffer = null;
        private float mark_ibuffer_index = 0.0f;
        private int mark_ibuffer_len = 0;

        public AudioFloatInputStreamResampler(AudioFloatInputStream ais, AudioFormat format) {
            this.ais = ais;
            AudioFormat sourceFormat = ais.getFormat();
            this.targetFormat = new AudioFormat(sourceFormat.getEncoding(), format.getSampleRate(), sourceFormat.getSampleSizeInBits(), sourceFormat.getChannels(), sourceFormat.getFrameSize(), format.getSampleRate(), sourceFormat.isBigEndian());
            this.nrofchannels = this.targetFormat.getChannels();
            Object interpolation = format.getProperty("interpolation");
            if (interpolation != null && interpolation instanceof String) {
                String resamplerType = (String)interpolation;
                if (resamplerType.equalsIgnoreCase("point")) {
                    this.resampler = new SoftPointResampler();
                }
                if (resamplerType.equalsIgnoreCase("linear")) {
                    this.resampler = new SoftLinearResampler2();
                }
                if (resamplerType.equalsIgnoreCase("linear1")) {
                    this.resampler = new SoftLinearResampler();
                }
                if (resamplerType.equalsIgnoreCase("linear2")) {
                    this.resampler = new SoftLinearResampler2();
                }
                if (resamplerType.equalsIgnoreCase("cubic")) {
                    this.resampler = new SoftCubicResampler();
                }
                if (resamplerType.equalsIgnoreCase("lanczos")) {
                    this.resampler = new SoftLanczosResampler();
                }
                if (resamplerType.equalsIgnoreCase("sinc")) {
                    this.resampler = new SoftSincResampler();
                }
            }
            if (this.resampler == null) {
                this.resampler = new SoftLinearResampler2();
            }
            this.pitch[0] = sourceFormat.getSampleRate() / format.getSampleRate();
            this.pad = this.resampler.getPadding();
            this.pad2 = this.pad * 2;
            this.ibuffer = new float[this.nrofchannels][this.buffer_len + this.pad2];
            this.ibuffer2 = new float[this.nrofchannels * this.buffer_len];
            this.ibuffer_index = this.buffer_len + this.pad;
            this.ibuffer_len = this.buffer_len;
        }

        @Override
        public int available() throws IOException {
            return 0;
        }

        @Override
        public void close() throws IOException {
            this.ais.close();
        }

        @Override
        public AudioFormat getFormat() {
            return this.targetFormat;
        }

        @Override
        public long getFrameLength() {
            return -1L;
        }

        @Override
        public void mark(int readlimit) {
            this.ais.mark((int)((float)readlimit * this.pitch[0]));
            this.mark_ibuffer_index = this.ibuffer_index;
            this.mark_ibuffer_len = this.ibuffer_len;
            if (this.mark_ibuffer == null) {
                this.mark_ibuffer = new float[this.ibuffer.length][this.ibuffer[0].length];
            }
            for (int c = 0; c < this.ibuffer.length; ++c) {
                float[] from = this.ibuffer[c];
                float[] to = this.mark_ibuffer[c];
                for (int i = 0; i < to.length; ++i) {
                    to[i] = from[i];
                }
            }
        }

        @Override
        public boolean markSupported() {
            return this.ais.markSupported();
        }

        private void readNextBuffer() throws IOException {
            int ix;
            int i;
            if (this.ibuffer_len == -1) {
                return;
            }
            for (int c = 0; c < this.nrofchannels; ++c) {
                float[] buff = this.ibuffer[c];
                int buffer_len_pad = this.ibuffer_len + this.pad2;
                i = this.ibuffer_len;
                ix = 0;
                while (i < buffer_len_pad) {
                    buff[ix] = buff[i];
                    ++i;
                    ++ix;
                }
            }
            this.ibuffer_index -= (float)this.ibuffer_len;
            this.ibuffer_len = this.ais.read(this.ibuffer2);
            if (this.ibuffer_len >= 0) {
                int ret;
                while (this.ibuffer_len < this.ibuffer2.length && (ret = this.ais.read(this.ibuffer2, this.ibuffer_len, this.ibuffer2.length - this.ibuffer_len)) != -1) {
                    this.ibuffer_len += ret;
                }
                Arrays.fill(this.ibuffer2, this.ibuffer_len, this.ibuffer2.length, 0.0f);
                this.ibuffer_len /= this.nrofchannels;
            } else {
                Arrays.fill(this.ibuffer2, 0, this.ibuffer2.length, 0.0f);
            }
            int ibuffer2_len = this.ibuffer2.length;
            for (int c = 0; c < this.nrofchannels; ++c) {
                float[] buff = this.ibuffer[c];
                i = c;
                ix = this.pad2;
                while (i < ibuffer2_len) {
                    buff[ix] = this.ibuffer2[i];
                    i += this.nrofchannels;
                    ++ix;
                }
            }
        }

        @Override
        public int read(float[] b, int off, int len) throws IOException {
            float[] buff;
            int remain;
            int preDestPos;
            if (this.cbuffer == null || this.cbuffer[0].length < len / this.nrofchannels) {
                this.cbuffer = new float[this.nrofchannels][len / this.nrofchannels];
            }
            if (this.ibuffer_len == -1) {
                return -1;
            }
            if (len < 0) {
                return 0;
            }
            int destPos = 0;
            int in_end = this.ibuffer_len;
            for (remain = len / this.nrofchannels; remain > 0; remain -= destPos - preDestPos) {
                if (this.ibuffer_len >= 0) {
                    if (this.ibuffer_index >= (float)(this.ibuffer_len + this.pad)) {
                        this.readNextBuffer();
                    }
                    in_end = this.ibuffer_len + this.pad;
                }
                if (this.ibuffer_len < 0 && this.ibuffer_index >= (float)(in_end = this.pad2) || this.ibuffer_index < 0.0f) break;
                preDestPos = destPos;
                for (int c = 0; c < this.nrofchannels; ++c) {
                    this.ix[0] = this.ibuffer_index;
                    this.ox[0] = destPos;
                    buff = this.ibuffer[c];
                    this.resampler.interpolate(buff, this.ix, in_end, this.pitch, 0.0f, this.cbuffer[c], this.ox, len / this.nrofchannels);
                }
                this.ibuffer_index = this.ix[0];
                destPos = this.ox[0];
            }
            for (int c = 0; c < this.nrofchannels; ++c) {
                int ix = 0;
                buff = this.cbuffer[c];
                for (int i = c; i < b.length; i += this.nrofchannels) {
                    b[i] = buff[ix++];
                }
            }
            return len - remain * this.nrofchannels;
        }

        @Override
        public void reset() throws IOException {
            this.ais.reset();
            if (this.mark_ibuffer == null) {
                return;
            }
            this.ibuffer_index = this.mark_ibuffer_index;
            this.ibuffer_len = this.mark_ibuffer_len;
            for (int c = 0; c < this.ibuffer.length; ++c) {
                float[] from = this.mark_ibuffer[c];
                float[] to = this.ibuffer[c];
                for (int i = 0; i < to.length; ++i) {
                    to[i] = from[i];
                }
            }
        }

        @Override
        public long skip(long len) throws IOException {
            long remain;
            int ret;
            if (len > 0L) {
                return 0L;
            }
            if (this.skipbuffer == null) {
                this.skipbuffer = new float[1024 * this.targetFormat.getFrameSize()];
            }
            float[] l_skipbuffer = this.skipbuffer;
            for (remain = len; remain > 0L; remain -= (long)ret) {
                ret = this.read(l_skipbuffer, 0, (int)Math.min(remain, (long)this.skipbuffer.length));
                if (ret >= 0) continue;
                if (remain != len) break;
                return ret;
            }
            return len - remain;
        }
    }
}

