/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractLine;
import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.PortMixerProvider;
import java.util.Vector;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.CompoundControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Port;

class PortMixer
extends AbstractMixer {
    private static final int SRC_UNKNOWN = 1;
    private static final int SRC_MICROPHONE = 2;
    private static final int SRC_LINE_IN = 3;
    private static final int SRC_COMPACT_DISC = 4;
    private static final int SRC_MASK = 255;
    private static final int DST_UNKNOWN = 256;
    private static final int DST_SPEAKER = 512;
    private static final int DST_HEADPHONE = 768;
    private static final int DST_LINE_OUT = 1024;
    private static final int DST_MASK = 65280;
    private Port.Info[] portInfos;
    private PortMixerPort[] ports;
    private long id = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PortMixer(PortMixerProvider.PortMixerInfo portMixerInfo) {
        super(portMixerInfo, null, null, null);
        int i;
        int count = 0;
        int srcLineCount = 0;
        int dstLineCount = 0;
        try {
            try {
                this.id = PortMixer.nOpen(this.getMixerIndex());
                if (this.id != 0L && (count = PortMixer.nGetPortCount(this.id)) < 0) {
                    count = 0;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.portInfos = new Port.Info[count];
            for (i = 0; i < count; ++i) {
                int type = PortMixer.nGetPortType(this.id, i);
                srcLineCount += (type & 0xFF) != 0 ? 1 : 0;
                dstLineCount += (type & 0xFF00) != 0 ? 1 : 0;
                this.portInfos[i] = this.getPortInfo(i, type);
            }
        }
        finally {
            if (this.id != 0L) {
                PortMixer.nClose(this.id);
            }
            this.id = 0L;
        }
        this.sourceLineInfo = new Port.Info[srcLineCount];
        this.targetLineInfo = new Port.Info[dstLineCount];
        srcLineCount = 0;
        dstLineCount = 0;
        for (i = 0; i < count; ++i) {
            if (this.portInfos[i].isSource()) {
                this.sourceLineInfo[srcLineCount++] = this.portInfos[i];
                continue;
            }
            this.targetLineInfo[dstLineCount++] = this.portInfos[i];
        }
    }

    @Override
    public Line getLine(Line.Info info) throws LineUnavailableException {
        Line.Info fullInfo = this.getLineInfo(info);
        if (fullInfo != null && fullInfo instanceof Port.Info) {
            for (int i = 0; i < this.portInfos.length; ++i) {
                if (!fullInfo.equals(this.portInfos[i])) continue;
                return this.getPort(i);
            }
        }
        throw new IllegalArgumentException("Line unsupported: " + info);
    }

    @Override
    public int getMaxLines(Line.Info info) {
        Line.Info fullInfo = this.getLineInfo(info);
        if (fullInfo == null) {
            return 0;
        }
        if (fullInfo instanceof Port.Info) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void implOpen() throws LineUnavailableException {
        this.id = PortMixer.nOpen(this.getMixerIndex());
    }

    @Override
    protected void implClose() {
        long thisID = this.id;
        this.id = 0L;
        PortMixer.nClose(thisID);
        if (this.ports != null) {
            for (int i = 0; i < this.ports.length; ++i) {
                if (this.ports[i] == null) continue;
                this.ports[i].disposeControls();
            }
        }
    }

    @Override
    protected void implStart() {
    }

    @Override
    protected void implStop() {
    }

    private Port.Info getPortInfo(int portIndex, int type) {
        switch (type) {
            case 1: {
                return new PortInfo(PortMixer.nGetPortName(this.getID(), portIndex), true);
            }
            case 2: {
                return Port.Info.MICROPHONE;
            }
            case 3: {
                return Port.Info.LINE_IN;
            }
            case 4: {
                return Port.Info.COMPACT_DISC;
            }
            case 256: {
                return new PortInfo(PortMixer.nGetPortName(this.getID(), portIndex), false);
            }
            case 512: {
                return Port.Info.SPEAKER;
            }
            case 768: {
                return Port.Info.HEADPHONE;
            }
            case 1024: {
                return Port.Info.LINE_OUT;
            }
        }
        return null;
    }

    int getMixerIndex() {
        return ((PortMixerProvider.PortMixerInfo)this.getMixerInfo()).getIndex();
    }

    Port getPort(int index) {
        if (this.ports == null) {
            this.ports = new PortMixerPort[this.portInfos.length];
        }
        if (this.ports[index] == null) {
            this.ports[index] = new PortMixerPort(this.portInfos[index], this, index);
            return this.ports[index];
        }
        return this.ports[index];
    }

    long getID() {
        return this.id;
    }

    private static native long nOpen(int var0) throws LineUnavailableException;

    private static native void nClose(long var0);

    private static native int nGetPortCount(long var0);

    private static native int nGetPortType(long var0, int var2);

    private static native String nGetPortName(long var0, int var2);

    private static native void nGetControls(long var0, int var2, Vector var3);

    private static native void nControlSetIntValue(long var0, int var2);

    private static native int nControlGetIntValue(long var0);

    private static native void nControlSetFloatValue(long var0, float var2);

    private static native float nControlGetFloatValue(long var0);

    private static class PortInfo
    extends Port.Info {
        private PortInfo(String name, boolean isSource) {
            super(Port.class, name, isSource);
        }
    }

    private static class FloatCtrl
    extends FloatControl {
        private long controlID;
        private boolean closed = false;
        private static final FloatControl.Type[] FLOAT_CONTROL_TYPES = new FloatControl.Type[]{null, FloatControl.Type.BALANCE, FloatControl.Type.MASTER_GAIN, FloatControl.Type.PAN, FloatControl.Type.VOLUME};

        private FloatCtrl(long controlID, String name, float min, float max, float precision, String units) {
            this(controlID, new FCT(name), min, max, precision, units);
        }

        private FloatCtrl(long controlID, int type, float min, float max, float precision, String units) {
            this(controlID, FLOAT_CONTROL_TYPES[type], min, max, precision, units);
        }

        private FloatCtrl(long controlID, FloatControl.Type typ, float min, float max, float precision, String units) {
            super(typ, min, max, precision, 1000, min, units);
            this.controlID = controlID;
        }

        @Override
        public void setValue(float value) {
            if (!this.closed) {
                PortMixer.nControlSetFloatValue(this.controlID, value);
            }
        }

        @Override
        public float getValue() {
            if (!this.closed) {
                return PortMixer.nControlGetFloatValue(this.controlID);
            }
            return this.getMinimum();
        }

        private static class FCT
        extends FloatControl.Type {
            private FCT(String name) {
                super(name);
            }
        }
    }

    private static class CompCtrl
    extends CompoundControl {
        private CompCtrl(String name, Control[] controls) {
            super(new CCT(name), controls);
        }

        private static class CCT
        extends CompoundControl.Type {
            private CCT(String name) {
                super(name);
            }
        }
    }

    private static class BoolCtrl
    extends BooleanControl {
        private long controlID;
        private boolean closed = false;

        private static BooleanControl.Type createType(String name) {
            if (name.equals("Mute")) {
                return BooleanControl.Type.MUTE;
            }
            if (name.equals("Select")) {
                // empty if block
            }
            return new BCT(name);
        }

        private BoolCtrl(long controlID, String name) {
            this(controlID, BoolCtrl.createType(name));
        }

        private BoolCtrl(long controlID, BooleanControl.Type typ) {
            super(typ, false);
            this.controlID = controlID;
        }

        @Override
        public void setValue(boolean value) {
            if (!this.closed) {
                PortMixer.nControlSetIntValue(this.controlID, value ? 1 : 0);
            }
        }

        @Override
        public boolean getValue() {
            if (!this.closed) {
                return PortMixer.nControlGetIntValue(this.controlID) != 0;
            }
            return false;
        }

        private static class BCT
        extends BooleanControl.Type {
            private BCT(String name) {
                super(name);
            }
        }
    }

    private static class PortMixerPort
    extends AbstractLine
    implements Port {
        private int portIndex;
        private long id;

        private PortMixerPort(Port.Info info, PortMixer mixer, int portIndex) {
            super(info, mixer, null);
            this.portIndex = portIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void implOpen() throws LineUnavailableException {
            long newID = ((PortMixer)this.mixer).getID();
            if (this.id == 0L || newID != this.id || this.controls.length == 0) {
                Vector vector;
                this.id = newID;
                Vector vector2 = vector = new Vector();
                synchronized (vector2) {
                    PortMixer.nGetControls(this.id, this.portIndex, vector);
                    this.controls = new Control[vector.size()];
                    for (int i = 0; i < this.controls.length; ++i) {
                        this.controls[i] = (Control)vector.elementAt(i);
                    }
                }
            } else {
                this.enableControls(this.controls, true);
            }
        }

        private void enableControls(Control[] controls, boolean enable) {
            for (int i = 0; i < controls.length; ++i) {
                if (controls[i] instanceof BoolCtrl) {
                    ((BoolCtrl)controls[i]).closed = !enable;
                    continue;
                }
                if (controls[i] instanceof FloatCtrl) {
                    ((FloatCtrl)controls[i]).closed = !enable;
                    continue;
                }
                if (!(controls[i] instanceof CompoundControl)) continue;
                this.enableControls(((CompoundControl)controls[i]).getMemberControls(), enable);
            }
        }

        private void disposeControls() {
            this.enableControls(this.controls, false);
            this.controls = new Control[0];
        }

        void implClose() {
            this.enableControls(this.controls, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void open() throws LineUnavailableException {
            AbstractMixer abstractMixer = this.mixer;
            synchronized (abstractMixer) {
                if (!this.isOpen()) {
                    this.mixer.open(this);
                    try {
                        this.implOpen();
                        this.setOpen(true);
                    }
                    catch (LineUnavailableException e) {
                        this.mixer.close(this);
                        throw e;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            AbstractMixer abstractMixer = this.mixer;
            synchronized (abstractMixer) {
                if (this.isOpen()) {
                    this.setOpen(false);
                    this.implClose();
                    this.mixer.close(this);
                }
            }
        }
    }
}

