/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AudioFloatInputStream;
import com.sun.media.sound.ModelByteBuffer;
import com.sun.media.sound.ModelOscillatorStream;
import com.sun.media.sound.ModelWavetable;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class ModelByteBufferWavetable
implements ModelWavetable {
    private float loopStart = -1.0f;
    private float loopLength = -1.0f;
    private ModelByteBuffer buffer;
    private ModelByteBuffer buffer8 = null;
    private AudioFormat format = null;
    private float pitchcorrection = 0.0f;
    private float attenuation = 0.0f;
    private int loopType = 0;

    public ModelByteBufferWavetable(ModelByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ModelByteBufferWavetable(ModelByteBuffer buffer, float pitchcorrection) {
        this.buffer = buffer;
        this.pitchcorrection = pitchcorrection;
    }

    public ModelByteBufferWavetable(ModelByteBuffer buffer, AudioFormat format) {
        this.format = format;
        this.buffer = buffer;
    }

    public ModelByteBufferWavetable(ModelByteBuffer buffer, AudioFormat format, float pitchcorrection) {
        this.format = format;
        this.buffer = buffer;
        this.pitchcorrection = pitchcorrection;
    }

    public void set8BitExtensionBuffer(ModelByteBuffer buffer) {
        this.buffer8 = buffer;
    }

    public ModelByteBuffer get8BitExtensionBuffer() {
        return this.buffer8;
    }

    public ModelByteBuffer getBuffer() {
        return this.buffer;
    }

    public AudioFormat getFormat() {
        if (this.format == null) {
            if (this.buffer == null) {
                return null;
            }
            InputStream is = this.buffer.getInputStream();
            AudioFormat format = null;
            try {
                format = AudioSystem.getAudioFileFormat(is).getFormat();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return format;
        }
        return this.format;
    }

    @Override
    public AudioFloatInputStream openStream() {
        if (this.buffer == null) {
            return null;
        }
        if (this.format == null) {
            InputStream is = this.buffer.getInputStream();
            AudioInputStream ais = null;
            try {
                ais = AudioSystem.getAudioInputStream(is);
            }
            catch (Exception e) {
                return null;
            }
            return AudioFloatInputStream.getInputStream(ais);
        }
        if (this.buffer.array() == null) {
            return AudioFloatInputStream.getInputStream(new AudioInputStream(this.buffer.getInputStream(), this.format, this.buffer.capacity() / (long)this.format.getFrameSize()));
        }
        if (this.buffer8 != null && (this.format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) || this.format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED))) {
            Buffer8PlusInputStream is = new Buffer8PlusInputStream();
            AudioFormat format2 = new AudioFormat(this.format.getEncoding(), this.format.getSampleRate(), this.format.getSampleSizeInBits() + 8, this.format.getChannels(), this.format.getFrameSize() + 1 * this.format.getChannels(), this.format.getFrameRate(), this.format.isBigEndian());
            AudioInputStream ais = new AudioInputStream(is, format2, this.buffer.capacity() / (long)this.format.getFrameSize());
            return AudioFloatInputStream.getInputStream(ais);
        }
        return AudioFloatInputStream.getInputStream(this.format, this.buffer.array(), (int)this.buffer.arrayOffset(), (int)this.buffer.capacity());
    }

    @Override
    public int getChannels() {
        return this.getFormat().getChannels();
    }

    @Override
    public ModelOscillatorStream open(float samplerate) {
        return null;
    }

    @Override
    public float getAttenuation() {
        return this.attenuation;
    }

    public void setAttenuation(float attenuation) {
        this.attenuation = attenuation;
    }

    @Override
    public float getLoopLength() {
        return this.loopLength;
    }

    public void setLoopLength(float loopLength) {
        this.loopLength = loopLength;
    }

    @Override
    public float getLoopStart() {
        return this.loopStart;
    }

    public void setLoopStart(float loopStart) {
        this.loopStart = loopStart;
    }

    public void setLoopType(int loopType) {
        this.loopType = loopType;
    }

    @Override
    public int getLoopType() {
        return this.loopType;
    }

    @Override
    public float getPitchcorrection() {
        return this.pitchcorrection;
    }

    public void setPitchcorrection(float pitchcorrection) {
        this.pitchcorrection = pitchcorrection;
    }

    private class Buffer8PlusInputStream
    extends InputStream {
        private boolean bigendian;
        private int framesize_pc;
        int pos = 0;
        int pos2 = 0;
        int markpos = 0;
        int markpos2 = 0;

        public Buffer8PlusInputStream() {
            this.framesize_pc = ModelByteBufferWavetable.this.format.getFrameSize() / ModelByteBufferWavetable.this.format.getChannels();
            this.bigendian = ModelByteBufferWavetable.this.format.isBigEndian();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int avail = this.available();
            if (avail <= 0) {
                return -1;
            }
            if (len > avail) {
                len = avail;
            }
            byte[] buff1 = ModelByteBufferWavetable.this.buffer.array();
            byte[] buff2 = ModelByteBufferWavetable.this.buffer8.array();
            this.pos = (int)((long)this.pos + ModelByteBufferWavetable.this.buffer.arrayOffset());
            this.pos2 = (int)((long)this.pos2 + ModelByteBufferWavetable.this.buffer8.arrayOffset());
            if (this.bigendian) {
                for (int i = 0; i < len; i += this.framesize_pc + 1) {
                    System.arraycopy(buff1, this.pos, b, i, this.framesize_pc);
                    System.arraycopy(buff2, this.pos2, b, i + this.framesize_pc, 1);
                    this.pos += this.framesize_pc;
                    ++this.pos2;
                }
            } else {
                for (int i = 0; i < len; i += this.framesize_pc + 1) {
                    System.arraycopy(buff2, this.pos2, b, i, 1);
                    System.arraycopy(buff1, this.pos, b, i + 1, this.framesize_pc);
                    this.pos += this.framesize_pc;
                    ++this.pos2;
                }
            }
            this.pos = (int)((long)this.pos - ModelByteBufferWavetable.this.buffer.arrayOffset());
            this.pos2 = (int)((long)this.pos2 - ModelByteBufferWavetable.this.buffer8.arrayOffset());
            return len;
        }

        @Override
        public long skip(long n) throws IOException {
            int avail = this.available();
            if (avail <= 0) {
                return -1L;
            }
            if (n > (long)avail) {
                n = avail;
            }
            this.pos = (int)((long)this.pos + n / (long)(this.framesize_pc + 1) * (long)this.framesize_pc);
            this.pos2 = (int)((long)this.pos2 + n / (long)(this.framesize_pc + 1));
            return super.skip(n);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int ret = this.read(b, 0, 1);
            if (ret == -1) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public int available() throws IOException {
            return (int)ModelByteBufferWavetable.this.buffer.capacity() + (int)ModelByteBufferWavetable.this.buffer8.capacity() - this.pos - this.pos2;
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.markpos = this.pos;
            this.markpos2 = this.pos2;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.pos = this.markpos;
            this.pos2 = this.markpos2;
        }
    }
}

