/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractLine;
import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.Platform;
import com.sun.media.sound.Toolkit;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineUnavailableException;

abstract class AbstractDataLine
extends AbstractLine
implements DataLine {
    protected AudioFormat defaultFormat;
    protected int defaultBufferSize;
    protected Object lock = new Object();
    protected AudioFormat format;
    protected int bufferSize;
    protected boolean running = false;
    private boolean started = false;
    private boolean active = false;

    protected AbstractDataLine(DataLine.Info info, AbstractMixer mixer, Control[] controls) {
        this(info, mixer, controls, null, -1);
    }

    protected AbstractDataLine(DataLine.Info info, AbstractMixer mixer, Control[] controls, AudioFormat format, int bufferSize) {
        super(info, mixer, controls);
        this.defaultFormat = format != null ? format : new AudioFormat(44100.0f, 16, 2, true, Platform.isBigEndian());
        this.defaultBufferSize = bufferSize > 0 ? bufferSize : (int)(this.defaultFormat.getFrameRate() / 2.0f) * this.defaultFormat.getFrameSize();
        this.format = this.defaultFormat;
        this.bufferSize = this.defaultBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(AudioFormat format, int bufferSize) throws LineUnavailableException {
        AbstractMixer abstractMixer = this.mixer;
        synchronized (abstractMixer) {
            if (!this.isOpen()) {
                Toolkit.isFullySpecifiedAudioFormat(format);
                this.mixer.open(this);
                try {
                    this.implOpen(format, bufferSize);
                    this.setOpen(true);
                }
                catch (LineUnavailableException e) {
                    this.mixer.close(this);
                    throw e;
                }
            } else {
                if (!format.matches(this.getFormat())) {
                    throw new IllegalStateException("Line is already open with format " + this.getFormat() + " and bufferSize " + this.getBufferSize());
                }
                if (bufferSize > 0) {
                    this.setBufferSize(bufferSize);
                }
            }
        }
    }

    public void open(AudioFormat format) throws LineUnavailableException {
        this.open(format, -1);
    }

    @Override
    public int available() {
        return 0;
    }

    @Override
    public void drain() {
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.mixer;
        synchronized (object) {
            if (this.isOpen() && !this.isStartedRunning()) {
                this.mixer.start(this);
                this.implStart();
                this.running = true;
            }
        }
        object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.mixer;
        synchronized (object) {
            if (this.isOpen() && this.isStartedRunning()) {
                this.implStop();
                this.mixer.stop(this);
                this.running = false;
                if (this.started && !this.isActive()) {
                    this.setStarted(false);
                }
            }
        }
        object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    @Override
    public boolean isRunning() {
        return this.started;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public long getMicrosecondPosition() {
        long microseconds = this.getLongFramePosition();
        if (microseconds != -1L) {
            microseconds = Toolkit.frames2micros(this.getFormat(), microseconds);
        }
        return microseconds;
    }

    @Override
    public AudioFormat getFormat() {
        return this.format;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    public int setBufferSize(int newSize) {
        return this.getBufferSize();
    }

    @Override
    public float getLevel() {
        return -1.0f;
    }

    protected boolean isStartedRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setActive(boolean active) {
        AbstractDataLine abstractDataLine = this;
        synchronized (abstractDataLine) {
            if (this.active != active) {
                this.active = active;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStarted(boolean started) {
        boolean sendEvents = false;
        long position = this.getLongFramePosition();
        AbstractDataLine abstractDataLine = this;
        synchronized (abstractDataLine) {
            if (this.started != started) {
                this.started = started;
                sendEvents = true;
            }
        }
        if (sendEvents) {
            if (started) {
                this.sendEvents(new LineEvent(this, LineEvent.Type.START, position));
            } else {
                this.sendEvents(new LineEvent(this, LineEvent.Type.STOP, position));
            }
        }
    }

    protected void setEOM() {
        this.setStarted(false);
    }

    @Override
    public void open() throws LineUnavailableException {
        this.open(this.format, this.bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AbstractMixer abstractMixer = this.mixer;
        synchronized (abstractMixer) {
            if (this.isOpen()) {
                this.stop();
                this.setOpen(false);
                this.implClose();
                this.mixer.close(this);
                this.format = this.defaultFormat;
                this.bufferSize = this.defaultBufferSize;
            }
        }
    }

    abstract void implOpen(AudioFormat var1, int var2) throws LineUnavailableException;

    abstract void implClose();

    abstract void implStart();

    abstract void implStop();
}

