/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.DescriptorCache;
import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.MBeanAnalyzer;
import com.sun.jmx.mbeanserver.PerInterface;
import com.sun.jmx.mbeanserver.Util;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.WeakHashMap;
import javax.management.Descriptor;
import javax.management.ImmutableDescriptor;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import javax.management.ReflectionException;

abstract class MBeanIntrospector<M> {
    MBeanIntrospector() {
    }

    abstract PerInterfaceMap<M> getPerInterfaceMap();

    abstract MBeanInfoMap getMBeanInfoMap();

    abstract MBeanAnalyzer<M> getAnalyzer(Class<?> var1) throws NotCompliantMBeanException;

    abstract boolean isMXBean();

    abstract M mFrom(Method var1);

    abstract String getName(M var1);

    abstract Type getGenericReturnType(M var1);

    abstract Type[] getGenericParameterTypes(M var1);

    abstract String[] getSignature(M var1);

    abstract void checkMethod(M var1);

    abstract Object invokeM2(M var1, Object var2, Object[] var3, Object var4) throws InvocationTargetException, IllegalAccessException, MBeanException;

    abstract boolean validParameter(M var1, Object var2, int var3, Object var4);

    abstract MBeanAttributeInfo getMBeanAttributeInfo(String var1, M var2, M var3);

    abstract MBeanOperationInfo getMBeanOperationInfo(String var1, M var2);

    abstract Descriptor getBasicMBeanDescriptor();

    abstract Descriptor getMBeanDescriptor(Class<?> var1);

    List<Method> getMethods(Class<?> mbeanType) {
        return Arrays.asList(mbeanType.getMethods());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PerInterface<M> getPerInterface(Class<?> mbeanInterface) throws NotCompliantMBeanException {
        PerInterfaceMap<M> map;
        PerInterfaceMap<M> perInterfaceMap = map = this.getPerInterfaceMap();
        synchronized (perInterfaceMap) {
            PerInterface<M> pi;
            WeakReference<PerInterface<M>> wr = (WeakReference<PerInterface<M>>)map.get(mbeanInterface);
            PerInterface<M> perInterface = pi = wr == null ? null : (PerInterface<M>)wr.get();
            if (pi == null) {
                try {
                    MBeanAnalyzer<M> analyzer = this.getAnalyzer(mbeanInterface);
                    MBeanInfo mbeanInfo = this.makeInterfaceMBeanInfo(mbeanInterface, analyzer);
                    pi = new PerInterface<M>(mbeanInterface, this, analyzer, mbeanInfo);
                    wr = new WeakReference<PerInterface<M>>(pi);
                    map.put(mbeanInterface, wr);
                }
                catch (Exception x) {
                    throw Introspector.throwException(mbeanInterface, x);
                }
            }
            return pi;
        }
    }

    private MBeanInfo makeInterfaceMBeanInfo(Class<?> mbeanInterface, MBeanAnalyzer<M> analyzer) {
        MBeanInfoMaker maker = new MBeanInfoMaker();
        analyzer.visit(maker);
        String description = "Information on the management interface of the MBean";
        return maker.makeMBeanInfo(mbeanInterface, "Information on the management interface of the MBean");
    }

    final boolean consistent(M getter, M setter) {
        return getter == null || setter == null || this.getGenericReturnType(getter).equals(this.getGenericParameterTypes(setter)[0]);
    }

    final Object invokeM(M m, Object target, Object[] args, Object cookie) throws MBeanException, ReflectionException {
        try {
            return this.invokeM2(m, target, args, cookie);
        }
        catch (InvocationTargetException e) {
            MBeanIntrospector.unwrapInvocationTargetException(e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e, e.toString());
        }
    }

    final void invokeSetter(String name, M setter, Object target, Object arg, Object cookie) throws MBeanException, ReflectionException, InvalidAttributeValueException {
        try {
            this.invokeM2(setter, target, new Object[]{arg}, cookie);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e, e.toString());
        }
        catch (RuntimeException e) {
            this.maybeInvalidParameter(name, setter, arg, cookie);
            throw e;
        }
        catch (InvocationTargetException e) {
            this.maybeInvalidParameter(name, setter, arg, cookie);
            MBeanIntrospector.unwrapInvocationTargetException(e);
        }
    }

    private void maybeInvalidParameter(String name, M setter, Object arg, Object cookie) throws InvalidAttributeValueException {
        if (!this.validParameter(setter, arg, 0, cookie)) {
            String msg = "Invalid value for attribute " + name + ": " + arg;
            throw new InvalidAttributeValueException(msg);
        }
    }

    static boolean isValidParameter(Method m, Object value, int paramNo) {
        Class<?> c = m.getParameterTypes()[paramNo];
        try {
            Object a = Array.newInstance(c, 1);
            Array.set(a, 0, value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static void unwrapInvocationTargetException(InvocationTargetException e) throws MBeanException {
        Throwable t = e.getCause();
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new MBeanException((Exception)t, t == null ? null : t.toString());
    }

    final MBeanInfo getMBeanInfo(Object resource, PerInterface<M> perInterface) {
        MBeanInfo mbi = this.getClassMBeanInfo(resource.getClass(), perInterface);
        MBeanNotificationInfo[] notifs = MBeanIntrospector.findNotifications(resource);
        if (notifs == null || notifs.length == 0) {
            return mbi;
        }
        return new MBeanInfo(mbi.getClassName(), mbi.getDescription(), mbi.getAttributes(), mbi.getConstructors(), mbi.getOperations(), notifs, mbi.getDescriptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final MBeanInfo getClassMBeanInfo(Class<?> resourceClass, PerInterface<M> perInterface) {
        MBeanInfoMap map;
        MBeanInfoMap mBeanInfoMap = map = this.getMBeanInfoMap();
        synchronized (mBeanInfoMap) {
            Class<?> intfClass;
            MBeanInfo mbi;
            WeakHashMap intfMap = (WeakHashMap)map.get(resourceClass);
            if (intfMap == null) {
                intfMap = new WeakHashMap();
                map.put(resourceClass, intfMap);
            }
            if ((mbi = (MBeanInfo)intfMap.get(intfClass = perInterface.getMBeanInterface())) == null) {
                MBeanInfo imbi = perInterface.getMBeanInfo();
                ImmutableDescriptor descriptor = ImmutableDescriptor.union(imbi.getDescriptor(), this.getMBeanDescriptor(resourceClass));
                mbi = new MBeanInfo(resourceClass.getName(), imbi.getDescription(), imbi.getAttributes(), MBeanIntrospector.findConstructors(resourceClass), imbi.getOperations(), null, descriptor);
                intfMap.put(intfClass, mbi);
            }
            return mbi;
        }
    }

    static MBeanNotificationInfo[] findNotifications(Object moi) {
        if (!(moi instanceof NotificationBroadcaster)) {
            return null;
        }
        MBeanNotificationInfo[] mbn = ((NotificationBroadcaster)moi).getNotificationInfo();
        if (mbn == null) {
            return null;
        }
        MBeanNotificationInfo[] result = new MBeanNotificationInfo[mbn.length];
        for (int i = 0; i < mbn.length; ++i) {
            MBeanNotificationInfo ni = mbn[i];
            if (ni.getClass() != MBeanNotificationInfo.class) {
                ni = (MBeanNotificationInfo)ni.clone();
            }
            result[i] = ni;
        }
        return result;
    }

    private static MBeanConstructorInfo[] findConstructors(Class<?> c) {
        Constructor<?>[] cons = c.getConstructors();
        MBeanConstructorInfo[] mbc = new MBeanConstructorInfo[cons.length];
        for (int i = 0; i < cons.length; ++i) {
            String descr = "Public constructor of the MBean";
            mbc[i] = new MBeanConstructorInfo("Public constructor of the MBean", cons[i]);
        }
        return mbc;
    }

    static class MBeanInfoMap
    extends WeakHashMap<Class<?>, WeakHashMap<Class<?>, MBeanInfo>> {
        MBeanInfoMap() {
        }
    }

    private class MBeanInfoMaker
    implements MBeanAnalyzer.MBeanVisitor<M> {
        private final List<MBeanAttributeInfo> attrs = Util.newList();
        private final List<MBeanOperationInfo> ops = Util.newList();

        private MBeanInfoMaker() {
        }

        @Override
        public void visitAttribute(String attributeName, M getter, M setter) {
            MBeanAttributeInfo mbai = MBeanIntrospector.this.getMBeanAttributeInfo(attributeName, getter, setter);
            this.attrs.add(mbai);
        }

        @Override
        public void visitOperation(String operationName, M operation) {
            MBeanOperationInfo mboi = MBeanIntrospector.this.getMBeanOperationInfo(operationName, operation);
            this.ops.add(mboi);
        }

        MBeanInfo makeMBeanInfo(Class<?> mbeanInterface, String description) {
            MBeanAttributeInfo[] attrArray = this.attrs.toArray(new MBeanAttributeInfo[0]);
            MBeanOperationInfo[] opArray = this.ops.toArray(new MBeanOperationInfo[0]);
            String interfaceClassName = "interfaceClassName=" + mbeanInterface.getName();
            ImmutableDescriptor classNameDescriptor = new ImmutableDescriptor(interfaceClassName);
            Descriptor mbeanDescriptor = MBeanIntrospector.this.getBasicMBeanDescriptor();
            Descriptor annotatedDescriptor = Introspector.descriptorForElement(mbeanInterface);
            ImmutableDescriptor descriptor = DescriptorCache.getInstance().union(classNameDescriptor, mbeanDescriptor, annotatedDescriptor);
            return new MBeanInfo(mbeanInterface.getName(), description, attrArray, null, opArray, null, descriptor);
        }
    }

    static final class PerInterfaceMap<M>
    extends WeakHashMap<Class<?>, WeakReference<PerInterface<M>>> {
        PerInterfaceMap() {
        }
    }
}

