/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nio.zipfs;

import com.sun.nio.zipfs.ZipFileAttributes;
import com.sun.nio.zipfs.ZipPath;
import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.util.LinkedHashMap;
import java.util.Map;

public class ZipFileAttributeView
implements BasicFileAttributeView {
    private final ZipPath path;
    private final boolean isZipView;

    private ZipFileAttributeView(ZipPath path, boolean isZipView) {
        this.path = path;
        this.isZipView = isZipView;
    }

    static <V extends FileAttributeView> V get(ZipPath path, Class<V> type) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (type == BasicFileAttributeView.class) {
            return (V)new ZipFileAttributeView(path, false);
        }
        if (type == ZipFileAttributeView.class) {
            return (V)new ZipFileAttributeView(path, true);
        }
        return null;
    }

    static ZipFileAttributeView get(ZipPath path, String type) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (type.equals("basic")) {
            return new ZipFileAttributeView(path, false);
        }
        if (type.equals("zip")) {
            return new ZipFileAttributeView(path, true);
        }
        return null;
    }

    @Override
    public String name() {
        return this.isZipView ? "zip" : "basic";
    }

    @Override
    public ZipFileAttributes readAttributes() throws IOException {
        return this.path.getAttributes();
    }

    @Override
    public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
        this.path.setTimes(lastModifiedTime, lastAccessTime, createTime);
    }

    void setAttribute(String attribute, Object value) throws IOException {
        try {
            if (AttrID.valueOf(attribute) == AttrID.lastModifiedTime) {
                this.setTimes((FileTime)value, null, null);
            }
            if (AttrID.valueOf(attribute) == AttrID.lastAccessTime) {
                this.setTimes(null, (FileTime)value, null);
            }
            if (AttrID.valueOf(attribute) == AttrID.creationTime) {
                this.setTimes(null, null, (FileTime)value);
            }
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedOperationException("'" + attribute + "' is unknown or read-only attribute");
        }
    }

    Map<String, Object> readAttributes(String attributes) throws IOException {
        ZipFileAttributes zfas = this.readAttributes();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if ("*".equals(attributes)) {
            for (AttrID id : AttrID.values()) {
                try {
                    map.put(id.name(), this.attribute(id, zfas));
                }
                catch (IllegalArgumentException x) {
                    // empty catch block
                }
            }
        } else {
            String[] as;
            for (String a : as = attributes.split(",")) {
                try {
                    map.put(a, this.attribute(AttrID.valueOf(a), zfas));
                }
                catch (IllegalArgumentException x) {
                    // empty catch block
                }
            }
        }
        return map;
    }

    Object attribute(AttrID id, ZipFileAttributes zfas) {
        switch (id) {
            case size: {
                return zfas.size();
            }
            case creationTime: {
                return zfas.creationTime();
            }
            case lastAccessTime: {
                return zfas.lastAccessTime();
            }
            case lastModifiedTime: {
                return zfas.lastModifiedTime();
            }
            case isDirectory: {
                return zfas.isDirectory();
            }
            case isRegularFile: {
                return zfas.isRegularFile();
            }
            case isSymbolicLink: {
                return zfas.isSymbolicLink();
            }
            case isOther: {
                return zfas.isOther();
            }
            case fileKey: {
                return zfas.fileKey();
            }
            case compressedSize: {
                if (!this.isZipView) break;
                return zfas.compressedSize();
            }
            case crc: {
                if (!this.isZipView) break;
                return zfas.crc();
            }
            case method: {
                if (!this.isZipView) break;
                return zfas.method();
            }
        }
        return null;
    }

    private static enum AttrID {
        size,
        creationTime,
        lastAccessTime,
        lastModifiedTime,
        isDirectory,
        isRegularFile,
        isSymbolicLink,
        isOther,
        fileKey,
        compressedSize,
        crc,
        method;

    }
}

