/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.DelegatableDecoder;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.JIS_X_0201;
import sun.nio.cs.ext.JIS_X_0208;
import sun.nio.cs.ext.JIS_X_0208_Decoder;
import sun.nio.cs.ext.JIS_X_0208_Encoder;

public class SJIS
extends Charset
implements HistoricallyNamedCharset {
    public SJIS() {
        super("Shift_JIS", ExtendedCharsets.aliasesFor("Shift_JIS"));
    }

    @Override
    public String historicalName() {
        return "SJIS";
    }

    @Override
    public boolean contains(Charset cs) {
        return cs.name().equals("US-ASCII") || cs instanceof JIS_X_0201 || cs instanceof SJIS || cs instanceof JIS_X_0208;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        byte[] replacementBytes = new byte[]{63};
        return new Encoder(this).replaceWith(replacementBytes);
    }

    static class Encoder
    extends JIS_X_0208_Encoder {
        private JIS_X_0201.Encoder jis0201;
        private static final short[] j0208Index1 = JIS_X_0208_Encoder.getIndex1();
        private static final String[] j0208Index2 = JIS_X_0208_Encoder.getIndex2();

        protected Encoder(Charset cs) {
            super(cs);
            this.jis0201 = new JIS_X_0201.Encoder(cs);
        }

        @Override
        protected int encodeSingle(char inputChar) {
            if ((inputChar & 0xFF80) == 0) {
                return (byte)inputChar;
            }
            byte b = this.jis0201.encode(inputChar);
            if (b == 0) {
                return -1;
            }
            return b;
        }

        @Override
        protected int encodeDouble(char ch) {
            int rowOffset;
            int offset = j0208Index1[ch >> 8] << 8;
            char pos = j0208Index2[offset >> 12].charAt((offset & 0xFFF) + (ch & 0xFF));
            if (pos == '\u0000') {
                return 0;
            }
            int c1 = pos >> 8 & 0xFF;
            int c2 = pos & 0xFF;
            int n = rowOffset = c1 < 95 ? 112 : 176;
            int cellOffset = c1 % 2 == 1 ? (c2 > 95 ? 32 : 31) : 126;
            return (c1 + 1 >> 1) + rowOffset << 8 | c2 + cellOffset;
        }
    }

    static class Decoder
    extends JIS_X_0208_Decoder
    implements DelegatableDecoder {
        JIS_X_0201.Decoder jis0201;

        protected Decoder(Charset cs) {
            super(cs);
            this.jis0201 = new JIS_X_0201.Decoder(cs);
        }

        @Override
        protected char decodeSingle(int b) {
            if ((b & 0xFF80) == 0) {
                return (char)b;
            }
            return this.jis0201.decode(b);
        }

        @Override
        protected char decodeDouble(int c1, int c2) {
            int rowOffset;
            int adjust = c2 < 159 ? 1 : 0;
            int n = rowOffset = c1 < 160 ? 112 : 176;
            int cellOffset = adjust == 1 ? (c2 > 127 ? 32 : 31) : 126;
            int b1 = (c1 - rowOffset << 1) - adjust;
            int b2 = c2 - cellOffset;
            return super.decodeDouble(b1, b2);
        }

        @Override
        public CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
            return super.decodeLoop(src, dst);
        }

        @Override
        public void implReset() {
            super.implReset();
        }

        @Override
        public CoderResult implFlush(CharBuffer out) {
            return super.implFlush(out);
        }
    }
}

