/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.crypto.BadPaddingException;
import javax.net.ssl.SSLException;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.ByteBufferInputStream;
import sun.security.ssl.CipherBox;
import sun.security.ssl.Debug;
import sun.security.ssl.InputRecord;
import sun.security.ssl.MAC;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLEngineImpl;

final class EngineInputRecord
extends InputRecord {
    private SSLEngineImpl engine;
    private static ByteBuffer tmpBB = ByteBuffer.allocate(0);
    private boolean internalData;

    EngineInputRecord(SSLEngineImpl engine) {
        this.engine = engine;
    }

    @Override
    byte contentType() {
        if (this.internalData) {
            return super.contentType();
        }
        return 23;
    }

    int bytesInCompletePacket(ByteBuffer buf) throws SSLException {
        if (buf.remaining() < 5) {
            return -1;
        }
        int pos = buf.position();
        byte byteZero = buf.get(pos);
        int len = 0;
        if (this.formatVerified || byteZero == 22 || byteZero == 21) {
            ProtocolVersion recordVersion = ProtocolVersion.valueOf(buf.get(pos + 1), buf.get(pos + 2));
            if (recordVersion.v < ProtocolVersion.MIN.v || recordVersion.major > ProtocolVersion.MAX.major) {
                throw new SSLException("Unsupported record version " + recordVersion);
            }
            this.formatVerified = true;
            len = ((buf.get(pos + 3) & 0xFF) << 8) + (buf.get(pos + 4) & 0xFF) + 5;
        } else {
            boolean isShort;
            boolean bl = isShort = (byteZero & 0x80) != 0;
            if (isShort && (buf.get(pos + 2) == 1 || buf.get(pos + 2) == 4)) {
                ProtocolVersion recordVersion = ProtocolVersion.valueOf(buf.get(pos + 3), buf.get(pos + 4));
                if ((recordVersion.v < ProtocolVersion.MIN.v || recordVersion.major > ProtocolVersion.MAX.major) && recordVersion.v != ProtocolVersion.SSL20Hello.v) {
                    throw new SSLException("Unsupported record version " + recordVersion);
                }
                int mask = isShort ? 127 : 63;
                len = ((byteZero & mask) << 8) + (buf.get(pos + 1) & 0xFF) + (isShort ? 2 : 3);
            } else {
                throw new SSLException("Unrecognized SSL message, plaintext connection?");
            }
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer decrypt(MAC signer, CipherBox box, ByteBuffer bb) throws BadPaddingException {
        if (this.internalData) {
            this.decrypt(signer, box);
            return tmpBB;
        }
        BadPaddingException reservedBPE = null;
        int tagLen = signer.MAClen();
        int cipheredLength = bb.remaining();
        if (!box.isNullCipher()) {
            if (!box.sanityCheck(tagLen, cipheredLength)) {
                throw new BadPaddingException("ciphertext sanity check failed");
            }
            try {
                box.decrypt(bb, tagLen);
            }
            catch (BadPaddingException bpe) {
                reservedBPE = bpe;
            }
            finally {
                bb.rewind();
            }
        }
        if (tagLen != 0) {
            int macOffset = bb.limit() - tagLen;
            if (bb.remaining() < tagLen) {
                if (reservedBPE == null) {
                    reservedBPE = new BadPaddingException("bad record");
                }
                macOffset = cipheredLength - tagLen;
                bb.limit(cipheredLength);
            }
            if (EngineInputRecord.checkMacTags(this.contentType(), bb, signer, false) && reservedBPE == null) {
                reservedBPE = new BadPaddingException("bad record MAC");
            }
            if (box.isCBCMode()) {
                int remainingLen = EngineInputRecord.calculateRemainingLen(signer, cipheredLength, macOffset);
                if (remainingLen > this.buf.length) {
                    throw new RuntimeException("Internal buffer capacity error");
                }
                EngineInputRecord.checkMacTags(this.contentType(), this.buf, 0, remainingLen, signer, true);
            }
            bb.limit(macOffset);
        }
        if (reservedBPE != null) {
            throw reservedBPE;
        }
        return bb.slice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkMacTags(byte contentType, ByteBuffer bb, MAC signer, boolean isSimulated) {
        int tagLen = signer.MAClen();
        int lim = bb.limit();
        int macData = lim - tagLen;
        bb.limit(macData);
        byte[] hash = signer.compute(contentType, bb, isSimulated);
        if (hash == null || tagLen != hash.length) {
            throw new RuntimeException("Internal MAC error");
        }
        bb.position(macData);
        bb.limit(lim);
        try {
            int[] results = EngineInputRecord.compareMacTags(bb, hash);
            boolean bl = results[0] != 0;
            return bl;
        }
        finally {
            bb.rewind();
            bb.limit(macData);
        }
    }

    private static int[] compareMacTags(ByteBuffer bb, byte[] tag) {
        int[] results = new int[]{0, 0};
        for (int i = 0; i < tag.length; ++i) {
            if (bb.get() != tag[i]) {
                results[0] = results[0] + 1;
                continue;
            }
            results[1] = results[1] + 1;
        }
        return results;
    }

    @Override
    void writeBuffer(OutputStream s, byte[] buf, int off, int len) throws IOException {
        ByteBuffer netBB = (ByteBuffer)ByteBuffer.allocate(len).put(buf, 0, len).flip();
        this.engine.writer.putOutboundDataSync(netBB);
    }

    ByteBuffer read(ByteBuffer srcBB) throws IOException {
        if (!this.formatVerified || srcBB.get(srcBB.position()) != 23) {
            this.internalData = true;
            this.read(new ByteBufferInputStream(srcBB), null);
            return tmpBB;
        }
        this.internalData = false;
        int srcPos = srcBB.position();
        int srcLim = srcBB.limit();
        ProtocolVersion recordVersion = ProtocolVersion.valueOf(srcBB.get(srcPos + 1), srcBB.get(srcPos + 2));
        if (recordVersion.v < ProtocolVersion.MIN.v || recordVersion.major > ProtocolVersion.MAX.major) {
            throw new SSLException("Unsupported record version " + recordVersion);
        }
        int len = this.bytesInCompletePacket(srcBB);
        assert (len > 0);
        if (debug != null && Debug.isOn("packet")) {
            try {
                HexDumpEncoder hd = new HexDumpEncoder();
                srcBB.limit(srcPos + len);
                ByteBuffer bb = srcBB.duplicate();
                System.out.println("[Raw read (bb)]: length = " + len);
                hd.encodeBuffer(bb, (OutputStream)System.out);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        srcBB.position(srcPos + 5);
        srcBB.limit(srcPos + len);
        ByteBuffer bb = srcBB.slice();
        srcBB.position(srcBB.limit());
        srcBB.limit(srcLim);
        return bb;
    }
}

