/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import sun.security.util.BitArray;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.KeyUsageExtension;

public class NetscapeCertTypeExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.NetscapeCertType";
    public static final String NAME = "NetscapeCertType";
    public static final String SSL_CLIENT = "ssl_client";
    public static final String SSL_SERVER = "ssl_server";
    public static final String S_MIME = "s_mime";
    public static final String OBJECT_SIGNING = "object_signing";
    public static final String SSL_CA = "ssl_ca";
    public static final String S_MIME_CA = "s_mime_ca";
    public static final String OBJECT_SIGNING_CA = "object_signing_ca";
    private static final int[] CertType_data = new int[]{2, 16, 840, 1, 113730, 1, 1};
    public static ObjectIdentifier NetscapeCertType_Id;
    private boolean[] bitString;
    private static MapEntry[] mMapData;
    private static final Vector<String> mAttributeNames;

    private static int getPosition(String name) throws IOException {
        for (int i = 0; i < mMapData.length; ++i) {
            if (!name.equalsIgnoreCase(NetscapeCertTypeExtension.mMapData[i].mName)) continue;
            return NetscapeCertTypeExtension.mMapData[i].mPosition;
        }
        throw new IOException("Attribute name [" + name + "] not recognized by CertAttrSet:NetscapeCertType.");
    }

    private void encodeThis() throws IOException {
        DerOutputStream os = new DerOutputStream();
        os.putTruncatedUnalignedBitString(new BitArray(this.bitString));
        this.extensionValue = os.toByteArray();
    }

    private boolean isSet(int position) {
        return this.bitString[position];
    }

    private void set(int position, boolean val) {
        if (position >= this.bitString.length) {
            boolean[] tmp = new boolean[position + 1];
            System.arraycopy(this.bitString, 0, tmp, 0, this.bitString.length);
            this.bitString = tmp;
        }
        this.bitString[position] = val;
    }

    public NetscapeCertTypeExtension(byte[] bitString) throws IOException {
        this.bitString = new BitArray(bitString.length * 8, bitString).toBooleanArray();
        this.extensionId = NetscapeCertType_Id;
        this.critical = true;
        this.encodeThis();
    }

    public NetscapeCertTypeExtension(boolean[] bitString) throws IOException {
        this.bitString = bitString;
        this.extensionId = NetscapeCertType_Id;
        this.critical = true;
        this.encodeThis();
    }

    public NetscapeCertTypeExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = NetscapeCertType_Id;
        this.critical = critical;
        this.extensionValue = (byte[])value;
        DerValue val = new DerValue(this.extensionValue);
        this.bitString = val.getUnalignedBitString().toBooleanArray();
    }

    public NetscapeCertTypeExtension() {
        this.extensionId = NetscapeCertType_Id;
        this.critical = true;
        this.bitString = new boolean[0];
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (!(obj instanceof Boolean)) {
            throw new IOException("Attribute must be of type Boolean.");
        }
        boolean val = (Boolean)obj;
        this.set(NetscapeCertTypeExtension.getPosition(name), val);
        this.encodeThis();
    }

    @Override
    public Object get(String name) throws IOException {
        return this.isSet(NetscapeCertTypeExtension.getPosition(name));
    }

    @Override
    public void delete(String name) throws IOException {
        this.set(NetscapeCertTypeExtension.getPosition(name), false);
        this.encodeThis();
    }

    @Override
    public String toString() {
        String s = super.toString() + "NetscapeCertType [\n";
        try {
            if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_CLIENT))) {
                s = s + "   SSL client\n";
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_SERVER))) {
                s = s + "   SSL server\n";
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(S_MIME))) {
                s = s + "   S/MIME\n";
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(OBJECT_SIGNING))) {
                s = s + "   Object Signing\n";
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_CA))) {
                s = s + "   SSL CA\n";
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(S_MIME_CA))) {
                s = s + "   S/MIME CA\n";
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(OBJECT_SIGNING_CA))) {
                s = s + "   Object Signing CA";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        s = s + "]\n";
        return s;
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = NetscapeCertType_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public Enumeration<String> getElements() {
        return mAttributeNames.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean[] getKeyUsageMappedBits() {
        KeyUsageExtension keyUsage = new KeyUsageExtension();
        Boolean val = Boolean.TRUE;
        try {
            if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_CLIENT)) || this.isSet(NetscapeCertTypeExtension.getPosition(S_MIME)) || this.isSet(NetscapeCertTypeExtension.getPosition(OBJECT_SIGNING))) {
                keyUsage.set("digital_signature", val);
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_SERVER))) {
                keyUsage.set("key_encipherment", val);
            }
            if (this.isSet(NetscapeCertTypeExtension.getPosition(SSL_CA)) || this.isSet(NetscapeCertTypeExtension.getPosition(S_MIME_CA)) || this.isSet(NetscapeCertTypeExtension.getPosition(OBJECT_SIGNING_CA))) {
                keyUsage.set("key_certsign", val);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return keyUsage.getBits();
    }

    static {
        try {
            NetscapeCertType_Id = new ObjectIdentifier(CertType_data);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        mMapData = new MapEntry[]{new MapEntry(SSL_CLIENT, 0), new MapEntry(SSL_SERVER, 1), new MapEntry(S_MIME, 2), new MapEntry(OBJECT_SIGNING, 3), new MapEntry(SSL_CA, 5), new MapEntry(S_MIME_CA, 6), new MapEntry(OBJECT_SIGNING_CA, 7)};
        mAttributeNames = new Vector();
        for (MapEntry entry : mMapData) {
            mAttributeNames.add(entry.mName);
        }
    }

    private static class MapEntry {
        String mName;
        int mPosition;

        MapEntry(String name, int position) {
            this.mName = name;
            this.mPosition = position;
        }
    }
}

