/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLReason;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.misc.HexDumpEncoder;
import sun.security.action.GetIntegerAction;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.OCSP;
import sun.security.provider.certpath.OCSPChecker;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

public final class OCSPResponse {
    private static ResponseStatus[] rsvalues = ResponseStatus.values();
    private static final Debug DEBUG = Debug.getInstance("certpath");
    private static final boolean dump = Debug.isOn("ocsp");
    private static final ObjectIdentifier OCSP_BASIC_RESPONSE_OID = ObjectIdentifier.newInternal(new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 1});
    private static final ObjectIdentifier OCSP_NONCE_EXTENSION_OID = ObjectIdentifier.newInternal(new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 2});
    private static final int CERT_STATUS_GOOD = 0;
    private static final int CERT_STATUS_REVOKED = 1;
    private static final int CERT_STATUS_UNKNOWN = 2;
    private static final int NAME_TAG = 1;
    private static final int KEY_TAG = 2;
    private static final String KP_OCSP_SIGNING_OID = "1.3.6.1.5.5.7.3.9";
    private final ResponseStatus responseStatus;
    private final Map<CertId, SingleResponse> singleResponseMap;
    private static final int DEFAULT_MAX_CLOCK_SKEW = 900000;
    private static final int MAX_CLOCK_SKEW = OCSPResponse.initializeClockSkew();
    private static CRLReason[] values = CRLReason.values();

    private static int initializeClockSkew() {
        Integer tmp = AccessController.doPrivileged(new GetIntegerAction("com.sun.security.ocsp.clockSkew"));
        if (tmp == null || tmp < 0) {
            return 900000;
        }
        return tmp * 1000;
    }

    OCSPResponse(byte[] bytes, Date dateCheckedAgainst, List<X509Certificate> responderCerts) throws IOException, CertPathValidatorException {
        short tag;
        if (dump) {
            HexDumpEncoder hexEnc = new HexDumpEncoder();
            DEBUG.println("\nOCSPResponse bytes...");
            DEBUG.println(hexEnc.encode(bytes) + "\n");
        }
        DerValue der = new DerValue(bytes);
        if (der.tag != 48) {
            throw new IOException("Bad encoding in OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream derIn = der.getData();
        int status = derIn.getEnumerated();
        if (status < 0 || status >= rsvalues.length) {
            throw new IOException("Unknown OCSPResponse status: " + status);
        }
        this.responseStatus = rsvalues[status];
        if (DEBUG != null) {
            DEBUG.println("OCSP response status: " + (Object)((Object)this.responseStatus));
        }
        if (this.responseStatus != ResponseStatus.SUCCESSFUL) {
            this.singleResponseMap = Collections.emptyMap();
            return;
        }
        der = derIn.getDerValue();
        if (!der.isContextSpecific((byte)0)) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 context specific tag 0.");
        }
        DerValue tmp = der.data.getDerValue();
        if (tmp.tag != 48) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        derIn = tmp.data;
        ObjectIdentifier responseType = derIn.getOID();
        if (responseType.equals((Object)OCSP_BASIC_RESPONSE_OID)) {
            if (DEBUG != null) {
                DEBUG.println("OCSP response type: basic");
            }
        } else {
            if (DEBUG != null) {
                DEBUG.println("OCSP response type: " + responseType);
            }
            throw new IOException("Unsupported OCSP response type: " + responseType);
        }
        DerInputStream basicOCSPResponse = new DerInputStream(derIn.getOctetString());
        DerValue[] seqTmp = basicOCSPResponse.getSequence(2);
        if (seqTmp.length < 3) {
            throw new IOException("Unexpected BasicOCSPResponse value");
        }
        DerValue responseData = seqTmp[0];
        byte[] responseDataDer = seqTmp[0].toByteArray();
        if (responseData.tag != 48) {
            throw new IOException("Bad encoding in tbsResponseData element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream seqDerIn = responseData.data;
        DerValue seq = seqDerIn.getDerValue();
        if (seq.isContextSpecific((byte)0) && seq.isConstructed() && seq.isContextSpecific()) {
            seq = seq.data.getDerValue();
            int version = seq.getInteger();
            if (seq.data.available() != 0) {
                throw new IOException("Bad encoding in version  element of OCSP response: bad format");
            }
            seq = seqDerIn.getDerValue();
        }
        if ((tag = (short)((byte)(seq.tag & 0x1F))) == 1) {
            if (DEBUG != null) {
                X500Name responderName = new X500Name(seq.getData());
                DEBUG.println("OCSP Responder name: " + responderName);
            }
        } else if (tag == 2) {
            seq = seq.data.getDerValue();
            if (DEBUG != null) {
                byte[] responderKeyId = seq.getOctetString();
                DEBUG.println("OCSP Responder key ID: " + String.format("0x%0" + responderKeyId.length * 2 + "x", new BigInteger(1, responderKeyId)));
            }
        } else {
            throw new IOException("Bad encoding in responderID element of OCSP response: expected ASN.1 context specific tag 1 or 2");
        }
        seq = seqDerIn.getDerValue();
        if (DEBUG != null) {
            Date producedAtDate = seq.getGeneralizedTime();
            DEBUG.println("OCSP response produced at: " + producedAtDate);
        }
        DerValue[] singleResponseDer = seqDerIn.getSequence(1);
        this.singleResponseMap = new HashMap<CertId, SingleResponse>(singleResponseDer.length);
        if (DEBUG != null) {
            DEBUG.println("OCSP number of SingleResponses: " + singleResponseDer.length);
        }
        for (int i = 0; i < singleResponseDer.length; ++i) {
            SingleResponse singleResponse = new SingleResponse(singleResponseDer[i], dateCheckedAgainst);
            this.singleResponseMap.put(singleResponse.getCertId(), singleResponse);
        }
        if (seqDerIn.available() > 0 && (seq = seqDerIn.getDerValue()).isContextSpecific((byte)1)) {
            DerValue[] responseExtDer = seq.data.getSequence(3);
            for (int i = 0; i < responseExtDer.length; ++i) {
                Extension responseExtension = new Extension(responseExtDer[i]);
                if (DEBUG != null) {
                    DEBUG.println("OCSP extension: " + responseExtension);
                }
                if (responseExtension.getExtensionId().equals((Object)OCSP_NONCE_EXTENSION_OID) || !responseExtension.isCritical()) continue;
                throw new IOException("Unsupported OCSP critical extension: " + responseExtension.getExtensionId());
            }
        }
        AlgorithmId sigAlgId = AlgorithmId.parse(seqTmp[1]);
        byte[] signature = seqTmp[2].getBitString();
        X509CertImpl[] x509Certs = null;
        if (seqTmp.length > 3) {
            DerValue seqCert = seqTmp[3];
            if (!seqCert.isContextSpecific((byte)0)) {
                throw new IOException("Bad encoding in certs element of OCSP response: expected ASN.1 context specific tag 0.");
            }
            DerValue[] certs = seqCert.getData().getSequence(3);
            x509Certs = new X509CertImpl[certs.length];
            try {
                for (int i = 0; i < certs.length; ++i) {
                    x509Certs[i] = new X509CertImpl(certs[i].toByteArray());
                }
            }
            catch (CertificateException ce) {
                throw new IOException("Bad encoding in X509 Certificate", ce);
            }
        }
        X509Certificate trustedResponderCert = responderCerts.get(0);
        if (x509Certs != null && x509Certs[0] != null) {
            void signerCert = x509Certs[0];
            if (DEBUG != null) {
                DEBUG.println("Signer certificate name: " + signerCert.getSubjectX500Principal());
                byte[] signerKeyId = signerCert.getSubjectKeyIdentifier();
                if (signerKeyId != null) {
                    DEBUG.println("Signer certificate key ID: " + String.format("0x%0" + signerKeyId.length * 2 + "x", new BigInteger(1, signerKeyId)));
                }
            }
            byte[] certIssuerKeyId = null;
            for (X509Certificate responderCert : responderCerts) {
                if (signerCert.equals(responderCert)) {
                    trustedResponderCert = responderCert;
                    if (DEBUG == null) break;
                    DEBUG.println("Signer certificate is a trusted responder");
                    break;
                }
                if (!signerCert.getIssuerX500Principal().equals(responderCert.getSubjectX500Principal())) continue;
                if (certIssuerKeyId == null && (certIssuerKeyId = signerCert.getIssuerKeyIdentifier()) == null && DEBUG != null) {
                    DEBUG.println("No issuer key identifier (AKID) in the signer certificate");
                }
                byte[] responderKeyId = null;
                if (certIssuerKeyId != null && (responderKeyId = OCSPChecker.getKeyId(responderCert)) != null) {
                    if (!Arrays.equals(certIssuerKeyId, responderKeyId)) continue;
                    if (DEBUG != null) {
                        DEBUG.println("Issuer certificate key ID: " + String.format("0x%0" + certIssuerKeyId.length * 2 + "x", new BigInteger(1, certIssuerKeyId)));
                    }
                }
                try {
                    List<String> keyPurposes = signerCert.getExtendedKeyUsage();
                    if (keyPurposes == null) continue;
                    if (!keyPurposes.contains(KP_OCSP_SIGNING_OID)) {
                    }
                }
                catch (CertificateParsingException cpe) {}
                continue;
                AlgorithmChecker algChecker = new AlgorithmChecker(new TrustAnchor(responderCert, null));
                algChecker.init(false);
                algChecker.check((Certificate)signerCert, Collections.emptySet());
                try {
                    if (dateCheckedAgainst == null) {
                        signerCert.checkValidity();
                    } else {
                        signerCert.checkValidity(dateCheckedAgainst);
                    }
                }
                catch (GeneralSecurityException e) {
                    if (DEBUG == null) continue;
                    DEBUG.println("Responder's certificate not within the validity period " + e);
                    continue;
                }
                Extension noCheck = signerCert.getExtension(PKIXExtensions.OCSPNoCheck_Id);
                if (noCheck != null && DEBUG != null) {
                    DEBUG.println("Responder's certificate includes the extension id-pkix-ocsp-nocheck.");
                }
                try {
                    signerCert.verify(responderCert.getPublicKey());
                    trustedResponderCert = signerCert;
                    if (DEBUG == null) break;
                    DEBUG.println("Signer certificate was issued by a trusted responder");
                    break;
                }
                catch (GeneralSecurityException e) {
                    trustedResponderCert = null;
                }
            }
        }
        if (trustedResponderCert != null) {
            AlgorithmChecker.check(trustedResponderCert.getPublicKey(), sigAlgId);
            if (!this.verifyResponse(responseDataDer, trustedResponderCert, sigAlgId, signature)) {
                throw new CertPathValidatorException("Error verifying OCSP Responder's signature");
            }
        } else {
            throw new CertPathValidatorException("Responder's certificate is not trusted for signing OCSP responses");
        }
    }

    ResponseStatus getResponseStatus() {
        return this.responseStatus;
    }

    private boolean verifyResponse(byte[] responseData, X509Certificate cert, AlgorithmId sigAlgId, byte[] signBytes) throws CertPathValidatorException {
        try {
            Signature respSignature = Signature.getInstance(sigAlgId.getName());
            respSignature.initVerify(cert.getPublicKey());
            respSignature.update(responseData);
            if (respSignature.verify(signBytes)) {
                if (DEBUG != null) {
                    DEBUG.println("Verified signature of OCSP Responder");
                }
                return true;
            }
            if (DEBUG != null) {
                DEBUG.println("Error verifying signature of OCSP Responder");
            }
            return false;
        }
        catch (InvalidKeyException ike) {
            throw new CertPathValidatorException(ike);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CertPathValidatorException(nsae);
        }
        catch (SignatureException se) {
            throw new CertPathValidatorException(se);
        }
    }

    SingleResponse getSingleResponse(CertId certId) {
        return this.singleResponseMap.get(certId);
    }

    static final class SingleResponse
    implements OCSP.RevocationStatus {
        private final CertId certId;
        private final OCSP.RevocationStatus.CertStatus certStatus;
        private final Date thisUpdate;
        private final Date nextUpdate;
        private final Date revocationTime;
        private final CRLReason revocationReason;
        private final Map<String, java.security.cert.Extension> singleExtensions;

        private SingleResponse(DerValue der) throws IOException {
            this(der, null);
        }

        private SingleResponse(DerValue der, Date dateCheckedAgainst) throws IOException {
            if (der.tag != 48) {
                throw new IOException("Bad ASN.1 encoding in SingleResponse");
            }
            DerInputStream tmp = der.data;
            this.certId = new CertId(tmp.getDerValue().data);
            DerValue derVal = tmp.getDerValue();
            short tag = (byte)(derVal.tag & 0x1F);
            if (tag == 1) {
                this.certStatus = OCSP.RevocationStatus.CertStatus.REVOKED;
                this.revocationTime = derVal.data.getGeneralizedTime();
                if (derVal.data.available() != 0) {
                    int reason;
                    DerValue dv = derVal.data.getDerValue();
                    tag = (byte)(dv.tag & 0x1F);
                    this.revocationReason = tag == 0 ? ((reason = dv.data.getEnumerated()) >= 0 && reason < values.length ? values[reason] : CRLReason.UNSPECIFIED) : CRLReason.UNSPECIFIED;
                } else {
                    this.revocationReason = CRLReason.UNSPECIFIED;
                }
                if (DEBUG != null) {
                    DEBUG.println("Revocation time: " + this.revocationTime);
                    DEBUG.println("Revocation reason: " + (Object)((Object)this.revocationReason));
                }
            } else {
                this.revocationTime = null;
                this.revocationReason = CRLReason.UNSPECIFIED;
                if (tag == 0) {
                    this.certStatus = OCSP.RevocationStatus.CertStatus.GOOD;
                } else if (tag == 2) {
                    this.certStatus = OCSP.RevocationStatus.CertStatus.UNKNOWN;
                } else {
                    throw new IOException("Invalid certificate status");
                }
            }
            this.thisUpdate = tmp.getGeneralizedTime();
            if (tmp.available() == 0) {
                this.nextUpdate = null;
            } else {
                derVal = tmp.getDerValue();
                tag = (byte)(derVal.tag & 0x1F);
                if (tag == 0) {
                    this.nextUpdate = derVal.data.getGeneralizedTime();
                    if (tmp.available() != 0) {
                        derVal = tmp.getDerValue();
                        tag = (byte)(derVal.tag & 0x1F);
                    }
                } else {
                    this.nextUpdate = null;
                }
            }
            if (tmp.available() > 0) {
                derVal = tmp.getDerValue();
                if (derVal.isContextSpecific((byte)1)) {
                    DerValue[] singleExtDer = derVal.data.getSequence(3);
                    this.singleExtensions = new HashMap<String, java.security.cert.Extension>(singleExtDer.length);
                    for (int i = 0; i < singleExtDer.length; ++i) {
                        Extension ext = new Extension(singleExtDer[i]);
                        if (DEBUG != null) {
                            DEBUG.println("OCSP single extension: " + ext);
                        }
                        if (ext.isCritical()) {
                            throw new IOException("Unsupported OCSP critical extension: " + ext.getExtensionId());
                        }
                        this.singleExtensions.put(ext.getId(), ext);
                    }
                } else {
                    this.singleExtensions = Collections.emptyMap();
                }
            } else {
                this.singleExtensions = Collections.emptyMap();
            }
            long now = System.currentTimeMillis();
            Date nowPlusSkew = new Date(now + (long)MAX_CLOCK_SKEW);
            Date nowMinusSkew = new Date(now - (long)MAX_CLOCK_SKEW);
            if (DEBUG != null) {
                String until = "";
                if (this.nextUpdate != null) {
                    until = " until " + this.nextUpdate;
                }
                DEBUG.println("Response's validity interval is from " + this.thisUpdate + until);
            }
            if (this.thisUpdate != null && nowPlusSkew.before(this.thisUpdate) || this.nextUpdate != null && nowMinusSkew.after(this.nextUpdate)) {
                if (DEBUG != null) {
                    DEBUG.println("Response is unreliable: its validity interval is out-of-date");
                }
                throw new IOException("Response is unreliable: its validity interval is out-of-date");
            }
        }

        @Override
        public OCSP.RevocationStatus.CertStatus getCertStatus() {
            return this.certStatus;
        }

        private CertId getCertId() {
            return this.certId;
        }

        @Override
        public Date getRevocationTime() {
            return (Date)this.revocationTime.clone();
        }

        @Override
        public CRLReason getRevocationReason() {
            return this.revocationReason;
        }

        @Override
        public Map<String, java.security.cert.Extension> getSingleExtensions() {
            return Collections.unmodifiableMap(this.singleExtensions);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("SingleResponse:  \n");
            sb.append(this.certId);
            sb.append("\nCertStatus: " + (Object)((Object)this.certStatus) + "\n");
            if (this.certStatus == OCSP.RevocationStatus.CertStatus.REVOKED) {
                sb.append("revocationTime is " + this.revocationTime + "\n");
                sb.append("revocationReason is " + (Object)((Object)this.revocationReason) + "\n");
            }
            sb.append("thisUpdate is " + this.thisUpdate + "\n");
            if (this.nextUpdate != null) {
                sb.append("nextUpdate is " + this.nextUpdate + "\n");
            }
            return sb.toString();
        }
    }

    public static enum ResponseStatus {
        SUCCESSFUL,
        MALFORMED_REQUEST,
        INTERNAL_ERROR,
        TRY_LATER,
        UNUSED,
        SIG_REQUIRED,
        UNAUTHORIZED;

    }
}

