/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import com.sun.beans.finder.ClassFinder;
import java.applet.Applet;
import java.beans.AppletInitializer;
import java.beans.BeansAppletContext;
import java.beans.BeansAppletStub;
import java.beans.Introspector;
import java.beans.ObjectInputStreamWithLoader;
import java.beans.ThreadGroupContext;
import java.beans.beancontext.BeanContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class Beans {
    public static Object instantiate(ClassLoader cls, String beanName) throws IOException, ClassNotFoundException {
        return Beans.instantiate(cls, beanName, null, null);
    }

    public static Object instantiate(ClassLoader cls, String beanName, BeanContext beanContext) throws IOException, ClassNotFoundException {
        return Beans.instantiate(cls, beanName, beanContext, null);
    }

    public static Object instantiate(ClassLoader cls, String beanName, BeanContext beanContext, AppletInitializer initializer) throws IOException, ClassNotFoundException {
        String serName;
        ClassLoader loader;
        InputStream ins;
        ObjectInputStream oins = null;
        Object result = null;
        boolean serialized = false;
        IOException serex = null;
        if (cls == null) {
            try {
                cls = ClassLoader.getSystemClassLoader();
            }
            catch (SecurityException ex) {
                // empty catch block
            }
        }
        if ((ins = (InputStream)AccessController.doPrivileged(new PrivilegedAction(loader = cls, serName = beanName.replace('.', '/').concat(".ser")){
            final /* synthetic */ ClassLoader val$loader;
            final /* synthetic */ String val$serName;
            {
                this.val$loader = classLoader;
                this.val$serName = string;
            }

            public Object run() {
                if (this.val$loader == null) {
                    return ClassLoader.getSystemResourceAsStream(this.val$serName);
                }
                return this.val$loader.getResourceAsStream(this.val$serName);
            }
        })) != null) {
            try {
                oins = cls == null ? new ObjectInputStream(ins) : new ObjectInputStreamWithLoader(ins, cls);
                result = oins.readObject();
                serialized = true;
                oins.close();
            }
            catch (IOException ex) {
                ins.close();
                serex = ex;
            }
            catch (ClassNotFoundException ex) {
                ins.close();
                throw ex;
            }
        }
        if (result == null) {
            Class<?> cl;
            try {
                cl = ClassFinder.findClass(beanName, cls);
            }
            catch (ClassNotFoundException ex) {
                if (serex != null) {
                    throw serex;
                }
                throw ex;
            }
            if (!Modifier.isPublic(cl.getModifiers())) {
                throw new ClassNotFoundException("" + cl + " : no public access");
            }
            try {
                result = cl.newInstance();
            }
            catch (Exception ex) {
                throw new ClassNotFoundException("" + cl + " : " + ex, ex);
            }
        }
        if (result != null) {
            BeansAppletStub stub = null;
            if (result instanceof Applet) {
                boolean needDummies;
                Applet applet = (Applet)result;
                boolean bl = needDummies = initializer == null;
                if (needDummies) {
                    String s;
                    final String resourceName = serialized ? beanName.replace('.', '/').concat(".ser") : beanName.replace('.', '/').concat(".class");
                    URL objectUrl = null;
                    URL codeBase = null;
                    URL docBase = null;
                    final ClassLoader cloader = cls;
                    objectUrl = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            if (cloader == null) {
                                return ClassLoader.getSystemResource(resourceName);
                            }
                            return cloader.getResource(resourceName);
                        }
                    });
                    if (objectUrl != null && (s = objectUrl.toExternalForm()).endsWith(resourceName)) {
                        int ix = s.length() - resourceName.length();
                        docBase = codeBase = new URL(s.substring(0, ix));
                        ix = s.lastIndexOf(47);
                        if (ix >= 0) {
                            docBase = new URL(s.substring(0, ix + 1));
                        }
                    }
                    BeansAppletContext context = new BeansAppletContext(applet);
                    stub = new BeansAppletStub(applet, context, codeBase, docBase);
                    applet.setStub(stub);
                } else {
                    initializer.initialize(applet, beanContext);
                }
                if (beanContext != null) {
                    beanContext.add(result);
                }
                if (!serialized) {
                    applet.setSize(100, 100);
                    applet.init();
                }
                if (needDummies) {
                    ((BeansAppletStub)stub).active = true;
                } else {
                    initializer.activate(applet);
                }
            } else if (beanContext != null) {
                beanContext.add(result);
            }
        }
        return result;
    }

    public static Object getInstanceOf(Object bean, Class<?> targetType) {
        return bean;
    }

    public static boolean isInstanceOf(Object bean, Class<?> targetType) {
        return Introspector.isSubclass(bean.getClass(), targetType);
    }

    public static boolean isDesignTime() {
        return ThreadGroupContext.getContext().isDesignTime();
    }

    public static boolean isGuiAvailable() {
        return ThreadGroupContext.getContext().isGuiAvailable();
    }

    public static void setDesignTime(boolean isDesignTime) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertiesAccess();
        }
        ThreadGroupContext.getContext().setDesignTime(isDesignTime);
    }

    public static void setGuiAvailable(boolean isGuiAvailable) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertiesAccess();
        }
        ThreadGroupContext.getContext().setGuiAvailable(isGuiAvailable);
    }
}

