/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.security;

import com.sun.jmx.remote.security.JMXSubjectDomainCombiner;
import com.sun.jmx.remote.util.CacheMap;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.management.remote.SubjectDelegationPermission;
import javax.security.auth.Subject;

public class SubjectDelegator {
    private static final int PRINCIPALS_CACHE_SIZE = 10;
    private static final int ACC_CACHE_SIZE = 10;
    private CacheMap<Subject, Principal[]> principalsCache;
    private CacheMap<Subject, AccessControlContext> accCache;

    public synchronized AccessControlContext delegatedContext(AccessControlContext authenticatedACC, Subject delegatedSubject, boolean removeCallerContext) throws SecurityException {
        AccessControlContext delegatedACC;
        Principal[] delegatedPrincipals;
        if (this.principalsCache == null || this.accCache == null) {
            this.principalsCache = new CacheMap(10);
            this.accCache = new CacheMap(10);
        }
        if ((delegatedPrincipals = this.principalsCache.get(delegatedSubject)) == null) {
            delegatedPrincipals = delegatedSubject.getPrincipals().toArray(new Principal[0]);
            this.principalsCache.put(delegatedSubject, delegatedPrincipals);
        }
        if ((delegatedACC = this.accCache.get(delegatedSubject)) == null) {
            delegatedACC = removeCallerContext ? JMXSubjectDomainCombiner.getDomainCombinerContext(delegatedSubject) : JMXSubjectDomainCombiner.getContext(delegatedSubject);
            this.accCache.put(delegatedSubject, delegatedACC);
        }
        final Principal[] dp = delegatedPrincipals;
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                for (int i = 0; i < dp.length; ++i) {
                    String pname = dp[i].getClass().getName() + "." + dp[i].getName();
                    SubjectDelegationPermission sdp = new SubjectDelegationPermission(pname);
                    AccessController.checkPermission(sdp);
                }
                return null;
            }
        };
        AccessController.doPrivileged(action, authenticatedACC);
        return delegatedACC;
    }

    public static synchronized boolean checkRemoveCallerContext(Subject subject) {
        try {
            Principal[] dp = subject.getPrincipals().toArray(new Principal[0]);
            for (int i = 0; i < dp.length; ++i) {
                String pname = dp[i].getClass().getName() + "." + dp[i].getName();
                SubjectDelegationPermission sdp = new SubjectDelegationPermission(pname);
                AccessController.checkPermission(sdp);
            }
        }
        catch (SecurityException e) {
            return false;
        }
        return true;
    }
}

