/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import sun.swing.SwingUtilities2;
import sun.swing.table.DefaultTableCellHeaderRenderer;

public class WindowsTableHeaderUI
extends BasicTableHeaderUI {
    private TableCellRenderer originalHeaderRenderer;

    public static ComponentUI createUI(JComponent h) {
        return new WindowsTableHeaderUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (XPStyle.getXP() != null) {
            this.originalHeaderRenderer = this.header.getDefaultRenderer();
            if (this.originalHeaderRenderer instanceof UIResource) {
                this.header.setDefaultRenderer(new XPDefaultRenderer());
            }
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (this.header.getDefaultRenderer() instanceof XPDefaultRenderer) {
            this.header.setDefaultRenderer(this.originalHeaderRenderer);
        }
        super.uninstallUI(c);
    }

    @Override
    protected void rolloverColumnUpdated(int oldColumn, int newColumn) {
        if (XPStyle.getXP() != null) {
            this.header.repaint(this.header.getHeaderRect(oldColumn));
            this.header.repaint(this.header.getHeaderRect(newColumn));
        }
    }

    private static class IconBorder
    implements Border,
    UIResource {
        private final Icon icon;
        private final int top;
        private final int left;
        private final int bottom;
        private final int right;

        public IconBorder(Icon icon, int top, int left, int bottom, int right) {
            this.icon = icon;
            this.top = top;
            this.left = left;
            this.bottom = bottom;
            this.right = right;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(this.icon.getIconHeight() + this.top, this.left, this.bottom, this.right);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.icon.paintIcon(c, g, x + this.left + (width - this.left - this.right - this.icon.getIconWidth()) / 2, y + this.top);
        }
    }

    private class XPDefaultRenderer
    extends DefaultTableCellHeaderRenderer {
        XPStyle.Skin skin;
        boolean isSelected;
        boolean hasFocus;
        boolean hasRollover;
        int column;

        XPDefaultRenderer() {
            this.setHorizontalAlignment(10);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Icon sortIcon;
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.isSelected = isSelected;
            this.hasFocus = hasFocus;
            this.column = column;
            boolean bl = this.hasRollover = column == WindowsTableHeaderUI.this.getRolloverColumn();
            if (this.skin == null) {
                this.skin = XPStyle.getXP().getSkin(WindowsTableHeaderUI.this.header, TMSchema.Part.HP_HEADERITEM);
            }
            Insets margins = this.skin.getContentMargin();
            Border border = null;
            int contentTop = 0;
            int contentLeft = 0;
            int contentBottom = 0;
            int contentRight = 0;
            if (margins != null) {
                contentTop = margins.top;
                contentLeft = margins.left;
                contentBottom = margins.bottom;
                contentRight = margins.right;
            }
            contentLeft += 5;
            contentBottom += 4;
            contentRight += 5;
            if (WindowsLookAndFeel.isOnVista() && ((sortIcon = this.getIcon()) instanceof UIResource || sortIcon == null)) {
                ++contentTop;
                this.setIcon(null);
                sortIcon = null;
                SortOrder sortOrder = XPDefaultRenderer.getColumnSortOrder(table, column);
                if (sortOrder != null) {
                    switch (sortOrder) {
                        case ASCENDING: {
                            sortIcon = UIManager.getIcon("Table.ascendingSortIcon");
                            break;
                        }
                        case DESCENDING: {
                            sortIcon = UIManager.getIcon("Table.descendingSortIcon");
                        }
                    }
                }
                if (sortIcon != null) {
                    contentBottom = sortIcon.getIconHeight();
                    border = new IconBorder(sortIcon, contentTop, contentLeft, contentBottom, contentRight);
                } else {
                    int sortIconHeight;
                    sortIcon = UIManager.getIcon("Table.ascendingSortIcon");
                    int n = sortIconHeight = sortIcon != null ? sortIcon.getIconHeight() : 0;
                    if (sortIconHeight != 0) {
                        contentBottom = sortIconHeight;
                    }
                    border = new EmptyBorder(sortIconHeight + contentTop, contentLeft, contentBottom, contentRight);
                }
            } else {
                border = new EmptyBorder(contentTop += 3, contentLeft, contentBottom, contentRight);
            }
            this.setBorder(border);
            return this;
        }

        @Override
        public void paint(Graphics g) {
            SortOrder sortOrder;
            Dimension size = this.getSize();
            TMSchema.State state = TMSchema.State.NORMAL;
            TableColumn draggedColumn = WindowsTableHeaderUI.this.header.getDraggedColumn();
            if (draggedColumn != null && this.column == SwingUtilities2.convertColumnIndexToView(WindowsTableHeaderUI.this.header.getColumnModel(), draggedColumn.getModelIndex())) {
                state = TMSchema.State.PRESSED;
            } else if (this.isSelected || this.hasFocus || this.hasRollover) {
                state = TMSchema.State.HOT;
            }
            if (WindowsLookAndFeel.isOnVista() && (sortOrder = XPDefaultRenderer.getColumnSortOrder(WindowsTableHeaderUI.this.header.getTable(), this.column)) != null) {
                block0 : switch (sortOrder) {
                    case ASCENDING: 
                    case DESCENDING: {
                        switch (state) {
                            case NORMAL: {
                                state = TMSchema.State.SORTEDNORMAL;
                                break block0;
                            }
                            case PRESSED: {
                                state = TMSchema.State.SORTEDPRESSED;
                                break block0;
                            }
                            case HOT: {
                                state = TMSchema.State.SORTEDHOT;
                                break block0;
                            }
                        }
                    }
                }
            }
            this.skin.paintSkin(g, 0, 0, size.width - 1, size.height - 1, state);
            super.paint(g);
        }
    }
}

