/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKConstants;
import com.sun.java.swing.plaf.gtk.GTKPainter;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import com.sun.java.swing.plaf.gtk.XColors;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthConstants;
import javax.swing.plaf.synth.SynthContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import sun.swing.SwingUtilities2;

class Metacity
implements SynthConstants {
    static Metacity INSTANCE;
    private static final String[] themeNames;
    private static boolean errorLogged;
    private static DocumentBuilder documentBuilder;
    private static Document xmlDoc;
    private static String userHome;
    private Node frame_style_set;
    private Map<String, Object> frameGeometry;
    private Map<String, Map<String, Object>> frameGeometries;
    private LayoutManager titlePaneLayout = new TitlePaneLayout();
    private ColorizeImageFilter imageFilter = new ColorizeImageFilter();
    private URL themeDir = null;
    private SynthContext context;
    private String themeName;
    private ArithmeticExpressionEvaluator aee = new ArithmeticExpressionEvaluator();
    private Map<String, Integer> variables;
    private RoundRectClipShape roundedClipShape;
    private HashMap<String, Image> images = new HashMap();

    protected Metacity(String themeName) throws IOException, ParserConfigurationException, SAXException {
        String name;
        Node node;
        int i;
        this.themeName = themeName;
        this.themeDir = Metacity.getThemeDir(themeName);
        if (this.themeDir != null) {
            URL themeURL = new URL(this.themeDir, "metacity-theme-1.xml");
            xmlDoc = Metacity.getXMLDoc(themeURL);
            if (xmlDoc == null) {
                throw new IOException(themeURL.toString());
            }
        } else {
            throw new FileNotFoundException(themeName);
        }
        this.variables = new HashMap<String, Integer>();
        NodeList nodes = xmlDoc.getElementsByTagName("constant");
        int n = nodes.getLength();
        for (i = 0; i < n; ++i) {
            String value;
            node = nodes.item(i);
            name = this.getStringAttr(node, "name");
            if (name == null || (value = this.getStringAttr(node, "value")) == null) continue;
            try {
                this.variables.put(name, Integer.parseInt(value));
                continue;
            }
            catch (NumberFormatException ex) {
                Metacity.logError(themeName, ex);
            }
        }
        this.frameGeometries = new HashMap<String, Map<String, Object>>();
        nodes = xmlDoc.getElementsByTagName("frame_geometry");
        n = nodes.getLength();
        for (i = 0; i < n; ++i) {
            node = nodes.item(i);
            name = this.getStringAttr(node, "name");
            if (name == null) continue;
            HashMap<String, Object> gm = new HashMap<String, Object>();
            this.frameGeometries.put(name, gm);
            String parentGM = this.getStringAttr(node, "parent");
            if (parentGM != null) {
                gm.putAll(this.frameGeometries.get(parentGM));
            }
            gm.put("has_title", this.getBooleanAttr(node, "has_title", true));
            gm.put("rounded_top_left", this.getBooleanAttr(node, "rounded_top_left", false));
            gm.put("rounded_top_right", this.getBooleanAttr(node, "rounded_top_right", false));
            gm.put("rounded_bottom_left", this.getBooleanAttr(node, "rounded_bottom_left", false));
            gm.put("rounded_bottom_right", this.getBooleanAttr(node, "rounded_bottom_right", false));
            NodeList childNodes = node.getChildNodes();
            int nc = childNodes.getLength();
            for (int j = 0; j < nc; ++j) {
                Node child = childNodes.item(j);
                if (child.getNodeType() != 1) continue;
                name = child.getNodeName();
                Serializable value = null;
                if ("distance".equals(name)) {
                    value = this.getIntAttr(child, "value", 0);
                } else if ("border".equals(name)) {
                    value = new Insets(this.getIntAttr(child, "top", 0), this.getIntAttr(child, "left", 0), this.getIntAttr(child, "bottom", 0), this.getIntAttr(child, "right", 0));
                } else if ("aspect_ratio".equals(name)) {
                    value = new Float(this.getFloatAttr(child, "value", 1.0f));
                } else {
                    Metacity.logError(themeName, "Unknown Metacity frame geometry value type: " + name);
                }
                String childName = this.getStringAttr(child, "name");
                if (childName == null || value == null) continue;
                gm.put(childName, value);
            }
        }
        this.frameGeometry = this.frameGeometries.get("normal");
    }

    public static LayoutManager getTitlePaneLayout() {
        return Metacity.INSTANCE.titlePaneLayout;
    }

    private Shape getRoundedClipShape(int x, int y, int w, int h, int arcw, int arch, int corners) {
        if (this.roundedClipShape == null) {
            this.roundedClipShape = new RoundRectClipShape();
        }
        this.roundedClipShape.setRoundedRect(x, y, w, h, arcw, arch, corners);
        return this.roundedClipShape;
    }

    void paintButtonBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        Node frame_style;
        JInternalFrame jif;
        this.updateFrameGeometry(context);
        this.context = context;
        JButton button = (JButton)context.getComponent();
        String buttonName = button.getName();
        int buttonState = context.getComponentState();
        JComponent titlePane = (JComponent)button.getParent();
        Container titlePaneParent = titlePane.getParent();
        if (titlePaneParent instanceof JInternalFrame) {
            jif = (JInternalFrame)titlePaneParent;
        } else if (titlePaneParent instanceof JInternalFrame.JDesktopIcon) {
            jif = ((JInternalFrame.JDesktopIcon)titlePaneParent).getInternalFrame();
        } else {
            return;
        }
        boolean active = jif.isSelected();
        button.setOpaque(false);
        String state = "normal";
        if ((buttonState & 4) != 0) {
            state = "pressed";
        } else if ((buttonState & 2) != 0) {
            state = "prelight";
        }
        String function = null;
        String location = null;
        boolean left_corner = false;
        boolean right_corner = false;
        if (buttonName == "InternalFrameTitlePane.menuButton") {
            function = "menu";
            location = "left_left";
            left_corner = true;
        } else if (buttonName == "InternalFrameTitlePane.iconifyButton") {
            function = "minimize";
            int nButtons = (jif.isIconifiable() ? 1 : 0) + (jif.isMaximizable() ? 1 : 0) + (jif.isClosable() ? 1 : 0);
            right_corner = nButtons == 1;
            switch (nButtons) {
                case 1: {
                    location = "right_right";
                    break;
                }
                case 2: {
                    location = "right_middle";
                    break;
                }
                case 3: {
                    location = "right_left";
                }
            }
        } else if (buttonName == "InternalFrameTitlePane.maximizeButton") {
            function = "maximize";
            right_corner = !jif.isClosable();
            location = jif.isClosable() ? "right_middle" : "right_right";
        } else if (buttonName == "InternalFrameTitlePane.closeButton") {
            function = "close";
            right_corner = true;
            location = "right_right";
        }
        Node frame = this.getNode(this.frame_style_set, "frame", new String[]{"focus", active ? "yes" : "no", "state", jif.isMaximum() ? "maximized" : "normal"});
        if (function != null && frame != null && (frame_style = this.getNode("frame_style", new String[]{"name", this.getStringAttr(frame, "style")})) != null) {
            Shape oldClip = g.getClip();
            if (right_corner && this.getBoolean("rounded_top_right", false) || left_corner && this.getBoolean("rounded_top_left", false)) {
                Point buttonLoc = button.getLocation();
                if (right_corner) {
                    g.setClip(this.getRoundedClipShape(0, 0, w, h, 12, 12, 2));
                } else {
                    g.setClip(this.getRoundedClipShape(0, 0, w, h, 11, 11, 1));
                }
                Rectangle clipBounds = oldClip.getBounds();
                g.clipRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
            }
            this.drawButton(frame_style, location + "_background", state, g, w, h, jif);
            this.drawButton(frame_style, function, state, g, w, h, jif);
            g.setClip(oldClip);
        }
    }

    protected void drawButton(Node frame_style, String function, String state, Graphics g, int w, int h, JInternalFrame jif) {
        Node buttonNode = this.getNode(frame_style, "button", new String[]{"function", function, "state", state});
        if (buttonNode == null && !state.equals("normal")) {
            buttonNode = this.getNode(frame_style, "button", new String[]{"function", function, "state", "normal"});
        }
        if (buttonNode != null) {
            String draw_ops_name = this.getStringAttr(buttonNode, "draw_ops");
            Node draw_ops = draw_ops_name != null ? this.getNode("draw_ops", new String[]{"name", draw_ops_name}) : this.getNode(buttonNode, "draw_ops", null);
            this.variables.put("width", w);
            this.variables.put("height", h);
            this.draw(draw_ops, g, jif);
        }
    }

    void paintFrameBorder(SynthContext context, Graphics g, int x0, int y0, int width, int height) {
        Node frame_style;
        Node frame;
        this.updateFrameGeometry(context);
        this.context = context;
        JComponent comp = context.getComponent();
        JComponent titlePane = Metacity.findChild(comp, "InternalFrame.northPane");
        if (titlePane == null) {
            return;
        }
        JInternalFrame jif = null;
        if (comp instanceof JInternalFrame) {
            jif = (JInternalFrame)comp;
        } else if (comp instanceof JInternalFrame.JDesktopIcon) {
            jif = ((JInternalFrame.JDesktopIcon)comp).getInternalFrame();
        } else {
            assert (false) : "component is not JInternalFrame or JInternalFrame.JDesktopIcon";
            return;
        }
        boolean active = jif.isSelected();
        Font oldFont = g.getFont();
        g.setFont(titlePane.getFont());
        g.translate(x0, y0);
        Rectangle titleRect = this.calculateTitleArea(jif);
        JComponent menuButton = Metacity.findChild(titlePane, "InternalFrameTitlePane.menuButton");
        Icon frameIcon = jif.getFrameIcon();
        this.variables.put("mini_icon_width", frameIcon != null ? frameIcon.getIconWidth() : 0);
        this.variables.put("mini_icon_height", frameIcon != null ? frameIcon.getIconHeight() : 0);
        this.variables.put("title_width", this.calculateTitleTextWidth(g, jif));
        FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)jif, g);
        this.variables.put("title_height", fm.getAscent() + fm.getDescent());
        this.variables.put("icon_width", 32);
        this.variables.put("icon_height", 32);
        if (this.frame_style_set != null && (frame = this.getNode(this.frame_style_set, "frame", new String[]{"focus", active ? "yes" : "no", "state", jif.isMaximum() ? "maximized" : "normal"})) != null && (frame_style = this.getNode("frame_style", new String[]{"name", this.getStringAttr(frame, "style")})) != null) {
            Shape oldClip = g.getClip();
            boolean roundTopLeft = this.getBoolean("rounded_top_left", false);
            boolean roundTopRight = this.getBoolean("rounded_top_right", false);
            boolean roundBottomLeft = this.getBoolean("rounded_bottom_left", false);
            boolean roundBottomRight = this.getBoolean("rounded_bottom_right", false);
            if (roundTopLeft || roundTopRight || roundBottomLeft || roundBottomRight) {
                jif.setOpaque(false);
                g.setClip(this.getRoundedClipShape(0, 0, width, height, 12, 12, (roundTopLeft ? 1 : 0) | (roundTopRight ? 2 : 0) | (roundBottomLeft ? 4 : 0) | (roundBottomRight ? 8 : 0)));
            }
            Rectangle clipBounds = oldClip.getBounds();
            g.clipRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
            int titleHeight = titlePane.getHeight();
            boolean minimized = jif.isIcon();
            Insets insets = this.getBorderInsets(context, null);
            int leftTitlebarEdge = this.getInt("left_titlebar_edge");
            int rightTitlebarEdge = this.getInt("right_titlebar_edge");
            int topTitlebarEdge = this.getInt("top_titlebar_edge");
            int bottomTitlebarEdge = this.getInt("bottom_titlebar_edge");
            if (!minimized) {
                this.drawPiece(frame_style, g, "entire_background", 0, 0, width, height, jif);
            }
            this.drawPiece(frame_style, g, "titlebar", 0, 0, width, titleHeight, jif);
            this.drawPiece(frame_style, g, "titlebar_middle", leftTitlebarEdge, topTitlebarEdge, width - leftTitlebarEdge - rightTitlebarEdge, titleHeight - topTitlebarEdge - bottomTitlebarEdge, jif);
            this.drawPiece(frame_style, g, "left_titlebar_edge", 0, 0, leftTitlebarEdge, titleHeight, jif);
            this.drawPiece(frame_style, g, "right_titlebar_edge", width - rightTitlebarEdge, 0, rightTitlebarEdge, titleHeight, jif);
            this.drawPiece(frame_style, g, "top_titlebar_edge", 0, 0, width, topTitlebarEdge, jif);
            this.drawPiece(frame_style, g, "bottom_titlebar_edge", 0, titleHeight - bottomTitlebarEdge, width, bottomTitlebarEdge, jif);
            this.drawPiece(frame_style, g, "title", titleRect.x, titleRect.y, titleRect.width, titleRect.height, jif);
            if (!minimized) {
                this.drawPiece(frame_style, g, "left_edge", 0, titleHeight, insets.left, height - titleHeight, jif);
                this.drawPiece(frame_style, g, "right_edge", width - insets.right, titleHeight, insets.right, height - titleHeight, jif);
                this.drawPiece(frame_style, g, "bottom_edge", 0, height - insets.bottom, width, insets.bottom, jif);
                this.drawPiece(frame_style, g, "overlay", 0, 0, width, height, jif);
            }
            g.setClip(oldClip);
        }
        g.translate(-x0, -y0);
        g.setFont(oldFont);
    }

    private static URL getThemeDir(String themeName) {
        return (URL)new Privileged().doPrivileged(Privileged.GET_THEME_DIR, themeName);
    }

    private static String getUserTheme() {
        return (String)new Privileged().doPrivileged(Privileged.GET_USER_THEME, null);
    }

    protected void tileImage(Graphics g, Image image, int x0, int y0, int w, int h, float[] alphas) {
        Graphics2D g2 = (Graphics2D)g;
        Composite oldComp = g2.getComposite();
        int sw = image.getWidth(null);
        int sh = image.getHeight(null);
        for (int y = y0; y < y0 + h; y += sh) {
            int swm;
            sh = Math.min(sh, y0 + h - y);
            for (int x = x0; x < x0 + w; x += swm) {
                float f = ((float)alphas.length - 1.0f) * (float)x / (float)(x0 + w);
                int i = (int)f;
                f -= (float)((int)f);
                float alpha = (1.0f - f) * alphas[i];
                if (i + 1 < alphas.length) {
                    alpha += f * alphas[i + 1];
                }
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
                swm = Math.min(sw, x0 + w - x);
                g.drawImage(image, x, y, x + swm, y + sh, 0, 0, swm, sh, null);
            }
        }
        g2.setComposite(oldComp);
    }

    protected Image getImage(String key, Color c) {
        Image image = this.images.get(key + "-" + c.getRGB());
        if (image == null && (image = this.imageFilter.colorize(this.getImage(key), c)) != null) {
            this.images.put(key + "-" + c.getRGB(), image);
        }
        return image;
    }

    protected Image getImage(String key) {
        Image image = this.images.get(key);
        if (image == null) {
            if (this.themeDir != null) {
                try {
                    URL url = new URL(this.themeDir, key);
                    image = (Image)new Privileged().doPrivileged(Privileged.GET_IMAGE, url);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (image != null) {
                this.images.put(key, image);
            }
        }
        return image;
    }

    protected static JComponent findChild(JComponent parent, String name) {
        int n = parent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            JComponent c = (JComponent)parent.getComponent(i);
            if (!name.equals(c.getName())) continue;
            return c;
        }
        return null;
    }

    protected Map getFrameGeometry() {
        return this.frameGeometry;
    }

    protected void setFrameGeometry(JComponent titlePane, Map gm) {
        this.frameGeometry = gm;
        if (this.getInt("top_height") == 0 && titlePane != null) {
            gm.put("top_height", titlePane.getHeight());
        }
    }

    protected int getInt(String key) {
        Integer i = (Integer)this.frameGeometry.get(key);
        if (i == null) {
            i = this.variables.get(key);
        }
        return i != null ? i : 0;
    }

    protected boolean getBoolean(String key, boolean fallback) {
        Boolean b = (Boolean)this.frameGeometry.get(key);
        return b != null ? b : fallback;
    }

    protected void drawArc(Node node, Graphics g) {
        NamedNodeMap attrs = node.getAttributes();
        Color color = this.parseColor(this.getStringAttr(attrs, "color"));
        int x = this.aee.evaluate(this.getStringAttr(attrs, "x"));
        int y = this.aee.evaluate(this.getStringAttr(attrs, "y"));
        int w = this.aee.evaluate(this.getStringAttr(attrs, "width"));
        int h = this.aee.evaluate(this.getStringAttr(attrs, "height"));
        int start_angle = this.aee.evaluate(this.getStringAttr(attrs, "start_angle"));
        int extent_angle = this.aee.evaluate(this.getStringAttr(attrs, "extent_angle"));
        boolean filled = this.getBooleanAttr(node, "filled", false);
        if (this.getInt("width") == -1) {
            x -= w;
        }
        if (this.getInt("height") == -1) {
            y -= h;
        }
        g.setColor(color);
        if (filled) {
            g.fillArc(x, y, w, h, start_angle, extent_angle);
        } else {
            g.drawArc(x, y, w, h, start_angle, extent_angle);
        }
    }

    protected void drawLine(Node node, Graphics g) {
        NamedNodeMap attrs = node.getAttributes();
        Color color = this.parseColor(this.getStringAttr(attrs, "color"));
        int x1 = this.aee.evaluate(this.getStringAttr(attrs, "x1"));
        int y1 = this.aee.evaluate(this.getStringAttr(attrs, "y1"));
        int x2 = this.aee.evaluate(this.getStringAttr(attrs, "x2"));
        int y2 = this.aee.evaluate(this.getStringAttr(attrs, "y2"));
        int lineWidth = this.aee.evaluate(this.getStringAttr(attrs, "width"), 1);
        g.setColor(color);
        if (lineWidth != 1) {
            Graphics2D g2d = (Graphics2D)g;
            Stroke stroke = g2d.getStroke();
            g2d.setStroke(new BasicStroke(lineWidth));
            g2d.drawLine(x1, y1, x2, y2);
            g2d.setStroke(stroke);
        } else {
            g.drawLine(x1, y1, x2, y2);
        }
    }

    protected void drawRectangle(Node node, Graphics g) {
        NamedNodeMap attrs = node.getAttributes();
        Color color = this.parseColor(this.getStringAttr(attrs, "color"));
        boolean filled = this.getBooleanAttr(node, "filled", false);
        int x = this.aee.evaluate(this.getStringAttr(attrs, "x"));
        int y = this.aee.evaluate(this.getStringAttr(attrs, "y"));
        int w = this.aee.evaluate(this.getStringAttr(attrs, "width"));
        int h = this.aee.evaluate(this.getStringAttr(attrs, "height"));
        g.setColor(color);
        if (this.getInt("width") == -1) {
            x -= w;
        }
        if (this.getInt("height") == -1) {
            y -= h;
        }
        if (filled) {
            g.fillRect(x, y, w, h);
        } else {
            g.drawRect(x, y, w, h);
        }
    }

    protected void drawTile(Node node, Graphics g, JInternalFrame jif) {
        NamedNodeMap attrs = node.getAttributes();
        int x0 = this.aee.evaluate(this.getStringAttr(attrs, "x"));
        int y0 = this.aee.evaluate(this.getStringAttr(attrs, "y"));
        int w = this.aee.evaluate(this.getStringAttr(attrs, "width"));
        int h = this.aee.evaluate(this.getStringAttr(attrs, "height"));
        int tw = this.aee.evaluate(this.getStringAttr(attrs, "tile_width"));
        int th = this.aee.evaluate(this.getStringAttr(attrs, "tile_height"));
        int width = this.getInt("width");
        int height = this.getInt("height");
        if (width == -1) {
            x0 -= w;
        }
        if (height == -1) {
            y0 -= h;
        }
        Shape oldClip = g.getClip();
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).clip(new Rectangle(x0, y0, w, h));
        }
        this.variables.put("width", tw);
        this.variables.put("height", th);
        Node draw_ops = this.getNode("draw_ops", new String[]{"name", this.getStringAttr(node, "name")});
        for (int y = y0; y < y0 + h; y += th) {
            for (int x = x0; x < x0 + w; x += tw) {
                g.translate(x, y);
                this.draw(draw_ops, g, jif);
                g.translate(-x, -y);
            }
        }
        this.variables.put("width", width);
        this.variables.put("height", height);
        g.setClip(oldClip);
    }

    protected void drawTint(Node node, Graphics g) {
        NamedNodeMap attrs = node.getAttributes();
        Color color = this.parseColor(this.getStringAttr(attrs, "color"));
        float alpha = Float.parseFloat(this.getStringAttr(attrs, "alpha"));
        int x = this.aee.evaluate(this.getStringAttr(attrs, "x"));
        int y = this.aee.evaluate(this.getStringAttr(attrs, "y"));
        int w = this.aee.evaluate(this.getStringAttr(attrs, "width"));
        int h = this.aee.evaluate(this.getStringAttr(attrs, "height"));
        if (this.getInt("width") == -1) {
            x -= w;
        }
        if (this.getInt("height") == -1) {
            y -= h;
        }
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            Composite oldComp = g2.getComposite();
            AlphaComposite ac = AlphaComposite.getInstance(3, alpha);
            g2.setComposite(ac);
            g2.setColor(color);
            g2.fillRect(x, y, w, h);
            g2.setComposite(oldComp);
        }
    }

    protected void drawTitle(Node node, Graphics g, JInternalFrame jif) {
        NamedNodeMap attrs = node.getAttributes();
        String colorStr = this.getStringAttr(attrs, "color");
        int i = colorStr.indexOf("gtk:fg[");
        if (i > 0) {
            colorStr = colorStr.substring(0, i) + "gtk:text[" + colorStr.substring(i + 7);
        }
        Color color = this.parseColor(colorStr);
        int x = this.aee.evaluate(this.getStringAttr(attrs, "x"));
        int y = this.aee.evaluate(this.getStringAttr(attrs, "y"));
        String title = jif.getTitle();
        if (title != null) {
            FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)jif, g);
            title = SwingUtilities2.clipStringIfNecessary(jif, fm, title, this.calculateTitleArea((JInternalFrame)jif).width);
            g.setColor(color);
            SwingUtilities2.drawString((JComponent)jif, g, title, x, y + fm.getAscent());
        }
    }

    protected Dimension calculateButtonSize(JComponent titlePane) {
        int buttonWidth;
        int buttonHeight = this.getInt("button_height");
        if (buttonHeight == 0) {
            buttonHeight = titlePane.getHeight();
            if (buttonHeight == 0) {
                buttonHeight = 13;
            } else {
                Insets button_border = (Insets)this.frameGeometry.get("button_border");
                if (button_border != null) {
                    buttonHeight -= button_border.top + button_border.bottom;
                }
            }
        }
        if ((buttonWidth = this.getInt("button_width")) == 0) {
            buttonWidth = buttonHeight;
            Float aspect_ratio = (Float)this.frameGeometry.get("aspect_ratio");
            if (aspect_ratio != null) {
                buttonWidth = (int)((float)buttonHeight / aspect_ratio.floatValue());
            }
        }
        return new Dimension(buttonWidth, buttonHeight);
    }

    protected Rectangle calculateTitleArea(JInternalFrame jif) {
        JComponent titlePane = Metacity.findChild(jif, "InternalFrame.northPane");
        Dimension buttonDim = this.calculateButtonSize(titlePane);
        Insets title_border = (Insets)this.frameGeometry.get("title_border");
        Insets button_border = (Insets)this.getFrameGeometry().get("button_border");
        Rectangle r = new Rectangle();
        r.x = this.getInt("left_titlebar_edge");
        r.y = 0;
        r.height = titlePane.getHeight();
        if (title_border != null) {
            r.x += title_border.left;
            r.y += title_border.top;
            r.height -= title_border.top + title_border.bottom;
        }
        if (titlePane.getParent().getComponentOrientation().isLeftToRight()) {
            r.x += buttonDim.width;
            if (button_border != null) {
                r.x += button_border.left;
            }
            r.width = titlePane.getWidth() - r.x - this.getInt("right_titlebar_edge");
            if (jif.isClosable()) {
                r.width -= buttonDim.width;
            }
            if (jif.isMaximizable()) {
                r.width -= buttonDim.width;
            }
            if (jif.isIconifiable()) {
                r.width -= buttonDim.width;
            }
        } else {
            if (jif.isClosable()) {
                r.x += buttonDim.width;
            }
            if (jif.isMaximizable()) {
                r.x += buttonDim.width;
            }
            if (jif.isIconifiable()) {
                r.x += buttonDim.width;
            }
            r.width = titlePane.getWidth() - r.x - this.getInt("right_titlebar_edge") - buttonDim.width;
            if (button_border != null) {
                r.x -= button_border.right;
            }
        }
        if (title_border != null) {
            r.width -= title_border.right;
        }
        return r;
    }

    protected int calculateTitleTextWidth(Graphics g, JInternalFrame jif) {
        String title = jif.getTitle();
        if (title != null) {
            Rectangle r = this.calculateTitleArea(jif);
            return Math.min(SwingUtilities2.stringWidth(jif, SwingUtilities2.getFontMetrics((JComponent)jif, g), title), r.width);
        }
        return 0;
    }

    protected void setClip(Node node, Graphics g) {
        NamedNodeMap attrs = node.getAttributes();
        int x = this.aee.evaluate(this.getStringAttr(attrs, "x"));
        int y = this.aee.evaluate(this.getStringAttr(attrs, "y"));
        int w = this.aee.evaluate(this.getStringAttr(attrs, "width"));
        int h = this.aee.evaluate(this.getStringAttr(attrs, "height"));
        if (this.getInt("width") == -1) {
            x -= w;
        }
        if (this.getInt("height") == -1) {
            y -= h;
        }
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).clip(new Rectangle(x, y, w, h));
        }
    }

    protected void drawGTKArrow(Node node, Graphics g) {
        NamedNodeMap attrs = node.getAttributes();
        String arrow = this.getStringAttr(attrs, "arrow");
        String shadow = this.getStringAttr(attrs, "shadow");
        String stateStr = this.getStringAttr(attrs, "state").toUpperCase();
        int x = this.aee.evaluate(this.getStringAttr(attrs, "x"));
        int y = this.aee.evaluate(this.getStringAttr(attrs, "y"));
        int w = this.aee.evaluate(this.getStringAttr(attrs, "width"));
        int h = this.aee.evaluate(this.getStringAttr(attrs, "height"));
        int state = -1;
        if ("NORMAL".equals(stateStr)) {
            state = 1;
        } else if ("SELECTED".equals(stateStr)) {
            state = 512;
        } else if ("INSENSITIVE".equals(stateStr)) {
            state = 8;
        } else if ("PRELIGHT".equals(stateStr)) {
            state = 2;
        }
        GTKConstants.ShadowType shadowType = null;
        if ("in".equals(shadow)) {
            shadowType = GTKConstants.ShadowType.IN;
        } else if ("out".equals(shadow)) {
            shadowType = GTKConstants.ShadowType.OUT;
        } else if ("etched_in".equals(shadow)) {
            shadowType = GTKConstants.ShadowType.ETCHED_IN;
        } else if ("etched_out".equals(shadow)) {
            shadowType = GTKConstants.ShadowType.ETCHED_OUT;
        } else if ("none".equals(shadow)) {
            shadowType = GTKConstants.ShadowType.NONE;
        }
        GTKConstants.ArrowType direction = null;
        if ("up".equals(arrow)) {
            direction = GTKConstants.ArrowType.UP;
        } else if ("down".equals(arrow)) {
            direction = GTKConstants.ArrowType.DOWN;
        } else if ("left".equals(arrow)) {
            direction = GTKConstants.ArrowType.LEFT;
        } else if ("right".equals(arrow)) {
            direction = GTKConstants.ArrowType.RIGHT;
        }
        GTKPainter.INSTANCE.paintMetacityElement(this.context, g, state, "metacity-arrow", x, y, w, h, shadowType, direction);
    }

    protected void drawGTKBox(Node node, Graphics g) {
        NamedNodeMap attrs = node.getAttributes();
        String shadow = this.getStringAttr(attrs, "shadow");
        String stateStr = this.getStringAttr(attrs, "state").toUpperCase();
        int x = this.aee.evaluate(this.getStringAttr(attrs, "x"));
        int y = this.aee.evaluate(this.getStringAttr(attrs, "y"));
        int w = this.aee.evaluate(this.getStringAttr(attrs, "width"));
        int h = this.aee.evaluate(this.getStringAttr(attrs, "height"));
        int state = -1;
        if ("NORMAL".equals(stateStr)) {
            state = 1;
        } else if ("SELECTED".equals(stateStr)) {
            state = 512;
        } else if ("INSENSITIVE".equals(stateStr)) {
            state = 8;
        } else if ("PRELIGHT".equals(stateStr)) {
            state = 2;
        }
        GTKConstants.ShadowType shadowType = null;
        if ("in".equals(shadow)) {
            shadowType = GTKConstants.ShadowType.IN;
        } else if ("out".equals(shadow)) {
            shadowType = GTKConstants.ShadowType.OUT;
        } else if ("etched_in".equals(shadow)) {
            shadowType = GTKConstants.ShadowType.ETCHED_IN;
        } else if ("etched_out".equals(shadow)) {
            shadowType = GTKConstants.ShadowType.ETCHED_OUT;
        } else if ("none".equals(shadow)) {
            shadowType = GTKConstants.ShadowType.NONE;
        }
        GTKPainter.INSTANCE.paintMetacityElement(this.context, g, state, "metacity-box", x, y, w, h, shadowType, null);
    }

    protected void drawGTKVLine(Node node, Graphics g) {
        NamedNodeMap attrs = node.getAttributes();
        String stateStr = this.getStringAttr(attrs, "state").toUpperCase();
        int x = this.aee.evaluate(this.getStringAttr(attrs, "x"));
        int y1 = this.aee.evaluate(this.getStringAttr(attrs, "y1"));
        int y2 = this.aee.evaluate(this.getStringAttr(attrs, "y2"));
        int state = -1;
        if ("NORMAL".equals(stateStr)) {
            state = 1;
        } else if ("SELECTED".equals(stateStr)) {
            state = 512;
        } else if ("INSENSITIVE".equals(stateStr)) {
            state = 8;
        } else if ("PRELIGHT".equals(stateStr)) {
            state = 2;
        }
        GTKPainter.INSTANCE.paintMetacityElement(this.context, g, state, "metacity-vline", x, y1, 1, y2 - y1, null, null);
    }

    protected void drawGradient(Node node, Graphics g) {
        boolean vertical;
        NamedNodeMap attrs = node.getAttributes();
        String type = this.getStringAttr(attrs, "type");
        float alpha = this.getFloatAttr(node, "alpha", -1.0f);
        int x = this.aee.evaluate(this.getStringAttr(attrs, "x"));
        int y = this.aee.evaluate(this.getStringAttr(attrs, "y"));
        int w = this.aee.evaluate(this.getStringAttr(attrs, "width"));
        int h = this.aee.evaluate(this.getStringAttr(attrs, "height"));
        if (this.getInt("width") == -1) {
            x -= w;
        }
        if (this.getInt("height") == -1) {
            y -= h;
        }
        Node[] colorNodes = this.getNodesByName(node, "color");
        Color[] colors = new Color[colorNodes.length];
        for (int i = 0; i < colorNodes.length; ++i) {
            colors[i] = this.parseColor(this.getStringAttr(colorNodes[i], "value"));
        }
        boolean horizontal = "diagonal".equals(type) || "horizontal".equals(type);
        boolean bl = vertical = "diagonal".equals(type) || "vertical".equals(type);
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            Composite oldComp = g2.getComposite();
            if (alpha >= 0.0f) {
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
            }
            int n = colors.length - 1;
            for (int i = 0; i < n; ++i) {
                g2.setPaint(new GradientPaint(x + (horizontal ? i * w / n : 0), y + (vertical ? i * h / n : 0), colors[i], x + (horizontal ? (i + 1) * w / n : 0), y + (vertical ? (i + 1) * h / n : 0), colors[i + 1]));
                g2.fillRect(x + (horizontal ? i * w / n : 0), y + (vertical ? i * h / n : 0), horizontal ? w / n : w, vertical ? h / n : h);
            }
            g2.setComposite(oldComp);
        }
    }

    protected void drawImage(Node node, Graphics g) {
        NamedNodeMap attrs = node.getAttributes();
        String filename = this.getStringAttr(attrs, "filename");
        String colorizeStr = this.getStringAttr(attrs, "colorize");
        Color colorize = colorizeStr != null ? this.parseColor(colorizeStr) : null;
        String alpha = this.getStringAttr(attrs, "alpha");
        Image object = colorize != null ? this.getImage(filename, colorize) : this.getImage(filename);
        this.variables.put("object_width", object.getWidth(null));
        this.variables.put("object_height", object.getHeight(null));
        String fill_type = this.getStringAttr(attrs, "fill_type");
        int x = this.aee.evaluate(this.getStringAttr(attrs, "x"));
        int y = this.aee.evaluate(this.getStringAttr(attrs, "y"));
        int w = this.aee.evaluate(this.getStringAttr(attrs, "width"));
        int h = this.aee.evaluate(this.getStringAttr(attrs, "height"));
        if (this.getInt("width") == -1) {
            x -= w;
        }
        if (this.getInt("height") == -1) {
            y -= h;
        }
        if (alpha != null) {
            if ("tile".equals(fill_type)) {
                StringTokenizer tokenizer = new StringTokenizer(alpha, ":");
                float[] alphas = new float[tokenizer.countTokens()];
                for (int i = 0; i < alphas.length; ++i) {
                    alphas[i] = Float.parseFloat(tokenizer.nextToken());
                }
                this.tileImage(g, object, x, y, w, h, alphas);
            } else {
                float a = Float.parseFloat(alpha);
                if (g instanceof Graphics2D) {
                    Graphics2D g2 = (Graphics2D)g;
                    Composite oldComp = g2.getComposite();
                    g2.setComposite(AlphaComposite.getInstance(3, a));
                    g2.drawImage(object, x, y, w, h, null);
                    g2.setComposite(oldComp);
                }
            }
        } else {
            g.drawImage(object, x, y, w, h, null);
        }
    }

    protected void drawIcon(Node node, Graphics g, JInternalFrame jif) {
        Icon icon = jif.getFrameIcon();
        if (icon == null) {
            return;
        }
        NamedNodeMap attrs = node.getAttributes();
        String alpha = this.getStringAttr(attrs, "alpha");
        int x = this.aee.evaluate(this.getStringAttr(attrs, "x"));
        int y = this.aee.evaluate(this.getStringAttr(attrs, "y"));
        int w = this.aee.evaluate(this.getStringAttr(attrs, "width"));
        int h = this.aee.evaluate(this.getStringAttr(attrs, "height"));
        if (this.getInt("width") == -1) {
            x -= w;
        }
        if (this.getInt("height") == -1) {
            y -= h;
        }
        if (alpha != null) {
            float a = Float.parseFloat(alpha);
            if (g instanceof Graphics2D) {
                Graphics2D g2 = (Graphics2D)g;
                Composite oldComp = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(3, a));
                icon.paintIcon(jif, g, x, y);
                g2.setComposite(oldComp);
            }
        } else {
            icon.paintIcon(jif, g, x, y);
        }
    }

    protected void drawInclude(Node node, Graphics g, JInternalFrame jif) {
        int oldWidth = this.getInt("width");
        int oldHeight = this.getInt("height");
        NamedNodeMap attrs = node.getAttributes();
        int x = this.aee.evaluate(this.getStringAttr(attrs, "x"), 0);
        int y = this.aee.evaluate(this.getStringAttr(attrs, "y"), 0);
        int w = this.aee.evaluate(this.getStringAttr(attrs, "width"), -1);
        int h = this.aee.evaluate(this.getStringAttr(attrs, "height"), -1);
        if (w != -1) {
            this.variables.put("width", w);
        }
        if (h != -1) {
            this.variables.put("height", h);
        }
        Node draw_ops = this.getNode("draw_ops", new String[]{"name", this.getStringAttr(node, "name")});
        g.translate(x, y);
        this.draw(draw_ops, g, jif);
        g.translate(-x, -y);
        if (w != -1) {
            this.variables.put("width", oldWidth);
        }
        if (h != -1) {
            this.variables.put("height", oldHeight);
        }
    }

    protected void draw(Node draw_ops, Graphics g, JInternalFrame jif) {
        NodeList nodes;
        if (draw_ops != null && (nodes = draw_ops.getChildNodes()) != null) {
            Shape oldClip = g.getClip();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node child = nodes.item(i);
                if (child.getNodeType() != 1) continue;
                try {
                    String name = child.getNodeName();
                    if ("include".equals(name)) {
                        this.drawInclude(child, g, jif);
                        continue;
                    }
                    if ("arc".equals(name)) {
                        this.drawArc(child, g);
                        continue;
                    }
                    if ("clip".equals(name)) {
                        this.setClip(child, g);
                        continue;
                    }
                    if ("gradient".equals(name)) {
                        this.drawGradient(child, g);
                        continue;
                    }
                    if ("gtk_arrow".equals(name)) {
                        this.drawGTKArrow(child, g);
                        continue;
                    }
                    if ("gtk_box".equals(name)) {
                        this.drawGTKBox(child, g);
                        continue;
                    }
                    if ("gtk_vline".equals(name)) {
                        this.drawGTKVLine(child, g);
                        continue;
                    }
                    if ("image".equals(name)) {
                        this.drawImage(child, g);
                        continue;
                    }
                    if ("icon".equals(name)) {
                        this.drawIcon(child, g, jif);
                        continue;
                    }
                    if ("line".equals(name)) {
                        this.drawLine(child, g);
                        continue;
                    }
                    if ("rectangle".equals(name)) {
                        this.drawRectangle(child, g);
                        continue;
                    }
                    if ("tint".equals(name)) {
                        this.drawTint(child, g);
                        continue;
                    }
                    if ("tile".equals(name)) {
                        this.drawTile(child, g, jif);
                        continue;
                    }
                    if ("title".equals(name)) {
                        this.drawTitle(child, g, jif);
                        continue;
                    }
                    System.err.println("Unknown Metacity drawing op: " + child);
                    continue;
                }
                catch (NumberFormatException ex) {
                    Metacity.logError(this.themeName, ex);
                }
            }
            g.setClip(oldClip);
        }
    }

    protected void drawPiece(Node frame_style, Graphics g, String position, int x, int y, int width, int height, JInternalFrame jif) {
        Node piece = this.getNode(frame_style, "piece", new String[]{"position", position});
        if (piece != null) {
            String draw_ops_name = this.getStringAttr(piece, "draw_ops");
            Node draw_ops = draw_ops_name != null ? this.getNode("draw_ops", new String[]{"name", draw_ops_name}) : this.getNode(piece, "draw_ops", null);
            this.variables.put("width", width);
            this.variables.put("height", height);
            g.translate(x, y);
            this.draw(draw_ops, g, jif);
            g.translate(-x, -y);
        }
    }

    Insets getBorderInsets(SynthContext context, Insets insets) {
        this.updateFrameGeometry(context);
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        insets.top = ((Insets)this.frameGeometry.get((Object)"title_border")).top;
        insets.bottom = this.getInt("bottom_height");
        insets.left = this.getInt("left_width");
        insets.right = this.getInt("right_width");
        return insets;
    }

    private void updateFrameGeometry(SynthContext context) {
        Node frame_style;
        Node frame;
        this.context = context;
        JComponent comp = context.getComponent();
        JComponent titlePane = Metacity.findChild(comp, "InternalFrame.northPane");
        JInternalFrame jif = null;
        if (comp instanceof JInternalFrame) {
            jif = (JInternalFrame)comp;
        } else if (comp instanceof JInternalFrame.JDesktopIcon) {
            jif = ((JInternalFrame.JDesktopIcon)comp).getInternalFrame();
        } else {
            assert (false) : "component is not JInternalFrame or JInternalFrame.JDesktopIcon";
            return;
        }
        if (this.frame_style_set == null) {
            Node window = this.getNode("window", new String[]{"type", "normal"});
            if (window != null) {
                this.frame_style_set = this.getNode("frame_style_set", new String[]{"name", this.getStringAttr(window, "style_set")});
            }
            if (this.frame_style_set == null) {
                this.frame_style_set = this.getNode("frame_style_set", new String[]{"name", "normal"});
            }
        }
        if (this.frame_style_set != null && (frame = this.getNode(this.frame_style_set, "frame", new String[]{"focus", jif.isSelected() ? "yes" : "no", "state", jif.isMaximum() ? "maximized" : "normal"})) != null && (frame_style = this.getNode("frame_style", new String[]{"name", this.getStringAttr(frame, "style")})) != null) {
            Map<String, Object> gm = this.frameGeometries.get(this.getStringAttr(frame_style, "geometry"));
            this.setFrameGeometry(titlePane, gm);
        }
    }

    protected static void logError(String themeName, Exception ex) {
        Metacity.logError(themeName, ex.toString());
    }

    protected static void logError(String themeName, String msg) {
        if (!errorLogged) {
            System.err.println("Exception in Metacity for theme \"" + themeName + "\": " + msg);
            errorLogged = true;
        }
    }

    protected static Document getXMLDoc(final URL xmlFile) throws IOException, ParserConfigurationException, SAXException {
        if (documentBuilder == null) {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        InputStream inputStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                try {
                    return new BufferedInputStream(xmlFile.openStream());
                }
                catch (IOException ex) {
                    return null;
                }
            }
        });
        Document doc = null;
        if (inputStream != null) {
            doc = documentBuilder.parse(inputStream);
        }
        return doc;
    }

    protected Node[] getNodesByName(Node parent, String name) {
        NodeList nodes = parent.getChildNodes();
        int n = nodes.getLength();
        ArrayList<Node> list = new ArrayList<Node>();
        for (int i = 0; i < n; ++i) {
            Node node = nodes.item(i);
            if (!name.equals(node.getNodeName())) continue;
            list.add(node);
        }
        return list.toArray(new Node[list.size()]);
    }

    protected Node getNode(String tagName, String[] attrs) {
        NodeList nodes = xmlDoc.getElementsByTagName(tagName);
        return nodes != null ? this.getNode(nodes, tagName, attrs) : null;
    }

    protected Node getNode(Node parent, String name, String[] attrs) {
        Node inheritFromNode;
        String inheritFrom;
        Node node = null;
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            node = this.getNode(nodes, name, attrs);
        }
        if (node == null && (inheritFrom = this.getStringAttr(parent, "parent")) != null && (inheritFromNode = this.getNode(parent.getParentNode(), parent.getNodeName(), new String[]{"name", inheritFrom})) != null) {
            node = this.getNode(inheritFromNode, name, attrs);
        }
        return node;
    }

    protected Node getNode(NodeList nodes, String name, String[] attrs) {
        int n = nodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodes.item(i);
            if (!name.equals(node.getNodeName())) continue;
            if (attrs != null) {
                NamedNodeMap nodeAttrs = node.getAttributes();
                if (nodeAttrs == null) continue;
                boolean matches = true;
                int nAttrs = attrs.length / 2;
                for (int a = 0; a < nAttrs; ++a) {
                    String aName = attrs[a * 2];
                    String aValue = attrs[a * 2 + 1];
                    Node attr = nodeAttrs.getNamedItem(aName);
                    if (attr != null && (aValue == null || aValue.equals(attr.getNodeValue()))) continue;
                    matches = false;
                    break;
                }
                if (!matches) continue;
                return node;
            }
            return node;
        }
        return null;
    }

    protected String getStringAttr(Node node, String name) {
        Node inheritFromNode;
        String inheritFrom;
        String value = null;
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null && (value = this.getStringAttr(attrs, name)) == null && (inheritFrom = this.getStringAttr(attrs, "parent")) != null && (inheritFromNode = this.getNode(node.getParentNode(), node.getNodeName(), new String[]{"name", inheritFrom})) != null) {
            value = this.getStringAttr(inheritFromNode, name);
        }
        return value;
    }

    protected String getStringAttr(NamedNodeMap attrs, String name) {
        Node item = attrs.getNamedItem(name);
        return item != null ? item.getNodeValue() : null;
    }

    protected boolean getBooleanAttr(Node node, String name, boolean fallback) {
        String str = this.getStringAttr(node, name);
        if (str != null) {
            return Boolean.valueOf(str);
        }
        return fallback;
    }

    protected int getIntAttr(Node node, String name, int fallback) {
        String str = this.getStringAttr(node, name);
        int value = fallback;
        if (str != null) {
            try {
                value = Integer.parseInt(str);
            }
            catch (NumberFormatException ex) {
                Metacity.logError(this.themeName, ex);
            }
        }
        return value;
    }

    protected float getFloatAttr(Node node, String name, float fallback) {
        String str = this.getStringAttr(node, name);
        float value = fallback;
        if (str != null) {
            try {
                value = Float.parseFloat(str);
            }
            catch (NumberFormatException ex) {
                Metacity.logError(this.themeName, ex);
            }
        }
        return value;
    }

    protected Color parseColor(String str) {
        StringTokenizer tokenizer = new StringTokenizer(str, "/");
        int n = tokenizer.countTokens();
        if (n > 1) {
            String function = tokenizer.nextToken();
            if ("shade".equals(function)) {
                assert (n == 3);
                Color c = this.parseColor2(tokenizer.nextToken());
                float alpha = Float.parseFloat(tokenizer.nextToken());
                return GTKColorType.adjustColor(c, 1.0f, alpha, alpha);
            }
            if ("blend".equals(function)) {
                assert (n == 4);
                Color bg = this.parseColor2(tokenizer.nextToken());
                Color fg = this.parseColor2(tokenizer.nextToken());
                float alpha = Float.parseFloat(tokenizer.nextToken());
                if (alpha > 1.0f) {
                    alpha = 1.0f / alpha;
                }
                return new Color((int)((float)bg.getRed() + (float)(fg.getRed() - bg.getRed()) * alpha), (int)((float)bg.getRed() + (float)(fg.getRed() - bg.getRed()) * alpha), (int)((float)bg.getRed() + (float)(fg.getRed() - bg.getRed()) * alpha));
            }
            System.err.println("Unknown Metacity color function=" + str);
            return null;
        }
        return this.parseColor2(str);
    }

    protected Color parseColor2(String str) {
        int i1;
        Color c = null;
        if (str.startsWith("gtk:") && (i1 = str.indexOf(91)) > 3) {
            String typeStr = str.substring(4, i1).toLowerCase();
            int i2 = str.indexOf(93);
            if (i2 > i1 + 1) {
                String stateStr = str.substring(i1 + 1, i2).toUpperCase();
                int state = -1;
                if ("ACTIVE".equals(stateStr)) {
                    state = 4;
                } else if ("INSENSITIVE".equals(stateStr)) {
                    state = 8;
                } else if ("NORMAL".equals(stateStr)) {
                    state = 1;
                } else if ("PRELIGHT".equals(stateStr)) {
                    state = 2;
                } else if ("SELECTED".equals(stateStr)) {
                    state = 512;
                }
                ColorType type = null;
                if ("fg".equals(typeStr)) {
                    type = GTKColorType.FOREGROUND;
                } else if ("bg".equals(typeStr)) {
                    type = GTKColorType.BACKGROUND;
                } else if ("base".equals(typeStr)) {
                    type = GTKColorType.TEXT_BACKGROUND;
                } else if ("text".equals(typeStr)) {
                    type = GTKColorType.TEXT_FOREGROUND;
                } else if ("dark".equals(typeStr)) {
                    type = GTKColorType.DARK;
                } else if ("light".equals(typeStr)) {
                    type = GTKColorType.LIGHT;
                }
                if (state >= 0 && type != null) {
                    c = ((GTKStyle)this.context.getStyle()).getGTKColor(this.context, state, type);
                }
            }
        }
        if (c == null) {
            c = Metacity.parseColorString(str);
        }
        return c;
    }

    private static Color parseColorString(String str) {
        if (str.charAt(0) == '#') {
            int b;
            int g;
            int r;
            int i = (str = str.substring(1)).length();
            if (i < 3 || i > 12 || i % 3 != 0) {
                return null;
            }
            i /= 3;
            try {
                r = Integer.parseInt(str.substring(0, i), 16);
                g = Integer.parseInt(str.substring(i, i * 2), 16);
                b = Integer.parseInt(str.substring(i * 2, i * 3), 16);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            if (i == 4) {
                return new ColorUIResource((float)r / 65535.0f, (float)g / 65535.0f, (float)b / 65535.0f);
            }
            if (i == 1) {
                return new ColorUIResource((float)r / 15.0f, (float)g / 15.0f, (float)b / 15.0f);
            }
            if (i == 2) {
                return new ColorUIResource(r, g, b);
            }
            return new ColorUIResource((float)r / 4095.0f, (float)g / 4095.0f, (float)b / 4095.0f);
        }
        return XColors.lookupColor(str);
    }

    static {
        for (String themeName : themeNames = new String[]{Metacity.getUserTheme(), "blueprint", "Bluecurve", "Crux", "SwingFallbackTheme"}) {
            if (themeName != null) {
                try {
                    INSTANCE = new Metacity(themeName);
                }
                catch (FileNotFoundException ex) {
                }
                catch (IOException ex) {
                    Metacity.logError(themeName, ex);
                }
                catch (ParserConfigurationException ex) {
                    Metacity.logError(themeName, ex);
                }
                catch (SAXException ex) {
                    Metacity.logError(themeName, ex);
                }
            }
            if (INSTANCE != null) break;
        }
        if (INSTANCE == null) {
            throw new Error("Could not find any installed metacity theme, and fallback failed");
        }
        errorLogged = false;
    }

    static class RoundRectClipShape
    extends RectangularShape {
        static final int TOP_LEFT = 1;
        static final int TOP_RIGHT = 2;
        static final int BOTTOM_LEFT = 4;
        static final int BOTTOM_RIGHT = 8;
        int x;
        int y;
        int width;
        int height;
        int arcwidth;
        int archeight;
        int corners;

        public RoundRectClipShape() {
        }

        public RoundRectClipShape(int x, int y, int w, int h, int arcw, int arch, int corners) {
            this.setRoundedRect(x, y, w, h, arcw, arch, corners);
        }

        public void setRoundedRect(int x, int y, int w, int h, int arcw, int arch, int corners) {
            this.corners = corners;
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
            this.arcwidth = arcw;
            this.archeight = arch;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        public double getArcWidth() {
            return this.arcwidth;
        }

        public double getArcHeight() {
            return this.archeight;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Rectangle2D getBounds2D() {
            return null;
        }

        public int getCornerFlags() {
            return this.corners;
        }

        @Override
        public void setFrame(double x, double y, double w, double h) {
        }

        @Override
        public boolean contains(double x, double y) {
            return false;
        }

        private int classify(double coord, double left, double right, double arcsize) {
            return 0;
        }

        @Override
        public boolean intersects(double x, double y, double w, double h) {
            return false;
        }

        @Override
        public boolean contains(double x, double y, double w, double h) {
            return false;
        }

        @Override
        public PathIterator getPathIterator(AffineTransform at) {
            return new RoundishRectIterator(this, at);
        }

        static class RoundishRectIterator
        implements PathIterator {
            double x;
            double y;
            double w;
            double h;
            double aw;
            double ah;
            AffineTransform affine;
            int index;
            double[][] ctrlpts;
            int[] types;
            private static final double angle = 0.7853981633974483;
            private static final double a = 1.0 - Math.cos(0.7853981633974483);
            private static final double b = Math.tan(0.7853981633974483);
            private static final double c = Math.sqrt(1.0 + b * b) - 1.0 + a;
            private static final double cv = 1.3333333333333333 * a * b / c;
            private static final double acv = (1.0 - cv) / 2.0;
            private static final double[][] CtrlPtTemplate = new double[][]{{0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 1.0, -0.5}, {0.0, 0.0, 1.0, -acv, 0.0, acv, 1.0, 0.0, 0.0, 0.5, 1.0, 0.0}, {1.0, 0.0, 1.0, 0.0}, {1.0, -0.5, 1.0, 0.0}, {1.0, -acv, 1.0, 0.0, 1.0, 0.0, 1.0, -acv, 1.0, 0.0, 1.0, -0.5}, {1.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 0.5}, {1.0, 0.0, 0.0, acv, 1.0, -acv, 0.0, 0.0, 1.0, -0.5, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.5, 0.0, 0.0}, {0.0, acv, 0.0, 0.0, 0.0, 0.0, 0.0, acv, 0.0, 0.0, 0.0, 0.5}, new double[0]};
            private static final int[] CornerFlags = new int[]{4, 8, 2, 1};

            RoundishRectIterator(RoundRectClipShape rr, AffineTransform at) {
                this.x = rr.getX();
                this.y = rr.getY();
                this.w = rr.getWidth();
                this.h = rr.getHeight();
                this.aw = Math.min(this.w, Math.abs(rr.getArcWidth()));
                this.ah = Math.min(this.h, Math.abs(rr.getArcHeight()));
                this.affine = at;
                if (this.w < 0.0 || this.h < 0.0) {
                    this.ctrlpts = new double[0][];
                    this.types = new int[0];
                } else {
                    int corners = rr.getCornerFlags();
                    int numedges = 5;
                    for (int i = 1; i < 16; i <<= 1) {
                        if ((corners & i) == 0) continue;
                        ++numedges;
                    }
                    this.ctrlpts = new double[numedges][];
                    this.types = new int[numedges];
                    int j = 0;
                    for (int i = 0; i < 4; ++i) {
                        this.types[j] = 1;
                        if ((corners & CornerFlags[i]) == 0) {
                            this.ctrlpts[j++] = CtrlPtTemplate[i * 3 + 0];
                            continue;
                        }
                        this.ctrlpts[j++] = CtrlPtTemplate[i * 3 + 1];
                        this.types[j] = 3;
                        this.ctrlpts[j++] = CtrlPtTemplate[i * 3 + 2];
                    }
                    this.types[j] = 4;
                    this.ctrlpts[j++] = CtrlPtTemplate[12];
                    this.types[0] = 0;
                }
            }

            @Override
            public int getWindingRule() {
                return 1;
            }

            @Override
            public boolean isDone() {
                return this.index >= this.ctrlpts.length;
            }

            @Override
            public void next() {
                ++this.index;
            }

            @Override
            public int currentSegment(float[] coords) {
                if (this.isDone()) {
                    throw new NoSuchElementException("roundrect iterator out of bounds");
                }
                double[] ctrls = this.ctrlpts[this.index];
                int nc = 0;
                for (int i = 0; i < ctrls.length; i += 4) {
                    coords[nc++] = (float)(this.x + ctrls[i + 0] * this.w + ctrls[i + 1] * this.aw);
                    coords[nc++] = (float)(this.y + ctrls[i + 2] * this.h + ctrls[i + 3] * this.ah);
                }
                if (this.affine != null) {
                    this.affine.transform(coords, 0, coords, 0, nc / 2);
                }
                return this.types[this.index];
            }

            @Override
            public int currentSegment(double[] coords) {
                if (this.isDone()) {
                    throw new NoSuchElementException("roundrect iterator out of bounds");
                }
                double[] ctrls = this.ctrlpts[this.index];
                int nc = 0;
                for (int i = 0; i < ctrls.length; i += 4) {
                    coords[nc++] = this.x + ctrls[i + 0] * this.w + ctrls[i + 1] * this.aw;
                    coords[nc++] = this.y + ctrls[i + 2] * this.h + ctrls[i + 3] * this.ah;
                }
                if (this.affine != null) {
                    this.affine.transform(coords, 0, coords, 0, nc / 2);
                }
                return this.types[this.index];
            }
        }
    }

    static class PeekableStringTokenizer
    extends StringTokenizer {
        String token = null;

        public PeekableStringTokenizer(String str, String delim, boolean returnDelims) {
            super(str, delim, returnDelims);
            this.peek();
        }

        public String peek() {
            if (this.token == null) {
                this.token = this.nextToken();
            }
            return this.token;
        }

        @Override
        public boolean hasMoreTokens() {
            return this.token != null || super.hasMoreTokens();
        }

        @Override
        public String nextToken() {
            if (this.token != null) {
                String t = this.token;
                this.token = null;
                if (this.hasMoreTokens()) {
                    this.peek();
                }
                return t;
            }
            String token = super.nextToken();
            while ((token.equals(" ") || token.equals("\t")) && this.hasMoreTokens()) {
                token = super.nextToken();
            }
            return token;
        }
    }

    class ArithmeticExpressionEvaluator {
        private PeekableStringTokenizer tokenizer;

        ArithmeticExpressionEvaluator() {
        }

        int evaluate(String expr) {
            this.tokenizer = new PeekableStringTokenizer(expr, " \t+-*/%()", true);
            return Math.round(this.expression());
        }

        int evaluate(String expr, int fallback) {
            return expr != null ? this.evaluate(expr) : fallback;
        }

        public float expression() {
            float value = this.getTermValue();
            boolean done = false;
            while (!done && this.tokenizer.hasMoreTokens()) {
                String next = this.tokenizer.peek();
                if ("+".equals(next) || "-".equals(next) || "`max`".equals(next) || "`min`".equals(next)) {
                    this.tokenizer.nextToken();
                    float value2 = this.getTermValue();
                    if ("+".equals(next)) {
                        value += value2;
                        continue;
                    }
                    if ("-".equals(next)) {
                        value -= value2;
                        continue;
                    }
                    if ("`max`".equals(next)) {
                        value = Math.max(value, value2);
                        continue;
                    }
                    if (!"`min`".equals(next)) continue;
                    value = Math.min(value, value2);
                    continue;
                }
                done = true;
            }
            return value;
        }

        public float getTermValue() {
            float value = this.getFactorValue();
            boolean done = false;
            while (!done && this.tokenizer.hasMoreTokens()) {
                String next = this.tokenizer.peek();
                if ("*".equals(next) || "/".equals(next) || "%".equals(next)) {
                    this.tokenizer.nextToken();
                    float value2 = this.getFactorValue();
                    if ("*".equals(next)) {
                        value *= value2;
                        continue;
                    }
                    if ("/".equals(next)) {
                        value /= value2;
                        continue;
                    }
                    value %= value2;
                    continue;
                }
                done = true;
            }
            return value;
        }

        public float getFactorValue() {
            float value;
            if ("(".equals(this.tokenizer.peek())) {
                this.tokenizer.nextToken();
                value = this.expression();
                this.tokenizer.nextToken();
            } else {
                String token = this.tokenizer.nextToken();
                if (Character.isDigit(token.charAt(0))) {
                    value = Float.parseFloat(token);
                } else {
                    Integer i = (Integer)Metacity.this.variables.get(token);
                    if (i == null) {
                        i = (Integer)Metacity.this.getFrameGeometry().get(token);
                    }
                    if (i == null) {
                        Metacity.logError(Metacity.this.themeName, "Variable \"" + token + "\" not defined");
                        return 0.0f;
                    }
                    value = i != null ? (float)i.intValue() : 0.0f;
                }
            }
            return value;
        }
    }

    protected class TitlePaneLayout
    implements LayoutManager {
        protected TitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int subtitle_w;
            int title_length;
            JInternalFrame frame;
            JComponent titlePane = (JComponent)c;
            Container titlePaneParent = titlePane.getParent();
            if (titlePaneParent instanceof JInternalFrame) {
                frame = (JInternalFrame)titlePaneParent;
            } else if (titlePaneParent instanceof JInternalFrame.JDesktopIcon) {
                frame = ((JInternalFrame.JDesktopIcon)titlePaneParent).getInternalFrame();
            } else {
                return null;
            }
            Dimension buttonDim = Metacity.this.calculateButtonSize(titlePane);
            Insets title_border = (Insets)Metacity.this.getFrameGeometry().get("title_border");
            Insets button_border = (Insets)Metacity.this.getFrameGeometry().get("button_border");
            int width = Metacity.this.getInt("left_titlebar_edge") + buttonDim.width + Metacity.this.getInt("right_titlebar_edge");
            if (title_border != null) {
                width += title_border.left + title_border.right;
            }
            if (frame.isClosable()) {
                width += buttonDim.width;
            }
            if (frame.isMaximizable()) {
                width += buttonDim.width;
            }
            if (frame.isIconifiable()) {
                width += buttonDim.width;
            }
            FontMetrics fm = frame.getFontMetrics(titlePane.getFont());
            String frameTitle = frame.getTitle();
            int title_w = frameTitle != null ? SwingUtilities2.stringWidth(frame, fm, frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 3 ? (width += title_w < (subtitle_w = SwingUtilities2.stringWidth(frame, fm, frameTitle.substring(0, 3) + "...")) ? title_w : subtitle_w) : (width += title_w);
            int titleHeight = fm.getHeight() + Metacity.this.getInt("title_vertical_pad");
            if (title_border != null) {
                titleHeight += title_border.top + title_border.bottom;
            }
            int buttonHeight = buttonDim.height;
            if (button_border != null) {
                buttonHeight += button_border.top + button_border.bottom;
            }
            int height = Math.max(buttonHeight, titleHeight);
            return new Dimension(width, height);
        }

        @Override
        public void layoutContainer(Container c) {
            int y;
            JInternalFrame frame;
            JComponent titlePane = (JComponent)c;
            Container titlePaneParent = titlePane.getParent();
            if (titlePaneParent instanceof JInternalFrame) {
                frame = (JInternalFrame)titlePaneParent;
            } else if (titlePaneParent instanceof JInternalFrame.JDesktopIcon) {
                frame = ((JInternalFrame.JDesktopIcon)titlePaneParent).getInternalFrame();
            } else {
                return;
            }
            Map gm = Metacity.this.getFrameGeometry();
            int w = titlePane.getWidth();
            int h = titlePane.getHeight();
            JComponent menuButton = Metacity.findChild(titlePane, "InternalFrameTitlePane.menuButton");
            JComponent minimizeButton = Metacity.findChild(titlePane, "InternalFrameTitlePane.iconifyButton");
            JComponent maximizeButton = Metacity.findChild(titlePane, "InternalFrameTitlePane.maximizeButton");
            JComponent closeButton = Metacity.findChild(titlePane, "InternalFrameTitlePane.closeButton");
            Insets button_border = (Insets)gm.get("button_border");
            Dimension buttonDim = Metacity.this.calculateButtonSize(titlePane);
            int n = y = button_border != null ? button_border.top : 0;
            if (titlePaneParent.getComponentOrientation().isLeftToRight()) {
                int x = Metacity.this.getInt("left_titlebar_edge");
                menuButton.setBounds(x, y, buttonDim.width, buttonDim.height);
                x = w - buttonDim.width - Metacity.this.getInt("right_titlebar_edge");
                if (button_border != null) {
                    x -= button_border.right;
                }
                if (frame.isClosable()) {
                    closeButton.setBounds(x, y, buttonDim.width, buttonDim.height);
                    x -= buttonDim.width;
                }
                if (frame.isMaximizable()) {
                    maximizeButton.setBounds(x, y, buttonDim.width, buttonDim.height);
                    x -= buttonDim.width;
                }
                if (frame.isIconifiable()) {
                    minimizeButton.setBounds(x, y, buttonDim.width, buttonDim.height);
                }
            } else {
                int x = w - buttonDim.width - Metacity.this.getInt("right_titlebar_edge");
                menuButton.setBounds(x, y, buttonDim.width, buttonDim.height);
                x = Metacity.this.getInt("left_titlebar_edge");
                if (button_border != null) {
                    x += button_border.left;
                }
                if (frame.isClosable()) {
                    closeButton.setBounds(x, y, buttonDim.width, buttonDim.height);
                    x += buttonDim.width;
                }
                if (frame.isMaximizable()) {
                    maximizeButton.setBounds(x, y, buttonDim.width, buttonDim.height);
                    x += buttonDim.width;
                }
                if (frame.isIconifiable()) {
                    minimizeButton.setBounds(x, y, buttonDim.width, buttonDim.height);
                }
            }
        }
    }

    private class ColorizeImageFilter
    extends RGBImageFilter {
        double cr;
        double cg;
        double cb;

        public ColorizeImageFilter() {
            this.canFilterIndexColorModel = true;
        }

        public void setColor(Color color) {
            this.cr = (double)color.getRed() / 255.0;
            this.cg = (double)color.getGreen() / 255.0;
            this.cb = (double)color.getBlue() / 255.0;
        }

        public Image colorize(Image fromImage, Color c) {
            this.setColor(c);
            FilteredImageSource producer = new FilteredImageSource(fromImage.getSource(), this);
            return new ImageIcon(Metacity.this.context.getComponent().createImage(producer)).getImage();
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            double b;
            double g;
            double r;
            double grayLevel = (double)(2 * (rgb & 0xFF)) / 255.0;
            if (grayLevel <= 1.0) {
                r = this.cr * grayLevel;
                g = this.cg * grayLevel;
                b = this.cb * grayLevel;
            } else {
                r = this.cr + (1.0 - this.cr) * (grayLevel -= 1.0);
                g = this.cg + (1.0 - this.cg) * grayLevel;
                b = this.cb + (1.0 - this.cb) * grayLevel;
            }
            return (rgb & 0xFF000000) + ((int)(r * 255.0) << 16) + ((int)(g * 255.0) << 8) + (int)(b * 255.0);
        }
    }

    private static class Privileged
    implements PrivilegedAction<Object> {
        private static int GET_THEME_DIR = 0;
        private static int GET_USER_THEME = 1;
        private static int GET_IMAGE = 2;
        private int type;
        private Object arg;

        private Privileged() {
        }

        public Object doPrivileged(int type, Object arg) {
            this.type = type;
            this.arg = arg;
            return AccessController.doPrivileged(this);
        }

        @Override
        public Object run() {
            if (this.type == GET_THEME_DIR) {
                String sep = File.separator;
                String[] dirs = new String[]{userHome + sep + ".themes", System.getProperty("swing.metacitythemedir"), "/usr/X11R6/share/themes", "/usr/X11R6/share/gnome/themes", "/usr/local/share/themes", "/usr/local/share/gnome/themes", "/usr/share/themes", "/usr/gnome/share/themes", "/opt/gnome2/share/themes"};
                URL themeDir = null;
                for (int i = 0; i < dirs.length; ++i) {
                    File dir;
                    if (dirs[i] == null || !new File(dir = new File(dirs[i] + sep + this.arg + sep + "metacity-1"), "metacity-theme-1.xml").canRead()) continue;
                    try {
                        themeDir = dir.toURI().toURL();
                    }
                    catch (MalformedURLException ex) {
                        themeDir = null;
                    }
                    break;
                }
                if (themeDir == null) {
                    String filename = "resources/metacity/" + this.arg + "/metacity-1/metacity-theme-1.xml";
                    URL url = this.getClass().getResource(filename);
                    if (url != null) {
                        String str = url.toString();
                        try {
                            themeDir = new URL(str.substring(0, str.lastIndexOf(47)) + "/");
                        }
                        catch (MalformedURLException ex) {
                            themeDir = null;
                        }
                    }
                }
                return themeDir;
            }
            if (this.type == GET_USER_THEME) {
                try {
                    String strLowerCase;
                    int i;
                    int n;
                    userHome = System.getProperty("user.home");
                    String theme = System.getProperty("swing.metacitythemename");
                    if (theme != null) {
                        return theme;
                    }
                    URL url = new URL(new File(userHome).toURI().toURL(), ".gconf/apps/metacity/general/%25gconf.xml");
                    InputStreamReader reader = new InputStreamReader(url.openStream(), "ISO-8859-1");
                    char[] buf = new char[1024];
                    StringBuffer strBuf = new StringBuffer();
                    while ((n = reader.read(buf)) >= 0) {
                        strBuf.append(buf, 0, n);
                    }
                    ((Reader)reader).close();
                    String str = strBuf.toString();
                    if (str != null && (i = (strLowerCase = str.toLowerCase()).indexOf("<entry name=\"theme\"")) >= 0 && (i = strLowerCase.indexOf("<stringvalue>", i)) > 0) {
                        int i2 = str.indexOf("<", i += "<stringvalue>".length());
                        return str.substring(i, i2);
                    }
                }
                catch (MalformedURLException ex) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
            if (this.type == GET_IMAGE) {
                return new ImageIcon((URL)this.arg).getImage();
            }
            return null;
        }
    }
}

