/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLProtocolException;
import sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec;
import sun.security.ssl.Debug;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeMessage;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;
import sun.security.util.KeyUtil;

final class RSAClientKeyExchange
extends HandshakeMessage {
    private static final String PROP_NAME = "com.sun.net.ssl.rsaPreMasterSecretFix";
    private static final boolean rsaPreMasterSecretFix = Debug.getBooleanProperty("com.sun.net.ssl.rsaPreMasterSecretFix", false);
    private ProtocolVersion protocolVersion;
    SecretKey preMaster;
    private byte[] encrypted;

    RSAClientKeyExchange(ProtocolVersion protocolVersion, ProtocolVersion maxVersion, SecureRandom generator, PublicKey publicKey) throws IOException {
        byte minor;
        byte major;
        if (!publicKey.getAlgorithm().equals("RSA")) {
            throw new SSLKeyException("Public key not of type RSA");
        }
        this.protocolVersion = protocolVersion;
        if (rsaPreMasterSecretFix || maxVersion.v >= ProtocolVersion.TLS11.v) {
            major = maxVersion.major;
            minor = maxVersion.minor;
        } else {
            major = protocolVersion.major;
            minor = protocolVersion.minor;
        }
        try {
            String s = protocolVersion.v >= ProtocolVersion.TLS12.v ? "SunTls12RsaPremasterSecret" : "SunTlsRsaPremasterSecret";
            KeyGenerator kg = JsseJce.getKeyGenerator(s);
            kg.init(new TlsRsaPremasterSecretParameterSpec(major, minor), generator);
            this.preMaster = kg.generateKey();
            Cipher cipher = JsseJce.getCipher("RSA/ECB/PKCS1Padding");
            cipher.init(3, (Key)publicKey, generator);
            this.encrypted = cipher.wrap(this.preMaster);
        }
        catch (GeneralSecurityException e) {
            throw (SSLKeyException)new SSLKeyException("RSA premaster secret error").initCause(e);
        }
    }

    RSAClientKeyExchange(ProtocolVersion currentVersion, ProtocolVersion maxVersion, SecureRandom generator, HandshakeInStream input, int messageSize, PrivateKey privateKey) throws IOException {
        if (!privateKey.getAlgorithm().equals("RSA")) {
            throw new SSLKeyException("Private key not of type RSA");
        }
        if (currentVersion.v >= ProtocolVersion.TLS10.v) {
            this.encrypted = input.getBytes16();
        } else {
            this.encrypted = new byte[messageSize];
            if (input.read(this.encrypted) != messageSize) {
                throw new SSLProtocolException("SSL: read PreMasterSecret: short read");
            }
        }
        try {
            Cipher cipher = JsseJce.getCipher("RSA/ECB/PKCS1Padding");
            cipher.init(4, privateKey);
            this.preMaster = (SecretKey)cipher.unwrap(this.encrypted, "TlsRsaPremasterSecret", 3);
            this.preMaster = this.polishPreMasterSecretKey(currentVersion, maxVersion, generator, this.preMaster, null);
        }
        catch (Exception e) {
            this.preMaster = this.polishPreMasterSecretKey(currentVersion, maxVersion, generator, null, e);
        }
    }

    private SecretKey polishPreMasterSecretKey(ProtocolVersion currentVersion, ProtocolVersion clientHelloVersion, SecureRandom generator, SecretKey secretKey, Exception failoverException) {
        this.protocolVersion = clientHelloVersion;
        if (failoverException == null && secretKey != null) {
            byte[] encoded = secretKey.getEncoded();
            if (encoded == null) {
                int keySize;
                if (debug != null && Debug.isOn("handshake")) {
                    System.out.println("unable to get the plaintext of the premaster secret");
                }
                if ((keySize = KeyUtil.getKeySize(secretKey)) > 0 && keySize != 384) {
                    if (debug != null && Debug.isOn("handshake")) {
                        System.out.println("incorrect length of premaster secret: " + keySize / 8);
                    }
                    return RSAClientKeyExchange.generateDummySecret(clientHelloVersion);
                }
                return secretKey;
            }
            if (encoded.length == 48) {
                if (clientHelloVersion.major == encoded[0] && clientHelloVersion.minor == encoded[1]) {
                    return secretKey;
                }
                if (clientHelloVersion.v <= ProtocolVersion.TLS10.v && currentVersion.major == encoded[0] && currentVersion.minor == encoded[1]) {
                    this.protocolVersion = currentVersion;
                    return secretKey;
                }
                if (debug != null && Debug.isOn("handshake")) {
                    System.out.println("Mismatching Protocol Versions, ClientHello.client_version is " + clientHelloVersion + ", while PreMasterSecret.client_version is " + ProtocolVersion.valueOf(encoded[0], encoded[1]));
                }
                return RSAClientKeyExchange.generateDummySecret(clientHelloVersion);
            }
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("incorrect length of premaster secret: " + encoded.length);
            }
            return RSAClientKeyExchange.generateDummySecret(clientHelloVersion);
        }
        if (debug != null && Debug.isOn("handshake") && failoverException != null) {
            System.out.println("Error decrypting premaster secret:");
            failoverException.printStackTrace(System.out);
        }
        return RSAClientKeyExchange.generateDummySecret(clientHelloVersion);
    }

    static SecretKey generateDummySecret(ProtocolVersion version) {
        if (debug != null && Debug.isOn("handshake")) {
            System.out.println("Generating a random fake premaster secret");
        }
        try {
            String s = version.v >= ProtocolVersion.TLS12.v ? "SunTls12RsaPremasterSecret" : "SunTlsRsaPremasterSecret";
            KeyGenerator kg = JsseJce.getKeyGenerator(s);
            kg.init(new TlsRsaPremasterSecretParameterSpec(version.major, version.minor));
            return kg.generateKey();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Could not generate dummy secret", e);
        }
    }

    @Override
    int messageType() {
        return 16;
    }

    @Override
    int messageLength() {
        if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
            return this.encrypted.length + 2;
        }
        return this.encrypted.length;
    }

    @Override
    void send(HandshakeOutStream s) throws IOException {
        if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
            s.putBytes16(this.encrypted);
        } else {
            s.write(this.encrypted);
        }
    }

    @Override
    void print(PrintStream s) throws IOException {
        s.println("*** ClientKeyExchange, RSA PreMasterSecret, " + this.protocolVersion);
    }
}

