/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DESKeyGenerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.util.Arrays;
import javax.crypto.SecretKey;

final class DESKey
implements SecretKey {
    static final long serialVersionUID = 7724971015953279128L;
    private byte[] key;

    DESKey(byte[] key) throws InvalidKeyException {
        this(key, 0);
    }

    DESKey(byte[] key, int offset) throws InvalidKeyException {
        if (key == null || key.length - offset < 8) {
            throw new InvalidKeyException("Wrong key size");
        }
        this.key = new byte[8];
        System.arraycopy(key, offset, this.key, 0, 8);
        DESKeyGenerator.setParityBit(this.key, 0);
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    @Override
    public String getAlgorithm() {
        return "DES";
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    public int hashCode() {
        int retval = 0;
        for (int i = 1; i < this.key.length; ++i) {
            retval += this.key[i] * i;
        }
        return retval ^= "des".hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SecretKey)) {
            return false;
        }
        String thatAlg = ((SecretKey)obj).getAlgorithm();
        if (!thatAlg.equalsIgnoreCase("DES")) {
            return false;
        }
        byte[] thatKey = ((SecretKey)obj).getEncoded();
        boolean ret = Arrays.equals(this.key, thatKey);
        Arrays.fill(thatKey, (byte)0);
        return ret;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.key = (byte[])this.key.clone();
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.SECRET, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
                this.key = null;
            }
        }
        finally {
            super.finalize();
        }
    }
}

