/*
 * Decompiled with CFR 0.152.
 */
package sun.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileSystemView;
import sun.awt.OSInfo;
import sun.awt.shell.ShellFolder;

public class WindowsPlacesBar
extends JToolBar
implements ActionListener,
PropertyChangeListener {
    JFileChooser fc;
    JToggleButton[] buttons;
    ButtonGroup buttonGroup;
    File[] files;
    final Dimension buttonSize;

    public WindowsPlacesBar(JFileChooser fc, boolean isXPStyle) {
        super(1);
        boolean isXPPlatform;
        this.fc = fc;
        this.setFloatable(false);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        boolean bl = isXPPlatform = OSInfo.getOSType() == OSInfo.OSType.WINDOWS && OSInfo.getWindowsVersion().compareTo(OSInfo.WINDOWS_XP) >= 0;
        if (isXPStyle) {
            this.buttonSize = new Dimension(83, 69);
            this.putClientProperty("XPStyle.subAppName", "placesbar");
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
        } else {
            this.buttonSize = new Dimension(83, isXPPlatform ? 65 : 54);
            this.setBorder(new BevelBorder(1, UIManager.getColor("ToolBar.highlight"), UIManager.getColor("ToolBar.background"), UIManager.getColor("ToolBar.darkShadow"), UIManager.getColor("ToolBar.shadow")));
        }
        Color bgColor = new Color(UIManager.getColor("ToolBar.shadow").getRGB());
        this.setBackground(bgColor);
        FileSystemView fsv = fc.getFileSystemView();
        this.files = AccessController.doPrivileged(new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                return (File[])ShellFolder.get("fileChooserShortcutPanelFolders");
            }
        });
        this.buttons = new JToggleButton[this.files.length];
        this.buttonGroup = new ButtonGroup();
        for (int i = 0; i < this.files.length; ++i) {
            Icon icon;
            String folderName;
            int index;
            if (fsv.isFileSystemRoot(this.files[i])) {
                this.files[i] = fsv.createFileObject(this.files[i].getAbsolutePath());
            }
            if ((index = (folderName = fsv.getSystemDisplayName(this.files[i])).lastIndexOf(File.separatorChar)) >= 0 && index < folderName.length() - 1) {
                folderName = folderName.substring(index + 1);
            }
            if (this.files[i] instanceof ShellFolder) {
                ShellFolder sf = (ShellFolder)this.files[i];
                Image image = sf.getIcon(true);
                if (image == null) {
                    image = (Image)ShellFolder.get("shell32LargeIcon 1");
                }
                icon = image == null ? null : new ImageIcon(image, sf.getFolderType());
            } else {
                icon = fsv.getSystemIcon(this.files[i]);
            }
            this.buttons[i] = new JToggleButton(folderName, icon);
            if (isXPPlatform) {
                this.buttons[i].setText("<html><center>" + folderName + "</center></html>");
            }
            if (isXPStyle) {
                this.buttons[i].putClientProperty("XPStyle.subAppName", "placesbar");
            } else {
                Color fgColor = new Color(UIManager.getColor("List.selectionForeground").getRGB());
                this.buttons[i].setContentAreaFilled(false);
                this.buttons[i].setForeground(fgColor);
            }
            this.buttons[i].setMargin(new Insets(3, 2, 1, 2));
            this.buttons[i].setFocusPainted(false);
            this.buttons[i].setIconTextGap(0);
            this.buttons[i].setHorizontalTextPosition(0);
            this.buttons[i].setVerticalTextPosition(3);
            this.buttons[i].setAlignmentX(0.5f);
            this.buttons[i].setPreferredSize(this.buttonSize);
            this.buttons[i].setMaximumSize(this.buttonSize);
            this.buttons[i].addActionListener(this);
            this.add(this.buttons[i]);
            if (i < this.files.length - 1 && isXPStyle) {
                this.add(Box.createRigidArea(new Dimension(1, 1)));
            }
            this.buttonGroup.add(this.buttons[i]);
        }
        this.doDirectoryChanged(fc.getCurrentDirectory());
    }

    protected void doDirectoryChanged(File f) {
        for (int i = 0; i < this.buttons.length; ++i) {
            JToggleButton b = this.buttons[i];
            if (this.files[i].equals(f)) {
                b.setSelected(true);
                break;
            }
            if (!b.isSelected()) continue;
            this.buttonGroup.remove(b);
            b.setSelected(false);
            this.buttonGroup.add(b);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop == "directoryChanged") {
            this.doDirectoryChanged(this.fc.getCurrentDirectory());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JToggleButton b = (JToggleButton)e.getSource();
        for (int i = 0; i < this.buttons.length; ++i) {
            if (b != this.buttons[i]) continue;
            this.fc.setCurrentDirectory(this.files[i]);
            break;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int bh;
        JToggleButton b;
        Dimension min = super.getMinimumSize();
        Dimension pref = super.getPreferredSize();
        int h = min.height;
        if (this.buttons != null && this.buttons.length > 0 && this.buttons.length < 5 && (b = this.buttons[0]) != null && (bh = 5 * (b.getPreferredSize().height + 1)) > h) {
            h = bh;
        }
        if (h > pref.height) {
            pref = new Dimension(pref.width, h);
        }
        return pref;
    }
}

